/***************************************************************************
                          dlgmappathproperties.cpp
                      -------------------
    description          :
    begin                : Thu Sep 14 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgmappathproperties.h"
#include <kapp.h>

DlgMapPathProperties::DlgMapPathProperties(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	setCaption(i18n("Path Properties"));

	initDialog();

	cmdDestN->setToggleButton(true);
	cmdDestNE->setToggleButton(true);
	cmdDestE->setToggleButton(true);
	cmdDestSE->setToggleButton(true);
	cmdDestS->setToggleButton(true);
	cmdDestSW->setToggleButton(true);
	cmdDestW->setToggleButton(true);
	cmdDestNW->setToggleButton(true);
	cmdDestDown->setToggleButton(true);
	cmdDestUp->setToggleButton(true);		

	cmdSrcN->setToggleButton(true);
	cmdSrcNE->setToggleButton(true);
	cmdSrcE->setToggleButton(true);
	cmdSrcSE->setToggleButton(true);
	cmdSrcS->setToggleButton(true);
	cmdSrcSW->setToggleButton(true);
	cmdSrcW->setToggleButton(true);
	cmdSrcNW->setToggleButton(true);
	cmdSrcDown->setToggleButton(true);
	cmdSrcUp->setToggleButton(true);		
	
	cmdSrcN->setOn(true);
	cmdDestN->setOn(true);
	optOneWay->setChecked(true);
	
	chkNormal->setChecked(true);
	
	connect( cmdOK, SIGNAL(clicked()), SLOT(accept()) );
	connect( cmdCancel, SIGNAL(clicked()), SLOT(reject()) );
	
	connect( cmdSrcN, SIGNAL(clicked()), SLOT(slotSrcNClicked()) );
	connect( cmdSrcNE, SIGNAL(clicked()), SLOT(slotSrcNEClicked()) );
	connect( cmdSrcE, SIGNAL(clicked()), SLOT(slotSrcEClicked()) );
	connect( cmdSrcSE, SIGNAL(clicked()), SLOT(slotSrcSEClicked()) );
	connect( cmdSrcS, SIGNAL(clicked()), SLOT(slotSrcSClicked()) );
	connect( cmdSrcSW, SIGNAL(clicked()), SLOT(slotSrcSWClicked()) );
	connect( cmdSrcW, SIGNAL(clicked()), SLOT(slotSrcWClicked()) );
	connect( cmdSrcNW, SIGNAL(clicked()), SLOT(slotSrcNWClicked()) );
	connect( cmdSrcDown, SIGNAL(clicked()), SLOT(slotSrcDownClicked()) );
	connect( cmdSrcUp, SIGNAL(clicked()), SLOT(slotSrcUpClicked()) );
	
	connect( cmdDestN, SIGNAL(clicked()), SLOT(slotDestNClicked()) );
	connect( cmdDestNE, SIGNAL(clicked()), SLOT(slotDestNEClicked()) );
	connect( cmdDestE, SIGNAL(clicked()), SLOT(slotDestEClicked()) );
	connect( cmdDestSE, SIGNAL(clicked()), SLOT(slotDestSEClicked()) );
	connect( cmdDestS, SIGNAL(clicked()), SLOT(slotDestSClicked()) );
	connect( cmdDestSW, SIGNAL(clicked()), SLOT(slotDestSWClicked()) );
	connect( cmdDestW, SIGNAL(clicked()), SLOT(slotDestWClicked()) );
	connect( cmdDestNW, SIGNAL(clicked()), SLOT(slotDestNWClicked()) );
	connect( cmdDestDown, SIGNAL(clicked()), SLOT(slotDestDownClicked()) );
	connect( cmdDestUp, SIGNAL(clicked()), SLOT(slotDestUpClicked()) );
	
	connect( chkNormal, SIGNAL(clicked()), SLOT(slotNormalClicked()) );
	connect( chkSpecial, SIGNAL(clicked()), SLOT(slotSpecialClicked()) );	

}

DlgMapPathProperties::~DlgMapPathProperties()
{
}

void DlgMapPathProperties::setNormalExit(bool normal)
{
	chkNormal->setChecked(normal);
	chkSpecial->setChecked(!normal);
	cmdSrcNE->setEnabled(normal);
	cmdSrcE->setEnabled(normal);
	cmdSrcSE->setEnabled(normal);
	cmdSrcS->setEnabled(normal);
	cmdSrcSW->setEnabled(normal);
	cmdSrcW->setEnabled(normal);       	
	cmdSrcNW->setEnabled(normal);       	
	cmdSrcN->setEnabled(normal);       	
	cmdSrcDown->setEnabled(normal);       	              	              	              	              	
	cmdSrcUp->setEnabled(normal);       	
       	
       	cmdDestNE->setEnabled(normal);
	cmdDestE->setEnabled(normal);
	cmdDestSE->setEnabled(normal);
	cmdDestS->setEnabled(normal);
	cmdDestSW->setEnabled(normal);
	cmdDestW->setEnabled(normal);       	
	cmdDestNW->setEnabled(normal);       		
	cmdDestN->setEnabled(normal);       	
	cmdDestDown->setEnabled(normal);       	              	              	              	              	
	cmdDestUp->setEnabled(normal);       	
       	
	txtSpecial->setEnabled(!normal);
}

bool DlgMapPathProperties::getNormalExit(void)
{
	return chkNormal->isChecked();
}

void DlgMapPathProperties::setSpecialCmd(QString cmd)
{
	txtSpecial->setText(cmd);
}

QString DlgMapPathProperties::getSpecialCmd(void)
{
	return txtSpecial->text();
}


direction DlgMapPathProperties::getSrcDirection(void)
{
	if (chkSpecial->isChecked()) return SPECIAL;
	if (cmdSrcNE->isOn()) return NORTHEAST;
	if (cmdSrcE->isOn()) return EAST;
	if (cmdSrcSE->isOn()) return SOUTHEAST;
	if (cmdSrcS->isOn()) return SOUTH;
	if (cmdSrcSW->isOn()) return SOUTHWEST;
	if (cmdSrcW->isOn()) return WEST;
	if (cmdSrcNW->isOn()) return NORTHWEST;
	if (cmdSrcN->isOn()) return NORTH;
	if (cmdSrcDown->isOn()) return DOWN;
	if (cmdSrcUp->isOn()) return UP;
}

direction DlgMapPathProperties::getDestDirection(void)
{
	if (chkSpecial->isChecked()) return SPECIAL;
	if (cmdDestNE->isOn()) return NORTHEAST;
	if (cmdDestE->isOn()) return EAST;
	if (cmdDestSE->isOn()) return SOUTHEAST;
	if (cmdDestS->isOn()) return SOUTH;
	if (cmdDestSW->isOn()) return SOUTHWEST;
	if (cmdDestW->isOn()) return WEST;
	if (cmdDestNW->isOn()) return NORTHWEST;
	if (cmdDestN->isOn()) return NORTH;
	if (cmdDestDown->isOn()) return DOWN;
	if (cmdDestUp->isOn()) return UP;
}

bool DlgMapPathProperties::getTwoWay(void)
{
	return optTwoWay->isChecked();
}

void DlgMapPathProperties::setTwoWay(bool twoWay)
{
	if (twoWay)
	{
		optOneWay->setChecked(false);
		optTwoWay->setChecked(true);
	}
	else
	{
		optOneWay->setChecked(true);
		optTwoWay->setChecked(false);
	}

}

void DlgMapPathProperties::setDirections(direction srcDir,direction destDir)
{
	switch (srcDir)
	{
		case NORTH     : slotSrcNClicked(); break;
		case NORTHEAST : slotSrcNEClicked(); break;		
		case EAST      : slotSrcEClicked(); break;
		case SOUTHEAST : slotSrcSEClicked(); break;
		case SOUTH     : slotSrcSClicked(); break;
		case SOUTHWEST : slotSrcSWClicked(); break;
		case WEST      : slotSrcWClicked(); break;
		case NORTHWEST : slotSrcNWClicked(); break;
		case DOWN      : slotSrcDownClicked(); break;
		case UP        : slotSrcUpClicked(); break;
		case SPECIAL   : break;
	}
	
	switch (destDir)
	{
		case NORTH     : slotDestNClicked(); break;
		case NORTHEAST : slotDestNEClicked(); break;		
		case EAST      : slotDestEClicked(); break;
		case SOUTHEAST : slotDestSEClicked(); break;
		case SOUTH     : slotDestSClicked(); break;
		case SOUTHWEST : slotDestSWClicked(); break;
		case WEST      : slotDestWClicked(); break;
		case NORTHWEST : slotDestNWClicked(); break;
		case DOWN      : slotDestDownClicked(); break;
		case UP        : slotDestUpClicked(); break;	
		case SPECIAL   : break;
	}

}


void DlgMapPathProperties::unselectSrc(void)
{	
	cmdSrcN->setOn(false);
	cmdSrcNE->setOn(false);
	cmdSrcE->setOn(false);
	cmdSrcSE->setOn(false);
	cmdSrcS->setOn(false);
	cmdSrcSW->setOn(false);
	cmdSrcW->setOn(false);
	cmdSrcNW->setOn(false);
	cmdSrcDown->setOn(false);
	cmdSrcUp->setOn(false);
}

void DlgMapPathProperties::unselectDest(void)
{	
	cmdDestN->setOn(false);
	cmdDestNE->setOn(false);
	cmdDestE->setOn(false);
	cmdDestSE->setOn(false);
	cmdDestS->setOn(false);
	cmdDestSW->setOn(false);
	cmdDestW->setOn(false);
	cmdDestNW->setOn(false);
	cmdDestDown->setOn(false);
	cmdDestUp->setOn(false);
}

void DlgMapPathProperties::slotSrcNClicked(void)
{
	unselectSrc();
	cmdSrcN->setOn(true);
}

void DlgMapPathProperties::slotSrcNEClicked(void)
{
	unselectSrc();
	cmdSrcNE->setOn(true);
}

void DlgMapPathProperties::slotSrcEClicked(void)
{
	unselectSrc();
	cmdSrcE->setOn(true);
}

void DlgMapPathProperties::slotSrcSEClicked(void)
{
	unselectSrc();
	cmdSrcSE->setOn(true);
}

void DlgMapPathProperties::slotSrcSClicked(void)
{
	unselectSrc();
	cmdSrcS->setOn(true);
}

void DlgMapPathProperties::slotSrcSWClicked(void)
{
	unselectSrc();
	cmdSrcSW->setOn(true);
}

void DlgMapPathProperties::slotSrcWClicked(void)
{
	unselectSrc();
	cmdSrcW->setOn(true);
}

void DlgMapPathProperties::slotSrcNWClicked(void)
{
	unselectSrc();
	cmdSrcNW->setOn(true);
}

void DlgMapPathProperties::slotSrcDownClicked(void)
{
	unselectSrc();
	cmdSrcDown->setOn(true);
}

void DlgMapPathProperties::slotSrcUpClicked(void)
{
	unselectSrc();
	cmdSrcUp->setOn(true);
}


void DlgMapPathProperties::slotDestNClicked(void)
{
	unselectDest();
	cmdDestN->setOn(true);
}

void DlgMapPathProperties::slotDestNEClicked(void)
{
	unselectDest();
	cmdDestNE->setOn(true);
}

void DlgMapPathProperties::slotDestEClicked(void)
{
	unselectDest();
	cmdDestE->setOn(true);
}

void DlgMapPathProperties::slotDestSEClicked(void)
{
	unselectDest();
	cmdDestSE->setOn(true);
}

void DlgMapPathProperties::slotDestSClicked(void)
{
	unselectDest();
	cmdDestS->setOn(true);
}

void DlgMapPathProperties::slotDestSWClicked(void)
{
	unselectDest();
	cmdDestSW->setOn(true);
}

void DlgMapPathProperties::slotDestWClicked(void)
{
	unselectDest();
	cmdDestW->setOn(true);
}

void DlgMapPathProperties::slotDestNWClicked(void)
{
	unselectDest();
	cmdDestNW->setOn(true);
}

void DlgMapPathProperties::slotDestUpClicked(void)
{
	unselectDest();
	cmdDestUp->setOn(true);
}

void DlgMapPathProperties::slotDestDownClicked(void)
{
	unselectDest();
	cmdDestDown->setOn(true);
}

void DlgMapPathProperties::slotSpecialClicked(void)
{
	setNormalExit(false);	
}

void DlgMapPathProperties::slotNormalClicked(void)
{
	setNormalExit(true);
}