/***************************************************************************
                          cmaptoolzone.cpp
                      -------------------
    description          :
    begin                : Mon Dec 4 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmaptoolzone.h"

CMapToolZone::CMapToolZone(CMapData *mapData,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu) : CMapToolBase(mapData,map,id,name,icon,toolBar,menu)
{
}

CMapToolZone::~CMapToolZone()
{
}

/** This method is called when the mouse is pressed */
void CMapToolZone::mousePressEvent(QMouseEvent *e)
{
	
}

/** This method is called when the mouse is released */
void CMapToolZone::mouseReleaseEvent(QMouseEvent *e)
{

	int x = (int)(e->x() / ROOM_SIZE) + 1;
	int y = (int)(e->y() / ROOM_SIZE) + 1;
	QScrollView *mapView = mapWidget->getMapView();

	if (mapWidget->getViewOverview() && mapWidget->width()>180 && mapWidget->height()>100)
	{
		int view_x,view_y;
		if (mapView->viewport()->width()>mapView->contentsWidth())
			view_x =mapView->contentsWidth();
		else
			view_x =mapView->viewport()->width();

		if (mapView->viewport()->height()>mapView->contentsHeight())
			view_y =mapView->contentsHeight();
		else
			view_y =mapView->viewport()->height();

		if (e->x()>=mapView->contentsX()+view_x-180 &&
			e->x()<=mapView->contentsX()+view_x &&
            		e->y()>=mapView->contentsY()+view_y-100 &&
	                e->y()<=mapView->contentsY()+view_y)
		{
			return;			
		}
	}
	
	mapWidget->createZone(x,y,mapWidget->getCurrentLevel(),mapWidget->getCurrentZone(),true);	
	
	int incx=0,incy=0;
	if (x == 1) incx = 2;
	if (y == 1) incy = 2;
	if (x == 2) incx = 1;
	if (y == 2) incy = 1;
	
	if (incx != 0 || incy !=0)
		mapWidget->moveMap(incx,incy);

	mapWidget->redraw();

	lastX=-100;
	lastY=-100;
}

/** This method is called when the mouse is moved */
void CMapToolZone::mouseMoveEvent(QMouseEvent *e)
{

	int posx = (((int)(e->x() / ROOM_SIZE)) * ROOM_SIZE);
	int posy = (((int)(e->y() / ROOM_SIZE)) * ROOM_SIZE);

	dragPainter.begin(mapWidget);	
	dragPainter.setPen(black);
	dragPainter.setBrush(QColor(black));

	dragPainter.setRasterOp(NotROP);

	if (posx>=0 && posy>=0)
	{
		// Erase old one
		dragPainter.drawRect(lastX+1,lastY+1,ROOM_SIZE-2,ROOM_SIZE-2);	

		// Draw new one
		dragPainter.drawRect(posx+1,posy+1,ROOM_SIZE-2,ROOM_SIZE-2);	
   	}
	dragPainter.end();

	lastX = posx;
	lastY = posy;
}

/** This function called when the zone tool is selected */
void CMapToolZone::toolSelected(void)
{
	mapWidget->setMouseTracking(true);
	lastX=-100;
	lastY=-100;
	
	mapWidget->setCursor(arrowCursor);
	menu->setItemChecked(id,true);		
	toolsToolbar->setButton(id,true);	
}
	
/** This function is called when the zone tool is unselected */
void CMapToolZone::toolUnselected()
{
	mapWidget->redraw();
	menu->setItemChecked(id,false);		
	toolsToolbar->setButton(id,false);
}