/***************************************************************************
                          cmaptoolbase.h
                      -------------------
    description          : Base class for map tools
    begin                : Fri Sep 8 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPTOOLBASE_H
#define CMAPTOOLBASE_H

#include <qpixmap.h>
#include <qobject.h>
#include <qevent.h>
#include <qcursor.h>
#include <qlist.h>
#include <qcursor.h>
#include <qscrollview.h>
#include <qbitmap.h>

#include <ktoolbar.h>
#include <qpopupmenu.h>

#include "cmapelement.h"
#include "cmapwidget.h"
#include "cmapdata.h"

// Protypes
class CMapWidget;
class CMapRoom;
class CMapText;
class CMapPath;

/** This is a base class for all mapper tools.
  * @author John-Paul Stanford
  */

class CMapToolBase : public QObject
{
Q_OBJECT
public:
	/** The constructor */
	CMapToolBase(CMapData *mapData,CMapWidget *map,int id1,QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu1) ;	

	/** The destructor */
	~CMapToolBase() { };
	
	virtual void mousePressEvent(QMouseEvent *e)=0;
	virtual void mouseReleaseEvent(QMouseEvent *e)=0;
	virtual void mouseMoveEvent(QMouseEvent *e)=0;	
	
	/** This function called when a tool is selected */
	virtual void toolSelected(void) { };
	/** This function is called when a tool is unselected */
	virtual void toolUnselected() { };
	
	/** These functions are used to set and get the icons */
	void setDownIcon(QPixmap icon);
	void setUpIcon(QPixmap icon);
	QPixmap getUpIcon(void);
	QPixmap getDownIcon(void);
	
	/** Used to set and get the mouse cursor for the tool */
protected:
	/** List of elements on the current level */
	QList<CMapElement> *elementList;
	/** A pointer to the map widget */
	CMapWidget *mapWidget;
	QPixmap upIcon;
	QPixmap downIcon;
	QString name1;
	int id;
	int menu_id;
	KToolBar *toolsToolbar;
	QPopupMenu *menu;	
	CMapData *mapperData;
};


#endif

