#include <qstring.h>
#include <qlist.h>
//#include <kmsgbox.h>
#include <kapp.h>
#include <qmessagebox.h>

#include "modifytable.h"
#include "tabledescr.h"
#include "globals.h"
#include "compoundkeydlg.h"
#include "stringres.h"
#include "my_sql.h"

#include <qcheckbox.h>                                                          
#include <qcombobox.h>                                                          
#include <qframe.h>                                                             
#include <qlabel.h>                                                             
#include <qlcdnumber.h>                                                         
#include <qlineedit.h>                                                          
#include <qlistbox.h>                                                           
#include <qpushbutton.h>                                                        
#include <qradiobutton.h>                                                       
#include <qslider.h>                                                            
#include <qlayout.h>                                                            
#include <qvariant.h>                                                           
#include <qtooltip.h>                                                           
#include <qwhatsthis.h>

#ifndef rcsid
static const char rcsid[]="$Id: modifytable.cpp,v 2.26 2001/04/14 10:56:03 ral Exp $";
//const char*modifytable_rcs(){return rcsid;}
#endif

#define Inherited CCreateTableData

CModifyTable::CModifyTable(smart_pointer<CMySql>& _sql_server, QWidget* parent, const char* name )
    :Inherited( parent, name, true)
{
    sql_server = _sql_server;
    int count;
    for (count = 0; count < CMySql::FieldDescriptCounts(); count++) {
	TypeComboList->insertItem(CMySql::FieldDescript(count));
    }
    EnumList->setInsertionPolicy(QComboBox::NoInsertion);
    SetTypeInt(0);
    stringlist db_list;
    CurrentTables.resize(0);
    if (sql_server) {
	sql_server->get_db_list("%",db_list);
	if (db_list.size()) {
	    stringlist::iterator iter;
	    for (iter = db_list.begin();iter != db_list.end();++iter) {
		DBList->insertItem(iter->c_str());
	    }
	} else {
	    DBList->insertItem("No DBs found");
	}
    } else {
	DBList->insertItem("Not connected");
    }

    AddButton->setEnabled(FALSE);
    CreateTableButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    DeleteButton->setEnabled(FALSE);
    CompoundKeyButton->setEnabled(FALSE);
    Key_Name_Edit->setEnabled(false);
    ColumnNameEdit->setEnabled(false);

    sql_server->get_table_list("%",DBList->currentText(),CurrentTables);
}


CModifyTable::~CModifyTable()
{

}

void CModifyTable::SetFloat(int i)
{
    FloatDisplay->display(i);
}

void CModifyTable::Set_KeySize(int i)
{
    K_Size_Display->display(i);
}

void CModifyTable::SetDec(int i)
{
    DecDisplay->display(i);
    int Item = TypeComboList->currentItem();
    if (Item > 6 && Item < 10) {
	KeySizeSlider->setRange(1,i);
	K_Size_Display->display(KeySizeSlider->value());
    }
}

void CModifyTable::Set_AutoInc(bool how)
{
    if (how) {
	Primary_Key->setChecked(how);
	Key_None->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Key_Name_Edit->setEnabled(how);
    }
}

void CModifyTable::Set_KeyNone(bool how)
{
    if (how) {
	AutoInc->setChecked(FALSE);
	Key_Name_Edit->setEnabled(FALSE);
	KeySizeSlider->setEnabled(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Primary_Key->setChecked(FALSE);
    }
}

void CModifyTable::SetKey(bool how)
{
    Key_Name_Edit->setEnabled(how&&!Primary_Key->isChecked());
    int Item = TypeComboList->currentItem();
    if (sql_server->sql_type(Item)._keysize) {
	KeySizeSlider->setRange(1,DecBar->value());
	KeySizeSlider->setEnabled(how && true);
    } else {
	KeySizeSlider->setRange(DecBar->value(),DecBar->value());
	KeySizeSlider->setEnabled(false);
    }
    K_Size_Display->display(KeySizeSlider->value());
}

void CModifyTable::Set_UniqueKey(bool how)
{
    if (how) {
	MultiKey->setChecked(FALSE);
	Primary_Key->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::Set_Primary_Key(bool how)
{
    if (how) {
	MultiKey->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::Set_MultiKey(bool how)
{
    if (how) {
	Primary_Key->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::SetTypeInt(int DataType)
{
    if (DataType >= sql_server->FieldDescriptCounts()) 
	return;

#define STY sql_server->sql_type(DataType)

    DecBar->setRange(STY._dec_min,STY._dec_max);
    if (STY._dec_min == STY._dec_max) {
	DecBar->setEnabled(FALSE);
    } else {
	DecBar->setEnabled(TRUE);
    }
    FloatBar->setRange(STY._float_min,STY._float_max);
    if (STY._float_min == STY._float_max) {
	FloatBar->setEnabled(FALSE);
    } else {
	FloatBar->setEnabled(TRUE);
    }
    DefaultValueEdit->setEnabled(STY._default);
    ZeroFill->setEnabled(STY._zero_fill);
    AutoInc->setEnabled(STY._auto_inc);
    if (!STY._auto_inc)
	AutoInc->setChecked(false);
    if (!STY._zero_fill)
	ZeroFill->setChecked(false);
    Unsigned->setEnabled(STY._unsigned);
    if (!STY._unsigned)
	Unsigned->setChecked(false);
    BinaryBox->setEnabled(STY._binary);
    if (!STY._binary)
	BinaryBox->setChecked(false);
    if (STY._keys) {
	Key_None->setEnabled(TRUE);
	Primary_Key->setEnabled(TRUE);
	UniqueKey->setEnabled(TRUE);
	MultiKey->setEnabled(TRUE);
    } else {
	Key_None->setChecked(TRUE);
	Primary_Key->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Key_None->setEnabled(FALSE);
	Primary_Key->setEnabled(FALSE);
	UniqueKey->setEnabled(FALSE);
	MultiKey->setEnabled(FALSE);
    }
    if (STY._keysize) {
	KeySizeSlider->setRange(DecBar->minValue(),DecBar->value());
	KeySizeSlider->setEnabled(TRUE);
    } else {
	KeySizeSlider->setEnabled(FALSE);
    }
    if (STY._enums) {
	EnumList->setEnabled(TRUE);
    } else {
	EnumList->setEnabled(FALSE);
    }
    SetFloat(FloatBar->value());
    SetDec(DecBar->value());
#undef STY
}

void CModifyTable::TableTextChanged(const QString&text)
{
    bool how =  (text.length()>0 &&
		 (CurrentTables.find(text.latin1()) == 0) );
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && ColumnNameEdit->text().length()>0 );
}
 
void CModifyTable::TableTextActivate()
{
}

void CModifyTable::NameChanged(const QString&text)
{
    AddButton->setEnabled(text.length()>0);
}

void CModifyTable::SetDBString(const QString&)
{
}

int CModifyTable::ReadDescriptor(CColumnDescriptor*col_target,QString*str_target,CKeyDescriptor*target_key)
{
    QString Entry = ColumnNameEdit->text();
    QString Helper;

    if (!col_target || !str_target || !target_key)
	return 0;

    Entry+= " ";

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    Desc.set_FieldType(TypeComboList->currentItem());
    
    Entry+=CMySql::TypeDescript(TypeComboList->currentItem());
    
    if (DecBar->value()) {
	Entry+="(";
	Helper.setNum(DecBar->value());
	Entry+=Helper;
	if (FloatBar->value()) {
	    Helper.setNum(FloatBar->value());
	    Entry+=",";
	    Entry+=Helper;
	}
	Entry+=")";
    }

    int DataType = TypeComboList->currentItem();

    if (sql_server->sql_type(DataType)._dec_min == sql_server->sql_type(DataType)._dec_max) {
	Desc.set_MaxLength(0);
    } else {
	Desc.set_MaxLength(DecBar->value());
    }
    Desc.set_MaxDecimals(FloatBar->value());
    if (Unsigned->isChecked() && Unsigned->isEnabled()) {
	Entry+=" UNSIGNED";
	Desc.set_Unsigned(Unsigned->isChecked());
    } else {
	Desc.set_Unsigned(0);
    }
    if (ValNotNull->isChecked()) {
	Entry+= " NOT NULL";
	Desc.set_NotNull(1);
	if (DefaultValueEdit->isEnabled() && strlen(DefaultValueEdit->text())) {
	    Entry+= " DEFAULT \"";
	    Entry+=DefaultValueEdit->text();
	    Entry+="\"";
	    Desc.set_default(DefaultValueEdit->text());
	}
    } else {
	Desc.set_NotNull(0);
    }
    // Autoincrement on?
    if (AutoInc->isEnabled() && AutoInc->isChecked()) {
	Entry+=" AUTO_INCREMENT";
	Desc.set_AutoIncrement(AutoInc->isChecked());
    } else {
	Desc.set_AutoIncrement(FALSE);
    }
    if (ZeroFill->isEnabled() && ZeroFill->isChecked()) {
	Entry+=" ZEROFILL";
	Desc.set_ZeroFill(true);
    } else {
	Desc.set_ZeroFill(false);
    }
    if (BinaryBox->isEnabled() && BinaryBox->isChecked()) {
	Entry+= " BINARY";
	Desc.set_Binary(true);
    } else {
	Desc.set_Binary(false);
    }
    if (!Key_None->isChecked()) {
	CKeyDescriptor Key;
	//	Key.add_column_name(ColumnNameEdit->text());
	Helper=Key_Name_Edit->text();
	if (Helper.length() == 0) {
	    Helper = "Key_";
	    Helper+=ColumnNameEdit->text();
	}
	if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	    Helper="PRIMARY";
	    Entry+=" PRIMARY KEY";
	    Desc.set_Primary(true);
	    Key.setType(CKeyDescriptor::PRIMARY);
	} else if (UniqueKey->isEnabled() && UniqueKey->isChecked()) {
	    Entry+=" UNIQUE";
	    Desc.set_Unique(true);
	    Key.setType(CKeyDescriptor::UNIQUE);
	} else if (MultiKey->isEnabled() && MultiKey->isChecked()) {
	    Entry+=" MULTI";
	    Desc.set_PartOfMultiKey(true);
	    Key.setType(CKeyDescriptor::INDEX);
	}
	
	int key_size = 0;

	Key.set_name(Helper);
        debug("Key name: %s\n",Key.get_name());
	int Item;
	if (sql_server->sql_type(DataType)._keysize) {
	    Item = KeySizeSlider->value();
	    if (Item < DecBar->value()) {
		Helper.setNum(Item);
		Entry+="(";
		Entry+=Helper;
		Entry+=")";
		key_size = Item;
	    }
	}
	Key.add_column_name(ColumnNameEdit->text(),key_size);
	*target_key = Key;
    }
    if (sql_server->sql_type(DataType)._enums) {
	Desc.enum_list(enums);
    }
    *col_target = Desc;
    *str_target = Entry;
 
    return 1;
}

void CModifyTable::AddColumn()
{
    _add_column();
}

bool CModifyTable::_add_column()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    if (desc_list.find(Desc)!=0) {
	QMessageBox::critical(this,CStringRes::get_string(6),
			      CStringRes::get_string(7));
	return false;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	if (key_list.find(Key)) {
	    QMessageBox::critical(this,CStringRes::get_string(6),
				  CStringRes::get_string(8));
	    return false;
	}
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
	return false;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
	CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
    return true;
}

void CModifyTable::ColumnSelected(int Item)
{
    if (Item < 0 || desc_list.size() <= (unsigned int)Item)
	return;
    DeleteButton->setEnabled(TRUE);
    ModifyButton->setEnabled(TRUE);
    ColumnNameEdit->setText(desc_list[Item].get_name());
    EnumList->clear();
    enums.clear();
    stringIlist e_list = desc_list[Item].enum_list();
    stringIlist::iterator iter = e_list.begin();
    enums = e_list;
    for (;iter!=e_list.end();++iter) {
	EnumList->insertItem(iter->c_str());
	if (iter == e_list.begin()) {
	    EnumList->setCurrentItem(0);
	}
    }
    ZeroFill->setChecked(desc_list[Item].is_ZeroFill());
    ValNotNull->setChecked(desc_list[Item].is_NotNull());
    AutoInc->setChecked(desc_list[Item].is_AutoIncrement());
    Unsigned->setChecked(desc_list[Item].is_Unsigned());
    BinaryBox->setChecked(desc_list[Item].is_Binary());
    unsigned int i = 0;
    i = desc_list[Item].get_FieldType();

    TypeComboList->setCurrentItem(i);
    SetTypeInt(desc_list[Item].get_FieldType());

    DecBar->setValue(desc_list[Item].get_MaxLength());
    FloatBar->setValue(desc_list[Item].get_MaxDecimals());
    DefaultValueEdit->setText(desc_list[Item].get_default());

    if (desc_list[Item].is_KeyField()) {
	bool key_real_found = false;
	KeyList_iterator key_iter;
	for (key_iter = key_list.begin();key_iter!=key_list.end();++key_iter) {
	    if (!key_iter->is_compound() && 
		key_iter->contains_column_name(desc_list[Item].get_name())) {
		key_real_found = true;
		if (key_iter->getType()!=CKeyDescriptor::PRIMARY) {
		    Key_Name_Edit->setText(key_iter->get_name());
		} else {
		    Key_Name_Edit->setText("");
		}
		switch (key_iter->getType()) {
		case CKeyDescriptor::UNIQUE:
		    Set_UniqueKey(true);
		    UniqueKey->setChecked(true);
		    break;
		case CKeyDescriptor::INDEX:
		    MultiKey->setChecked(true);
		    Set_MultiKey(true);
		    break;
		case CKeyDescriptor::PRIMARY:
		    Primary_Key->setChecked(true);
		    Set_Primary_Key(true);
		    break;
		default:
		    Set_KeyNone(true);
		    Key_None->setChecked(true);
		    break;
		}
		break;
	    }
	}
	if (!key_real_found) {
	    Set_KeyNone(true);
	    Key_None->setChecked(true);
	    desc_list[Item].set_PartOfMultiKey(false);
	    Key_Name_Edit->setText("");
	}
    } else {
	Key_Name_Edit->setText("");
	Set_KeyNone(true);
	Key_None->setChecked(true);
    }
}

void CModifyTable::Modify_Column()
{
    _modify_column();
}

bool CModifyTable::_modify_column()
{
    CKeyDescriptor Key;
    QString text;
    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    
    int i = ColumnsList->currentItem();
    if (i < 0)
	return false;
    if (desc_list.size() <= (unsigned int)i)
	return false;
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	KeyList_iterator iter = key_list.find(Key);
	if (iter) {
	    if (!iter->contains_column_name(desc_list[i].get_name())) {
		if (!iter->contains_column_name(desc_list[i].get_name())) {
		    QMessageBox::critical(this,CStringRes::get_string(9),
					  CStringRes::get_string(8));
		    return false;
		}
	    }
	} else {
        }
    }

    if (Desc != desc_list[i]) {
	// check for duplicates if name has changed
	if (desc_list.find(Desc)!=0) {
	    QMessageBox::critical(this,CStringRes::get_string(9),
				  CStringRes::get_string(7));
	    return false;
	}
	RemoveFromKey(desc_list[i].get_name(),true,Desc.get_name());
    }
    RemoveFromKey(desc_list[i].get_name());
    if (!ReadDescriptor(&Desc,&text,&Key))
	return false;
    desc_list[i]=Desc;
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
    ColumnsList->changeItem(text,i);
    return true;
}

void CModifyTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
	return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
	if (counter == Index) {
	    desc_list.erase(col_iter);
	    break;
	}
	++counter;
    }
    if (desc_list.size() < 2) {
	CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
	CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
	DeleteButton->setEnabled(FALSE);
	ModifyButton->setEnabled(FALSE);
    }
}

void CModifyTable::Build_Compound()
{
    CCompoundKeyDlg dlg(this);
    dlg.set_Columns(&desc_list,&key_list);
    dlg.exec();
    RemoveFromKey(NULL,true);
}

void CModifyTable::AddEnum()
{
    if (enums.find(EnumList->currentText().latin1()))
	return;
    QString current = EnumList->currentText();
    EnumList->insertItem(current,0);
    enums.push_back(std::string(EnumList->currentText()));
}

void CModifyTable::DelEnum()
{
    if (EnumList->count() == 0)
	return;
    int i = EnumList->currentItem();
    stringIlist::iterator iter = enums.find(EnumList->currentText().latin1());
    if (iter)
	enums.erase(iter);
    if (i == -1)
	return;
    EnumList->removeItem(i);
}

void CModifyTable::RemoveFromKey(const char*col_name,bool compounds,const char*new_name)
{
    KeyList_iterator key_iterator;
    for (key_iterator = key_list.begin(); key_iterator != key_list.end();++key_iterator) {
	if (key_iterator->is_compound() == compounds) {
	    if (col_name && key_iterator->contains_column_name(col_name)) {
		key_iterator->remove_column_name(col_name);
		if (compounds && new_name) {
		    key_iterator->add_column_name(new_name);
		}
	    }
	    if (key_iterator->column_count() == 0) {
		key_iterator = key_list.erase(key_iterator);
		--key_iterator;
	    }
	}
    }
}
void CModifyTable::Set_ValNotNull(bool)
{
}
