// -*- Mode: C++; -*-
// $Id: change_type.h,v 2.6 2001/04/13 23:58:56 ral Exp $

#include "pairs.h"
#include "liste.h"
#include "stringlist.h"
#include "specials.h"

#ifndef change_type_included
#define change_type_included

//! helper class for alter tables
struct change_type : public string_pair{
    //! type of change
    enum c_type{
        //! do nothing
        none,
        //! new column
        add,
        //! change column
        mod,
        //! delete column
        del};
    //!
    string_pair columns;
    //! type of change
    c_type typ;

    //! simple contructor
    change_type():columns(){typ = none;}
};

typedef my_vector<change_type> base_change_list;

//! list of changes
class change_list:public base_change_list
{

public:
    iterator find_second(const change_type&what,iterator start_pos=0);
    iterator find(const change_type&what,iterator start_pos=0);
    
    iterator find_second(const std::string&what,iterator start_pos=0);
    iterator find(const std::string&what,iterator start_pos=0);

    iterator find_second(const char*what,iterator start_pos=0);
    iterator find(const char*what,iterator start_pos=0);
};

inline change_list::iterator
change_list::find_second(const change_type&what,const iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.columns.second.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find(const change_type&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.columns.first.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find_second(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find_second(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find_second(t);
}

inline change_list::iterator
change_list::find(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find(t);
}

#endif
