/*
 * KMLOFax
 *
 * A utility to process facsimiles received with the ELSA
 * MicroLink(tm) Office or MicroLink(tm) ISDN Office modem.
 *
 * Copyright (C) 1999-2001 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen.
 */

#ifndef CONFIGURE_H
#define CONFIGURE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qcombobox.h>

#include <kconfig.h>
#include <kdialogbase.h>


class Configure : public KDialogBase
{
	Q_OBJECT
public:
	Configure(QWidget *parent = 0, const char *name = 0);
	~Configure();

	void addToolTips(bool on);

protected:
	void reset();

protected slots:
	virtual void slotDefault();
	virtual void slotOk();
	virtual void slotApply();
	virtual void slotCancel();

signals:
	void newConfig();

private:
	KConfig *config;

	bool gotToolTips;

	QCheckBox *gen_tooltips;
	QCheckBox *gen_loadnew;
	QCheckBox *gen_deletefax;

	QLineEdit *mod_device;
	QComboBox *mod_speed;

	QSpinBox *prt_lmargin;
	QSpinBox *prt_rmargin;
	QSpinBox *prt_tmargin;
	QSpinBox *prt_bmargin;

	QLineEdit *mail_server;
	QLineEdit *mail_port;
	QLineEdit *mail_name;
	QLineEdit *mail_org;
	QLineEdit *mail_email;
	QLineEdit *mail_reply;
};


extern Configure *configure;

#endif // CONFIGURE_H
