/************************************************************************
 * kcreateinst - part of kinst package - tparams.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "tparams.h"

int LoadParams(tParams* params, const char* filename)
{
  FILE* f;
  size_t i;
  char ver_maj, ver_min;

  f = fopen(filename, "r");
  if(f == NULL) return(2); // Err 2: Could not open file

  i = fread(&ver_maj, sizeof(char), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error reading file
  i = fread(&ver_min, sizeof(char), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error reading file

  if(ver_maj != KIFOPTIONS_VERSION_MAJ)
    { if(f != NULL) fclose(f); return(4); } // Err 4: Wrong file version
  if(ver_min != KIFOPTIONS_VERSION_MIN)
    { if(f != NULL) fclose(f); return(4); } // Err 4: Wrong file version

  i = fread(params, sizeof(tKIFOptions), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error reading file

  if(f != NULL) fclose(f);

  return(1);
}

int SaveParams(tParams* params, const char* filename)
{
  FILE* f;
  size_t i;
  char ver_maj, ver_min;

  ver_maj = KIFOPTIONS_VERSION_MAJ;
  ver_min = KIFOPTIONS_VERSION_MIN;

  f = fopen(filename, "w");
  if(f == NULL) return(2); // Err 2: Could not create/open file

  i = fwrite(&ver_maj, sizeof(char), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error writing to file
  i = fwrite(&ver_min, sizeof(char), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error writing to file

  i = fwrite(params, sizeof(tKIFOptions), 1, f);
  if(i < 1)
    { if(f != NULL) fclose(f); return(3); } // Err 3: I/O error writing to file

  if(f != NULL) fclose(f);

  return(1);
}
