/*************************************************************
 *
 *  Copyright (c) 2018 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import {SVGCharMap, AddPaths} from '../../FontData.js';
import {monospace as font} from '../../../common/fonts/tex/monospace.js';

export const monospace: SVGCharMap = AddPaths(font, {
    0x20: '',
    0x21: '206 565Q206 590 222 606T265 622Q287 621 303 606T319 565T314 392L308 216Q299 194 273 194H262Q247 194 241 195T228 200T217 216L211 392Q206 539 206 565ZM206 56Q206 83 223 99T265 115Q288 113 304 99T320 58Q320 33 303 17T262 0Q237 0 222 17T206 56',
    0x22: '122 575Q122 593 137 608T173 623Q196 623 210 608T225 575Q225 562 218 464Q212 373 211 361T201 341Q193 333 173 333Q154 333 146 341Q138 348 137 360T129 464Q122 561 122 575ZM299 575Q299 593 314 608T350 623Q373 623 387 608T402 575Q402 562 395 464Q389 373 388 361T378 341Q370 333 350 333Q331 333 323 341Q315 348 314 360T306 464Q299 561 299 575',
    0x23: '93 163Q74 163 65 164T46 173T36 198Q36 210 40 215T61 233H131V236Q132 239 140 307T149 377Q149 379 105 379L61 380Q36 392 36 414Q36 450 86 450Q91 450 99 450T112 449H159Q163 480 167 517Q168 524 170 545T174 573T180 591T191 607T210 611Q223 611 232 604T243 588L245 580Q245 565 238 511T230 451Q230 449 282 449H333Q337 480 341 517Q342 524 343 537T345 556T348 573T352 589T359 600T370 608T384 611Q395 611 406 602T419 580Q419 565 412 511T404 451Q404 449 431 449H442Q477 449 485 429Q489 421 489 414Q489 392 463 380L428 379H394V376Q393 373 385 305T376 235Q376 233 419 233H463L468 230Q472 227 473 227T477 223T482 218T486 213T488 206T489 198Q489 162 436 162Q430 162 422 162T412 163H366V161Q364 159 357 92Q356 85 355 73T353 54T350 37T346 22T339 11T328 3T314 0Q303 0 292 9T279 31Q279 37 287 96T295 162Q295 163 244 163H192V161Q190 159 183 92Q182 85 181 73T179 54T176 37T172 22T165 11T154 3T140 0Q129 0 118 9T105 31Q105 37 113 96T121 162Q121 163 93 163ZM323 377Q323 379 272 379H220V376Q219 373 211 305T202 235Q202 233 253 233H305V236Q306 239 314 307T323 377',
    0x24: '415 397Q392 397 377 411T362 448Q362 464 376 485Q369 498 362 506T346 520T332 528T315 533T300 538V445L301 353L311 350Q382 334 424 284T466 174Q466 115 425 65T303 -2L300 -3V-30Q300 -64 291 -74Q283 -82 262 -82H255Q234 -82 225 -60L224 -32V-4L213 -2Q152 6 106 51T59 170V180Q59 197 74 213Q89 227 110 227T146 213T162 174Q162 156 147 137Q153 123 161 112T176 95T191 85T205 79T216 76T224 74V283L213 285Q147 298 103 343T58 449Q58 516 108 560T224 614V643V654Q224 666 226 673T237 687T264 694Q289 693 294 683T300 642V615H303Q355 607 390 587T440 540T460 493T466 453Q466 425 451 411T415 397ZM137 452Q137 425 158 404T198 376T223 369Q224 369 224 453T223 537Q198 532 168 509T137 452ZM301 75Q307 75 325 83T365 116T387 171Q387 238 300 267V171Q300 75 301 75',
    0x25: '35 560Q35 607 54 645T110 693Q111 693 116 693T125 694Q165 692 187 651T210 560Q210 506 186 467T123 428Q84 428 60 466T35 560ZM139 560Q139 574 136 587T130 608T124 615Q122 617 120 614Q106 595 106 561Q106 516 121 506Q123 504 125 507Q139 526 139 560ZM123 -83Q107 -83 98 -73T88 -48Q88 -43 89 -41Q90 -37 229 316T370 675Q381 694 400 694Q416 694 426 684T436 659Q436 654 435 652Q434 647 295 294T153 -65Q144 -83 123 -83ZM314 50Q314 104 338 143T400 183Q439 183 464 144T489 50T465 -43T402 -82Q358 -82 336 -41T314 50ZM417 50Q417 71 413 85T405 102L401 106Q386 95 386 50Q386 29 390 15T398 -2L402 -6Q417 5 417 50',
    0x26: '96 462Q96 546 132 584T211 622Q255 622 284 583T314 474Q314 395 224 305L208 288Q213 275 226 251L265 185L269 179Q273 184 299 246L332 333L342 363Q342 364 341 365Q334 365 334 393Q334 406 334 410T340 420T356 431H412H440Q467 431 478 424T490 393Q490 376 484 367T470 357T448 355H441H415L399 312Q349 176 322 127L315 115L323 106Q360 65 393 65Q405 65 410 80T416 109Q416 140 452 140Q487 140 487 105Q487 56 460 23T391 -11L286 41L273 53L262 42Q212 -11 151 -11Q97 -11 63 33T28 143Q28 161 30 176T38 205T47 227T60 247T72 261T84 274T94 283L122 311L119 323Q96 392 96 462ZM243 474Q243 533 218 545L215 546Q212 546 210 546Q182 546 169 501Q167 492 167 466Q167 419 179 368L188 377Q234 425 242 461Q243 465 243 474ZM217 129Q185 174 154 235Q121 214 115 176Q113 168 113 143Q113 83 139 67Q141 66 152 66Q191 66 228 112L217 129',
    0x27: '205 554Q205 577 221 594T263 611Q302 611 325 577T349 490Q349 409 298 347Q285 330 258 309T214 287Q203 289 189 302T175 327Q175 341 185 349T213 369T245 402Q269 437 273 483V497Q264 496 263 496Q240 496 223 513T205 554',
    0x28: '437 -53Q437 -82 399 -82H394Q377 -82 342 -55Q259 7 213 102T166 306Q166 412 211 507T342 667Q377 694 393 694H399Q437 694 437 665Q437 654 426 643T397 620T356 584T311 525Q301 511 290 488T264 412T250 306Q250 191 300 105T422 -27Q437 -37 437 -53',
    0x29: '87 664Q87 694 126 694Q138 694 147 690T183 667Q266 605 312 510T358 306Q358 193 307 93T161 -70Q142 -82 126 -82Q105 -82 96 -73T87 -53Q87 -47 88 -44Q92 -36 116 -19T173 34T230 119Q273 206 273 306Q273 408 231 494T109 635Q87 649 87 664',
    0x2A: '222 487Q224 501 235 510T262 520Q279 520 289 510T302 487Q302 458 301 429Q301 421 301 413T301 398T300 386T300 377V374Q300 373 301 373Q304 373 353 403T416 434Q432 434 444 423T456 393Q456 389 456 386T454 379T451 373T448 368T442 363T436 358T427 353T417 348T405 342T391 334Q345 309 339 305L388 279Q400 273 412 266T432 255T441 250Q456 238 456 218Q456 200 445 189T417 177Q403 177 354 207T301 238Q300 238 300 237V234Q300 231 300 226T300 214T301 199T301 182Q302 153 302 124Q300 109 289 100T262 90T235 100T222 124Q222 153 223 182Q223 190 223 198T223 213T224 225T224 234V237Q224 238 223 238Q220 238 171 208T108 177Q92 177 80 188T68 218Q68 237 79 246T134 277Q180 303 185 306L136 332Q124 338 112 345T92 356T83 361Q68 373 68 393Q68 411 79 422T107 434Q121 434 170 404T223 373Q224 373 224 374V377Q224 380 224 385T224 397T223 412T223 429Q222 458 222 487',
    0x2B: '147 271Q138 271 122 271T98 270Q68 270 53 277T38 306T53 335T98 342Q105 342 121 342T147 341H227V423L228 505Q241 531 262 531Q268 531 273 530T282 525T287 519T293 511L297 505V341H377H430Q457 341 467 338T483 321Q487 313 487 306Q487 295 480 286T463 273Q457 271 377 271H297V107Q281 81 262 81Q250 81 242 87T230 100L228 107L227 189V271H147',
    0x2C: '193 37T193 70T213 121T260 140Q302 140 327 108T353 36Q353 -7 336 -43T294 -98T249 -128T215 -139Q204 -139 189 -125Q177 -111 174 -101Q172 -84 183 -77T217 -61T253 -33Q261 -24 272 1L265 0Q234 0 214 18',
    0x2D: '57 306Q57 333 86 341H438Q468 332 468 306T438 271H86Q57 280 57 306',
    0x2E: '193 70Q193 105 214 122T258 140Q291 140 311 120T332 70Q332 44 314 23T262 1Q234 1 214 18T193 70',
    0x2F: '94 -83Q78 -83 68 -73T58 -48Q58 -44 60 -36Q62 -31 227 314T399 673Q410 694 431 694Q445 694 455 684T466 659Q466 656 464 648Q463 643 298 298T125 -62Q114 -83 94 -83',
    0x3A: '193 361Q193 396 214 413T258 431Q291 431 311 411T332 361Q332 335 314 314T262 292Q234 292 214 309T193 361ZM193 70Q193 105 214 122T258 140Q291 140 311 120T332 70Q332 44 314 23T262 1Q234 1 214 18T193 70',
    0x3B: '193 361Q193 396 214 413T258 431Q291 431 311 411T332 361Q332 335 314 314T262 292Q234 292 214 309T193 361ZM193 70Q193 105 214 122T259 140Q301 140 319 108T337 33Q337 -38 291 -88T214 -139Q203 -139 189 -126T175 -97Q175 -85 182 -78T200 -66T225 -50T249 -17Q256 -3 256 0Q252 1 248 1Q242 2 235 5T218 15T200 36T193 70',
    0x3C: '468 90Q468 76 458 66T433 55Q426 55 419 58Q413 61 243 168T68 280Q57 291 57 306T68 332Q72 335 241 442T416 553Q424 557 432 557Q447 557 457 547T468 522T456 496Q454 494 305 399L158 306L305 213Q341 190 390 159Q443 125 452 119T464 106V105Q468 97 468 90',
    0x3D: '38 382Q38 409 67 417H457Q487 408 487 382Q487 358 461 348H64Q51 352 45 360T38 376V382ZM67 195Q38 204 38 230Q38 255 62 264Q66 265 264 265H461L464 264Q467 262 469 261T475 256T481 249T485 240T487 230Q487 204 457 195H67',
    0x3E: '57 522Q57 539 67 548T90 557Q98 557 105 554Q111 551 281 444T456 332Q468 320 468 306T456 280Q452 276 282 169T105 58Q98 55 91 55Q79 55 68 63T57 90Q57 105 68 116Q70 118 219 213L366 306L219 399Q75 491 71 494Q57 507 57 522',
    0x3F: '62 493Q62 540 107 578T253 617Q366 617 414 578T462 490Q462 459 445 434T411 400L394 390Q315 347 296 287Q294 278 293 247V217Q285 201 278 198T246 194T216 197T201 215V245V253Q201 379 351 456Q366 464 375 477Q377 482 377 490Q377 517 339 528T251 540Q182 540 159 517Q166 503 166 490Q166 468 151 453T114 438Q96 438 79 451T62 493ZM190 58Q190 85 208 100T249 115Q272 113 288 99T304 58Q304 33 287 17T246 0T206 16T190 58',
    0x40: '44 306Q44 445 125 531T302 617Q332 617 358 607T411 574T456 502T479 387Q481 361 481 321Q481 203 421 143Q381 103 332 103Q266 103 225 165T183 307Q183 390 227 449T332 508Q358 508 378 498Q350 541 304 541Q229 541 172 473T115 305Q115 208 171 140T306 71H310Q358 71 397 105Q409 115 436 115Q458 115 462 113Q481 106 481 86Q481 73 468 61Q401 -6 305 -6Q262 -6 217 14T133 71T69 170T44 306ZM410 306Q410 361 386 396T333 431Q300 431 277 394T254 305Q254 256 276 218T332 180Q364 180 387 217T410 306',
    0x5B: '237 -82Q221 -78 214 -58V305Q214 669 216 673Q220 687 231 690T278 694H350H461Q462 693 467 690T474 685T478 679T482 670T483 656Q483 632 471 625T428 617Q422 617 406 617T379 618H298V-7H379H420Q459 -7 471 -13T483 -45Q483 -55 483 -59T477 -70T461 -82H237',
    0x5C: '58 659Q58 673 68 683T93 694Q114 694 125 673Q132 659 297 314T464 -36Q466 -44 466 -48Q466 -66 454 -74T431 -83Q410 -83 399 -62Q391 -47 226 298T60 648Q58 656 58 659',
    0x5D: '41 656Q41 681 53 688T99 695Q107 695 133 695T177 694H288Q307 681 310 669V-58Q303 -76 288 -82H64Q41 -73 41 -45Q41 -21 53 -14T96 -6Q102 -6 118 -6T145 -7H226V618H145H100Q67 618 54 625T41 656',
    0x5E: '138 460Q121 460 109 479T96 512Q96 527 106 534Q109 536 178 571T253 609Q256 611 264 611Q272 610 343 574Q357 567 369 561T389 550T402 543T411 538T416 535T420 532T422 529T425 525Q428 518 428 512Q428 498 416 479T386 460H384Q377 460 316 496L262 526L208 496Q147 460 138 460',
    0x5F: '57 -60Q57 -33 86 -25H438Q468 -34 468 -60T438 -95H86Q57 -86 57 -60',
    0x60: '176 479Q176 563 227 622T310 681Q324 680 337 667T350 641Q350 627 340 619T312 599T280 566Q256 531 252 485V471Q261 472 262 472Q285 472 302 455T320 414Q320 389 303 373T261 357Q223 357 200 391T176 479',
    0x7B: '430 -7H436Q449 -7 456 -8T469 -19T475 -45Q475 -69 466 -76T434 -83H419Q386 -82 363 -80T308 -69T253 -41T223 7L221 17L220 118V220L218 224Q215 229 214 230T210 235T204 241T195 246T184 252T170 257T151 262T127 265Q118 267 100 267T69 270T52 283Q50 288 50 306V314Q50 335 67 341Q68 342 102 343T172 355T217 386L220 392V493L221 595Q225 611 230 621T251 650T304 679T395 693L406 694Q418 694 426 694Q458 694 466 685Q475 676 475 656T466 627Q458 618 430 618Q319 618 305 587L304 486Q304 476 304 458T305 431Q305 385 295 358T251 311L243 306Q243 305 254 298T281 274T302 231Q304 223 304 125L305 25Q309 16 316 10T352 -1T430 -7',
    0x7C: '228 668Q241 694 262 694Q268 694 273 693T282 688T287 682T293 674L297 668V-57Q282 -82 262 -82Q239 -82 228 -57V668',
    0x7D: '49 655Q49 674 56 682T73 692T106 694Q141 693 167 690T224 677T275 647T303 595L305 392Q313 367 347 356T417 344T457 341Q475 335 475 306Q475 292 473 285T464 273T451 269T430 267Q352 262 327 246Q311 236 305 220L303 17L301 7Q294 -16 277 -33T242 -60T196 -74T150 -80T106 -83Q78 -83 72 -82T58 -74Q49 -65 49 -44Q49 -24 58 -16Q66 -7 94 -7Q143 -7 171 -1T207 10T220 25V125Q220 223 222 231Q228 257 243 274T270 299L281 306Q234 329 222 381Q220 387 220 486V587Q212 597 207 601T173 612T94 618Q66 618 58 627Q49 635 49 655',
    0x7E: '125 467Q113 467 100 480T87 509Q88 520 111 543Q172 602 209 609Q219 611 224 611Q246 611 263 596T290 566T304 551Q319 551 367 594Q383 610 396 610H400Q411 610 424 597T437 568Q436 557 413 534Q348 469 305 466Q278 466 260 481T234 511T220 526Q205 526 157 483Q141 467 129 467H125',
    0x7F: '104 565Q104 590 120 600T155 611Q175 611 180 610Q217 599 217 565Q217 545 202 532T166 519H159H155Q120 519 107 547Q104 553 104 565ZM307 565Q307 580 317 593T346 610Q348 610 350 610T354 611Q355 612 367 612Q395 611 408 597T421 565T409 534T365 519H358Q336 519 322 532T307 565',
    0xA0: '',
    0x131: '411 76Q441 76 451 69T462 38Q462 29 462 26T460 18T453 9T440 1H94Q72 8 72 33V38Q72 46 72 49T74 58T81 68T94 76H233V355H167L102 356Q80 363 80 393Q80 418 91 425T138 432Q145 432 165 432T200 431H295Q297 429 303 425T310 420T314 415T317 404T317 389T318 363Q318 354 318 314T317 241V76H378H411',
    0x237: '75 -91T100 -91T138 -107T152 -144V-150L160 -151H193H203Q241 -151 267 -121Q284 -97 288 -73T292 23V151V355H218L145 356Q123 365 123 387V393Q123 422 145 430H148Q151 430 156 430T169 430T185 430T205 431T227 431T251 431H354Q356 430 360 427T365 424T369 420T372 416T373 410T375 402T376 391T377 376T377 356Q377 345 377 286T376 176Q376 -67 371 -88Q362 -123 342 -151T299 -194Q254 -228 180 -228Q84 -226 56 -177Q49 -162 48 -148Q48 -122 61 -107',
    0x2B9: '211 572Q211 593 226 608T262 623Q281 623 297 610T313 573Q313 561 307 465Q301 370 299 357T284 336Q279 334 262 334Q240 334 231 343Q226 350 225 362T217 465Q211 549 211 572',
    0x300: '-409 569Q-409 586 -399 596T-377 610Q-376 610 -372 610T-365 611Q-355 610 -284 588T-210 563Q-195 556 -195 537Q-195 533 -197 522T-208 498T-229 485Q-238 485 -312 508T-388 533Q-400 538 -405 552Q-409 559 -409 569',
    0x301: '-297 485Q-315 485 -323 505T-331 537Q-331 556 -316 563Q-307 569 -170 610Q-169 610 -165 610T-157 611Q-141 609 -131 600T-119 584T-117 569Q-117 555 -124 545T-138 533Q-140 531 -214 508T-297 485',
    0x302: '-387 460Q-404 460 -416 479T-429 512Q-429 527 -419 534Q-416 536 -347 571T-272 609Q-269 611 -261 611Q-254 610 -182 574Q-168 567 -156 561T-136 550T-123 543T-114 538T-109 535T-105 532T-103 529T-100 525Q-97 518 -97 512Q-97 498 -109 479T-139 460H-141Q-148 460 -209 496L-263 526L-317 496Q-378 460 -387 460',
    0x303: '-400 467Q-412 467 -425 480T-438 509Q-437 520 -414 543Q-353 602 -316 609Q-306 611 -301 611Q-279 611 -262 596T-235 566T-221 551Q-206 551 -158 594Q-142 610 -129 610H-125Q-114 610 -101 597T-88 568Q-89 557 -112 534Q-177 469 -220 466Q-247 466 -265 481T-291 511T-305 526Q-320 526 -368 483Q-384 467 -396 467H-400',
    0x304: '-429 500Q-440 504 -445 511T-450 522T-452 536Q-452 552 -451 556Q-445 571 -434 574T-379 578Q-369 578 -330 578T-261 577H-96Q-94 575 -90 573T-85 569T-81 564T-77 558T-75 550T-74 538Q-74 522 -78 515T-96 500H-429',
    0x306: '-446 579Q-446 611 -412 611H-407Q-383 609 -378 599T-358 587Q-340 583 -263 583H-235Q-159 583 -152 593Q-145 611 -120 611H-117H-115Q-79 611 -79 577Q-80 552 -95 536T-140 514T-191 506T-251 504H-263H-274Q-311 504 -334 505T-386 513T-431 536T-446 579',
    0x308: '-421 565Q-421 590 -405 600T-370 611Q-350 611 -345 610Q-308 599 -308 565Q-308 545 -323 532T-359 519H-366H-370Q-405 519 -418 547Q-421 553 -421 565ZM-218 565Q-218 580 -208 593T-179 610Q-177 610 -175 610T-171 611Q-170 612 -158 612Q-130 611 -117 597T-104 565T-116 534T-160 519H-167Q-189 519 -203 532T-218 565',
    0x30A: '-344 558Q-344 583 -321 601T-262 619Q-225 619 -204 600T-182 560Q-182 536 -205 518T-264 499Q-301 499 -322 519T-344 558ZM-223 559Q-223 570 -234 579T-261 588T-289 580T-303 559Q-303 549 -293 540T-263 530T-234 539T-223 559',
    0x30C: '-427 525Q-427 542 -417 559T-392 577Q-385 577 -323 553L-263 530L-203 553Q-143 576 -136 576Q-118 576 -109 559T-99 525Q-99 508 -107 502T-161 481Q-177 475 -186 472Q-256 449 -263 449Q-272 449 -339 472T-412 498Q-420 501 -423 508T-427 520V525',
    0x391: '191 76Q212 75 220 68T229 38Q229 10 208 1H129H80Q48 1 38 7T28 38Q28 51 29 57T40 69T70 76Q89 76 89 78Q90 79 117 205T173 461T205 599Q212 623 250 623H262H273Q312 623 319 599Q322 591 350 461T406 205T435 78Q435 76 454 76H458Q484 76 493 59Q496 53 496 38Q496 11 478 3Q474 1 395 1H317Q295 8 295 38Q295 65 311 73Q316 75 333 76L348 77V78Q348 80 341 112L334 143H190L183 112Q176 80 176 78Q175 76 178 76Q180 76 191 76ZM318 221Q313 238 288 366T263 519Q263 526 262 527Q261 527 261 520Q261 493 236 365T206 221Q206 219 262 219T318 221',
    0x392: '39 1Q17 10 17 32V38V46Q17 65 34 73Q40 76 61 76H84V535H61H54Q27 535 19 553Q17 557 17 573Q17 583 17 587T23 599T39 610Q40 611 179 611Q320 610 332 607Q332 607 339 605Q394 591 427 547T461 454Q461 413 436 378T369 325L358 320Q405 311 443 270T482 169Q482 112 445 64T345 3L334 1H39ZM309 533Q302 535 234 535H168V356H230Q284 357 296 358T323 368Q346 380 361 402T377 452Q377 482 358 505T309 533ZM398 176Q396 218 371 246T315 279Q310 280 237 280H168V76H239Q316 77 327 81Q329 82 334 84Q398 107 398 176',
    0x393: '466 611Q468 609 473 606T479 602T483 598T486 593T487 586T488 576T488 562V526V488Q488 452 470 444Q466 442 446 442Q421 442 413 450Q406 457 405 463T404 501V535H185V76H222H239Q260 76 270 69T281 38Q281 12 270 6T209 0H155H104Q48 0 37 5T25 38Q25 59 35 69Q44 76 76 76H101V535H76H64Q36 535 27 552Q25 557 25 573T27 594Q33 606 43 608T106 611H258H466',
    0x394: '232 622H237Q242 622 249 622T264 623H293Q295 622 300 619T308 613T314 608T319 601Q322 597 405 316T489 19Q489 9 473 1Q471 0 262 0T51 1Q35 9 35 19Q35 34 118 315T205 601Q214 616 232 622ZM267 501Q266 504 265 510T263 521T261 526V523Q261 508 211 332Q142 91 138 82H386Q385 84 345 224Q281 439 267 501',
    0x395: '374 271Q374 241 367 232T332 223Q307 223 299 231Q290 240 290 263V279H173V76H418V118V144Q418 167 426 176T460 186Q491 186 500 166Q502 161 502 93V52Q502 25 499 17T480 1H41Q19 9 19 32V38Q19 63 36 73Q42 76 65 76H89V535H65H55Q44 535 38 537T25 548T19 573Q19 602 41 610H47Q53 610 63 610T88 610T121 610T160 611T204 611T251 611H458Q460 609 465 606T471 602T475 598T478 593T479 586T480 576T480 562V526V488Q480 452 462 444Q458 442 438 442Q413 442 405 450Q398 457 397 463T396 501V535H173V355H290V371Q290 394 299 403T332 412Q363 412 372 392Q374 387 374 317V271',
    0x396: '71 1Q60 5 55 11T49 23T48 39V46Q48 56 58 73T131 183Q171 242 197 282L366 535H144V501Q144 470 143 464T135 450Q127 442 102 442H94Q71 442 62 461Q60 466 60 527L61 589Q70 607 83 610H88Q93 610 102 610T124 610T154 610T188 611T227 611T270 611H454Q456 609 461 606T467 601T471 597T474 591T475 584T476 572V565Q476 555 466 538T393 428Q353 369 327 329L158 76H397V120V146Q397 169 405 179T439 189Q470 189 479 169Q481 164 481 95V48Q481 24 478 16T459 1H71',
    0x397: '16 571Q16 597 27 604T74 611H125H208Q223 602 226 596T230 573Q230 559 227 551T217 540T204 536T186 535H165V356H359V535H338H333Q306 535 297 552Q295 556 295 573Q295 586 295 590T301 600T317 611H486Q501 602 504 596T508 573Q508 559 505 551T495 540T482 536T464 535H443V76H464H470Q482 76 489 75T502 64T508 38Q508 10 486 1H317Q306 5 301 11T296 21T295 38V44Q295 66 311 73Q318 76 338 76H359V280H165V76H186H192Q204 76 211 75T224 64T230 38Q230 10 208 1H39Q28 5 23 11T18 21T17 38V44Q17 66 33 73Q40 76 60 76H81V535H60Q45 535 38 536T24 545T16 571',
    0x398: '102 588Q140 621 240 621Q323 621 335 620Q393 613 422 588Q450 560 459 493T468 306Q468 185 460 118T422 23Q382 -10 289 -10H262H235Q142 -10 102 23Q74 50 65 118T56 306Q56 427 64 494T102 588ZM262 66Q285 66 300 67T329 74T351 86T366 108T376 138T381 181T383 235T384 306Q384 452 371 492T304 544Q296 545 251 545Q230 545 215 543T188 534T169 520T155 497T147 466T143 423T141 371T140 306Q140 247 141 215T146 151T158 107T179 82T212 69T262 66ZM179 356Q187 378 219 378H223Q240 377 249 372T260 360L261 355Q261 353 262 353T263 355Q263 362 272 369Q280 377 304 377H310Q325 377 331 374T346 356V256Q338 241 331 238T309 234H304Q280 234 272 242Q263 249 263 256Q263 258 262 258T261 256Q261 249 252 242Q244 234 220 234H216Q186 234 179 256V356',
    0x399: '400 76Q431 76 441 69T452 38Q452 29 452 26T450 18T443 9T430 1H95Q84 6 79 12T73 23T72 38Q72 65 90 73Q96 76 157 76H220V535H157H124Q93 535 83 542T72 573Q72 603 93 610Q97 611 264 611H430Q432 609 436 607T444 602T449 594Q452 588 452 573Q452 546 434 538Q428 535 367 535H304V76H367H400',
    0x39A: '18 549T18 573T29 604T70 611H118H193Q207 603 210 596T214 573Q214 549 198 538Q191 535 172 535H152V421Q152 344 152 326T153 309L242 422L329 534Q327 535 322 536T314 538T308 542T303 548T300 558T298 573Q298 600 316 608Q322 611 392 611H463Q477 602 481 595T485 573Q485 535 446 535H441H420L281 357L436 77L454 76Q473 75 478 73Q495 62 495 38Q495 10 473 1H345Q334 5 329 11T324 21T323 38Q323 51 324 56T332 68T355 77L233 296L152 192V76H172Q191 76 198 73Q214 63 214 38Q214 9 193 1H41Q18 8 18 38Q18 61 35 73Q42 76 61 76H81V535H61Q42 535 35 538Q18 549 18 573',
    0x39B: '30 38Q30 57 38 66T70 76Q88 76 88 78Q89 79 117 207T173 466T205 602Q213 617 231 622H236Q241 622 249 622T264 623H294Q315 609 319 602Q321 598 350 468T407 208T435 78Q436 76 454 76Q470 76 478 73Q495 62 495 38Q495 10 473 1H313Q290 10 290 38Q290 56 297 65T310 74T331 76Q350 76 350 78Q349 80 328 176T285 383T263 520Q263 526 262 527Q261 527 261 521Q261 497 240 388T198 181T174 78Q174 76 193 76Q220 75 227 65Q234 56 234 38Q234 28 234 24T228 13T212 1H52Q30 9 30 32V38',
    0x39C: '50 535Q37 536 31 537T18 547T12 573Q12 598 22 604T62 611H91H121Q147 611 158 607T178 587Q183 579 222 446T261 293Q261 289 262 288Q263 288 263 292Q263 311 298 434T346 588Q353 603 365 607T402 611H435H450Q488 611 500 605T512 573Q512 556 506 547T493 537T474 535H459V76H474Q487 75 493 74T505 64T512 38Q512 11 494 3Q490 1 424 1H386Q355 1 345 7T335 38Q335 55 341 64T354 74T373 76H388V302Q388 512 387 519Q382 482 346 359T304 228Q292 204 262 204T220 228Q215 237 179 359T137 519Q136 512 136 302V76H151Q164 75 170 74T182 64T189 38Q189 11 171 3Q167 1 101 1H63Q32 1 22 7T12 38Q12 55 18 64T31 74T50 76H65V535H50',
    0x39D: '20 571Q20 598 30 604T73 611H105H136Q152 611 160 611T177 607T189 601T198 587T206 568T217 537T231 497Q354 142 365 95L368 84V535H347H342Q314 535 306 552Q304 556 304 573Q304 586 304 590T310 600T326 611H482Q497 602 500 596T504 573Q504 559 501 551T491 540T478 536T460 535H439V25Q432 7 424 4T389 0H374Q334 0 322 31L293 115Q171 468 159 517L156 528V76H177H183Q195 76 202 75T215 64T221 38Q221 10 199 1H43Q32 5 27 11T22 21T21 38V44Q21 66 37 73Q44 76 64 76H85V535H64Q49 535 42 536T28 545T20 571',
    0x39E: '37 555V569Q37 605 60 610H66Q71 610 81 610T105 610T137 610T175 611T217 611T264 611H465Q467 609 471 606T477 602T481 599T484 594T485 588T487 580T487 570T487 554Q487 526 486 520T478 506Q470 498 445 498T412 506Q403 515 403 531V539H121V531Q121 498 86 498H79H71Q48 498 39 517Q37 522 37 555ZM109 318V346Q109 366 113 374T132 389H170Q193 379 193 359V354H331V359Q331 379 354 389H392Q407 381 411 373T415 342V318V290Q415 270 411 262T392 247H354Q331 257 331 277V282H193V277Q193 257 170 247H132Q117 255 113 263T109 294V318ZM56 1Q41 7 37 15T33 42V58V80Q33 101 41 110T77 119Q87 118 91 118T103 114T114 103T117 83V72H407V83Q407 101 416 110T449 119T482 110Q489 103 490 97T491 59V41Q491 24 487 16T469 1H56',
    0x39F: '102 588Q140 621 240 621Q323 621 335 620Q393 613 422 588Q450 560 459 493T468 306Q468 185 460 118T422 23Q382 -10 289 -10H262H235Q142 -10 102 23Q74 50 65 118T56 306Q56 427 64 494T102 588ZM363 513Q357 523 347 530T324 540T302 544T280 546H268Q192 546 167 521Q150 501 145 452T140 300Q140 235 142 197T151 130T172 89T207 71T262 65Q317 65 341 81T374 144T384 300Q384 474 363 513',
    0x3A0: '60 535Q45 535 38 536T24 545T16 571Q16 603 36 609Q41 611 264 611H486Q501 602 504 596T508 573Q508 559 505 551T495 540T482 536T464 535H443V76H464H470Q482 76 489 75T502 64T508 38Q508 10 486 1H317Q306 5 301 11T296 21T295 38V44Q295 66 311 73Q318 76 338 76H359V535H165V76H186H192Q204 76 211 75T224 64T230 38Q230 10 208 1H39Q28 5 23 11T18 21T17 38V44Q17 66 33 73Q40 76 60 76H81V535H60',
    0x3A1: '41 1Q19 9 19 32V38Q19 63 36 73Q42 76 65 76H89V535H65H55Q38 535 29 543T19 576Q19 603 41 610H49Q57 610 70 610T100 610T136 611T175 611Q190 611 216 611T255 612Q321 612 363 598T441 537Q480 486 480 427V421Q480 354 447 311T378 251Q339 230 275 230H239H173V76H197Q220 76 227 73Q244 62 244 38Q244 10 222 1H41ZM396 421Q396 461 369 491T300 533Q294 534 233 535H173V306H233Q294 307 300 308Q345 319 370 352T396 421',
    0x3A3: '40 575Q40 576 40 579T41 583T41 588T43 593T46 597T50 602T55 606T63 610H68Q74 610 84 610T108 610T139 610T176 611T219 611T264 611H462Q464 609 469 606T475 602T479 598T482 593T483 586T484 576T484 562V526V488Q484 452 466 444Q462 442 442 442Q417 442 409 450Q402 457 401 463T400 501V535H153Q153 533 218 430Q233 405 250 378T276 336T286 319Q290 311 290 307Q290 296 239 211Q229 194 223 184L161 78H400V112Q400 142 401 149T409 163Q418 172 442 172Q473 172 482 152Q484 147 484 86V49Q484 25 481 17T462 1H63Q41 10 41 31Q41 39 43 44Q43 45 81 109T157 238L195 303Q195 307 119 430T41 557T40 575',
    0x3A4: '129 38Q129 51 129 55T135 65T151 76H220V535H110V501Q110 470 109 464T101 450Q93 442 68 442H60Q37 442 28 461Q26 466 26 527L27 589Q36 607 49 610H55Q61 610 72 610T97 610T131 610T170 611T215 611T264 611H476Q478 609 483 606T489 602T493 598T496 593T497 586T498 576T498 562V526V488Q498 452 480 444Q476 442 456 442Q431 442 423 450Q416 457 415 463T414 501V535H304V76H374Q389 67 392 61T396 38Q396 10 374 1H151Q140 5 135 11T130 21T129 38',
    0x3A5: '38 494Q38 549 74 585T152 621Q168 621 179 619T209 606T241 566T262 492Q262 494 265 507T270 526T276 547T285 569T298 589T315 606T337 617T365 622Q416 622 451 584T486 494Q486 470 469 461Q464 459 445 459H437Q416 459 406 476Q404 479 403 502T393 541T365 558Q350 558 340 548T323 519T312 475T307 419T305 354T304 282Q304 254 304 239V76H358Q372 67 376 60T380 38Q380 10 358 1H167Q145 9 145 32V38Q145 54 148 60T167 76H220V239Q220 256 220 289T220 338T219 383T217 426T214 463T209 497T201 522T189 543T174 555Q168 558 159 558Q139 558 131 541T121 502T118 476Q108 459 84 459H79H71Q38 459 38 494',
    0x3A6: '139 573V578Q139 603 161 610H166Q172 610 182 610T204 610T232 611T264 611H364Q379 602 382 595T385 573Q385 544 364 536L334 535H304V441H306Q313 440 325 438T367 426T421 403T464 364T483 306Q483 251 430 216T317 172Q315 172 313 172T308 170H306H304V76H364Q379 67 382 60T385 38Q385 28 385 24T379 12T364 1H161Q139 8 139 33V38Q139 46 139 49T141 58T148 68T161 76H220V170H218Q211 171 199 173T157 185T103 208T60 248T41 306Q41 361 94 396T208 439Q210 439 212 439T216 440L218 441H220V535H190L161 536Q139 543 139 573ZM124 306Q124 286 147 271T194 252L218 247Q220 247 220 306V364H218Q212 364 192 359T148 340T124 306ZM400 305Q400 325 377 340T330 360L306 364Q304 364 304 306Q304 247 306 247Q312 247 332 252T376 271T400 305',
    0x3A7: '39 571Q39 597 49 604T93 611H141H218Q233 602 236 595T239 573Q239 538 210 535Q202 535 202 534T215 507T243 454L257 428L307 535H298Q266 538 266 573Q266 584 267 588T273 598T289 611H366H401Q442 611 454 605T466 573Q466 546 448 538Q442 535 421 535H398L299 327Q299 323 362 201L426 77L449 76Q467 76 475 75T489 65T495 38Q495 11 477 3Q473 1 395 1H317Q295 8 295 38Q295 73 325 76L334 77Q333 78 314 117T276 196L257 235L239 196Q221 157 204 118T186 77Q190 76 196 76Q211 74 218 67T227 55T228 38Q228 28 227 24T221 13T206 1H50Q28 9 28 32V38Q28 63 45 73Q51 76 73 76H96L214 324Q215 327 162 431L108 535H85H79Q67 535 60 536T46 546T39 571',
    0x3A8: '37 439Q38 451 40 457T52 469T77 475H79Q96 475 107 473T132 456T152 411Q152 409 153 396T154 372V365Q154 291 198 261Q215 251 219 251Q220 251 220 393V535H193L167 536Q145 545 145 567V573Q145 602 167 610Q168 611 264 611H358Q372 602 376 595T380 573Q380 545 358 536L331 535H304V393Q304 251 305 251Q307 251 310 252T323 259T339 272T355 295T367 331Q368 337 370 372Q370 382 371 395T372 411Q376 434 384 448T404 467T425 474T447 475Q461 474 467 473T480 463T487 437Q487 419 481 412Q476 403 459 398Q457 390 453 344T431 263Q415 228 383 205T332 177T306 172H304V76H358Q372 67 376 60T380 38Q380 10 358 1H167Q145 9 145 32V38Q145 54 148 60T167 76H220V172H218Q211 172 192 177T141 205T93 263Q74 298 71 343T67 391L66 398Q47 403 42 411T37 433V439',
    0x3A9: '40 404Q40 498 106 560T258 622Q357 622 420 558T484 406Q484 359 469 311T428 205T392 117Q382 84 382 78Q382 76 402 76H421V87Q421 110 431 116T457 123Q474 123 483 114Q490 107 491 100T492 61V42Q492 11 474 3Q470 1 397 1H324Q302 9 302 32V39Q302 104 351 225T400 405Q400 462 361 504T262 546Q200 546 162 504T124 405Q124 346 171 230T223 42V36Q223 11 205 3Q201 1 128 1H55Q39 7 33 23L32 60V80Q32 94 34 102T44 116T68 123Q103 123 103 87V76H123Q142 76 142 78Q142 100 117 156T66 282T40 404',
    0x2017: '57 -60Q57 -33 86 -25H438Q468 -34 468 -60T438 -95H86Q57 -86 57 -60',
    0x2032: '211 572Q211 593 226 608T262 623Q281 623 297 610T313 573Q313 561 307 465Q301 370 299 357T284 336Q279 334 262 334Q240 334 231 343Q226 350 225 362T217 465Q211 549 211 572',
    0x2044: '94 -83Q78 -83 68 -73T58 -48Q58 -44 60 -36Q62 -31 227 314T399 673Q410 694 431 694Q445 694 455 684T466 659Q466 656 464 648Q463 643 298 298T125 -62Q114 -83 94 -83',
    0x2206: '232 622H237Q242 622 249 622T264 623H293Q295 622 300 619T308 613T314 608T319 601Q322 597 405 316T489 19Q489 9 473 1Q471 0 262 0T51 1Q35 9 35 19Q35 34 118 315T205 601Q214 616 232 622ZM267 501Q266 504 265 510T263 521T261 526V523Q261 508 211 332Q142 91 138 82H386Q385 84 345 224Q281 439 267 501',
},{
    0x2033: "\u2032\u2032",
    0x2034: "\u2032\u2032\u2032",
    0x2057: "\u2032\u2032\u2032\u2032",
});
