/*
    SPDX-FileCopyrightText: 2000-2001 Michael Edwardes <mte@users.sourceforge.net>
    SPDX-FileCopyrightText: 2002-2017 Thomas Baumgart <tbaumgart@kde.org>
    SPDX-FileCopyrightText: 2003 Kevin Tambascio <ktambascio@users.sourceforge.net>
    SPDX-FileCopyrightText: 2004-2006 Ace Jones <acejones@users.sourceforge.net>
    SPDX-FileCopyrightText: 2017-2018 Łukasz Wojniłowicz <lukasz.wojnilowicz@gmail.com>
    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef MYMONEYINSTITUTION_P_H
#define MYMONEYINSTITUTION_P_H

#include "mymoneyinstitution.h"

// ----------------------------------------------------------------------------
// QT Includes

#include <QString>
#include <QHash>
#include <QMap>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "mymoneyobject_p.h"

class MyMoneyInstitutionPrivate : public MyMoneyObjectPrivate
{
public:
    /**
      * This member variable keeps the name of the institution
      */
    QString m_name;

    /**
      * This member variable keeps the city of the institution
      */
    QString m_town;

    /**
      * This member variable keeps the street of the institution
      */
    QString m_street;

    /**
      * This member variable keeps the zip-code of the institution
      */
    QString m_postcode;

    /**
      * This member variable keeps the telephone number of the institution
      */
    QString m_telephone;

    /**
      * This member variable keeps the name of the representative of
      * the institution
      */
    QString m_manager;

    /**
      * This member variable keeps the sort code of the institution.
      * FIXME: I have no idea
      * what it is good for. I keep it because it was in the old engine.
      */
    QString m_sortcode;

    /**
      * This member variable keeps the sorted list of the account ids
      * available at this institution
      */
    QStringList m_accountList;
};

#endif
