#include "Widget.h"
#include "Application.h"

QList<Widget> *Widgets = NULL;

Widget::Widget(char *abstractdummyvariable)
{
  //  printf("Abstract Widget constructor!\n");
  if(!Widgets)
    {
      printf("Application not initialised!!!\n");
    }
  else
    Widgets->append(this);
}
  
Widget::Widget(Widget *parent, const char *name)
  : Object()
{
  if(!Widgets)
    {
      //  printf("Application not initialised!!!\n");
      return;
    }

  if(parent)
    {
      widget = new QWidget(parent->widget,name);
    }  
  else
    {
      widget = new QWidget(NULL,name);
    }

  Widgets->append(this);
  setWidget(widget);
}

Widget::~Widget()
{
  if(widget)
    {
      Widgets->removeRef(this);
    }
}

void Widget::setWidget(QWidget *w)
{
  QObject::connect(w,SIGNAL(destroyed()),this,SLOT(destroyed()));
  widget = w;
}

void Widget::destroyed()
{
  Widgets->removeRef(this);
  widget = NULL;
}


bool Widget::isTopLevel()
{
  return widget->isTopLevel();
}

bool Widget::isModal()
{
  return widget->isModal();
}

bool Widget::isPopup()
{
  return widget->isPopup();
}

bool Widget::isDesktop()
{
  return widget->isDesktop();
}

bool Widget::isEnabled()
{
  return widget->isEnabled();
}

void Widget::setEnabled(int enable)
{
  widget->setEnabled(enable);
}

const QRect& Widget::frameGeometry() const
{
  return widget->frameGeometry();
}

const QRect& Widget::geometry() const
{
  return widget->geometry();
}

int Widget::x()
{
  return widget->x();
}

int Widget::y()
{
  return widget->y();
}

QPoint Widget::pos() const
{
  return widget->pos();
}

QSize Widget::size() const
{
  return widget->size();
}

int Widget::width() const
{
  return widget->width();
}

int Widget::height() const
{
  return widget->height();
}

QRect Widget::rect() const
{
  return widget->rect();
}

QRect Widget::childrenRect () const
{
  return widget->childrenRect();
}
 
QSize Widget::minimumSize () const
{
  return widget->minimumSize();
}
 
QSize Widget::maximumSize () const
{
  return widget->maximumSize();
}
 
void Widget::setMinimumSize (const QSize&size)
{
  widget->setMinimumSize(size);
}
 
void Widget::setMinimumSize (int w, int h)
{
  widget->setMinimumSize(w,h);
}
 
void Widget::setMaximumSize (const QSize& size)
{
  widget->setMaximumSize(size);
}
 
void Widget::setMaximumSize (int w, int h)
{
  widget->setMaximumSize(w,h);
}
 
QSize Widget::sizeIncrement () const
{
  return widget->sizeIncrement();
}
 
void Widget::setSizeIncrement (const QSize&size)
{
  widget->setSizeIncrement(size);
}
 
void Widget::setSizeIncrement (int w, int h)
{
  widget->setSizeIncrement(w,h);
}
 
void Widget::setFixedSize (const QSize& size)
{
  widget->setFixedSize(size);
}
 
void Widget::setFixedSize (int w, int h)
{
  widget->setFixedSize(w,h);
}
 
QPoint Widget::mapToGlobal (const QPoint& p) const
{
  return widget->mapToGlobal(p);
}
 
QPoint Widget::mapFromGlobal (const QPoint& p) const
{
  return widget->mapToGlobal(p);
}
 
QPoint Widget::mapToParent (const QPoint& p) const
{
  return widget->mapToParent(p);
}
 
QPoint Widget::mapFromParent (const QPoint& p) const
{
  return widget->mapFromParent(p);
}
 
Widget* Widget::topLevelWidget () const
{
  QWidget *w = widget->topLevelWidget();
  Widget *ww;
  for(ww = Widgets->first(); ww!=0; ww = Widgets->next())
    {
      if(ww->widget == w)
	return ww;
    }
  return NULL;
}
 
const QColor& Widget::backgroundColor () const
{
  return widget->backgroundColor();
}
 
const QColor& Widget::foregroundColor () const
{
  return widget->foregroundColor();
}
 
void Widget::setBackgroundColor (const QColor& color)
{
  widget->setBackgroundColor(color);
}
 
const QPixmap* Widget::backgroundPixmap () const
{
  return widget->backgroundPixmap();
}
 
void Widget::setBackgroundPixmap (const QPixmap& pixmap)
{
  widget->setBackgroundPixmap(pixmap);
}
 
const QColorGroup& Widget::colorGroup () const
{
  return widget->colorGroup();
}
 
const QPalette& Widget::palette () const
{
  return widget->palette();
}
 
void Widget::setPalette (const QPalette& palette)
{
  widget->setPalette(palette);
}
 
const QFont& Widget::font () const
{
  return widget->font();
}
 
void Widget::setFont (const QFont& font)
{
  widget->setFont(font);
}
 
QFontMetrics Widget::fontMetrics () const
{
  return widget->fontMetrics();
}
 
QFontInfo Widget::fontInfo () const
{
  return widget->fontInfo();
}
 
const QCursor& Widget::cursor () const
{
  return widget->cursor();
}
 
void Widget::setCursor (const QCursor& cursor)
{
  widget->setCursor(cursor);
}
 
const char* Widget::caption () const
{
  return widget->caption();
}

void Widget::setCaption(const char *caption)
{
  widget->setCaption(caption);
}

const QPixmap* Widget::icon () const
{
  return widget->icon();
}
 
void Widget::setIcon (const QPixmap& icon)
{
  widget->setIcon(icon);
}

 
const char* Widget::iconText () const
{
  return widget->iconText();
}
 
void Widget::setIconText (const char*text)
{
  widget->setIconText(text);
}
 
bool Widget::hasMouseTracking () const
{
  return widget->hasMouseTracking();
}
 
void Widget::setMouseTracking (int enable)
{
  widget->setMouseTracking(enable);
}
 
bool Widget::isActiveWindow () const
{
  return widget->isActiveWindow();
}
 
void Widget::setActiveWindow ()
{
  widget->setActiveWindow();
}
 
bool Widget::isFocusEnabled () const
{
  return widget->isFocusEnabled();
}
 
Widget::FocusPolicy Widget::focusPolicy () const
{
  return (Widget::FocusPolicy)widget->focusPolicy();
}
 
void Widget::setFocusPolicy (FocusPolicy fp)
{
  widget->setFocusPolicy((QWidget::FocusPolicy)fp);
}
 
bool Widget::hasFocus () const
{
  widget->hasFocus();
}
 
void Widget::setFocus ()
{
  widget->setFocus();
}
 
void Widget::clearFocus ()
{
  widget->clearFocus();
}
 
void Widget::grabMouse ()
{
  widget->grabMouse();
}
 
void Widget::grabMouse (const QCursor& c)
{
  widget->grabMouse(c);  
}
 
void Widget::releaseMouse ()
{
  widget->releaseMouse();
}
 
void Widget::grabKeyboard ()
{
  widget->grabKeyboard();
}
 
void Widget::releaseKeyboard ()
{
  widget->releaseKeyboard();
}
 
bool Widget::isUpdatesEnabled () const
{
  return widget->isUpdatesEnabled();
}
 
void Widget::setUpdatesEnabled (int enable)
{
  widget->setUpdatesEnabled(enable);
}
 
void Widget::update ()
{
  widget->update();
}
 
void Widget::update (int x, int y, int w, int h)
{
  widget->update(x,y,w,h);
}
 
void Widget::repaint (int erase=1)
{
  widget->repaint(erase);
}
 
void Widget::repaint (int x, int y, int w, int h, int erase=1)
{
  widget->repaint(x,y,w,h,erase);
}
 
void Widget::repaint (const QRect& r, int erase=1)
{
  widget->repaint(r,erase);
}
 
void Widget::show()
{
  widget->show();
}

void Widget::hide()
{
  widget->hide();
}

void Widget::iconify ()
{
  widget->iconify();
}
 
bool Widget::close (int forceKill=0)
{
  return widget->close(forceKill);
}
 
bool Widget::isVisible () const
{
  return widget->isVisible();
}
 
void Widget::raise ()
{
  widget->raise();
}
 
void Widget::lower ()
{
  widget->lower();
}
 
void Widget::move(int x, int y)
{
  widget->move(x,y);
}
  
void Widget::move (const QPoint&p)
{
  widget->move(p);
} 

void Widget::resize(int w, int h)
{
  widget->resize(w,h);
}

void Widget::resize (const QSize&s)
{
  widget->resize(s);
} 

void Widget::setGeometry(int x, int y, int w, int h)
{
  widget->setGeometry(x,y,w,h);
}

void Widget::setGeometry (const QRect&r)
{
  widget->setGeometry(r);
}
 
QSize Widget::sizeHint () const
{
  return widget->sizeHint();
}
 
void Widget::adjustSize ()
{
  widget->adjustSize();
}
 
void Widget::recreate (Widget* parent, WFlags f, const QPoint& p, int
		       showIt=1)
{
  QWidget *theparent;
  if(parent)
    theparent = parent->widget;
  else
    theparent = NULL;

  widget->recreate(theparent, f,p,showIt);
}
 
void Widget::erase ()
{
  widget->erase();
}
 
void Widget::erase (int x, int y, int w, int h)
{
  widget->erase(x,y,w,h);
}
 
void Widget::erase (const QRect& r)
{
  widget->erase(r);
}
 
void Widget::scroll (int dx, int dy)
{
  widget->scroll(dx,dy);
}
 
void Widget::drawText (int x, int y, const char*t)
{
  widget->drawText(x,y,t);
}
 
void Widget::drawText (const QPoint& p, const char* t)
{
  widget->drawText(p,t);
}
 
Widget* Widget::parentWidget () const
{
  QWidget *got;

  got = widget->parentWidget();
  Widget *w;
  for(w=Widgets->first(); w!=0; w=Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}
 

  
















