#ifndef LABEL
#define LABEL

#include "Frame.h"
#include <qlabel.h>

class Label : public Frame
{
  Q_OBJECT;
public:
  Label(Widget *parent=0, const char *name=0);
  Label(const char *text, Widget *parent=0, const char *name=0);
  Label(Widget *buddy, const char *text, Widget *parent,
	const char *name=0);

  ~Label();

  const char *text();
  QPixmap *pixmap() const;
  int alignment();
  void setAlignment(int a);
  int margin();
  void setMargin(int m);
  bool autoResize();
  void setAutoResize(bool ar);
  QSize sizeHint() const;
  void setBuddy(Widget *buddy);
  Widget *buddy() const;

  // these act as slots
  void setText(const char *text);
  void setPixmap(const QPixmap& pixmap);
  void setNum(int num);         
  void setNum(double num);

private:
  QLabel *label;
};

#endif
