/* -------------------------------------------------------------

   toplevel.cpp (part of KDE Icon Browser)

   (C)  by 

   Generated with the KDE Application Generator

 ------------------------------------------------------------- */


#include <qmessagebox.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <kfiledialog.h>
#include "toplevel.h"

TopLevel::TopLevel()
  : KTopLevelWidget()
{
  handle = 0;

  setupMenuBar();
  setupStatusBar();
  setupToolBar();

  lb = new KIconListBox(this);
  setView(lb);

  loadLibrary("libktoolbaricons.so.0");
}

TopLevel::~TopLevel()
{
  if(!handle)
    return;

  (*xpm_fini)();

  LIB::unloadLibrary(handle);
}

void TopLevel::setupMenuBar()
{
  menubar = new KMenuBar(this);

  fileMenu = new QPopupMenu();
  helpMenu = new QPopupMenu();

  openID = fileMenu->insertItem(i18n("&Open"));
  fileMenu->connectItem(openID,this,SLOT(open()));

  quitID = fileMenu->insertItem(i18n("&Quit"));
  fileMenu->connectItem(quitID,kapp,SLOT(quit()));

  aboutID = helpMenu->insertItem(i18n("&About kiconbrowse ..."));
  helpMenu->connectItem(aboutID,this,SLOT(aboutApp()));
  helpMenu->setAccel(Key_F1,aboutID);

  aboutKDEID = helpMenu->insertItem(i18n("About &KDE..."));
  helpMenu->connectItem(aboutKDEID,kapp,SLOT(aboutKDE()));

  menubar->insertItem(i18n("&File"), fileMenu);
  menubar->insertSeparator();
  menubar->insertItem(i18n("&Help"), helpMenu);

  setMenu(menubar);
}

void TopLevel::setupToolBar()
{
  KNewIconLoader iconLoader;
  toolbar = new KToolBar(this);

  addToolBar(toolbar);

  toolbar->insertButton(iconLoader.loadIcon("fileopen"), ID_OPEN,SIGNAL(pressed()), this, SLOT(open()));
  toolbar->insertSeparator();
  toolbar->insertButton(iconLoader.loadIcon("help"),ID_HELP,SIGNAL(pressed()), this, SLOT(aboutApp()));
}

void TopLevel::setupStatusBar()
{
  statusbar = new KStatusBar(this);
  setStatusBar(statusbar);
}


void TopLevel::aboutApp()
{
  QMessageBox::about(this, i18n("About kiconbrowse 0.1"), i18n("A program by Thomas Tanghus"));
}

void TopLevel::open()
{
  QString str = KFileDialog::getOpenFileName("", "*.so*", this);
  if(!str.isEmpty())
    loadLibrary(str.data());
}

void TopLevel::closeEvent(QCloseEvent *e)
{
  e->accept();
  delete this;
  if(memberList->count() == 0)
  {
    kapp->quit();
  }
}

bool TopLevel::loadLibrary(const char *lib)
{
  if(handle)
  {
    (*xpm_fini)();
    LIB::unloadLibrary(handle);
  }

  handle = LIB::loadLibrary(lib, LIB::ResolveLazy);
  if (!handle)
  {
    QString msg = i18n("Couldn't open library:\n");
    msg += LIB::error();
    QMessageBox::warning(this, i18n("Warning"), msg.data());
    return false;
  }

  xpm_init = LIB::getSymbol(handle, QString("xpm_init"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_init\"\n");
    msg += error;
    QMessageBox::warning(this, i18n("Warning"), msg.data());
    return false;
  }

  (*xpm_init)();

  xpm_fini = LIB::getSymbol(handle, QString("xpm_fini"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = "Couldn't load symbol \"xpm_fini\"\n";
    msg += error;
    QMessageBox::warning(this, i18n("Warning"), msg.data());
    return false;
  }

  xpm_icon = LIB::getSymbol(handle, QString("xpm_icon"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_icon\"\n");
    msg += error;
    QMessageBox::warning(this, i18n("Warning"), msg.data());
    return false;
  }

  xpm_names = LIB::getSymbol(handle, QString("xpm_names"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_names\"\n");
    msg += error;
    QMessageBox::warning(this, i18n("Warning"), msg.data());
    return false;
  }
  QStrList list;
  list = (*xpm_names)(list);

  lb->clear();

  for(int i = 0; i < (int)list.count(); i++)
  {
    //debug("Name: %s", list.at(i));
    KIconTemplate *k = new KIconTemplate;
    k->pix = *(*xpm_icon)(list.at(i));
    k->title = list.at(i);
    KIconListBoxItem *li = new KIconListBoxItem(k);
    lb->insertItem(li);
  }

  return true;
}
