/*
    KDE Draw - a small graphics drawing program for the KDE
    Copyright (C) 1998  Thomas Tanghus (tanghus@earthling.net)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/  

#include "kiconlistbox.h"

KIconListBoxItem::KIconListBoxItem( KIconTemplate *t )
   : QListBoxItem()
{
  //debug("KIconListBoxItem - %s, %s", t->path.data(), t->title.data());
  icontemplate = t;
  pm = t->pix;
  setText( t->title.data() );
}

void KIconListBoxItem::paint( QPainter *p )    
{
  p->drawPixmap( 3, 0, pm );      
  QFontMetrics fm = p->fontMetrics();      
  int yPos;                       // vertical text position      
  if ( pm.height() < fm.height() )          
    yPos = fm.ascent() + fm.leading()/2;      
  else            
    yPos = pm.height()/2 - fm.height()/2 + fm.ascent();      
  p->drawText( pm.width() + 5, yPos, text() );    
}

int KIconListBoxItem::height(const QListBox *lb ) const    
{
  return QMAX( pm.height(), lb->fontMetrics().lineSpacing() + 1 );    
}
    
int KIconListBoxItem::width(const QListBox *lb ) const
{
  return pm.width() + lb->fontMetrics().width( text() ) + 6;
}

KIconListBox::KIconListBox( QWidget *parent ) : QListBox(parent)
{
  di = new QImageDrag( img, this );
  dragging = false;
}

KIconListBox::~KIconListBox()
{
  delete di;
}

void KIconListBox::mousePressEvent(QMouseEvent *e)
{
  QListBox::mousePressEvent(e);
  debug("KIconListBox::mousePressEvent()");
  start = e->pos();
}

void KIconListBox::mouseMoveEvent(QMouseEvent *e)
{
  QListBox::mouseMoveEvent(e);
  if(start == e->pos() || dragging)
    return;

  debug("KIconListBox::mouseMoveEvent()");

  KIconListBoxItem *it = 0L;
  it = (KIconListBoxItem*)item(findItem(e->pos().y()));
  if(it < 0)
  {
    debug("KIconListBox::mouseMoveEvent() : Couldn't find item!");
    return;
  }

  img = it->iconTemplate()->pix;
  img.detach();
  if(img.isNull())
  {
    debug("KIconListBox::mouseMoveEvent() : Invalid image!");
  }
  else
  {
    dragging = true;

    di->setImage( img );
    debug("KIconListBox::mouseMoveEvent - before dragCopy");
    di->dragCopy();
    debug("KIconListBox::mouseMoveEvent - after dragCopy");

    dragging = false;
  }
}



