%module Widget


%{
#include "Object.h"
#include <qwidget.h>
%}


%include Types.i
%include Constants.i
%import Object.i
%import Paintdevice.i
%import Font.i
%import Colorgroup.i
%import Cursor.i
%import Font.i
%import Palette.i
%import Pixmap.i


class QWidget : public Object, public QPaintDevice
{	
  public:
    QWidget(QWidget *parent=0, const char *name=0, unsigned int f=0 );
   ~QWidget();

    unsigned int winId() const;

  // GUI style setting

    GUIStyle	 style() const;
    virtual void setStyle( GUIStyle );

  // Widget types and states

    bool	 isTopLevel()	const;
    bool	 isModal()	const;
    bool	 isPopup()	const;
    bool	 isDesktop()	const;

    bool	 isEnabled()	const;

    virtual void setEnabled( bool );

  // Widget coordinates

public:
    const QRect &frameGeometry() const;
    const QRect &geometry()	const;
    int		 x()		const;
    int		 y()		const;
    QPoint	 pos()		const;
    QSize	 size()		const;
    int		 width()	const;
    int		 height()	const;
    QRect	 rect()		const;
    QRect	 childrenRect() const;

    QSize	 minimumSize()	const;
    QSize	 maximumSize()	const;
    void	 setMinimumSize( int w, int h );
    void	 setMaximumSize( int w, int h );
    void	 setMinimumWidth( int w );
    void	 setMinimumHeight( int h );
    void	 setMaximumWidth( int w );
    void	 setMaximumHeight( int h );

    QSize	 sizeIncrement() const;
    void	 setSizeIncrement( int w, int h );

    void	 setFixedSize( int w, int h );
    void	 setFixedWidth( int w );
    void	 setFixedHeight( int h );

  // Widget coordinate mapping

    QPoint	 mapToGlobal( const QPoint & )	 const;
    QPoint	 mapFromGlobal( const QPoint & ) const;
    QPoint	 mapToParent( const QPoint & )	 const;
    QPoint	 mapFromParent( const QPoint & ) const;

    QWidget	*topLevelWidget()   const;

  // Widget attribute functions

    enum BackgroundMode { FixedColor=0, 
			FixedPixmap=1, 
			NoBackground=2,
			PaletteForeground=3, 
 			PaletteBackground=4, 
			PaletteLight=5,
			PaletteMidlight=6, 
			PaletteDark=7, 
			PaletteMid=8,
			PaletteText=9, 
			PaletteBase=10 };

    BackgroundMode backgroundMode() const;
    void	   setBackgroundMode( BackgroundMode );

    const QColor  backgroundColor() const;
    const QColor  foregroundColor() const;
    virtual void  setBackgroundColor( const QColor & );

    const QPixmap *backgroundPixmap() const;
    virtual void   setBackgroundPixmap( const QPixmap & );

    const QColorGroup &colorGroup();
    const QPalette    &palette()    const;
    virtual void       setPalette( const QPalette & );

    const QFont &font()		const;
    virtual void setFont( const QFont & );
    QFontMetrics fontMetrics()	const;
    QFontInfo	 fontInfo()	const;

    const QCursor &cursor() const;
    virtual void setCursor( const QCursor & );

    const char	*caption()	const;
    void	 setCaption( const char * );
    const QPixmap *icon()	const;
    void	 setIcon( const QPixmap & );
    const char	*iconText()	const;
    void	 setIconText( const char * );

    bool	 hasMouseTracking() const;

    void	 setMouseTracking( bool enable );

  // Keyboard input focus functions

public:

    enum FocusPolicy { 	NoFocus = 0, 
			TabFocus = 1, 
			ClickFocus = 2, 
			StrongFocus = 3 };

    bool	 isActiveWindow() const;
    void	 setActiveWindow();
    bool	 isFocusEnabled() const;
    FocusPolicy	 focusPolicy() const;
    void	 setFocusPolicy( FocusPolicy );
    bool	 hasFocus() const;
    void	 setFocus();
    void	 clearFocus();
    static void  setTabOrder( QWidget *, QWidget * );
    void	 setFocusProxy(QWidget * );
    QWidget *	 focusProxy() const;

  // Grab functions

    void	 grabMouse();
%name(grabMouseCursor)    void	 grabMouse( const QCursor & );
    void	 releaseMouse();
    void	 grabKeyboard();
    void	 releaseKeyboard();
    static QWidget *mouseGrabber();
    static QWidget *keyboardGrabber();

  // Update/refresh functions

    bool	 isUpdatesEnabled() const;

    void	 setUpdatesEnabled( bool enable );
    void	 update();
%name(updateRect)    void	 update( int x, int y, int w, int h);
    void	 repaint( bool erase=TRUE );
%name(repaintRect)    void	 repaint( int x, int y, int w, int h, bool erase=TRUE );

  // Widget management functions

    virtual void show();
    virtual void hide();
    void	 iconify();

public:
    virtual bool close(bool forceKill);
    bool	 isVisible()	const;
    bool	 isVisibleToTLW() const;

%name(raiseWidget)    void	 raise();
%name(lowerWidget)    void	 lower();
    virtual void move( int x, int y );
    virtual void resize( int w, int h );
    virtual void setGeometry( int x, int y, int w, int h );

    virtual QSize sizeHint() const;
    virtual void  adjustSize();


    void	 recreate( QWidget *parent, unsigned int, const QPoint &,
			   bool showIt=FALSE );

    void	 erase();
%name(eraseRect)    void	 erase( int x, int y, int w, int h );
    void	 scroll( int dx, int dy );

    void	 drawText( int x, int y, const char * );

  // Misc. functions

    QWidget     *focusWidget() const;

public:
    QWidget	*parentWidget() const;
    bool	 testWFlags( unsigned int n ) const;
    static QWidget	 *find( unsigned int );
    static QWidgetMapper *wmapper();
};
