#ifndef _SLIDER_H_
#define _SLIDER_H_

#include <Python.h>
#include <qslider.h>
#include "Baseobject.h"


class Slider : public QSlider, BaseObject
{
  Q_OBJECT

  public:

  Slider(int min, int max, int step, int value, Orientation ot, QWidget *parent=0, const char *name=0) :
    QSlider(min,max,step,value,ot,parent,name), BaseObject()
  {
    connect(this, SIGNAL(sliderPressed()), this, SLOT(sigSliderPressed()));
    connect(this, SIGNAL(sliderMoved(int)), this, SLOT(sigSliderMoved(int)));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(sigSliderReleased()));
    connect(this, SIGNAL(valueChanged(int)), this, SLOT(sigValueChanged(int)));    
  }
  ~Slider() {};

  protected slots:

    void sigSliderPressed() {
      _emit("pressed", 0);
    };
    
    void sigSliderReleased() {
      _emit("sliderReleaser", 0);
    };
    
    void sigSliderMoved(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("sliderMoved", arg);
      Py_DECREF(arg);
    };

    void sigValueChanged(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("valueChanged", arg);
      Py_DECREF(arg);
    };

};

#endif


