#ifndef _FILEDIALOG_H_
#define _FILEDIALOG_H_

#include <qfiledlg.h>
#include "Baseobject.h"


class FileDialog : public QFileDialog, BaseObject
{
  Q_OBJECT
  
public:
    FileDialog( QWidget *parent=0, const char *name=0, bool modal=FALSE )
      : QFileDialog(parent,name,modal)
    {
      connect(this, SIGNAL(fileHightlighted(const char *)), this, SLOT(sigFileHighlighted(const char *)));
      connect(this, SIGNAL(fileSelected(const char *)), this, SLOT(sigFileSelected(const char *)));
      connect(this, SIGNAL(dirEntered(const char *)), this, SLOT(sigDirEntered(const char *)));
    };
    FileDialog( const char *dirName, const char *filter = 0,
		 QWidget *parent=0, const char *name=0, bool modal=FALSE)
      : QFileDialog(dirName,filter,parent,name,modal)
    {
      connect(this, SIGNAL(fileHightlighted(const char *)), this, SLOT(sigFileHighlighted(const char *)));
      connect(this, SIGNAL(fileSelected(const char *)), this, SLOT(sigFileSelected(const char *)));
      connect(this, SIGNAL(dirEntered(const char *)), this, SLOT(sigDirEntered(const char *)));
    };
    ~FileDialog() {};


protected slots:

    void sigFileHighlighted( const char *file ) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileHighlighted", arg);  
       Py_DECREF(arg);    
    }
    void sigFileSelected( const char *file ) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileSelected", arg);  
       Py_DECREF(arg);    
    }
    void sigDirEntered( const char *file ) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("dirEntered", arg);  
       Py_DECREF(arg);    
    }
};


#endif