%module Application

%{
#include "Application.h"
#include "Object.h"
#include <qapp.h>
%}

%include Types.i
%include Constants.i

%import Baseobject.i
%import Object.i
%import Cursor.i
%import Color.i
%import Palette.i
%import Clipboard.i
%import Font.i
%import Fontmetrics.i
%import Widget.i


// Disable freeing the args, as QApplication only stores a pointer to argv
%typemap(python,freearg) char **;


extern QApplication *qApp;


class Application : public Object
{
  public:

    Application(int argc, char ** argv );
    virtual ~Application();

    int		     argc();
    char	  ** argv();

    static GUIStyle style();
    static void	    setStyle( GUIStyle );

    enum ColorSpec { NormalColor=0, CustomColor=1, PrivateColor=4,
		     ManyColor=4, TrueColor=4 };
    static int	     colorSpec();
    static void      setColorSpec( int );

    static QCursor  *overrideCursor();
    static void	     setOverrideCursor( const QCursor &, bool replace=FALSE );
    static void	     restoreOverrideCursor();

    static bool	     hasGlobalMouseTracking();
    static void	     setGlobalMouseTracking( bool enable );

    static QPalette *palette();
    static void	     setPalette( const QPalette &,bool updateAllWidgets=FALSE);

    static QFont    *font();
    static void	     setFont( const QFont &, bool updateAllWidgets=FALSE );
    static QFontMetrics fontMetrics();

    QWidget	    *mainWidget()  const;
    void	     setMainWidget( QWidget * );

    static QWidgetList *allWidgets();
    static QWidgetList *topLevelWidgets();
    static QWidget  *desktop();
    static QWidget  *activePopupWidget();
    static QWidget  *activeModalWidget();
    static QClipboard *clipboard();
    QWidget	    *focusWidget() const;

    static QWidget  *widgetAt( int x, int y, bool child=FALSE );

    %name(execute) int		     exec();
    void	     processEvents();
    %name(processEventsTill) void	     processEvents( int maxtime );
    void	     processOneEvent();
    int		     enter_loop();
    void	     exit_loop();
    static void	     exit( int retcode=0 );

    static bool	     sendEvent( Object *receiver, QEvent *event )
	{ return qApp->notify( receiver, event ); }
    static void	     postEvent( Object *receiver, QEvent *event );

    virtual bool     notify( Object *, QEvent * );

    static bool	     startingUp();
    static bool	     closingDown();

    static void	     flushX();
    static void	     syncX();

    static void	     beep();

    static void      setWinStyleHighlightColor( const QColor & );
    static const QColor&   winStyleHighlightColor();

    static void	    setDoubleClickInterval( int );
    static int      doubleClickInterval();

    // slots
    void	     quit();
};
