/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-assist.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-assist
 * @title: IAnjutaEditorAssist
 * @short_description: Editor assistance framework
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-assist.h
 * 
 */

#include "ianjuta-editor-assist.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_assist_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-assist-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_assist_cancel_tip:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Cancels the last shown tooltip
 */
void
ianjuta_editor_assist_cancel_tips (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->cancel_tips (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_cancel_tips_default (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_get_suggestions:
 * @obj: Self
 * @context: The context for the suggestions.
 * @err: Error propagation and reporting
 *
 * Usually the editor might have some suggestions to make
 * for a context. For example in a simple word completion context.
 * The list of suggestion returned is allocated dynamically. The whole
 * list, including the the strings should be freed when done.
 * If the editor has no suggestions to make, it returns NULL.
 * 
 * Returns: A list of dynamically allocated strings for the given context or NULL
 * if there is nothing to suggest.
 */
GList*
ianjuta_editor_assist_get_suggestions (IAnjutaEditorAssist *obj, const gchar *context, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj), 0);
	return IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->get_suggestions (obj, context, err);
}

/* Default implementation */
static GList*
ianjuta_editor_assist_get_suggestions_default (IAnjutaEditorAssist *obj, const gchar *context, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_assist_hide_suggestions:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Hide current suggestions but do not emit assist_end signal.
 * This is useful when temporary waiting for more context
 */
void
ianjuta_editor_assist_hide_suggestions (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->hide_suggestions (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_hide_suggestions_default (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_tip:
 * @obj: Self
 * @tips: list of alternative tips.
 * @char_alignment: Character alignment.
 * @err: Error propagation and reporting
 *
 * Show tips showing more information on current context. No user feedback
 * is required when tips are shown. @char_alignment indicates
 * the position before which is the known context and after which are
 * the suggestions. Usually the editor would use this to
 * align the choices displayed such that the carat is just at this
 * position when the choices are displayed.
 *
 */
void
ianjuta_editor_assist_show_tips (IAnjutaEditorAssist *obj, GList* tips,   IAnjutaIterable *position,   gint char_alignment, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	g_return_if_fail (IANJUTA_IS_ITERABLE(position));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->show_tips (obj, tips, position, char_alignment, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_show_tips_default (IAnjutaEditorAssist *obj, GList* tips,   IAnjutaIterable *position,   gint char_alignment, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_suggest:
 * @obj: Self
 * @choices: list of choices.
 		 * @char_alignment: Character alignment.
 * @err: Error propagation and reporting
 * 
 * Suggest a list of choices to the user. The suggestions are viewed 
 * at char_alignment which should be the beginning of the completed word.
 * If choices is NULL, and assist_end signal
 * will occur
 *
 */
void
ianjuta_editor_assist_suggest (IAnjutaEditorAssist *obj, GList* choices,   IAnjutaIterable *position,   int char_alignment, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	g_return_if_fail (IANJUTA_IS_ITERABLE(position));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->suggest (obj, choices, position, char_alignment, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_suggest_default (IAnjutaEditorAssist *obj, GList* choices,   IAnjutaIterable *position,   int char_alignment, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_tip_shown:
 * @obj: Self
 * @err: Error propagation and reporting
 * 
 * Returns: whether a tooltip is crrently shown		
 */
gboolean
ianjuta_editor_assist_tip_shown (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj), FALSE);
	return IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->tip_shown (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_editor_assist_tip_shown_default (IAnjutaEditorAssist *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_editor_assist_base_init (IAnjutaEditorAssistIface* klass)
{
	static gboolean initialized = FALSE;

	klass->cancel_tips = ianjuta_editor_assist_cancel_tips_default;
	klass->get_suggestions = ianjuta_editor_assist_get_suggestions_default;
	klass->hide_suggestions = ianjuta_editor_assist_hide_suggestions_default;
	klass->show_tips = ianjuta_editor_assist_show_tips_default;
	klass->suggest = ianjuta_editor_assist_suggest_default;
	klass->tip_shown = ianjuta_editor_assist_tip_shown_default;
	
	if (!initialized) {

		/* IAnjutaEdiotrAssist::assist_chosen:
		 * @obj: self
		 * @selection: The selection index
		 * @err: Error propagation and reporting
		 *
		 * User's selection from the choices. It is the index of the choice
		 * presented with ianjuta_editor_assist_suggest().
		 */
		g_signal_new ("assist-chosen",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_chosen),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_assist_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorAssistIface),
			(GBaseInitFunc) ianjuta_editor_assist_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorAssist", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
