# Note that this is NOT a relocatable package
%define ver      0.7
%define rel      1
%define prefix   /usr
%define sysconfdir	/etc
%define datadir %{prefix}/share

Summary: GTK+ DocBook Documentation Generator
Name: gtk-doc
Version: %ver
Release: %rel
Copyright: GPL
Group: Utilities/Text
Source: ftp://ftp.gtk.org/pub/gtk/v1.1/docs/rdp/gtk-doc-%{ver}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Obsoletes: gtk-doc
Packager: John Gotts <jgotts@linuxsavvy.com>
URL: http://www.gtk.org/rdp/
Docdir: %{datadir}/doc
BuildArchitectures: noarch
Requires: jade

%description
gtk-doc is a set of perl scripts that generate API reference documention in
DocBook format.  It can extract documentation from source code comments in a
manner similar to java-doc.  It is used to generate the documentation for
GLib, Gtk+, and GNOME.

%changelog
* Fri Apr 27 2001 Toshio Kuratomi <badger@prtr-13.ucsc.edu>
- Merge in some of the features of the redhat spec file.

* Wed Nov 15 2000 John Gotts <jgotts@linuxsavvy.com>
- Minor updates for 0.4.
* Thu Aug 26 1999 John E. Gotts <jgotts@engin.umich.edu>
- Created spec file.

%prep
%setup

# Move this doc file to avoid name collisions
mv doc/README doc/README.docs

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%prefix \
		--sysconfdir=%{sysconfdir}
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%prefix \
		--sysconfdir=%{sysconfdir}
fi

if [ "$SMP" != "" ]; then
	make -k -j$SMP "MAKE=make -k -j$SMP"
else
	make -k
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT/etc install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog README doc/* examples
# INSTALL is generic instructions from autoconf
# NEWS is currently empty
# %doc INSTALL NEWS

%{prefix}/bin/*
%{prefix}/share/gtk-doc/*
