/* Helper functions for gtk-engines
 *
 * Copyright (C) 2006 Andrew Johnson <acjgenius@earthlink.net>
 * Copyright (C) 2006 Thomas Wood <thos@gnome.org>
 * Copyright (C) 2006-2007 Benjamin Berg <benjamin@sipsolutions.net>
 * Copyright (C) 2007 Andrea Cimitan <andrea.cimitan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Project contact: <gnome-themes-list@gnome.org>
 *
 *
 * Written by Andrew Johnson <acjgenius@earthlink.net>
 * Written by Benjamin Berg <benjamin@sipsolutions.net>
 * Written by Thomas Wood <thos@gnome.org>
 * modified by Andrea Cimitan <andrea.cimitan@gmail.com>
 *
 */

#include <gtk/gtk.h>
#include <math.h>

typedef struct
{
	gdouble r;
	gdouble g;
	gdouble b;
	gdouble a;
} CairoColor;

typedef struct
{
	CairoColor bg[5];
	CairoColor fg[5];

	CairoColor dark[5];
	CairoColor light[5];
	CairoColor mid[5];

	CairoColor base[5];
	CairoColor text[5];
	CairoColor text_aa[5];

	CairoColor black;
	CairoColor white;
} CairoColorCube;

typedef enum
{
	CR_CORNER_NONE        = 0,
	CR_CORNER_TOPLEFT     = 1,
	CR_CORNER_TOPRIGHT    = 2,
	CR_CORNER_BOTTOMLEFT  = 4,
	CR_CORNER_BOTTOMRIGHT = 8,
	CR_CORNER_ALL         = 15
} CairoCorners;

typedef enum
{
	CR_MIRROR_NONE       = 0,
	CR_MIRROR_HORIZONTAL = 1 << 0,
	CR_MIRROR_VERTICAL   = 1 << 1
} CairoMirror;

/*****************************/
/* Pattern Fills             */
/*****************************/
typedef enum {
	GE_DIRECTION_VERTICAL,
	GE_DIRECTION_HORIZONTAL,
	GE_DIRECTION_BOTH,
	GE_DIRECTION_NONE
} GeDirection;

typedef struct
{
	GeDirection scale;
	GeDirection translate;

	cairo_pattern_t *handle;
	cairo_operator_t operator;
} CairoPattern;

GE_INTERNAL void ge_hsb_from_color (const CairoColor *color, gdouble *hue, gdouble *saturation, gdouble *brightness);
GE_INTERNAL void ge_color_from_hsb (gdouble hue, gdouble saturation, gdouble brightness, CairoColor *color);

GE_INTERNAL void ge_gdk_color_to_cairo (const GdkColor * gc, CairoColor * cc);
GE_INTERNAL void ge_cairo_color_to_gtk (const CairoColor *cc, GdkColor *c);
GE_INTERNAL void ge_gtk_style_to_cairo_color_cube (GtkStyle * style, CairoColorCube *cube);

GE_INTERNAL void ge_shade_color(const CairoColor *base, gdouble shade_ratio, CairoColor *composite);
GE_INTERNAL void ge_saturate_color (const CairoColor * base, gdouble saturate_level, CairoColor *composite);
GE_INTERNAL void ge_mix_color (const CairoColor *color1, const CairoColor *color2, gdouble mix_factor, CairoColor *composite);

GE_INTERNAL void ge_cairo_set_color (cairo_t *cr, const CairoColor *color);
GE_INTERNAL void ge_cairo_set_gdk_color_with_alpha (cairo_t *cr, const GdkColor *color, gdouble alpha);
GE_INTERNAL void ge_cairo_pattern_add_color_stop_color (cairo_pattern_t *pattern, gfloat offset, const CairoColor *color);
GE_INTERNAL void ge_cairo_pattern_add_color_stop_shade (cairo_pattern_t *pattern, gdouble offset, const CairoColor *color, gdouble shade);

GE_INTERNAL void ge_cairo_rounded_corner (cairo_t *cr, double x, double y, double radius, CairoCorners corner);
GE_INTERNAL void ge_cairo_rounded_rectangle (cairo_t *cr, double x, double y, double w, double h, double radius, CairoCorners corners);

GE_INTERNAL void ge_cairo_stroke_rectangle (cairo_t *cr, double x, double y, double w, double h);
GE_INTERNAL void ge_cairo_inner_rectangle (cairo_t *cr, double x, double y, double width, double height);
GE_INTERNAL void ge_cairo_inner_rounded_rectangle (cairo_t *cr, double x, double y, double width, double height, double radius, CairoCorners corners);
GE_INTERNAL void ge_cairo_simple_border (cairo_t *cr, const CairoColor * tl, const CairoColor * br, gint x, gint y, gint width, gint height, gboolean topleft_overlap);

GE_INTERNAL void ge_cairo_line (cairo_t *cr, const CairoColor *color, gint x1, gint y1, gint x2, gint y2);
GE_INTERNAL void ge_cairo_polygon (cairo_t *cr, const CairoColor *color, GdkPoint *points, gint npoints);

GE_INTERNAL void ge_cairo_mirror (cairo_t *cr, CairoMirror mirror, gint *x, gint *y, gint *width, gint *height);
GE_INTERNAL void ge_cairo_exchange_axis (cairo_t *cr, gint *x, gint *y, gint *width, gint *height);

GE_INTERNAL void ge_cairo_pattern_fill(cairo_t *canvas, CairoPattern *pattern, gint x, gint y, gint width, gint height);

GE_INTERNAL CairoPattern *ge_cairo_color_pattern(CairoColor *base);
GE_INTERNAL CairoPattern *ge_cairo_pixbuf_pattern(GdkPixbuf *pixbuf);
GE_INTERNAL CairoPattern *ge_cairo_pattern_pattern(cairo_pattern_t *pattern);
GE_INTERNAL CairoPattern *ge_cairo_linear_shade_gradient_pattern(CairoColor *base, gdouble shade1, gdouble shade2, gboolean vertical);
GE_INTERNAL void ge_cairo_pattern_destroy(CairoPattern *pattern);

GE_INTERNAL void ge_cairo_transform_for_layout (cairo_t *cr, PangoLayout *layout, int x, int y);
