/* rygel-http-item-uri_http-post.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-http-item-uri_http-post.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	char* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	char* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY
};
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const char* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const char* uri, RygelHTTPServer* http_server, GError** error);
const char* rygel_http_server_get_path_root (RygelHTTPServer* self);
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static char* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const char* path);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 33 "rygel-http-item-uri_http-post.vala"
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target) {
#line 156 "rygel-http-item-uri_http-post.c"
	RygelHTTPItemURI * self;
	char* _tmp0_;
	char* _tmp1_;
	RygelHTTPServer* _tmp2_;
#line 33 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 33 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 33 "rygel-http-item-uri_http-post.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 38 "rygel-http-item-uri_http-post.vala"
	self->item_id = (_tmp0_ = g_strdup (item_id), _g_free0 (self->item_id), _tmp0_);
#line 39 "rygel-http-item-uri_http-post.vala"
	self->thumbnail_index = thumbnail_index;
#line 40 "rygel-http-item-uri_http-post.vala"
	self->subtitle_index = subtitle_index;
#line 41 "rygel-http-item-uri_http-post.vala"
	self->transcode_target = (_tmp1_ = g_strdup (transcode_target), _g_free0 (self->transcode_target), _tmp1_);
#line 42 "rygel-http-item-uri_http-post.vala"
	self->http_server = (_tmp2_ = _g_object_ref0 (http_server), _g_object_unref0 (self->http_server), _tmp2_);
#line 177 "rygel-http-item-uri_http-post.c"
	return self;
}


#line 33 "rygel-http-item-uri_http-post.vala"
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target) {
#line 33 "rygel-http-item-uri_http-post.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item_id, http_server, thumbnail_index, subtitle_index, transcode_target);
#line 186 "rygel-http-item-uri_http-post.c"
}


#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 192 "rygel-http-item-uri_http-post.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 201 "rygel-http-item-uri_http-post.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 209 "rygel-http-item-uri_http-post.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 220 "rygel-http-item-uri_http-post.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 235 "rygel-http-item-uri_http-post.c"
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 246 "rygel-http-item-uri_http-post.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 45 "rygel-http-item-uri_http-post.vala"
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const char* uri, RygelHTTPServer* http_server, GError** error) {
#line 261 "rygel-http-item-uri_http-post.c"
	RygelHTTPItemURI * self;
	char* _tmp0_;
	RygelHTTPServer* _tmp1_;
	char* request_uri;
	gint parts_length1;
	gint _parts_size_;
	char** _tmp3_;
	char** _tmp2_;
	char** parts;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 45 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 45 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 45 "rygel-http-item-uri_http-post.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 49 "rygel-http-item-uri_http-post.vala"
	self->thumbnail_index = -1;
#line 50 "rygel-http-item-uri_http-post.vala"
	self->subtitle_index = -1;
#line 51 "rygel-http-item-uri_http-post.vala"
	self->transcode_target = (_tmp0_ = NULL, _g_free0 (self->transcode_target), _tmp0_);
#line 52 "rygel-http-item-uri_http-post.vala"
	self->http_server = (_tmp1_ = _g_object_ref0 (http_server), _g_object_unref0 (self->http_server), _tmp1_);
#line 54 "rygel-http-item-uri_http-post.vala"
	request_uri = string_replace (uri, rygel_http_server_get_path_root (http_server), "");
#line 289 "rygel-http-item-uri_http-post.c"
	parts = (_tmp3_ = _tmp2_ = g_strsplit (request_uri, "/", 0), parts_length1 = _vala_array_length (_tmp2_), _parts_size_ = parts_length1, _tmp3_);
#line 57 "rygel-http-item-uri_http-post.vala"
	if (parts_length1 < 2) {
#line 57 "rygel-http-item-uri_http-post.vala"
		_tmp4_ = TRUE;
#line 295 "rygel-http-item-uri_http-post.c"
	} else {
#line 57 "rygel-http-item-uri_http-post.vala"
		_tmp4_ = (parts_length1 % 2) == 0;
#line 299 "rygel-http-item-uri_http-post.c"
	}
#line 57 "rygel-http-item-uri_http-post.vala"
	if (_tmp4_) {
#line 303 "rygel-http-item-uri_http-post.c"
		_inner_error_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ ("Invalid URI '%s'"), request_uri);
		{
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (request_uri);
				_g_object_unref0 (self);
				return NULL;
			} else {
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (request_uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	{
		gint i;
#line 62 "rygel-http-item-uri_http-post.vala"
		i = 1;
#line 325 "rygel-http-item-uri_http-post.c"
		{
			gboolean _tmp5_;
#line 62 "rygel-http-item-uri_http-post.vala"
			_tmp5_ = TRUE;
#line 62 "rygel-http-item-uri_http-post.vala"
			while (TRUE) {
#line 332 "rygel-http-item-uri_http-post.c"
				const char* _tmp12_;
				GQuark _tmp13_;
				static GQuark _tmp13__label0 = 0;
				static GQuark _tmp13__label1 = 0;
				static GQuark _tmp13__label2 = 0;
				static GQuark _tmp13__label3 = 0;
#line 62 "rygel-http-item-uri_http-post.vala"
				if (!_tmp5_) {
#line 62 "rygel-http-item-uri_http-post.vala"
					i = i + 2;
#line 343 "rygel-http-item-uri_http-post.c"
				}
#line 62 "rygel-http-item-uri_http-post.vala"
				_tmp5_ = FALSE;
#line 62 "rygel-http-item-uri_http-post.vala"
				if (!(i < (parts_length1 - 1))) {
#line 62 "rygel-http-item-uri_http-post.vala"
					break;
#line 351 "rygel-http-item-uri_http-post.c"
				}
				_tmp12_ = parts[i];
				_tmp13_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
				if (_tmp13_ == ((0 != _tmp13__label0) ? _tmp13__label0 : (_tmp13__label0 = g_quark_from_static_string ("item"))))
				switch (0) {
					default:
					{
						gint data_length1;
						gint _data_size_;
						guchar* _tmp9_;
						char* _tmp6_;
						size_t _tmp7_;
						guchar* _tmp8_;
						guchar* data;
						GString* builder;
						char* _tmp10_;
						data = (_tmp9_ = (_tmp8_ = g_base64_decode (_tmp6_ = soup_uri_decode (parts[i + 1]), &_tmp7_), _g_free0 (_tmp6_), _tmp8_), data_length1 = _tmp7_, _data_size_ = data_length1, _tmp9_);
#line 66 "rygel-http-item-uri_http-post.vala"
						builder = g_string_new ("");
#line 67 "rygel-http-item-uri_http-post.vala"
						g_string_append (builder, (const char*) data);
#line 68 "rygel-http-item-uri_http-post.vala"
						self->item_id = (_tmp10_ = g_strdup (builder->str), _g_free0 (self->item_id), _tmp10_);
#line 375 "rygel-http-item-uri_http-post.c"
						_g_string_free0 (builder);
						data = (g_free (data), NULL);
#line 70 "rygel-http-item-uri_http-post.vala"
						break;
#line 380 "rygel-http-item-uri_http-post.c"
					}
				} else if (_tmp13_ == ((0 != _tmp13__label1) ? _tmp13__label1 : (_tmp13__label1 = g_quark_from_static_string ("transcoded"))))
				switch (0) {
					default:
					{
						char* _tmp11_;
#line 72 "rygel-http-item-uri_http-post.vala"
						self->transcode_target = (_tmp11_ = soup_uri_decode (parts[i + 1]), _g_free0 (self->transcode_target), _tmp11_);
#line 74 "rygel-http-item-uri_http-post.vala"
						break;
#line 391 "rygel-http-item-uri_http-post.c"
					}
				} else if (_tmp13_ == ((0 != _tmp13__label2) ? _tmp13__label2 : (_tmp13__label2 = g_quark_from_static_string ("thumbnail"))))
				switch (0) {
					default:
					{
#line 76 "rygel-http-item-uri_http-post.vala"
						self->thumbnail_index = atoi (parts[i + 1]);
#line 78 "rygel-http-item-uri_http-post.vala"
						break;
#line 401 "rygel-http-item-uri_http-post.c"
					}
				} else if (_tmp13_ == ((0 != _tmp13__label3) ? _tmp13__label3 : (_tmp13__label3 = g_quark_from_static_string ("subtitle"))))
				switch (0) {
					default:
					{
#line 80 "rygel-http-item-uri_http-post.vala"
						self->subtitle_index = atoi (parts[i + 1]);
#line 82 "rygel-http-item-uri_http-post.vala"
						break;
#line 411 "rygel-http-item-uri_http-post.c"
					}
				} else
				switch (0) {
					default:
					{
#line 84 "rygel-http-item-uri_http-post.vala"
						break;
#line 419 "rygel-http-item-uri_http-post.c"
					}
				}
			}
		}
	}
#line 88 "rygel-http-item-uri_http-post.vala"
	if (self->item_id == NULL) {
#line 427 "rygel-http-item-uri_http-post.c"
		_inner_error_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _ ("Not Found"));
		{
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (request_uri);
				_g_object_unref0 (self);
				return NULL;
			} else {
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (request_uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}


#line 45 "rygel-http-item-uri_http-post.vala"
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const char* uri, RygelHTTPServer* http_server, GError** error) {
#line 45 "rygel-http-item-uri_http-post.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 455 "rygel-http-item-uri_http-post.c"
}


#line 1201 "glib-2.0.vapi"
static gchar* string_to_utf8 (const char* self, int* result_length1) {
#line 461 "rygel-http-item-uri_http-post.c"
	gchar* result = NULL;
	gint _result__length1;
	gint __result__size_;
	gchar* _tmp1_;
	gint _tmp0_;
	gchar* _result_;
	gchar* _tmp2_;
#line 1201 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 471 "rygel-http-item-uri_http-post.c"
	_result_ = (_tmp1_ = g_new0 (gchar, _tmp0_ = strlen (self) + 1), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
#line 1203 "glib-2.0.vapi"
	_result__length1--;
#line 1204 "glib-2.0.vapi"
	memcpy (_result_, self, strlen (self));
#line 477 "rygel-http-item-uri_http-post.c"
	result = (_tmp2_ = _result_, *result_length1 = _result__length1, _tmp2_);
#line 1205 "glib-2.0.vapi"
	return result;
#line 481 "rygel-http-item-uri_http-post.c"
	_result_ = (g_free (_result_), NULL);
}


#line 93 "rygel-http-item-uri_http-post.vala"
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
#line 488 "rygel-http-item-uri_http-post.c"
	char* result = NULL;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp1_;
	gint _tmp0_;
	gchar* data;
	char* _tmp2_;
	char* _tmp3_;
	char* escaped;
	char* path;
#line 93 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 501 "rygel-http-item-uri_http-post.c"
	data = (_tmp1_ = string_to_utf8 (self->item_id, &_tmp0_), data_length1 = _tmp0_, _data_size_ = data_length1, _tmp1_);
#line 98 "rygel-http-item-uri_http-post.vala"
	escaped = (_tmp3_ = g_uri_escape_string (_tmp2_ = g_base64_encode ((guchar*) data, data_length1), "", TRUE), _g_free0 (_tmp2_), _tmp3_);
#line 101 "rygel-http-item-uri_http-post.vala"
	path = g_strconcat ("/item/", escaped, NULL);
#line 103 "rygel-http-item-uri_http-post.vala"
	if (self->transcode_target != NULL) {
#line 509 "rygel-http-item-uri_http-post.c"
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
#line 104 "rygel-http-item-uri_http-post.vala"
		escaped = (_tmp4_ = g_uri_escape_string (self->transcode_target, "", TRUE), _g_free0 (escaped), _tmp4_);
#line 105 "rygel-http-item-uri_http-post.vala"
		path = (_tmp6_ = g_strconcat (path, _tmp5_ = g_strconcat ("/transcoded/", escaped, NULL), NULL), _g_free0 (path), _tmp6_);
#line 517 "rygel-http-item-uri_http-post.c"
		_g_free0 (_tmp5_);
	} else {
#line 106 "rygel-http-item-uri_http-post.vala"
		if (self->thumbnail_index >= 0) {
#line 522 "rygel-http-item-uri_http-post.c"
			char* _tmp7_;
			char* _tmp8_;
			char* _tmp9_;
#line 107 "rygel-http-item-uri_http-post.vala"
			path = (_tmp9_ = g_strconcat (path, _tmp8_ = g_strconcat ("/thumbnail/", _tmp7_ = g_strdup_printf ("%i", self->thumbnail_index), NULL), NULL), _g_free0 (path), _tmp9_);
#line 528 "rygel-http-item-uri_http-post.c"
			_g_free0 (_tmp8_);
			_g_free0 (_tmp7_);
		} else {
#line 108 "rygel-http-item-uri_http-post.vala"
			if (self->subtitle_index >= 0) {
#line 534 "rygel-http-item-uri_http-post.c"
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
#line 109 "rygel-http-item-uri_http-post.vala"
				path = (_tmp12_ = g_strconcat (path, _tmp11_ = g_strconcat ("/subtitle/", _tmp10_ = g_strdup_printf ("%i", self->subtitle_index), NULL), NULL), _g_free0 (path), _tmp12_);
#line 540 "rygel-http-item-uri_http-post.c"
				_g_free0 (_tmp11_);
				_g_free0 (_tmp10_);
			}
		}
	}
	result = rygel_http_item_uri_create_uri_for_path (self, path);
	_g_free0 (path);
	_g_free0 (escaped);
	data = (g_free (data), NULL);
#line 112 "rygel-http-item-uri_http-post.vala"
	return result;
#line 552 "rygel-http-item-uri_http-post.c"
}


#line 115 "rygel-http-item-uri_http-post.vala"
static char* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const char* path) {
#line 558 "rygel-http-item-uri_http-post.c"
	char* result = NULL;
#line 115 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 564 "rygel-http-item-uri_http-post.c"
	result = g_strdup_printf ("http://%s:%u%s%s", gssdp_client_get_host_ip ((GSSDPClient*) self->http_server->context), gupnp_context_get_port (self->http_server->context), rygel_http_server_get_path_root (self->http_server), path);
#line 116 "rygel-http-item-uri_http-post.vala"
	return result;
#line 568 "rygel-http-item-uri_http-post.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
	self = RYGEL_HTTP_ITEM_URI (obj);
	_g_free0 (self->item_id);
	_g_free0 (self->transcode_target);
	_g_object_unref0 (self->http_server);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




