/* rygel-visual-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-visual-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const char* uri);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const char* uri, GError** error);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const char* protocol);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const char* uri);
char* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
char* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 41 "rygel-visual-item.vala"
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const char* uri) {
#line 199 "rygel-visual-item.c"
	RygelThumbnailer* thumbnailer;
	GError * _inner_error_ = NULL;
#line 41 "rygel-visual-item.vala"
	g_return_if_fail (uri != NULL);
#line 43 "rygel-visual-item.vala"
	thumbnailer = rygel_thumbnailer_get_default ();
#line 45 "rygel-visual-item.vala"
	if (thumbnailer != NULL) {
#line 208 "rygel-visual-item.c"
		{
			RygelThumbnail* thumb;
#line 47 "rygel-visual-item.vala"
			thumb = rygel_thumbnailer_get_thumbnail (thumbnailer, uri, &_inner_error_);
#line 213 "rygel-visual-item.c"
			if (_inner_error_ != NULL) {
				goto __catch41_g_error;
			}
#line 48 "rygel-visual-item.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) rygel_visual_item_get_thumbnails (self), thumb);
#line 219 "rygel-visual-item.c"
			_rygel_icon_info_unref0 (thumb);
		}
		goto __finally41;
		__catch41_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (err);
			}
		}
		__finally41:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (thumbnailer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (thumbnailer);
}


#line 53 "rygel-visual-item.vala"
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 246 "rygel-visual-item.c"
	GError * _inner_error_ = NULL;
#line 53 "rygel-visual-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 250 "rygel-visual-item.c"
	{
		GeeIterator* _thumbnail_it;
#line 56 "rygel-visual-item.vala"
		_thumbnail_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) rygel_visual_item_get_thumbnails (self));
#line 56 "rygel-visual-item.vala"
		while (TRUE) {
#line 257 "rygel-visual-item.c"
			RygelThumbnail* thumbnail;
			char* protocol;
			gboolean _tmp0_ = FALSE;
#line 56 "rygel-visual-item.vala"
			if (!gee_iterator_next (_thumbnail_it)) {
#line 56 "rygel-visual-item.vala"
				break;
#line 265 "rygel-visual-item.c"
			}
#line 56 "rygel-visual-item.vala"
			thumbnail = (RygelThumbnail*) gee_iterator_get (_thumbnail_it);
#line 57 "rygel-visual-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, ((RygelIconInfo*) thumbnail)->uri, &_inner_error_);
#line 271 "rygel-visual-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_icon_info_unref0 (thumbnail);
				_g_object_unref0 (_thumbnail_it);
				return;
			}
#line 59 "rygel-visual-item.vala"
			if (allow_internal) {
#line 59 "rygel-visual-item.vala"
				_tmp0_ = TRUE;
#line 282 "rygel-visual-item.c"
			} else {
#line 59 "rygel-visual-item.vala"
				_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 286 "rygel-visual-item.c"
			}
#line 59 "rygel-visual-item.vala"
			if (_tmp0_) {
#line 290 "rygel-visual-item.c"
				GUPnPDIDLLiteResource* _tmp1_;
#line 60 "rygel-visual-item.vala"
				_tmp1_ = rygel_thumbnail_add_resource (thumbnail, didl_item, protocol);
#line 294 "rygel-visual-item.c"
				_g_object_unref0 (_tmp1_);
			}
			_g_free0 (protocol);
			_rygel_icon_info_unref0 (thumbnail);
		}
		_g_object_unref0 (_thumbnail_it);
	}
}


#line 65 "rygel-visual-item.vala"
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res) {
#line 65 "rygel-visual-item.vala"
	g_return_if_fail (res != NULL);
#line 66 "rygel-visual-item.vala"
	gupnp_didl_lite_resource_set_width (res, rygel_visual_item_get_width (self));
#line 67 "rygel-visual-item.vala"
	gupnp_didl_lite_resource_set_height (res, rygel_visual_item_get_height (self));
#line 68 "rygel-visual-item.vala"
	gupnp_didl_lite_resource_set_color_depth (res, rygel_visual_item_get_color_depth (self));
#line 315 "rygel-visual-item.c"
}


#line 71 "rygel-visual-item.vala"
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 71 "rygel-visual-item.vala"
	g_return_if_fail (server != NULL);
#line 71 "rygel-visual-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 325 "rygel-visual-item.c"
	{
		GeeIterator* _thumbnail_it;
#line 74 "rygel-visual-item.vala"
		_thumbnail_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) rygel_visual_item_get_thumbnails (self));
#line 74 "rygel-visual-item.vala"
		while (TRUE) {
#line 332 "rygel-visual-item.c"
			RygelThumbnail* thumbnail;
#line 74 "rygel-visual-item.vala"
			if (!gee_iterator_next (_thumbnail_it)) {
#line 74 "rygel-visual-item.vala"
				break;
#line 338 "rygel-visual-item.c"
			}
#line 74 "rygel-visual-item.vala"
			thumbnail = (RygelThumbnail*) gee_iterator_get (_thumbnail_it);
#line 75 "rygel-visual-item.vala"
			if (rygel_http_server_need_proxy (server, ((RygelIconInfo*) thumbnail)->uri)) {
#line 344 "rygel-visual-item.c"
				char* uri;
				gint index;
				char* _tmp0_;
				char* _tmp1_;
				GUPnPDIDLLiteResource* _tmp2_;
				char* _tmp3_;
#line 76 "rygel-visual-item.vala"
				uri = g_strdup (((RygelIconInfo*) thumbnail)->uri);
#line 77 "rygel-visual-item.vala"
				index = gee_abstract_list_index_of ((GeeAbstractList*) rygel_visual_item_get_thumbnails (self), thumbnail);
#line 79 "rygel-visual-item.vala"
				((RygelIconInfo*) thumbnail)->uri = (_tmp0_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) server, (RygelMediaItem*) self, index, -1, NULL), _g_free0 (((RygelIconInfo*) thumbnail)->uri), _tmp0_);
#line 83 "rygel-visual-item.vala"
				_tmp2_ = rygel_thumbnail_add_resource (thumbnail, didl_item, _tmp1_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) server));
#line 359 "rygel-visual-item.c"
				_g_object_unref0 (_tmp2_);
				_g_free0 (_tmp1_);
#line 86 "rygel-visual-item.vala"
				((RygelIconInfo*) thumbnail)->uri = (_tmp3_ = g_strdup (uri), _g_free0 (((RygelIconInfo*) thumbnail)->uri), _tmp3_);
#line 364 "rygel-visual-item.c"
				_g_free0 (uri);
			}
			_rygel_icon_info_unref0 (thumbnail);
		}
		_g_object_unref0 (_thumbnail_it);
	}
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
}


gint rygel_visual_item_get_pixel_width (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_width (self);
}


void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_width (self, value);
}


gint rygel_visual_item_get_pixel_height (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_height (self);
}


void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_height (self, value);
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("pixel-width", "pixel-width", "pixel-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("pixel-height", "pixel-height", "pixel-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * An interface that visual (video and image) items must implement.
 */
GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




