/* rygel-external-container.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY (rygel_external_media_object_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxyIface))

typedef struct _RygelExternalMediaObjectProxy RygelExternalMediaObjectProxy;
typedef struct _RygelExternalMediaObjectProxyIface RygelExternalMediaObjectProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY (rygel_external_media_object_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY (rygel_external_media_container_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxyIface))

typedef struct _RygelExternalMediaContainerProxy RygelExternalMediaContainerProxy;
typedef struct _RygelExternalMediaContainerProxyIface RygelExternalMediaContainerProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY (rygel_external_media_container_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _RygelExternalContainerFindObjectData RygelExternalContainerFindObjectData;
typedef struct _RygelExternalContainerCreateMediaObjectsData RygelExternalContainerCreateMediaObjectsData;
typedef struct _RygelExternalContainerRefreshChildContainersData RygelExternalContainerRefreshChildContainersData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalContainerUpdateContainerData RygelExternalContainerUpdateContainerData;

struct _RygelExternalMediaObjectProxyIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObjectProxy* self);
	void (*set_parent) (RygelExternalMediaObjectProxy* self, const char* value);
	char* (*get_display_name) (RygelExternalMediaObjectProxy* self);
	void (*set_display_name) (RygelExternalMediaObjectProxy* self, const char* value);
	char* (*get_object_type) (RygelExternalMediaObjectProxy* self);
	void (*set_object_type) (RygelExternalMediaObjectProxy* self, const char* value);
};

struct _RygelExternalMediaContainerProxyIface {
	GTypeInterface parent_iface;
	void (*list_children) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_children_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_containers) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_containers_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_items) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_items_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*search_objects) (RygelExternalMediaContainerProxy* self, const char* query, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*search_objects_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	guint (*get_child_count) (RygelExternalMediaContainerProxy* self);
	void (*set_child_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_item_count) (RygelExternalMediaContainerProxy* self);
	void (*set_item_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainerProxy* self);
	void (*set_container_count) (RygelExternalMediaContainerProxy* self, guint value);
	gboolean (*get_searchable) (RygelExternalMediaContainerProxy* self);
	void (*set_searchable) (RygelExternalMediaContainerProxy* self, gboolean value);
	char* (*get_icon) (RygelExternalMediaContainerProxy* self);
	void (*set_icon) (RygelExternalMediaContainerProxy* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainerProxy* actual_container;
	char* host_ip;
	char* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	RygelExternalItemFactory* item_factory;
	GeeArrayList* containers;
	gboolean searchable;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	char** filter;
	char** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	char** _tmp1_;
	const char** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const char* object_prop;
	const char** item_prop_collection;
	int item_prop_collection_length1;
	int item_prop_it;
	const char* item_prop;
	GHashTable** children_props;
	gint _tmp2_;
	gint children_props_length1;
	gint _children_props_size_;
	GHashTable** _tmp3_;
	RygelMediaObjects* _tmp4_;
	GError * _inner_error_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	RygelMediaObjects* _tmp1_;
	char** filter;
	char** _tmp2_;
	gint filter_length1;
	gint _filter_size_;
	char** _tmp3_;
	const char** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const char* object_prop;
	const char** container_prop_collection;
	int container_prop_collection_length1;
	int container_prop_it;
	const char* container_prop;
	const char** item_prop_collection;
	int item_prop_collection_length1;
	int item_prop_it;
	const char* item_prop;
	RygelSearchExpression* ext_expression;
	GHashTable** _result_;
	char* _tmp4_;
	gint _tmp5_;
	GHashTable** _tmp6_;
	gint _result__length1;
	gint __result__size_;
	GHashTable** _tmp7_;
	RygelMediaObjects* _tmp8_;
	GError * _inner_error_;
};

struct _RygelExternalContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelExternalMediaObjectProxy* actual_object;
	RygelMediaObject* _tmp2_;
	GeeIterator* _container_it;
	RygelExternalContainer* container;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelExternalDummyContainer* parent_container;
	char* _tmp5_;
	RygelExternalDummyContainer* _tmp6_;
	FreeDesktopProperties* props_iface;
	GHashTable* props;
	RygelMediaItem* _tmp10_;
	char* _tmp7_;
	char* _tmp8_;
	RygelMediaItem* _tmp9_;
	RygelMediaObject* _tmp11_;
	char* _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _RygelExternalContainerCreateMediaObjectsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	GHashTable** all_props;
	gint all_props_length1;
	RygelMediaContainer* parent;
	RygelMediaObjects* result;
	RygelMediaObjects* media_objects;
	char* id;
	char* type;
	RygelMediaContainer* parent_container;
	RygelMediaContainer* _tmp0_;
	char* parent_id;
	RygelMediaContainer* _tmp1_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp2_;
	char* title;
	guint child_count;
	RygelMediaObject* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelMediaObject* _tmp5_;
	GHashTable** props_collection;
	int props_collection_length1;
	int props_it;
	GHashTable* props;
	GError * _inner_error_;
};

struct _RygelExternalContainerRefreshChildContainersData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	char** filter;
	char** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	char** _tmp1_;
	const char** object_prop_collection;
	int object_prop_collection_length1;
	int object_prop_it;
	const char* object_prop;
	const char** container_prop_collection;
	int container_prop_collection_length1;
	int container_prop_it;
	const char* container_prop;
	GHashTable** children_props;
	gint _tmp2_;
	gint children_props_length1;
	gint _children_props_size_;
	GHashTable** _tmp3_;
	char* path;
	char* title;
	guint child_count;
	gboolean searchable;
	RygelExternalContainer* container;
	GHashTable** props_collection;
	int props_collection_length1;
	int props_it;
	GHashTable* props;
	GError * _inner_error_;
};

struct _RygelExternalContainerUpdateContainerData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gboolean connect_signal;
	GError * err;
	GError * _inner_error_;
};


static gpointer rygel_external_container_parent_class = NULL;

GType rygel_external_container_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_object_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_container_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_get_type (void) G_GNUC_CONST;
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerPrivate))
enum  {
	RYGEL_EXTERNAL_CONTAINER_DUMMY_PROPERTY
};
RygelExternalContainer* rygel_external_container_new (const char* id, const char* title, guint child_count, gboolean searchable, const char* service_name, const char* path, const char* host_ip, RygelExternalContainer* parent, GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const char* id, const char* title, guint child_count, gboolean searchable, const char* service_name, const char* path, const char* host_ip, RygelExternalContainer* parent, GError** error);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
void rygel_external_media_container_proxy_list_children (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_children_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data);
static void _vala_array_add3 (char*** array, int* length, int* size, char* value);
static void _vala_array_add4 (char*** array, int* length, int* size, char* value);
static void _vala_array_add5 (char*** array, int* length, int* size, char* value);
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression);
void rygel_external_media_container_proxy_search_objects (RygelExternalMediaContainerProxy* self, const char* query, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_search_objects_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_real_find_object_data_free (gpointer _data);
static void rygel_external_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* data);
char* rygel_external_media_object_proxy_get_object_type (RygelExternalMediaObjectProxy* self);
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const char* id);
char* rygel_external_media_object_proxy_get_parent (RygelExternalMediaObjectProxy* self);
RygelExternalDummyContainer* rygel_external_dummy_container_new (const char* id, const char* title, guint child_count, RygelMediaContainer* parent);
RygelExternalDummyContainer* rygel_external_dummy_container_construct (GType object_type, const char* id, const char* title, guint child_count, RygelMediaContainer* parent);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE "org.gnome.UPnP.MediaItem2"
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* type, const char* title, GHashTable* props, const char* service_name, const char* host_ip, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
char* rygel_external_media_object_proxy_get_display_name (RygelExternalMediaObjectProxy* self);
static void rygel_external_container_create_media_objects_data_free (gpointer _data);
static GHashTable** _vala_array_dup1 (GHashTable** self, int length);
static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* data);
static const char* _variant_get1 (GVariant* value);
static const char* _variant_get2 (GVariant* value);
static const char* _variant_get3 (GVariant* value);
static const char* _variant_get4 (GVariant* value);
static guint _variant_get5 (GVariant* value);
static void rygel_external_container_refresh_child_containers_data_free (gpointer _data);
static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* data);
static void _vala_array_add6 (char*** array, int* length, int* size, char* value);
static void _vala_array_add7 (char*** array, int* length, int* size, char* value);
void rygel_external_media_container_proxy_list_containers (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, char** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_containers_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static const char* _variant_get6 (GVariant* value);
static const char* _variant_get7 (GVariant* value);
static guint _variant_get8 (GVariant* value);
static gboolean _variant_get9 (GVariant* value);
static void rygel_external_container_update_container_data_free (gpointer _data);
static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* data);
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self);
char* rygel_external_container_translate_property (RygelExternalContainer* self, const char* property);
static void rygel_external_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

extern const char* RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES[4];
extern const char* RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES[18];
extern const char* RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES[2];


#line 43 "rygel-external-container.vala"
RygelExternalContainer* rygel_external_container_construct (GType object_type, const char* id, const char* title, guint child_count, gboolean searchable, const char* service_name, const char* path, const char* host_ip, RygelExternalContainer* parent, GError** error) {
#line 430 "rygel-external-container.c"
	RygelExternalContainer * self;
	char* _tmp0_;
	char* _tmp1_;
	RygelExternalItemFactory* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelExternalMediaContainerProxy* _tmp4_;
	RygelExternalMediaContainerProxy* _tmp5_;
	GError * _inner_error_ = NULL;
#line 43 "rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 43 "rygel-external-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 43 "rygel-external-container.vala"
	g_return_val_if_fail (service_name != NULL, NULL);
#line 43 "rygel-external-container.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 43 "rygel-external-container.vala"
	g_return_val_if_fail (host_ip != NULL, NULL);
#line 51 "rygel-external-container.vala"
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, id, (RygelMediaContainer*) parent, title, (gint) child_count);
#line 53 "rygel-external-container.vala"
	self->service_name = (_tmp0_ = g_strdup (service_name), _g_free0 (self->service_name), _tmp0_);
#line 54 "rygel-external-container.vala"
	self->host_ip = (_tmp1_ = g_strdup (host_ip), _g_free0 (self->host_ip), _tmp1_);
#line 55 "rygel-external-container.vala"
	self->priv->item_factory = (_tmp2_ = rygel_external_item_factory_new (), _rygel_external_item_factory_unref0 (self->priv->item_factory), _tmp2_);
#line 56 "rygel-external-container.vala"
	self->priv->containers = (_tmp3_ = gee_array_list_new (RYGEL_EXTERNAL_TYPE_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->containers), _tmp3_);
#line 59 "rygel-external-container.vala"
	_tmp4_ = (RygelExternalMediaContainerProxy*) g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", path, "g-interface-name", "org.gnome.UPnP.MediaContainer2", NULL);
#line 461 "rygel-external-container.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 59 "rygel-external-container.vala"
	self->actual_container = (_tmp5_ = _tmp4_, _g_object_unref0 (self->actual_container), _tmp5_);
#line 63 "rygel-external-container.vala"
	rygel_external_container_update_container (self, TRUE, NULL, NULL);
#line 477 "rygel-external-container.c"
	return self;
}


#line 43 "rygel-external-container.vala"
RygelExternalContainer* rygel_external_container_new (const char* id, const char* title, guint child_count, gboolean searchable, const char* service_name, const char* path, const char* host_ip, RygelExternalContainer* parent, GError** error) {
#line 43 "rygel-external-container.vala"
	return rygel_external_container_construct (RYGEL_EXTERNAL_TYPE_CONTAINER, id, title, child_count, searchable, service_name, path, host_ip, parent, error);
#line 486 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children_data_free (gpointer _data) {
	RygelExternalContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerGetChildrenData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
	_data_->self = g_object_ref (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_external_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_real_get_children_co (data);
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->filter = (data->_tmp1_ = (data->_tmp0_ = g_new0 (char*, 0 + 1), data->_tmp0_), data->filter_length1 = 0, data->_filter_size_ = data->filter_length1, data->_tmp1_);
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
#line 73 "rygel-external-container.vala"
				_vala_array_add1 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->object_prop));
#line 583 "rygel-external-container.c"
			}
		}
	}
	{
		data->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		data->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (data->item_prop_it = 0; data->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); data->item_prop_it = data->item_prop_it + 1) {
			data->item_prop = data->item_prop_collection[data->item_prop_it];
			{
#line 77 "rygel-external-container.vala"
				_vala_array_add2 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->item_prop));
#line 595 "rygel-external-container.c"
			}
		}
	}
	data->_state_ = 1;
	rygel_external_media_container_proxy_list_children (data->self->actual_container, data->offset, data->max_count, data->filter, data->filter_length1, rygel_external_container_get_children_ready, data);
	return FALSE;
	_state_1:
	data->children_props = (data->_tmp3_ = rygel_external_media_container_proxy_list_children_finish (data->self->actual_container, data->_res_, &data->_tmp2_, &data->_inner_error_), data->children_props_length1 = data->_tmp2_, data->_children_props_size_ = data->children_props_length1, data->_tmp3_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 2;
	rygel_external_container_create_media_objects (data->self, data->children_props, data->children_props_length1, (RygelMediaContainer*) data->self, rygel_external_container_get_children_ready, data);
	return FALSE;
	_state_2:
	data->_tmp4_ = rygel_external_container_create_media_objects_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->result = data->_tmp4_;
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_container_real_search_data_free (gpointer _data) {
	RygelExternalContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_external_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_external_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_real_search_co (data);
}


static void _vala_array_add3 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
	}
	_state_0:
#line 94 "rygel-external-container.vala"
	if (data->expression == NULL) {
#line 94 "rygel-external-container.vala"
		data->_tmp0_ = TRUE;
#line 766 "rygel-external-container.c"
	} else {
#line 94 "rygel-external-container.vala"
		data->_tmp0_ = !data->self->priv->searchable;
#line 770 "rygel-external-container.c"
	}
#line 94 "rygel-external-container.vala"
	if (data->_tmp0_) {
#line 774 "rygel-external-container.c"
		data->_state_ = 3;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search (RYGEL_MEDIA_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_external_container_search_ready, data);
		return FALSE;
		_state_3:
		data->_tmp1_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp2_ = NULL;
	data->filter = (data->_tmp3_ = (data->_tmp2_ = g_new0 (char*, 0 + 1), data->_tmp2_), data->filter_length1 = 0, data->_filter_size_ = data->filter_length1, data->_tmp3_);
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
#line 105 "rygel-external-container.vala"
				_vala_array_add3 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->object_prop));
#line 814 "rygel-external-container.c"
			}
		}
	}
	{
		data->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		data->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (data->container_prop_it = 0; data->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); data->container_prop_it = data->container_prop_it + 1) {
			data->container_prop = data->container_prop_collection[data->container_prop_it];
			{
#line 109 "rygel-external-container.vala"
				_vala_array_add4 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->container_prop));
#line 826 "rygel-external-container.c"
			}
		}
	}
	{
		data->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		data->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (data->item_prop_it = 0; data->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); data->item_prop_it = data->item_prop_it + 1) {
			data->item_prop = data->item_prop_collection[data->item_prop_it];
			{
#line 113 "rygel-external-container.vala"
				_vala_array_add5 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->item_prop));
#line 838 "rygel-external-container.c"
			}
		}
	}
	data->ext_expression = rygel_external_container_translate_expression (data->self, data->expression);
	data->_state_ = 4;
	rygel_external_media_container_proxy_search_objects (data->self->actual_container, data->_tmp4_ = rygel_search_expression_to_string (data->ext_expression), data->offset, data->max_count, data->filter, data->filter_length1, rygel_external_container_search_ready, data);
	return FALSE;
	_state_4:
	data->_result_ = (data->_tmp7_ = (data->_tmp6_ = rygel_external_media_container_proxy_search_objects_finish (data->self->actual_container, data->_res_, &data->_tmp5_, &data->_inner_error_), _g_free0 (data->_tmp4_), data->_tmp6_), data->_result__length1 = data->_tmp5_, data->__result__size_ = data->_result__length1, data->_tmp7_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_search_expression_unref0 (data->ext_expression);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 122 "rygel-external-container.vala"
	data->total_matches = (guint) data->_result__length1;
#line 865 "rygel-external-container.c"
	data->_state_ = 5;
	rygel_external_container_create_media_objects (data->self, data->_result_, data->_result__length1, NULL, rygel_external_container_search_ready, data);
	return FALSE;
	_state_5:
	data->_tmp8_ = rygel_external_container_create_media_objects_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_rygel_search_expression_unref0 (data->ext_expression);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->result = data->_tmp8_;
	data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_rygel_search_expression_unref0 (data->ext_expression);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_result_ = (_vala_array_free (data->_result_, data->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_rygel_search_expression_unref0 (data->ext_expression);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_container_real_find_object_data_free (gpointer _data) {
	RygelExternalContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerFindObjectData, data);
}


static void rygel_external_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerFindObjectData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_external_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelExternalContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_real_find_object_co (data);
}


static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
	}
	_state_0:
	data->media_object = NULL;
	data->actual_object = (RygelExternalMediaObjectProxy*) g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->id, "g-interface-name", "org.gnome.UPnP.MediaObject2", NULL);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->media_object);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 137 "rygel-external-container.vala"
	if ((data->_tmp1_ = _vala_strcmp0 (data->_tmp0_ = rygel_external_media_object_proxy_get_object_type (data->actual_object), "container") == 0, _g_free0 (data->_tmp0_), data->_tmp1_)) {
#line 138 "rygel-external-container.vala"
		data->media_object = (data->_tmp2_ = (RygelMediaObject*) rygel_external_container_find_container_by_id (data->self, data->id), _g_object_unref0 (data->media_object), data->_tmp2_);
#line 140 "rygel-external-container.vala"
		if (data->media_object == NULL) {
#line 997 "rygel-external-container.c"
			{
				data->_container_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->self->priv->containers);
#line 142 "rygel-external-container.vala"
				while (TRUE) {
#line 142 "rygel-external-container.vala"
					if (!gee_iterator_next (data->_container_it)) {
#line 142 "rygel-external-container.vala"
						break;
#line 1006 "rygel-external-container.c"
					}
					data->container = (RygelExternalContainer*) gee_iterator_get (data->_container_it);
					data->_state_ = 6;
					rygel_media_container_find_object ((RygelMediaContainer*) data->container, data->id, data->cancellable, rygel_external_container_find_object_ready, data);
					return FALSE;
					_state_6:
					data->_tmp3_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) data->container, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_object_unref0 (data->container);
						_g_object_unref0 (data->_container_it);
						_g_object_unref0 (data->actual_object);
						_g_object_unref0 (data->media_object);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
#line 143 "rygel-external-container.vala"
					data->media_object = (data->_tmp4_ = data->_tmp3_, _g_object_unref0 (data->media_object), data->_tmp4_);
#line 146 "rygel-external-container.vala"
					if (data->media_object != NULL) {
#line 1035 "rygel-external-container.c"
						_g_object_unref0 (data->container);
#line 147 "rygel-external-container.vala"
						break;
#line 1039 "rygel-external-container.c"
					}
					_g_object_unref0 (data->container);
				}
				_g_object_unref0 (data->_container_it);
			}
		}
	} else {
		data->parent_container = (data->_tmp6_ = rygel_external_dummy_container_new (data->_tmp5_ = (char*) rygel_external_media_object_proxy_get_parent (data->actual_object), "LaLaLa", (guint) 0, NULL), _g_free0 (data->_tmp5_), data->_tmp6_);
		data->props_iface = (FreeDesktopProperties*) g_initable_new (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->self->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->id, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 7;
		free_desktop_properties_get_all (data->props_iface, RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE, rygel_external_container_find_object_ready, data);
		return FALSE;
		_state_7:
		data->props = free_desktop_properties_get_all_finish (data->props_iface, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->props_iface);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 8;
		rygel_external_item_factory_create (data->self->priv->item_factory, data->id, data->_tmp7_ = rygel_external_media_object_proxy_get_object_type (data->actual_object), data->_tmp8_ = rygel_external_media_object_proxy_get_display_name (data->actual_object), data->props, data->self->service_name, data->self->host_ip, (RygelMediaContainer*) data->parent_container, rygel_external_container_find_object_ready, data);
		return FALSE;
		_state_8:
		data->_tmp10_ = (data->_tmp9_ = rygel_external_item_factory_create_finish (data->self->priv->item_factory, data->_res_, &data->_inner_error_), _g_free0 (data->_tmp8_), _g_free0 (data->_tmp7_), data->_tmp9_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->props);
			_g_object_unref0 (data->props_iface);
			_g_object_unref0 (data->parent_container);
			_g_object_unref0 (data->actual_object);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 165 "rygel-external-container.vala"
		data->media_object = (data->_tmp11_ = (RygelMediaObject*) data->_tmp10_, _g_object_unref0 (data->media_object), data->_tmp11_);
#line 1112 "rygel-external-container.c"
		_g_hash_table_unref0 (data->props);
		_g_object_unref0 (data->props_iface);
		_g_object_unref0 (data->parent_container);
	}
	data->result = data->media_object;
	_g_object_unref0 (data->actual_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->actual_object);
	_g_object_unref0 (data->media_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_container_create_media_objects_data_free (gpointer _data) {
	RygelExternalContainerCreateMediaObjectsData* data;
	data = _data;
	data->all_props = (_vala_array_free (data->all_props, data->all_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerCreateMediaObjectsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static GHashTable** _vala_array_dup1 (GHashTable** self, int length) {
	GHashTable** result;
	int i;
	result = g_new0 (GHashTable*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_hash_table_ref0 (self[i]);
	}
	return result;
}


static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	GHashTable** _tmp0_;
	_data_ = g_slice_new0 (RygelExternalContainerCreateMediaObjectsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_create_media_objects);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_create_media_objects_data_free);
	_data_->self = g_object_ref (self);
	_data_->all_props = (_tmp0_ = all_props, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, all_props_length1));
	_data_->all_props_length1 = all_props_length1;
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_container_create_media_objects_co (_data_);
}


static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerCreateMediaObjectsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_create_media_objects_co (data);
}


static const char* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const char* _variant_get2 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const char* _variant_get3 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const char* _variant_get4 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint _variant_get5 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 9:
		goto _state_9;
	}
	_state_0:
	data->media_objects = rygel_media_objects_new ();
	{
		data->props_collection = data->all_props;
		data->props_collection_length1 = data->all_props_length1;
		for (data->props_it = 0; data->props_it < data->all_props_length1; data->props_it = data->props_it + 1) {
			data->props = _g_hash_table_ref0 (data->props_collection[data->props_it]);
			{
				data->id = g_strdup (_variant_get1 ((GVariant*) g_hash_table_lookup (data->props, "Path")));
				data->type = g_strdup (_variant_get2 ((GVariant*) g_hash_table_lookup (data->props, "Type")));
#line 189 "rygel-external-container.vala"
				if (data->parent != NULL) {
#line 190 "rygel-external-container.vala"
					data->parent_container = (data->_tmp0_ = _g_object_ref0 (data->parent), _g_object_unref0 (data->parent_container), data->_tmp0_);
#line 1252 "rygel-external-container.c"
				} else {
					data->parent_id = g_strdup (_variant_get3 ((GVariant*) g_hash_table_lookup (data->props, "Parent")));
#line 194 "rygel-external-container.vala"
					data->parent_container = (data->_tmp1_ = (RygelMediaContainer*) rygel_external_dummy_container_new (data->parent_id, "LaLaLa", (guint) 0, NULL), _g_object_unref0 (data->parent_container), data->_tmp1_);
#line 1257 "rygel-external-container.c"
					_g_free0 (data->parent_id);
				}
				data->media_object = NULL;
#line 201 "rygel-external-container.vala"
				if (_vala_strcmp0 (data->type, "container") == 0) {
#line 202 "rygel-external-container.vala"
					data->media_object = (data->_tmp2_ = (RygelMediaObject*) rygel_external_container_find_container_by_id (data->self, data->id), _g_object_unref0 (data->media_object), data->_tmp2_);
#line 1265 "rygel-external-container.c"
				}
#line 205 "rygel-external-container.vala"
				if (data->media_object == NULL) {
#line 1269 "rygel-external-container.c"
					data->title = g_strdup (_variant_get4 ((GVariant*) g_hash_table_lookup (data->props, "DisplayName")));
#line 208 "rygel-external-container.vala"
					if (_vala_strcmp0 (data->type, "container") == 0) {
#line 1273 "rygel-external-container.c"
						data->child_count = _variant_get5 ((GVariant*) g_hash_table_lookup (data->props, "ChildCount"));
#line 211 "rygel-external-container.vala"
						data->media_object = (data->_tmp3_ = (RygelMediaObject*) rygel_external_dummy_container_new (data->id, data->title, data->child_count, data->parent_container), _g_object_unref0 (data->media_object), data->_tmp3_);
#line 1277 "rygel-external-container.c"
					} else {
						data->_state_ = 9;
						rygel_external_item_factory_create (data->self->priv->item_factory, data->id, data->type, data->title, data->props, data->self->service_name, data->self->host_ip, data->parent_container, rygel_external_container_create_media_objects_ready, data);
						return FALSE;
						_state_9:
						data->_tmp4_ = rygel_external_item_factory_create_finish (data->self->priv->item_factory, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							_g_free0 (data->title);
							_g_object_unref0 (data->media_object);
							_g_object_unref0 (data->parent_container);
							_g_free0 (data->type);
							_g_free0 (data->id);
							_g_hash_table_unref0 (data->props);
							_g_object_unref0 (data->media_objects);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						}
#line 217 "rygel-external-container.vala"
						data->media_object = (data->_tmp5_ = (RygelMediaObject*) data->_tmp4_, _g_object_unref0 (data->media_object), data->_tmp5_);
#line 1306 "rygel-external-container.c"
					}
					_g_free0 (data->title);
				}
#line 228 "rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) data->media_objects, data->media_object);
#line 1312 "rygel-external-container.c"
				_g_object_unref0 (data->media_object);
				_g_object_unref0 (data->parent_container);
				_g_free0 (data->type);
				_g_free0 (data->id);
				_g_hash_table_unref0 (data->props);
			}
		}
	}
	data->result = data->media_objects;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->media_objects);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_container_refresh_child_containers_data_free (gpointer _data) {
	RygelExternalContainerRefreshChildContainersData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerRefreshChildContainersData, data);
}


static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = g_slice_new0 (RygelExternalContainerRefreshChildContainersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_refresh_child_containers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_refresh_child_containers_data_free);
	_data_->self = g_object_ref (self);
	rygel_external_container_refresh_child_containers_co (_data_);
}


static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_refresh_child_containers_co (data);
}


static void _vala_array_add6 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static const char* _variant_get6 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static const char* _variant_get7 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint _variant_get8 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static gboolean _variant_get9 (GVariant* value) {
	return g_variant_get_boolean (value);
}


static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 10:
		goto _state_10;
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->filter = (data->_tmp1_ = (data->_tmp0_ = g_new0 (char*, 0 + 1), data->_tmp0_), data->filter_length1 = 0, data->_filter_size_ = data->filter_length1, data->_tmp1_);
	{
		data->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		data->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (data->object_prop_it = 0; data->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); data->object_prop_it = data->object_prop_it + 1) {
			data->object_prop = data->object_prop_collection[data->object_prop_it];
			{
#line 238 "rygel-external-container.vala"
				_vala_array_add6 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->object_prop));
#line 1439 "rygel-external-container.c"
			}
		}
	}
	{
		data->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		data->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (data->container_prop_it = 0; data->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); data->container_prop_it = data->container_prop_it + 1) {
			data->container_prop = data->container_prop_collection[data->container_prop_it];
			{
#line 242 "rygel-external-container.vala"
				_vala_array_add7 (&data->filter, &data->filter_length1, &data->_filter_size_, g_strdup (data->container_prop));
#line 1451 "rygel-external-container.c"
			}
		}
	}
	data->_state_ = 10;
	rygel_external_media_container_proxy_list_containers (data->self->actual_container, (guint) 0, (guint) 0, data->filter, data->filter_length1, rygel_external_container_refresh_child_containers_ready, data);
	return FALSE;
	_state_10:
	data->children_props = (data->_tmp3_ = rygel_external_media_container_proxy_list_containers_finish (data->self->actual_container, data->_res_, &data->_tmp2_, &data->_inner_error_), data->children_props_length1 = data->_tmp2_, data->_children_props_size_ = data->children_props_length1, data->_tmp3_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 249 "rygel-external-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) data->self->priv->containers);
#line 1476 "rygel-external-container.c"
	{
		data->props_collection = data->children_props;
		data->props_collection_length1 = data->children_props_length1;
		for (data->props_it = 0; data->props_it < data->children_props_length1; data->props_it = data->props_it + 1) {
			data->props = _g_hash_table_ref0 (data->props_collection[data->props_it]);
			{
				data->path = g_strdup (_variant_get6 ((GVariant*) g_hash_table_lookup (data->props, "Path")));
				data->title = g_strdup (_variant_get7 ((GVariant*) g_hash_table_lookup (data->props, "DisplayName")));
				data->child_count = _variant_get8 ((GVariant*) g_hash_table_lookup (data->props, "ChildCount"));
				data->searchable = _variant_get9 ((GVariant*) g_hash_table_lookup (data->props, "Searchable"));
				data->container = rygel_external_container_new (data->path, data->title, data->child_count, data->searchable, data->self->service_name, data->path, data->self->host_ip, data->self, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_free0 (data->title);
					_g_free0 (data->path);
					_g_hash_table_unref0 (data->props);
					data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
#line 265 "rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->containers, data->container);
#line 1508 "rygel-external-container.c"
				_g_object_unref0 (data->container);
				_g_free0 (data->title);
				_g_free0 (data->path);
				_g_hash_table_unref0 (data->props);
			}
		}
	}
	data->children_props = (_vala_array_free (data->children_props, data->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	data->filter = (_vala_array_free (data->filter, data->filter_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_container_update_container_data_free (gpointer _data) {
	RygelExternalContainerUpdateContainerData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelExternalContainerUpdateContainerData, data);
}


static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = g_slice_new0 (RygelExternalContainerUpdateContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_update_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_update_container_data_free);
	_data_->self = g_object_ref (self);
	_data_->connect_signal = connect_signal;
	rygel_external_container_update_container_co (_data_);
}


static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_update_container_co (data);
}


#line 287 "rygel-external-container.vala"
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self) {
#line 1565 "rygel-external-container.c"
	rygel_external_container_on_updated (self, _sender);
}


static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 11:
		goto _state_11;
	}
	_state_0:
	{
		data->_state_ = 11;
		rygel_external_container_refresh_child_containers (data->self, rygel_external_container_update_container_ready, data);
		return FALSE;
		_state_11:
#line 272 "rygel-external-container.vala"
		rygel_external_container_refresh_child_containers_finish (data->self, data->_res_, &data->_inner_error_);
#line 1587 "rygel-external-container.c"
		if (data->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 274 "rygel-external-container.vala"
			g_warning ("rygel-external-container.vala:274: Failed to update information about " \
"container '%s': %s", g_dbus_proxy_get_object_path ((GDBusProxy*) data->self->actual_container), data->err->message);
#line 1600 "rygel-external-container.c"
			_g_error_free0 (data->err);
		}
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
#line 280 "rygel-external-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) data->self);
#line 282 "rygel-external-container.vala"
	if (data->connect_signal) {
#line 283 "rygel-external-container.vala"
		g_signal_connect_object (data->self->actual_container, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated, data->self, 0);
#line 1616 "rygel-external-container.c"
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 287 "rygel-external-container.vala"
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container) {
#line 287 "rygel-external-container.vala"
	g_return_if_fail (self != NULL);
#line 287 "rygel-external-container.vala"
	g_return_if_fail (actual_container != NULL);
#line 288 "rygel-external-container.vala"
	rygel_external_container_update_container (self, FALSE, NULL, NULL);
#line 1638 "rygel-external-container.c"
}


#line 291 "rygel-external-container.vala"
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const char* id) {
#line 1644 "rygel-external-container.c"
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* target;
#line 291 "rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 291 "rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 292 "rygel-external-container.vala"
	target = NULL;
#line 1653 "rygel-external-container.c"
	{
		GeeIterator* _container_it;
#line 294 "rygel-external-container.vala"
		_container_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->containers);
#line 294 "rygel-external-container.vala"
		while (TRUE) {
#line 1660 "rygel-external-container.c"
			RygelExternalContainer* container;
#line 294 "rygel-external-container.vala"
			if (!gee_iterator_next (_container_it)) {
#line 294 "rygel-external-container.vala"
				break;
#line 1666 "rygel-external-container.c"
			}
#line 294 "rygel-external-container.vala"
			container = (RygelExternalContainer*) gee_iterator_get (_container_it);
#line 295 "rygel-external-container.vala"
			if (_vala_strcmp0 (((RygelMediaObject*) container)->id, id) == 0) {
#line 1672 "rygel-external-container.c"
				RygelMediaContainer* _tmp0_;
#line 296 "rygel-external-container.vala"
				target = (_tmp0_ = _g_object_ref0 ((RygelMediaContainer*) container), _g_object_unref0 (target), _tmp0_);
#line 1676 "rygel-external-container.c"
				_g_object_unref0 (container);
#line 298 "rygel-external-container.vala"
				break;
#line 1680 "rygel-external-container.c"
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	result = target;
#line 302 "rygel-external-container.vala"
	return result;
#line 1689 "rygel-external-container.c"
}


#line 305 "rygel-external-container.vala"
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression) {
#line 1695 "rygel-external-container.c"
	RygelSearchExpression* result = NULL;
#line 305 "rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 305 "rygel-external-container.vala"
	g_return_val_if_fail (upnp_expression != NULL, NULL);
#line 307 "rygel-external-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION (upnp_expression)) {
#line 1703 "rygel-external-container.c"
		RygelSearchExpression* _tmp0_;
		RygelRelationalExpression* expression;
		RygelRelationalExpression* ext_expression;
		char* _tmp1_;
		char* _tmp2_;
#line 308 "rygel-external-container.vala"
		expression = _rygel_search_expression_ref0 ((_tmp0_ = upnp_expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp0_) ? ((RygelRelationalExpression*) _tmp0_) : NULL));
#line 309 "rygel-external-container.vala"
		ext_expression = rygel_relational_expression_new ();
#line 310 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->op = GINT_TO_POINTER (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op));
#line 311 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->operand1 = (_tmp1_ = rygel_external_container_translate_property (self, (const char*) ((RygelSearchExpression*) expression)->operand1), _g_free0 (((RygelSearchExpression*) ext_expression)->operand1), _tmp1_);
#line 313 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->operand2 = (_tmp2_ = g_strdup ((const char*) ((RygelSearchExpression*) expression)->operand2), _g_free0 (((RygelSearchExpression*) ext_expression)->operand2), _tmp2_);
#line 1719 "rygel-external-container.c"
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
#line 315 "rygel-external-container.vala"
		return result;
#line 1724 "rygel-external-container.c"
	} else {
		RygelSearchExpression* _tmp3_;
		RygelLogicalExpression* expression;
		RygelLogicalExpression* ext_expression;
		RygelSearchExpression* _tmp4_;
		RygelSearchExpression* _tmp5_;
#line 317 "rygel-external-container.vala"
		expression = _rygel_search_expression_ref0 ((_tmp3_ = upnp_expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp3_) ? ((RygelLogicalExpression*) _tmp3_) : NULL));
#line 318 "rygel-external-container.vala"
		ext_expression = rygel_logical_expression_new ();
#line 320 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->op = GINT_TO_POINTER (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op));
#line 321 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->operand1 = (_tmp4_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1), _rygel_search_expression_unref0 (((RygelSearchExpression*) ext_expression)->operand1), _tmp4_);
#line 323 "rygel-external-container.vala"
		((RygelSearchExpression*) ext_expression)->operand2 = (_tmp5_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2), _rygel_search_expression_unref0 (((RygelSearchExpression*) ext_expression)->operand2), _tmp5_);
#line 1741 "rygel-external-container.c"
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
#line 326 "rygel-external-container.vala"
		return result;
#line 1746 "rygel-external-container.c"
	}
}


#line 330 "rygel-external-container.vala"
char* rygel_external_container_translate_property (RygelExternalContainer* self, const char* property) {
#line 1753 "rygel-external-container.c"
	char* result = NULL;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
#line 330 "rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 330 "rygel-external-container.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 1768 "rygel-external-container.c"
	_tmp0_ = property;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			result = g_strdup ("Path");
#line 333 "rygel-external-container.vala"
			return result;
#line 1778 "rygel-external-container.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			result = g_strdup ("Parent");
#line 335 "rygel-external-container.vala"
			return result;
#line 1787 "rygel-external-container.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			result = g_strdup ("DisplayName");
#line 337 "rygel-external-container.vala"
			return result;
#line 1796 "rygel-external-container.c"
		}
	} else if (((_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("dc:creator")))) || (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("upnp:artist"))))) || (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("upnp:author")))))
	switch (0) {
		default:
		{
			result = g_strdup ("Artist");
#line 341 "rygel-external-container.vala"
			return result;
#line 1805 "rygel-external-container.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			result = g_strdup ("Album");
#line 343 "rygel-external-container.vala"
			return result;
#line 1814 "rygel-external-container.c"
		}
	} else
	switch (0) {
		default:
		{
			result = g_strdup (property);
#line 345 "rygel-external-container.vala"
			return result;
#line 1823 "rygel-external-container.c"
		}
	}
}


static void rygel_external_container_class_init (RygelExternalContainerClass * klass) {
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelExternalContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_external_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_external_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_external_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_external_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_external_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_external_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
}


static void rygel_external_container_instance_init (RygelExternalContainer * self) {
	self->priv = RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE (self);
}


static void rygel_external_container_finalize (GObject* obj) {
	RygelExternalContainer * self;
	self = RYGEL_EXTERNAL_CONTAINER (obj);
	_g_object_unref0 (self->actual_container);
	_g_free0 (self->host_ip);
	_g_free0 (self->service_name);
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
	_g_object_unref0 (self->priv->containers);
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
}


/**
 * Represents an external container.
 */
GType rygel_external_container_get_type (void) {
	static volatile gsize rygel_external_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		GType rygel_external_container_type_id;
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_external_container_type_id__volatile, rygel_external_container_type_id);
	}
	return rygel_external_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




