<?xml version="1.0" encoding="UTF-8"?>
<xslt:stylesheet xmlns:xslt="http://www.w3.org/1999/XSL/Transform" xmlns:msg="http://www.gnome.org/~shaunm/gnome-doc-utils/xsl-format" version="1.0">
  <title xmlns="http://www.gnome.org/~shaunm/xsldoc">Format Templates</title>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.citetitle</name>
    <purpose>
    Format a <xmltag>citetitle</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>citetitle</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <description>
      <para>This template used for formatting the <sgmltag>citetitle</sgmltag>
    element in DocBook.  The <sgmltag>citetitle</sgmltag> element has a
    <sgmltag>pubwork</sgmltag> attribute that can be set
    to one of the following values:
    <literal>article</literal>,      <literal>bbs</literal>,
    <literal>book</literal>,         <literal>cdrom</literal>,
    <literal>chapter</literal>,      <literal>dvd</literal>,
    <literal>emailmessage</literal>, <literal>gopher</literal>,
    <literal>journal</literal>,      <literal>manuscript</literal>,
    <literal>newsposting</literal>,  <literal>part</literal>,
    <literal>refentry</literal>,     <literal>section</literal>,
    <literal>series</literal>,       <literal>set</literal>,
    <literal>webpage</literal>,      <literal>wiki</literal>.
    This template allows multiple role format strings, using the value of
    <sgmltag>pubwork</sgmltag> as the role.  Translators
    can use this to customize the appearance of a cited title based on the
    type of document being cited.  The default formatting is as follows:</para>
      <programlisting>
&lt;msg:msgstr role="article"&gt;“%t{node}”&lt;/msg:msgstr&gt;
&lt;msg:msgstr&gt;&lt;i&gt;%t{node}&lt;/i&gt;&lt;/msg:msgstr&gt;</programlisting>
      <para>This puts the title of an article citation in quotes.  For all other
    types of works, the title is simply italicized.</para>
    </description>
  </template>
  <xslt:template name="format.citetitle">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.títulodecitação</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>“</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.citeringstitel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.títulocita</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citattitel</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.date</name>
    <purpose>
    Format a date
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <node>year</node>
      <purpose>
      The year in the Gregorian calendar
    </purpose>
    </parameter>
    <parameter>
      <name>month</name>
      <purpose>
      The number of the month
    </purpose>
    </parameter>
    <parameter>
      <name>day</name>
      <purpose>
      The number of the day in the month
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.date">
    <xslt:param name="year"/>
    <xslt:param name="month"/>
    <xslt:param name="day"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.data</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:value-of select="$day"/>
        <xslt:text> </xslt:text>
        <xslt:choose>
          <xslt:when test="$month =  1">
            <xslt:text>януари </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  2">
            <xslt:text>февруари </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  3">
            <xslt:text>март </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  4">
            <xslt:text>април </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  5">
            <xslt:text>май </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  6">
            <xslt:text>юни </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  7">
            <xslt:text>юли </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  8">
            <xslt:text>август </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  9">
            <xslt:text>септември </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 10">
            <xslt:text>октомври </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 11">
            <xslt:text>ноември </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 12">
            <xslt:text>декември </xslt:text>
          </xslt:when>
        </xslt:choose>
        <xslt:value-of select="$year"/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.dato</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.fecha</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:value-of select="$day"/>
        <xslt:text>. </xslt:text>
        <xslt:choose>
          <xslt:when test="$month =  1">
            <xslt:text>tammikuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  2">
            <xslt:text>helmikuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  3">
            <xslt:text>maaliskuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  4">
            <xslt:text>huhtikuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  5">
            <xslt:text>toukokuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  6">
            <xslt:text>kesäkuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  7">
            <xslt:text>heinäkuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  8">
            <xslt:text>elokuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  9">
            <xslt:text>syyskuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 10">
            <xslt:text>lokakuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 11">
            <xslt:text>marraskuuta </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 12">
            <xslt:text>joulukuuta </xslt:text>
          </xslt:when>
        </xslt:choose>
        <xslt:value-of select="$year"/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:value-of select="$day"/>
        <xslt:text>. </xslt:text>
        <xslt:choose>
          <xslt:when test="$month =  1">
            <xslt:text>sausis </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  2">
            <xslt:text>vasaris </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  3">
            <xslt:text>kovas </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  4">
            <xslt:text>balandis </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  5">
            <xslt:text>gegužė </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  6">
            <xslt:text>birželis </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  7">
            <xslt:text>liepa </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  8">
            <xslt:text>rugpjūtis </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  9">
            <xslt:text>rugsėjis </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 10">
            <xslt:text>spalis </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 11">
            <xslt:text>lapkritis </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 12">
            <xslt:text>gruodis </xslt:text>
          </xslt:when>
        </xslt:choose>
        <xslt:value-of select="$year"/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.datum</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$month =  1">
            <xslt:text>January </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  2">
            <xslt:text>February </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  3">
            <xslt:text>March </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  4">
            <xslt:text>April </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  5">
            <xslt:text>May </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  6">
            <xslt:text>June </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  7">
            <xslt:text>July </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  8">
            <xslt:text>August </xslt:text>
          </xslt:when>
          <xslt:when test="$month =  9">
            <xslt:text>September </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 10">
            <xslt:text>October </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 11">
            <xslt:text>November </xslt:text>
          </xslt:when>
          <xslt:when test="$month = 12">
            <xslt:text>December </xslt:text>
          </xslt:when>
        </xslt:choose>
        <xslt:value-of select="$day"/>
        <xslt:text>, </xslt:text>
        <xslt:value-of select="$year"/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.outer</name>
    <purpose>
    Format a <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.quote.outer">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.aspas.externas</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.citat.ydre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.comilla.exterior</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>"</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>"</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.yttre</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.inner</name>
    <purpose>
    Format a nested <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.quote.inner">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.aspas.internas</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.citat.indre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.comilla.interior</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.inre</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.appendix.label</name>
    <purpose>
    Format the label for a <xmltag>appendix</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>appendix</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.appendix.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.apêndice.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.appendix label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Приложение </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Příloha </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.appendiks.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.apéndice.título</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Liite </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Priedas </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Apêndice </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Príloha </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.appendix.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.chapter.label</name>
    <purpose>
    Format the label for a <xmltag>chapter</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>chapter</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.chapter.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.capítulo.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.chapter label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Глава </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Kapitola </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.kapitel.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.capítulo.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Kappale </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Skyrius </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Capítulo </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Kapitola </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.kapitel.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.label</name>
    <purpose>
    Format the label for a <xmltag>example</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>example</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.example.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.exemplo.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.example label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Пример </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Příklad </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.eksempel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.ejemplo.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Esimerkki </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Pavyzdys </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Exemplo </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Príklad </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.exempel.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Example </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Example </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.label</name>
    <purpose>
    Format the label for a <xmltag>figure</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>figure</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.figure.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.figura.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.figure label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Фигура </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Obrázek </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.cifre.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.figura.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Kuva </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Paveikslėlis </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Imagem </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Obrázok </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.figur.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Figure </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figure </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.manvolnum</name>
    <purpose>
    Format a <xmltag>manvolnum</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>manvolnum</xmltag> element to format
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.manvolnum">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.númvolman</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.númvolman</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>(</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>)</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.part.label</name>
    <purpose>
    Format the label for a <xmltag>part</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>part</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.part.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'en' and $lang_region = 'CA'">
        <xslt:text>format.part.label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.parte.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Část </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.del.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.parte.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Osa </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Dalis </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Časť </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.del.etikett</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'uk'">
        <xslt:text>format.part.label</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Part </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Part </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.refentry.label</name>
    <purpose>
    Format the label for a <xmltag>refentry</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>refentry</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.refentry.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'en' and $lang_region = 'CA'">
        <xslt:text>format.refentry.label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.entradadereferencia.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.title">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.refpost.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.entradaref.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.title">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.title">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.title">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.refpost.etikett</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'uk'">
        <xslt:text>format.refentry.label</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.section.label</name>
    <purpose>
    Format the label for a <xmltag>section</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>section</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.section.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.seção.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.section label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Дял </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Oddíl </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.sektion.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.sección.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Luku </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Skyrius </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Secção </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Oddiel </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.avsnitt.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Section </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Section </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.label</name>
    <purpose>
    Format the label for a <xmltag>table</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>table</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.table.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.tabela.rótulo</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:text>format.table label</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Таблица </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Tabulka </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.tabel.etiket</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.tabla.etiqueta</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Taulukko </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Lentelė </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>Tabela </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Tabuľka </xslt:text>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="$node" name="node"/>
        </xslt:call-template>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.tabell.etikett</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Table </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'titleabbrev'">
            <xslt:call-template name="db.titleabbrev">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'subtitle'">
            <xslt:call-template name="db.subtitle">
              <xslt:with-param name="node" select="$node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Table </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number</name>
    <purpose>
    Format the number for a <xmltag>example</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.example.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.exemplo.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.eksempel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.ejemplo.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.exempel.nummer</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.number.flat</name>
    <purpose>
    Format the number for a <xmltag>example</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.example.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.exemplo.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.eksempel.nummer.plan</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.ejemplo.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.exempel.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="example"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number</name>
    <purpose>
    Format the number for a <xmltag>figure</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.figure.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.figura.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.cifre.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.figura.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.figur.nummer</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.number.flat</name>
    <purpose>
    Format the number for a <xmltag>figure</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.figure.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.figura.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.cifre.nummer.plan</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.figura.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.figur.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="figure"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.part.number</name>
    <purpose>
    Format the number for a <xmltag>part</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.part.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'en' and $lang_region = 'CA'">
        <xslt:text>format.part.number</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.parte.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.del.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.tparte.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.del.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'uk'">
        <xslt:text>format.part.number</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="I" value="count($node/preceding-sibling::part) + 1"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number</name>
    <purpose>
    Format the number for a <xmltag>table</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.table.number">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.tabela.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.tabel.nummer</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.tabla.número</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>.</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.tabell.nummer</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:call-template name="db.label.number">
          <xslt:with-param select="                       $node/ancestor::appendix |                       $node/ancestor::chapter  " name="node"/>
        </xslt:call-template>
        <xslt:text>-</xslt:text>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.table.number.flat</name>
    <purpose>
    Format the number for a <xmltag>table</xmltag> element in a flat document
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The element for which to generate a number
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.table.number.flat">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.tabela.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.tabel.nummer.plan</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.tabla.número.plano</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.tabell.nummer.platt</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text/>
        <xslt:number format="1" level="any" from="chapter | appendix" count="table"/>
        <xslt:text/>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.tooltip.glossentry</name>
    <purpose>
    Format the tooltip for a link to a <xmltag>glossentry</xmltag>
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>glossentry</xmltag> element
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.tooltip.glossentry">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.dicadeferramenta.entradadeglossario</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>Виж дефиницията на „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Viz definici „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.værktøjstip.glosepost</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.consejo.entradaglosario</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Lue sanan "</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>" määritelmä.</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Skaitykit „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“ aprašymą</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Pozri definíciu „</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.verktygstips.ordlistepost</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>Read the definition for ‘</xslt:text>
        <xslt:value-of select="normalize-space($node/glossterm)"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.tooltip.mailto</name>
    <purpose>
    Format the tooltip for a link to a
    <systemitem>mailto</systemitem> URI.
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The source node
    </purpose>
    </parameter>
    <parameter>
      <name>address</name>
      <purpose>
      The email address
    </purpose>
    </parameter>
  </template>
  <xslt:template name="format.tooltip.mailto">
    <xslt:param name="node"/>
    <xslt:param name="address"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>formato.dicadeferramenta.mailto</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>Odeslat e-mail na „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'da'">
        <xslt:text>format.værktøjstip.brevtil</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>formato.consejo.correoa</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>Lähetä sähköpostia osoitteeseen "</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>"</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>Siųsti „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“ el.laišką</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>Odoslať e-mail pre „</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.verktygstips.e-postatill</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>Send email to ‘</xslt:text>
        <xslt:value-of select="normalize-space($address)"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
</xslt:stylesheet>
