/*
 *  Copyright (C) 2000-2003 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-automation.h,v 1.6 2003/11/19 19:19:57 chpe Exp $
 */

#ifndef EPHY_AUTOMATION_H
#define EPHY_AUTOMATION_H

#include "EphyAutomation.h"

#include <bonobo/bonobo-generic-factory.h>

G_BEGIN_DECLS

#define EPHY_TYPE_AUTOMATION		(ephy_automation_get_type ())
#define EPHY_AUTOMATION(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_AUTOMATION, EphyAutomation))
#define EPHY_AUTOMATION_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_AUTOMATION, EphyAutomationClass))
#define EPHY_IS_AUTOMATION(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_AUTOMATION))
#define EPHY_IS_AUTOMATION_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_AUTOMATION))
#define EPHY_AUTOMATION_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_TYPE_AUTOMATION, EphyAutomationClass))

#define AUTOMATION_FACTORY_IID "OAFIID:GNOME_Epiphany_Automation_Factory"

typedef struct
{
        BonoboObject parent;
} EphyAutomation;

typedef struct
{
        BonoboObjectClass parent_class;

	/*< private >*/
        POA_GNOME_EphyAutomation__epv epv;
} EphyAutomationClass;

GType			 ephy_automation_get_type	(void);

G_END_DECLS

#endif /* _EPHY_AUTOMATION_H_ */
