/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_XVIMAGE_H__
#define __GST_XVIMAGE_H__

#include <glib.h>
#include <X11/Xlib.h>

#ifdef HAVE_XVIDEO
# include <X11/extensions/Xv.h>
# include <X11/extensions/Xvlib.h>
#endif

#include "gstxwindow.h"

#include "gstimage.h"

G_BEGIN_DECLS

typedef struct _GstXvImage	      GstXvImage;
typedef guint64                       GstXvImageType;

#define GST_XVIMAGE(img)	((GstXvImage *)(img))

struct _GstXvImage
{
  GstImage parent;

  GstXvImageType  type;
#ifdef HAVE_XVIDEO
  XvImage *ximage;
#else
  gpointer ximage;
#endif
  gpointer x_shm_info;
  gint im_adaptor;
  gint im_port;
  gint im_format;
  gint width, height;
};

gboolean 	_gst_xvimage_check_xvideo	(Display *display);

GstCaps* 	_gst_xvimage_get_capslist	(void);

GstXvImage*  	_gst_xvimage_new    		(GstImageFormat *format,
						 GstXWindow *window,
				 		 gint width,
				 		 gint height);
void _gst_xvimage_add_formats (GstXWindow *window);

G_END_DECLS

#endif /* __GST_XVIMAGE_H__ */
