/* presconf.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __PRES_CONF__
#define __PRES_CONF__

#include <glib.h>

typedef struct
{
    gchar *device;
    gchar *role;
    gchar *event;
    gchar *chunk;
} PresentationStruct;

gboolean 	presconf_gconf_init		();
void 		presconf_gconf_terminate 	();
GSList*		presconf_get_all_entries 	();
void		presconf_preload_list 		();
PresentationStruct*
		presconf_presentation_struct_new (const gchar *device,
						const gchar *role,
						const gchar *event,
						const gchar *chunk);
gboolean	presconf_presentation_struct_free (PresentationStruct* value);
void 		presconf_save_list 		();
void		presconf_set_defaults 		();
void		presconf_append_item_to_list 	(const gchar *device,
			    			const gchar *role,
			    			const gchar *event,
			    			const gchar *chunk);
gboolean	presconf_remove_from_list	(const gchar *device,
						const gchar *role,
						const gchar *event);
gboolean	presconf_item_exist		(const gchar *device,
						const gchar *role,
						const gchar *event);
GSList*		presconf_search_item 		(const gchar *device,
		    				const gchar *role,
		    				const gchar *event);
void		presconf_free_list 		(GSList *list);
void		presconf_unset_remove_list 	();
#endif
