from ContainerTarget import ContainerTarget
from utils.datatypes import *
from utils import vfs

import gtk


_STATE_VISIBLE = 0
_STATE_HIDDEN = 1


#
# Class for target expander.
#
class TargetExpander(ContainerTarget):

    __ACTION_EXPAND = 100

    def __init__(self, parent, display):

        self.__show_state = _STATE_VISIBLE

        
        ContainerTarget.__init__(self, parent, display)
        button = gtk.Button()
        button.set_border_width(3)
        button.connect("button-release-event", self.__on_click)
        button.show()
        self.__icon = gtk.Image()
        self.__icon.show()
        button.add(self.__icon)
        align=gtk.Alignment(0.0, 0.0)
        align.show()
        align.add(button)
        self.pack_start(align, gtk.FALSE, gtk.FALSE, 0)

        self._set_property_type("expanded", TYPE_BOOL)
        self._set_property_type("icon-uri", TYPE_STRING)
        self._set_property_type("on-expand", TYPE_STRING)



    def __on_click(self, src, event):

        if (self.__show_state == _STATE_VISIBLE):
            self.__set_expanded(gtk.FALSE)
        else:
            self.__set_expanded(gtk.TRUE)



    def __set_expanded(self, value):

        if (value): self.__show_state = _STATE_VISIBLE
        else: self.__show_state = _STATE_HIDDEN

        if (self.__show_state == _STATE_VISIBLE): self._get_child().show()
        else: self._get_child().hide()

        call = self.get_action_call(self.__ACTION_EXPAND)
        path = []  # TODO: find real path
        self._get_display()._call_sensor(call, path, value)
        print call, path, value


    def __set_icon(self, uri):

        uri = vfs.join(self.get_path(), uri)
        try:
            loader = gtk.gdk.PixbufLoader()
            fd = vfs.open(uri, "r")
            data = vfs.read_all(fd)
            fd.close()
            loader.write(data, len(data))
            loader.close()
            pbuf = loader.get_pixbuf()
            self.__icon.set_from_pixbuf(pbuf)
        except:
            pass

        

    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.add(self._get_child())
        self._init_children()



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "expanded"):
            self.__set_expanded(value)
            
        elif (key == "icon-uri"):
            self.__set_icon(value)

        elif (key == "on-expand"):
            self.set_action_call(self.__ACTION_EXPAND, value)
            
        else:
            ContainerTarget.set_config(self, key, value)



    def get_target_at(self, px, py, path):

        x, y, w, h = self.get_geometry()
        cx, cy, cw, ch = self._get_child().get_geometry()
        cx, cy, nil, nil = self._get_child().get_allocation()
        offx = cx
        offy = cy

        ctargets = self._get_child().get_target_at(px - x - offx,
                                                   py - y - offy,
                                                   path)
        ret = [(self, path)] + ctargets

        return ret
