from Sensor import Sensor
from utils.datatypes import *

import os


#
# The DefaultSensor is always present in a Display and handles things like
# the initial positioning of the Display window.
#
class DefaultSensor(Sensor):

    def __init__(self):

        # flag for indicating whether the display has been positioned yet
        self.__is_positioned = 0


        Sensor.__init__(self)

        self._set_config_type("x", TYPE_INT, -1)
        self._set_config_type("y", TYPE_INT, -1)
        self._set_config_type("real-x", TYPE_INT, -1)
        self._set_config_type("real-y", TYPE_INT, -1)
        self._set_config_type("width", TYPE_INT, 0)
        self._set_config_type("height", TYPE_INT, 0)

        self._add_timer(0, self.__init_display)
        self._add_timer(500, self.__ensure_position)



    #
    # Initializes the Display.
    #
    def __init_display(self):

        x = self._get_config("x")
        y = self._get_config("y")

        # only set position if it was set in the config
        if (x != -1 and y != -1):
            self.__is_positioned = 1
            settings = self._new_output()
            settings.set("x", x)
            settings.set("y", y)
            self._send_output(settings)


    #
    # Ensures that the display has been positioned.
    #
    def __ensure_position(self):

        # set default position if the display is still unpositioned
        if (not self.__is_positioned):
            settings = self._new_output()
            settings.set("x", 100)
            settings.set("y", 100)
            self._send_output(settings)

        self._watch_config(self.__on_watch_config)


    #
    # Reacts on window movements in the config.
    #
    def __on_watch_config(self, key, value):

        if (key in ["x", "y"]):
            settings = self._new_output()
            settings.set(key, value)
            self._send_output(settings)

        


    def call_action(self, call, path, args):

        # show display menu
        if (call == "menu"):
            menu = []
            self._open_menu(menu)

        # get notification about window positioning
        elif (call == "positioned"):
            self.__is_positioned = 1

        # save new coordinates after moving
        elif (call == "move"):
            x, y, real_x, real_y = args
            self._set_config("x", x)
            self._set_config("y", y)
            self._set_config("real-x", real_x)
            self._set_config("real-y", real_y)

        elif (call == "size"):
            w, h = args
            self._set_config("width", w)
            self._set_config("height", h)

        # open URLs
        elif (call == "open"):
            uri = args[-1]
            try:
                import gnome
                gnome.url_show(uri)
            except:
                print "could not open", uri

        # execute commands
        elif (call == "exec"):
            commands = args[-1]
            os.system(commands + " &")
