import polling
import glibtop

import commands, os


class Sys:

    def __init__(self):

        self.get_arch = polling.wrap(self.__poll_arch, 0)
        self.get_os = polling.wrap(self.__poll_os, 0)

        self.get_users = polling.wrap(self.__poll_users, 30)

        self.get_uptime = polling.wrap(self.__poll_uptime, 1, 0)
        self.get_idletime = polling.wrap(self.__poll_uptime, 1, 1)

        self.get_load_avg_1m = polling.wrap(self.__poll_load_avg, 30, 0)
        self.get_load_avg_5m = polling.wrap(self.__poll_load_avg, 30, 1)
        self.get_load_avg_15m = polling.wrap(self.__poll_load_avg, 30, 2)

        self.get_tasks = polling.wrap(self.__poll_tasks, 0.5)



    def __poll_arch(self):

        return (os.uname()[4])


    def __poll_os(self):

        return (os.uname()[0])


    def __poll_users(self):

        uptime = commands.getoutput("uptime")
        return int(uptime.split()[-7])



    def __poll_uptime(self, mode):

        uptime, idletime = glibtop.get_uptime()

        # uptime
        if (mode == 0):
            return int(float(uptime))
        # idle time
        elif (mode == 1):
            return int(float(idletime))


    def __poll_load_avg(self, mode):

        avg1, avg5, avg15 = glibtop.get_loadavg()[0]
        if (mode == 0): return int(avg1 * 100) / 100.0
        elif (mode == 1): return int(avg5 * 100) / 100.0
        elif (mode == 2): return int(avg15 * 100) / 100.0


    def __poll_tasks(self):

        running, tasks = glibtop.get_loadavg()[1:3]

        return (tasks, running)
