import glibtop
import polling


class Disk:

    def __init__(self):

        self.get_partitions = polling.wrap(self.__poll_partitions, 3)
        self.get_size = self.__poll_size



    def __poll_partitions(self):

        data = glibtop.get_mountlist(0)
        partitions = []
        for size, device, mpoint, fstype in data:
            if (fstype in ("ext2", "ext3", "msdos", "vfat", "ntfs", "hpfs"
                           "jfs", "reiserfs", "xfs", "qnx4", "adfs", "ffs",
                           "hfs", "befs", "bfs", "efs", "iso9660", "minix",
                           "sysv", "coda", "nfs", "udf", "ufs", "xiafs")):
                partitions.append((device, mpoint))
        #end for

        return partitions
            


    def __poll_size(self, partition):

        blocks, bfree, bavail, files, ffree = glibtop.get_fsusage(partition)
        free = float(bfree * 512)
        total = float(blocks * 512)
        used = total - free

        return (total, used)
