from main import _

import gtk


#
# Class for the display configurator. It displays the configurators of the
# sensors of a display.
#
class DisplayConfigurator(gtk.Dialog):

    def __init__(self, sensorconfigurators):

        gtk.Dialog.__init__(self)
        self.set_title(_("Configuration"))
        self.connect("delete-event", self.__on_close)
        self.set_has_separator(0)
        self.set_border_width(5)
        self.vbox.set_spacing(2)

        # close button
        btn = self.add_button(gtk.STOCK_CLOSE, 0)
        btn.connect("clicked", self.__on_close)

        #close functions
        self.callbacks = []
        pages = []
        for c in sensorconfigurators:
            if (c):
                lbl = gtk.Label(c.get_name())
                lbl.show()
                pages.append((c, lbl))
                for cb in c.callbacks:
                    self.callbacks.append( cb )

        #end for

        # use a special page when there are no config options
        if (not pages):
            lbl = gtk.Label(_("This display is not configurable."))
            lbl.show()
            pages.append((lbl, None))

        # only use the notebook when there are more than one pages
        if (len(pages) == 1):
            self.vbox.add(pages[0][0])
        else:
            notebook = gtk.Notebook()
            notebook.show()
            notebook.set_border_width(5)
            self.vbox.pack_start(notebook, gtk.TRUE, gtk.TRUE, 0)
            for page, tab in pages:
                notebook.append_page(page, tab)
        #end if

        self.show()



    #
    # Reacts on closing the window.
    #
    def __on_close(self, *args):

        # process any callbacks before destroying yourself
        for f,a in self.callbacks:
            if a:
                apply( f, a )
            else:
                f()

        self.destroy()
        return gtk.TRUE
