/* rygel-media-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	char* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
	char* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const char* value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value);
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const char* uri);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
const char* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
static void rygel_media_item_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


#line 46 "rygel-media-item.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 246 "rygel-media-item.c"
	RygelMediaItem * self;
	char* _tmp0_;
	char* _tmp1_;
#line 46 "rygel-media-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 46 "rygel-media-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 46 "rygel-media-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 46 "rygel-media-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 46 "rygel-media-item.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 50 "rygel-media-item.vala"
	((RygelMediaObject*) self)->id = (_tmp0_ = g_strdup (id), _g_free0 (((RygelMediaObject*) self)->id), _tmp0_);
#line 51 "rygel-media-item.vala"
	((RygelMediaObject*) self)->parent = parent;
#line 52 "rygel-media-item.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
#line 53 "rygel-media-item.vala"
	((RygelMediaObject*) self)->upnp_class = (_tmp1_ = g_strdup (upnp_class), _g_free0 (((RygelMediaObject*) self)->upnp_class), _tmp1_);
#line 268 "rygel-media-item.c"
	return self;
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


#line 58 "rygel-media-item.vala"
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self) {
#line 285 "rygel-media-item.c"
	GstElement* result = NULL;
	GstElement* src;
#line 58 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "rygel-media-item.vala"
	src = NULL;
#line 61 "rygel-media-item.vala"
	if (gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) self)->uris) != 0) {
#line 294 "rygel-media-item.c"
		char* _tmp0_;
		GstElement* _tmp1_;
#line 62 "rygel-media-item.vala"
		src = (_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) self)->uris, 0), NULL), _gst_object_unref0 (src), _tmp1_);
#line 299 "rygel-media-item.c"
		_g_free0 (_tmp0_);
	}
#line 65 "rygel-media-item.vala"
	if (src != NULL) {
#line 66 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "blocksize") != NULL) {
#line 69 "rygel-media-item.vala"
			_dynamic_set_blocksize1 (src, (glong) 65536);
#line 308 "rygel-media-item.c"
		}
#line 72 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "tcp-timeout") != NULL) {
#line 75 "rygel-media-item.vala"
			_dynamic_set_tcp_timeout2 (src, (gint64) 60000000);
#line 314 "rygel-media-item.c"
		}
	}
	result = src;
#line 79 "rygel-media-item.vala"
	return result;
#line 320 "rygel-media-item.c"
}


#line 46 "rygel-media-item.vala"
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
#line 46 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self);
#line 328 "rygel-media-item.c"
}


#line 85 "rygel-media-item.vala"
gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
#line 334 "rygel-media-item.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 85 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "rygel-media-item.vala"
	if (rygel_media_item_streamable (self)) {
#line 87 "rygel-media-item.vala"
		_tmp0_ = self->size <= 0;
#line 343 "rygel-media-item.c"
	} else {
#line 87 "rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 347 "rygel-media-item.c"
	}
	result = _tmp0_;
#line 87 "rygel-media-item.vala"
	return result;
#line 352 "rygel-media-item.c"
}


#line 90 "rygel-media-item.vala"
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
#line 358 "rygel-media-item.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 46 "rygel-media-item.vala"
gboolean rygel_media_item_streamable (RygelMediaItem* self) {
#line 46 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
#line 369 "rygel-media-item.c"
}


#line 92 "rygel-media-item.vala"
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const char* uri) {
#line 92 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 92 "rygel-media-item.vala"
	g_return_if_fail (uri != NULL);
#line 93 "rygel-media-item.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
#line 381 "rygel-media-item.c"
}


#line 46 "rygel-media-item.vala"
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri) {
#line 46 "rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
#line 389 "rygel-media-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 96 "rygel-media-item.vala"
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b) {
#line 400 "rygel-media-item.c"
	gint result = 0;
	RygelTranscoder* transcoder1;
	RygelTranscoder* transcoder2;
#line 96 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 97 "rygel-media-item.vala"
	transcoder1 = _g_object_ref0 (RYGEL_TRANSCODER (a));
#line 98 "rygel-media-item.vala"
	transcoder2 = _g_object_ref0 (RYGEL_TRANSCODER (b));
#line 410 "rygel-media-item.c"
	result = ((gint) rygel_transcoder_get_distance (transcoder1, self)) - ((gint) rygel_transcoder_get_distance (transcoder2, self));
	_g_object_unref0 (transcoder2);
	_g_object_unref0 (transcoder1);
#line 100 "rygel-media-item.vala"
	return result;
#line 416 "rygel-media-item.c"
}


#line 104 "rygel-media-item.vala"
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 422 "rygel-media-item.c"
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res;
	GUPnPProtocolInfo* _tmp0_;
#line 104 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "rygel-media-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 104 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 110 "rygel-media-item.vala"
	res = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) didl_item);
#line 112 "rygel-media-item.vala"
	if (uri != NULL) {
#line 113 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, uri);
#line 438 "rygel-media-item.c"
	}
#line 116 "rygel-media-item.vala"
	if (import_uri != NULL) {
#line 117 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_import_uri (res, import_uri);
#line 444 "rygel-media-item.c"
	}
#line 120 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_size64 (res, self->size);
#line 123 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp0_ = rygel_media_item_get_protocol_info (self, uri, protocol));
#line 450 "rygel-media-item.c"
	_g_object_unref0 (_tmp0_);
	result = res;
#line 125 "rygel-media-item.vala"
	return result;
#line 455 "rygel-media-item.c"
}


#line 46 "rygel-media-item.vala"
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 46 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resource (self, didl_item, uri, protocol, import_uri, error);
#line 463 "rygel-media-item.c"
}


#line 128 "rygel-media-item.vala"
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property) {
#line 469 "rygel-media-item.c"
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaItem* item;
	const char* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	self = (RygelMediaItem*) base;
#line 128 "rygel-media-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 128 "rygel-media-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 130 "rygel-media-item.vala"
	if (!RYGEL_IS_MEDIA_ITEM (media_object)) {
#line 484 "rygel-media-item.c"
		result = 1;
#line 131 "rygel-media-item.vala"
		return result;
#line 488 "rygel-media-item.c"
	}
#line 134 "rygel-media-item.vala"
	item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
#line 492 "rygel-media-item.c"
	_tmp1_ = property;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			result = rygel_media_item_compare_by_date (self, item);
			_g_object_unref0 (item);
#line 138 "rygel-media-item.vala"
			return result;
#line 503 "rygel-media-item.c"
		}
	} else
	switch (0) {
		default:
		{
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (RYGEL_MEDIA_OBJECT (self), (RygelMediaObject*) item, property);
			_g_object_unref0 (item);
#line 140 "rygel-media-item.vala"
			return result;
#line 513 "rygel-media-item.c"
		}
	}
	_g_object_unref0 (item);
}


#line 144 "rygel-media-item.vala"
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 522 "rygel-media-item.c"
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* didl_item;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
#line 144 "rygel-media-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 144 "rygel-media-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 147 "rygel-media-item.vala"
	didl_item = gupnp_didl_lite_writer_add_item (writer);
#line 149 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->id);
#line 150 "rygel-media-item.vala"
	if (((RygelMediaObject*) self)->parent != NULL) {
#line 151 "rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) ((RygelMediaObject*) self)->parent)->id);
#line 540 "rygel-media-item.c"
	} else {
#line 153 "rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, "0");
#line 544 "rygel-media-item.c"
	}
#line 156 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_item, FALSE);
#line 157 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) didl_item, rygel_media_object_get_title ((RygelMediaObject*) self));
#line 158 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->upnp_class);
#line 165 "rygel-media-item.vala"
	if (self->place_holder) {
#line 166 "rygel-media-item.vala"
		rygel_media_item_add_proxy_resources (self, http_server, didl_item, &_inner_error_);
#line 556 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
	} else {
		gboolean internal_allowed = FALSE;
		gboolean _tmp0_ = FALSE;
#line 169 "rygel-media-item.vala"
		rygel_media_item_add_proxy_resources (self, http_server, didl_item, &_inner_error_);
#line 567 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
#line 173 "rygel-media-item.vala"
		if (_vala_strcmp0 (gssdp_client_get_interface ((GSSDPClient*) http_server->context), "lo") == 0) {
#line 173 "rygel-media-item.vala"
			_tmp0_ = TRUE;
#line 577 "rygel-media-item.c"
		} else {
#line 174 "rygel-media-item.vala"
			_tmp0_ = _vala_strcmp0 (gssdp_client_get_host_ip ((GSSDPClient*) http_server->context), "127.0.0.1") == 0;
#line 581 "rygel-media-item.c"
		}
#line 173 "rygel-media-item.vala"
		internal_allowed = _tmp0_;
#line 175 "rygel-media-item.vala"
		rygel_media_item_add_resources (self, didl_item, internal_allowed, &_inner_error_);
#line 587 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 178 "rygel-media-item.vala"
	return result;
#line 597 "rygel-media-item.c"
}


#line 181 "rygel-media-item.vala"
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 603 "rygel-media-item.c"
	GError * _inner_error_ = NULL;
#line 181 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 181 "rygel-media-item.vala"
	g_return_if_fail (server != NULL);
#line 181 "rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 185 "rygel-media-item.vala"
	rygel_http_server_add_proxy_resource (server, didl_item, self, &_inner_error_);
#line 613 "rygel-media-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 188 "rygel-media-item.vala"
	rygel_transcode_manager_add_resources ((RygelTranscodeManager*) server, didl_item, self, &_inner_error_);
#line 620 "rygel-media-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
}


#line 191 "rygel-media-item.vala"
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol) {
#line 635 "rygel-media-item.c"
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info;
#line 191 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 193 "rygel-media-item.vala"
	protocol_info = gupnp_protocol_info_new ();
#line 195 "rygel-media-item.vala"
	gupnp_protocol_info_set_mime_type (protocol_info, self->mime_type);
#line 196 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_profile (protocol_info, self->dlna_profile);
#line 197 "rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (protocol_info, protocol);
#line 198 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (protocol_info, GUPNP_DLNA_FLAGS_DLNA_V15);
#line 200 "rygel-media-item.vala"
	if (rygel_media_item_streamable (self)) {
#line 201 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 656 "rygel-media-item.c"
	}
#line 204 "rygel-media-item.vala"
	if (!rygel_media_item_should_stream (self)) {
#line 205 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_RANGE);
#line 206 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | (GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE | GUPNP_DLNA_FLAGS_CONNECTION_STALL));
#line 664 "rygel-media-item.c"
	}
	result = protocol_info;
#line 210 "rygel-media-item.vala"
	return result;
#line 669 "rygel-media-item.c"
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
}


#line 213 "rygel-media-item.vala"
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error) {
#line 680 "rygel-media-item.c"
	char* result = NULL;
	char* scheme;
	GError * _inner_error_ = NULL;
#line 213 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 213 "rygel-media-item.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 214 "rygel-media-item.vala"
	scheme = g_uri_parse_scheme (uri);
#line 215 "rygel-media-item.vala"
	if (scheme == NULL) {
#line 692 "rygel-media-item.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _ ("Bad URI: %s"), uri);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (scheme);
			return NULL;
		}
	}
#line 219 "rygel-media-item.vala"
	if (_vala_strcmp0 (scheme, "http") == 0) {
#line 702 "rygel-media-item.c"
		result = g_strdup ("http-get");
		_g_free0 (scheme);
#line 220 "rygel-media-item.vala"
		return result;
#line 707 "rygel-media-item.c"
	} else {
#line 221 "rygel-media-item.vala"
		if (_vala_strcmp0 (scheme, "file") == 0) {
#line 711 "rygel-media-item.c"
			result = g_strdup ("internal");
			_g_free0 (scheme);
#line 222 "rygel-media-item.vala"
			return result;
#line 716 "rygel-media-item.c"
		} else {
#line 223 "rygel-media-item.vala"
			if (_vala_strcmp0 (scheme, "rtsp") == 0) {
#line 720 "rygel-media-item.c"
				result = g_strdup ("rtsp-rtp-udp");
				_g_free0 (scheme);
#line 225 "rygel-media-item.vala"
				return result;
#line 725 "rygel-media-item.c"
			} else {
#line 228 "rygel-media-item.vala"
				g_warning (_ ("Failed to probe protocol for URI %s. Assuming '%s'"), uri, scheme);
#line 729 "rygel-media-item.c"
				result = scheme;
#line 232 "rygel-media-item.vala"
				return result;
#line 733 "rygel-media-item.c"
			}
		}
	}
	_g_free0 (scheme);
}


#line 236 "rygel-media-item.vala"
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 743 "rygel-media-item.c"
	GError * _inner_error_ = NULL;
#line 236 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 236 "rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 749 "rygel-media-item.c"
	{
		GeeIterator* _uri_it;
#line 239 "rygel-media-item.vala"
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris);
#line 239 "rygel-media-item.vala"
		while (TRUE) {
#line 756 "rygel-media-item.c"
			char* uri;
			char* protocol;
			gboolean _tmp0_ = FALSE;
#line 239 "rygel-media-item.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 239 "rygel-media-item.vala"
				break;
#line 764 "rygel-media-item.c"
			}
#line 239 "rygel-media-item.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 240 "rygel-media-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri (self, uri, &_inner_error_);
#line 770 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_it);
				return;
			}
#line 242 "rygel-media-item.vala"
			if (allow_internal) {
#line 242 "rygel-media-item.vala"
				_tmp0_ = TRUE;
#line 781 "rygel-media-item.c"
			} else {
#line 242 "rygel-media-item.vala"
				_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 785 "rygel-media-item.c"
			}
#line 242 "rygel-media-item.vala"
			if (_tmp0_) {
#line 789 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp1_;
#line 243 "rygel-media-item.vala"
				_tmp1_ = rygel_media_item_add_resource (self, didl_item, uri, protocol, NULL, &_inner_error_);
#line 793 "rygel-media-item.c"
				_g_object_unref0 (_tmp1_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_it);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
}


#line 248 "rygel-media-item.vala"
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
#line 818 "rygel-media-item.c"
	gint result = 0;
#line 248 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 248 "rygel-media-item.vala"
	g_return_val_if_fail (item != NULL, 0);
#line 249 "rygel-media-item.vala"
	if (self->date == NULL) {
#line 826 "rygel-media-item.c"
		result = -1;
#line 250 "rygel-media-item.vala"
		return result;
#line 830 "rygel-media-item.c"
	} else {
#line 251 "rygel-media-item.vala"
		if (item->date == NULL) {
#line 834 "rygel-media-item.c"
			result = 1;
#line 252 "rygel-media-item.vala"
			return result;
#line 838 "rygel-media-item.c"
		} else {
			GTimeVal tv1 = {0};
			GTimeVal tv2 = {0};
			gint ret;
			g_get_current_time (&tv1);
#line 255 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (self->date, &tv1));
#line 846 "rygel-media-item.c"
			g_get_current_time (&tv2);
#line 258 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (item->date, &tv2));
#line 260 "rygel-media-item.vala"
			ret = rygel_media_item_compare_long (self, tv1.tv_sec, tv2.tv_sec);
#line 261 "rygel-media-item.vala"
			if (ret == 0) {
#line 262 "rygel-media-item.vala"
				ret = rygel_media_item_compare_long (self, tv1.tv_usec, tv2.tv_usec);
#line 856 "rygel-media-item.c"
			}
			result = ret;
#line 265 "rygel-media-item.vala"
			return result;
#line 861 "rygel-media-item.c"
		}
	}
}


#line 269 "rygel-media-item.vala"
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
#line 869 "rygel-media-item.c"
	gint result = 0;
#line 269 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 270 "rygel-media-item.vala"
	if (a < b) {
#line 875 "rygel-media-item.c"
		result = -1;
#line 271 "rygel-media-item.vala"
		return result;
#line 879 "rygel-media-item.c"
	} else {
#line 272 "rygel-media-item.vala"
		if (a > b) {
#line 883 "rygel-media-item.c"
			result = 1;
#line 273 "rygel-media-item.vala"
			return result;
#line 887 "rygel-media-item.c"
		} else {
			result = 0;
#line 275 "rygel-media-item.vala"
			return result;
#line 892 "rygel-media-item.c"
		}
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (gint64) (-1);
	self->place_holder = FALSE;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_free0 (self->date);
	_g_free0 (self->mime_type);
	_g_free0 (self->dlna_profile);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




