/* rygel-tracker-item-creation.c generated by valac, the Vala compiler
 * generated from rygel-tracker-item-creation.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TRACKER_TYPE_ITEM_CREATION (rygel_tracker_item_creation_get_type ())
#define RYGEL_TRACKER_ITEM_CREATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_CREATION, RygelTrackerItemCreation))
#define RYGEL_TRACKER_ITEM_CREATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_CREATION, RygelTrackerItemCreationClass))
#define RYGEL_TRACKER_IS_ITEM_CREATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_CREATION))
#define RYGEL_TRACKER_IS_ITEM_CREATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_CREATION))
#define RYGEL_TRACKER_ITEM_CREATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_CREATION, RygelTrackerItemCreationClass))

typedef struct _RygelTrackerItemCreation RygelTrackerItemCreation;
typedef struct _RygelTrackerItemCreationClass RygelTrackerItemCreationClass;
typedef struct _RygelTrackerItemCreationPrivate RygelTrackerItemCreationPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER (rygel_tracker_category_all_container_get_type ())
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))

typedef struct _RygelTrackerCategoryAllContainer RygelTrackerCategoryAllContainer;
typedef struct _RygelTrackerCategoryAllContainerClass RygelTrackerCategoryAllContainerClass;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_MINER_IFACE (rygel_tracker_miner_iface_get_type ())
#define RYGEL_TRACKER_MINER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MINER_IFACE, RygelTrackerMinerIface))
#define RYGEL_TRACKER_IS_MINER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MINER_IFACE))
#define RYGEL_TRACKER_MINER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_MINER_IFACE, RygelTrackerMinerIfaceIface))

typedef struct _RygelTrackerMinerIface RygelTrackerMinerIface;
typedef struct _RygelTrackerMinerIfaceIface RygelTrackerMinerIfaceIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTrackerItemCreationRunData RygelTrackerItemCreationRunData;
typedef struct _RygelTrackerItemCreationPrepareFileData RygelTrackerItemCreationPrepareFileData;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
typedef struct _RygelTrackerItemCreationCreateEntryInStoreData RygelTrackerItemCreationCreateEntryInStoreData;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _RygelTrackerItemCreation {
	GObject parent_instance;
	RygelTrackerItemCreationPrivate * priv;
};

struct _RygelTrackerItemCreationClass {
	GObjectClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerMinerIfaceIface {
	GTypeInterface parent_iface;
	void (*ignore_next_update) (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ignore_next_update_finish) (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerItemCreationPrivate {
	GCancellable* _cancellable;
	GError* _error;
	RygelMediaItem* item;
	RygelTrackerCategoryAllContainer* container;
	RygelTrackerResourcesIface* resources;
	RygelTrackerMinerIface* miner;
};

struct _RygelTrackerItemCreationRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerItemCreation* self;
	GFile* file;
	char* urn;
	char** uris;
	char** _tmp0_;
	char** _tmp1_;
	gint _uris_size_;
	gint uris_length1;
	GFileOutputStream* _tmp2_;
	char* _tmp3_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelTrackerItemCreationPrepareFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerItemCreation* self;
	GFile* result;
	GFile* dir;
	GFile* file;
	char* _tmp0_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	char* category;
	char* upnp_class;
	char* resources_class_path;
	char* upload_dir;
	GeeArrayList* key_chains;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	char* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	char* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerItemCreationCreateEntryInStoreData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerItemCreation* self;
	char* result;
	char* category;
	RygelTrackerInsertionQuery* query;
	GError * _inner_error_;
};


static gpointer rygel_tracker_item_creation_parent_class = NULL;
static RygelStateMachineIface* rygel_tracker_item_creation_rygel_state_machine_parent_iface = NULL;

GType rygel_tracker_item_creation_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_category_all_container_get_type (void) G_GNUC_CONST;
RygelTrackerResourcesIface* rygel_tracker_resources_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
RygelTrackerMinerIface* rygel_tracker_miner_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_tracker_miner_iface_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_ITEM_CREATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_ITEM_CREATION, RygelTrackerItemCreationPrivate))
enum  {
	RYGEL_TRACKER_ITEM_CREATION_DUMMY_PROPERTY,
	RYGEL_TRACKER_ITEM_CREATION_CANCELLABLE,
	RYGEL_TRACKER_ITEM_CREATION_ERROR
};
#define RYGEL_TRACKER_ITEM_CREATION_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_ITEM_CREATION_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_ITEM_CREATION_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files"
#define RYGEL_TRACKER_ITEM_CREATION_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files"
static void rygel_tracker_item_creation_create_proxies (RygelTrackerItemCreation* self, GError** error);
RygelTrackerItemCreation* rygel_tracker_item_creation_new (RygelMediaItem* item, RygelTrackerCategoryAllContainer* container, GCancellable* cancellable, GError** error);
RygelTrackerItemCreation* rygel_tracker_item_creation_construct (GType object_type, RygelMediaItem* item, RygelTrackerCategoryAllContainer* container, GCancellable* cancellable, GError** error);
static void rygel_tracker_item_creation_real_run_data_free (gpointer _data);
static void rygel_tracker_item_creation_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_item_creation_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_item_creation_prepare_file (RygelTrackerItemCreation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GFile* rygel_tracker_item_creation_prepare_file_finish (RygelTrackerItemCreation* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_item_creation_create_entry_in_store (RygelTrackerItemCreation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char* rygel_tracker_item_creation_create_entry_in_store_finish (RygelTrackerItemCreation* self, GAsyncResult* _res_, GError** error);
void rygel_tracker_miner_iface_ignore_next_update (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_miner_iface_ignore_next_update_finish (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error);
char* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const char* urn);
void rygel_tracker_item_creation_set_error (RygelTrackerItemCreation* self, GError* value);
static gboolean rygel_tracker_item_creation_real_run_co (RygelTrackerItemCreationRunData* data);
static void rygel_tracker_item_creation_prepare_file_data_free (gpointer _data);
static void rygel_tracker_item_creation_prepare_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_item_creation_prepare_file_co (RygelTrackerItemCreationPrepareFileData* data);
static void rygel_tracker_item_creation_create_entry_in_store_data_free (gpointer _data);
static void rygel_tracker_item_creation_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const char* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const char* category);
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
static gboolean rygel_tracker_item_creation_create_entry_in_store_co (RygelTrackerItemCreationCreateEntryInStoreData* data);
GError* rygel_tracker_item_creation_get_error (RygelTrackerItemCreation* self);
static void rygel_tracker_item_creation_finalize (GObject* obj);
static void rygel_tracker_item_creation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_item_creation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 44 "rygel-tracker-item-creation.vala"
RygelTrackerItemCreation* rygel_tracker_item_creation_construct (GType object_type, RygelMediaItem* item, RygelTrackerCategoryAllContainer* container, GCancellable* cancellable, GError** error) {
#line 354 "rygel-tracker-item-creation.c"
	GError * _inner_error_;
	RygelTrackerItemCreation * self;
	RygelMediaItem* _tmp0_;
	RygelTrackerCategoryAllContainer* _tmp1_;
#line 44 "rygel-tracker-item-creation.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 44 "rygel-tracker-item-creation.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 363 "rygel-tracker-item-creation.c"
	_inner_error_ = NULL;
#line 44 "rygel-tracker-item-creation.vala"
	self = (RygelTrackerItemCreation*) g_object_new (object_type, NULL);
#line 47 "rygel-tracker-item-creation.vala"
	self->priv->item = (_tmp0_ = _g_object_ref0 (item), _g_object_unref0 (self->priv->item), _tmp0_);
#line 48 "rygel-tracker-item-creation.vala"
	self->priv->container = (_tmp1_ = _g_object_ref0 (container), _g_object_unref0 (self->priv->container), _tmp1_);
#line 49 "rygel-tracker-item-creation.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, cancellable);
#line 50 "rygel-tracker-item-creation.vala"
	rygel_tracker_item_creation_create_proxies (self, &_inner_error_);
#line 375 "rygel-tracker-item-creation.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 44 "rygel-tracker-item-creation.vala"
RygelTrackerItemCreation* rygel_tracker_item_creation_new (RygelMediaItem* item, RygelTrackerCategoryAllContainer* container, GCancellable* cancellable, GError** error) {
#line 44 "rygel-tracker-item-creation.vala"
	return rygel_tracker_item_creation_construct (RYGEL_TRACKER_TYPE_ITEM_CREATION, item, container, cancellable, error);
#line 389 "rygel-tracker-item-creation.c"
}


static void rygel_tracker_item_creation_real_run_data_free (gpointer _data) {
	RygelTrackerItemCreationRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelTrackerItemCreationRunData, data);
}


static void rygel_tracker_item_creation_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerItemCreation * self;
	RygelTrackerItemCreationRunData* _data_;
	self = (RygelTrackerItemCreation*) base;
	_data_ = g_slice_new0 (RygelTrackerItemCreationRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_item_creation_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_item_creation_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_item_creation_real_run_co (_data_);
}


static void rygel_tracker_item_creation_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelTrackerItemCreationRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_item_creation_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerItemCreationRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_item_creation_real_run_co (data);
}


static gboolean rygel_tracker_item_creation_real_run_co (RygelTrackerItemCreationRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 9;
			rygel_tracker_item_creation_prepare_file (data->self, rygel_tracker_item_creation_run_ready, data);
			return FALSE;
			_state_9:
			data->file = rygel_tracker_item_creation_prepare_file_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
			data->_state_ = 10;
			rygel_tracker_item_creation_create_entry_in_store (data->self, rygel_tracker_item_creation_run_ready, data);
			return FALSE;
			_state_10:
			data->urn = rygel_tracker_item_creation_create_entry_in_store_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->file);
				goto __catch7_g_error;
			}
			data->_tmp0_ = NULL;
			data->uris = (data->_tmp1_ = (data->_tmp0_ = g_new0 (char*, 1 + 1), data->_tmp0_[0] = (char*) gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) data->self->priv->item)->uris, 0), data->_tmp0_), data->uris_length1 = 1, data->_uris_size_ = data->uris_length1, data->_tmp1_);
			data->_state_ = 11;
			rygel_tracker_miner_iface_ignore_next_update (data->self->priv->miner, data->uris, data->uris_length1, rygel_tracker_item_creation_run_ready, data);
			return FALSE;
			_state_11:
#line 60 "rygel-tracker-item-creation.vala"
			rygel_tracker_miner_iface_ignore_next_update_finish (data->self->priv->miner, data->_res_, &data->_inner_error_);
#line 470 "rygel-tracker-item-creation.c"
			if (data->_inner_error_ != NULL) {
				data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->urn);
				_g_object_unref0 (data->file);
				goto __catch7_g_error;
			}
			data->_state_ = 12;
			g_file_create_async (data->file, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_tracker_item_creation_run_ready, data);
			return FALSE;
			_state_12:
#line 61 "rygel-tracker-item-creation.vala"
			data->_tmp2_ = g_file_create_finish (data->file, data->_res_, &data->_inner_error_);
#line 483 "rygel-tracker-item-creation.c"
			_g_object_unref0 (data->_tmp2_);
			if (data->_inner_error_ != NULL) {
				data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (data->urn);
				_g_object_unref0 (data->file);
				goto __catch7_g_error;
			}
#line 65 "rygel-tracker-item-creation.vala"
			((RygelMediaObject*) data->self->priv->item)->id = (data->_tmp3_ = rygel_tracker_search_container_create_child_id_for_urn ((RygelTrackerSearchContainer*) data->self->priv->container, data->urn), _g_free0 (((RygelMediaObject*) data->self->priv->item)->id), data->_tmp3_);
#line 66 "rygel-tracker-item-creation.vala"
			((RygelMediaObject*) data->self->priv->item)->parent = (RygelMediaContainer*) data->self->priv->container;
#line 495 "rygel-tracker-item-creation.c"
			data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->urn);
			_g_object_unref0 (data->file);
		}
		goto __finally7;
		__catch7_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 68 "rygel-tracker-item-creation.vala"
				rygel_tracker_item_creation_set_error (data->self, data->_error_);
#line 508 "rygel-tracker-item-creation.c"
				_g_error_free0 (data->_error_);
			}
		}
		__finally7:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_item_creation_prepare_file_data_free (gpointer _data) {
	RygelTrackerItemCreationPrepareFileData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerItemCreationPrepareFileData, data);
}


static void rygel_tracker_item_creation_prepare_file (RygelTrackerItemCreation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerItemCreationPrepareFileData* _data_;
	_data_ = g_slice_new0 (RygelTrackerItemCreationPrepareFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_item_creation_prepare_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_item_creation_prepare_file_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_item_creation_prepare_file_co (_data_);
}


static GFile* rygel_tracker_item_creation_prepare_file_finish (RygelTrackerItemCreation* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelTrackerItemCreationPrepareFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_item_creation_prepare_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerItemCreationPrepareFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_item_creation_prepare_file_co (data);
}


static gboolean rygel_tracker_item_creation_prepare_file_co (RygelTrackerItemCreationPrepareFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 13:
		goto _state_13;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 13;
		rygel_media_object_get_writable ((RygelMediaObject*) data->self->priv->container, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_tracker_item_creation_prepare_file_ready, data);
		return FALSE;
		_state_13:
		data->dir = rygel_media_object_get_writable_finish ((RygelMediaObject*) data->self->priv->container, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 74 "rygel-tracker-item-creation.vala"
		if (data->dir == NULL) {
#line 602 "rygel-tracker-item-creation.c"
			data->_inner_error_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), ((RygelMediaObject*) data->self->priv->container)->id);
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->dir);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
		data->file = g_file_get_child_for_display_name (data->dir, rygel_media_object_get_title ((RygelMediaObject*) data->self->priv->item), &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->dir);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 82 "rygel-tracker-item-creation.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) data->self->priv->item)->uris, data->_tmp0_ = g_file_get_uri (data->file));
#line 636 "rygel-tracker-item-creation.c"
		_g_free0 (data->_tmp0_);
		data->result = data->file;
		_g_object_unref0 (data->dir);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->file);
		_g_object_unref0 (data->dir);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_item_creation_create_entry_in_store_data_free (gpointer _data) {
	RygelTrackerItemCreationCreateEntryInStoreData* data;
	data = _data;
	_g_free0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerItemCreationCreateEntryInStoreData, data);
}


static void rygel_tracker_item_creation_create_entry_in_store (RygelTrackerItemCreation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerItemCreationCreateEntryInStoreData* _data_;
	_data_ = g_slice_new0 (RygelTrackerItemCreationCreateEntryInStoreData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_item_creation_create_entry_in_store);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_item_creation_create_entry_in_store_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_item_creation_create_entry_in_store_co (_data_);
}


static char* rygel_tracker_item_creation_create_entry_in_store_finish (RygelTrackerItemCreation* self, GAsyncResult* _res_, GError** error) {
	char* result;
	RygelTrackerItemCreationCreateEntryInStoreData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_item_creation_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerItemCreationCreateEntryInStoreData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_item_creation_create_entry_in_store_co (data);
}


static gboolean rygel_tracker_item_creation_create_entry_in_store_co (RygelTrackerItemCreationCreateEntryInStoreData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 14:
		goto _state_14;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->category = g_strdup (((RygelTrackerSearchContainer*) data->self->priv->container)->item_factory->category);
		data->query = rygel_tracker_insertion_query_new (data->self->priv->item, data->category);
		data->_state_ = 14;
		rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_item_creation_create_entry_in_store_ready, data);
		return FALSE;
		_state_14:
#line 91 "rygel-tracker-item-creation.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 723 "rygel-tracker-item-creation.c"
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_tracker_query_unref0 (data->query);
			_g_free0 (data->category);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = g_strdup (data->query->id);
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->category);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->category);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 96 "rygel-tracker-item-creation.vala"
static void rygel_tracker_item_creation_create_proxies (RygelTrackerItemCreation* self, GError** error) {
#line 768 "rygel-tracker-item-creation.c"
	GError * _inner_error_;
	DBusGConnection* connection;
	RygelTrackerResourcesIface* _tmp0_;
	RygelTrackerMinerIface* _tmp1_;
#line 96 "rygel-tracker-item-creation.vala"
	g_return_if_fail (self != NULL);
#line 775 "rygel-tracker-item-creation.c"
	_inner_error_ = NULL;
#line 97 "rygel-tracker-item-creation.vala"
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 779 "rygel-tracker-item-creation.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 99 "rygel-tracker-item-creation.vala"
	self->priv->resources = (_tmp0_ = rygel_tracker_resources_iface_dbus_proxy_new (connection, RYGEL_TRACKER_ITEM_CREATION_TRACKER_SERVICE, RYGEL_TRACKER_ITEM_CREATION_RESOURCES_PATH), _g_object_unref0 (self->priv->resources), _tmp0_);
#line 101 "rygel-tracker-item-creation.vala"
	self->priv->miner = (_tmp1_ = rygel_tracker_miner_iface_dbus_proxy_new (connection, RYGEL_TRACKER_ITEM_CREATION_MINER_SERVICE, RYGEL_TRACKER_ITEM_CREATION_MINER_PATH), _g_object_unref0 (self->priv->miner), _tmp1_);
#line 794 "rygel-tracker-item-creation.c"
	_dbus_g_connection_unref0 (connection);
}


static GCancellable* rygel_tracker_item_creation_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelTrackerItemCreation* self;
	self = (RygelTrackerItemCreation*) base;
	result = self->priv->_cancellable;
#line 36 "rygel-tracker-item-creation.vala"
	return result;
#line 806 "rygel-tracker-item-creation.c"
}


static void rygel_tracker_item_creation_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelTrackerItemCreation* self;
	GCancellable* _tmp0_;
	self = (RygelTrackerItemCreation*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


GError* rygel_tracker_item_creation_get_error (RygelTrackerItemCreation* self) {
	GError* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_error;
#line 37 "rygel-tracker-item-creation.vala"
	return result;
#line 825 "rygel-tracker-item-creation.c"
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void rygel_tracker_item_creation_set_error (RygelTrackerItemCreation* self, GError* value) {
	GError* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_error = (_tmp0_ = _g_error_copy0 (value), _g_error_free0 (self->priv->_error), _tmp0_);
	g_object_notify ((GObject *) self, "error");
}


static void rygel_tracker_item_creation_class_init (RygelTrackerItemCreationClass * klass) {
	rygel_tracker_item_creation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerItemCreationPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_item_creation_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_item_creation_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_item_creation_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_ITEM_CREATION_CANCELLABLE, "cancellable");
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_ITEM_CREATION_ERROR, g_param_spec_pointer ("error", "error", "error", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_tracker_item_creation_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_tracker_item_creation_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_tracker_item_creation_real_run;
	iface->run_finish = rygel_tracker_item_creation_real_run_finish;
	iface->get_cancellable = rygel_tracker_item_creation_real_get_cancellable;
	iface->set_cancellable = rygel_tracker_item_creation_real_set_cancellable;
}


static void rygel_tracker_item_creation_instance_init (RygelTrackerItemCreation * self) {
	self->priv = RYGEL_TRACKER_ITEM_CREATION_GET_PRIVATE (self);
}


static void rygel_tracker_item_creation_finalize (GObject* obj) {
	RygelTrackerItemCreation * self;
	self = RYGEL_TRACKER_ITEM_CREATION (obj);
	_g_object_unref0 (self->priv->_cancellable);
	_g_error_free0 (self->priv->_error);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->resources);
	_g_object_unref0 (self->priv->miner);
	G_OBJECT_CLASS (rygel_tracker_item_creation_parent_class)->finalize (obj);
}


GType rygel_tracker_item_creation_get_type (void) {
	static volatile gsize rygel_tracker_item_creation_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_item_creation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerItemCreationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_item_creation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerItemCreation), 0, (GInstanceInitFunc) rygel_tracker_item_creation_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_tracker_item_creation_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_tracker_item_creation_type_id;
		rygel_tracker_item_creation_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTrackerItemCreation", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_tracker_item_creation_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_tracker_item_creation_type_id__volatile, rygel_tracker_item_creation_type_id);
	}
	return rygel_tracker_item_creation_type_id__volatile;
}


static void rygel_tracker_item_creation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTrackerItemCreation * self;
	self = RYGEL_TRACKER_ITEM_CREATION (object);
	switch (property_id) {
		case RYGEL_TRACKER_ITEM_CREATION_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		case RYGEL_TRACKER_ITEM_CREATION_ERROR:
		g_value_set_pointer (value, rygel_tracker_item_creation_get_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_tracker_item_creation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTrackerItemCreation * self;
	self = RYGEL_TRACKER_ITEM_CREATION (object);
	switch (property_id) {
		case RYGEL_TRACKER_ITEM_CREATION_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		case RYGEL_TRACKER_ITEM_CREATION_ERROR:
		rygel_tracker_item_creation_set_error (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




