/* rygel-gst-renderer-av-transport.c generated by valac, the Vala compiler
 * generated from rygel-gst-renderer-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT (rygel_gst_renderer_av_transport_get_type ())
#define RYGEL_GST_RENDERER_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT, RygelGstRendererAVTransport))
#define RYGEL_GST_RENDERER_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT, RygelGstRendererAVTransportClass))
#define RYGEL_GST_RENDERER_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT))
#define RYGEL_GST_RENDERER_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT))
#define RYGEL_GST_RENDERER_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT, RygelGstRendererAVTransportClass))

typedef struct _RygelGstRendererAVTransport RygelGstRendererAVTransport;
typedef struct _RygelGstRendererAVTransportClass RygelGstRendererAVTransportClass;
typedef struct _RygelGstRendererAVTransportPrivate RygelGstRendererAVTransportPrivate;

#define RYGEL_GST_RENDERER_TYPE_CHANGE_LOG (rygel_gst_renderer_change_log_get_type ())
#define RYGEL_GST_RENDERER_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_RENDERER_TYPE_CHANGE_LOG, RygelGstRendererChangeLog))
#define RYGEL_GST_RENDERER_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_RENDERER_TYPE_CHANGE_LOG, RygelGstRendererChangeLogClass))
#define RYGEL_GST_RENDERER_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_RENDERER_TYPE_CHANGE_LOG))
#define RYGEL_GST_RENDERER_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_RENDERER_TYPE_CHANGE_LOG))
#define RYGEL_GST_RENDERER_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_RENDERER_TYPE_CHANGE_LOG, RygelGstRendererChangeLogClass))

typedef struct _RygelGstRendererChangeLog RygelGstRendererChangeLog;
typedef struct _RygelGstRendererChangeLogClass RygelGstRendererChangeLogClass;

#define RYGEL_GST_RENDERER_TYPE_PLAYER (rygel_gst_renderer_player_get_type ())
#define RYGEL_GST_RENDERER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayer))
#define RYGEL_GST_RENDERER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayerClass))
#define RYGEL_GST_RENDERER_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER))
#define RYGEL_GST_RENDERER_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_RENDERER_TYPE_PLAYER))
#define RYGEL_GST_RENDERER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_RENDERER_TYPE_PLAYER, RygelGstRendererPlayerClass))

typedef struct _RygelGstRendererPlayer RygelGstRendererPlayer;
typedef struct _RygelGstRendererPlayerClass RygelGstRendererPlayerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstRendererAVTransport {
	GUPnPService parent_instance;
	RygelGstRendererAVTransportPrivate * priv;
};

struct _RygelGstRendererAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelGstRendererAVTransportPrivate {
	guint _n_tracks;
	guint _track;
	char* _metadata;
	char* _status;
	char* _speed;
	char* _mode;
	RygelGstRendererChangeLog* changelog;
	RygelGstRendererPlayer* player;
};


static gpointer rygel_gst_renderer_av_transport_parent_class = NULL;

GType rygel_gst_renderer_av_transport_get_type (void);
GType rygel_gst_renderer_change_log_get_type (void);
GType rygel_gst_renderer_player_get_type (void);
#define RYGEL_GST_RENDERER_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT, RygelGstRendererAVTransportPrivate))
enum  {
	RYGEL_GST_RENDERER_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_GST_RENDERER_AV_TRANSPORT_N_TRACKS,
	RYGEL_GST_RENDERER_AV_TRANSPORT_TRACK,
	RYGEL_GST_RENDERER_AV_TRANSPORT_METADATA,
	RYGEL_GST_RENDERER_AV_TRANSPORT_URI,
	RYGEL_GST_RENDERER_AV_TRANSPORT_STATUS,
	RYGEL_GST_RENDERER_AV_TRANSPORT_SPEED,
	RYGEL_GST_RENDERER_AV_TRANSPORT_MODE
};
#define RYGEL_GST_RENDERER_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_GST_RENDERER_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_GST_RENDERER_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_GST_RENDERER_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
RygelGstRendererChangeLog* rygel_gst_renderer_change_log_new (GUPnPService* service, const char* service_ns);
RygelGstRendererChangeLog* rygel_gst_renderer_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
RygelGstRendererPlayer* rygel_gst_renderer_player_get_default (void);
static void rygel_gst_renderer_av_transport_query_last_change_cb (RygelGstRendererAVTransport* self, GUPnPService* service, const char* variable, GValue* value);
static void _rygel_gst_renderer_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self);
static void rygel_gst_renderer_av_transport_set_av_transport_uri_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_get_media_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_get_transport_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_get_position_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_get_device_capabilities_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_get_transport_settings_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_stop_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_play_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_pause_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_seek_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_next_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_previous_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_renderer_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_renderer_av_transport_notify_state_cb (RygelGstRendererAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_gst_renderer_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_gst_renderer_av_transport_notify_duration_cb (RygelGstRendererAVTransport* self, GObject* window, GParamSpec* p);
static void _rygel_gst_renderer_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_gst_renderer_av_transport_real_constructed (GObject* base);
void rygel_gst_renderer_change_log_log (RygelGstRendererChangeLog* self, const char* variable, const char* value);
const char* rygel_gst_renderer_player_get_playback_state (RygelGstRendererPlayer* self);
const char* rygel_gst_renderer_av_transport_get_status (RygelGstRendererAVTransport* self);
const char* rygel_gst_renderer_av_transport_get_mode (RygelGstRendererAVTransport* self);
const char* rygel_gst_renderer_av_transport_get_speed (RygelGstRendererAVTransport* self);
guint rygel_gst_renderer_av_transport_get_n_tracks (RygelGstRendererAVTransport* self);
guint rygel_gst_renderer_av_transport_get_track (RygelGstRendererAVTransport* self);
char* rygel_gst_renderer_player_get_duration (RygelGstRendererPlayer* self);
char* rygel_gst_renderer_av_transport_get_metadata (RygelGstRendererAVTransport* self);
char* rygel_gst_renderer_av_transport_get_uri (RygelGstRendererAVTransport* self);
char* rygel_gst_renderer_change_log_finish (RygelGstRendererChangeLog* self);
static gboolean rygel_gst_renderer_av_transport_check_instance_id (RygelGstRendererAVTransport* self, GUPnPServiceAction* action);
void rygel_gst_renderer_av_transport_set_uri (RygelGstRendererAVTransport* self, const char* value);
void rygel_gst_renderer_av_transport_set_metadata (RygelGstRendererAVTransport* self, const char* value);
char* rygel_gst_renderer_player_get_position (RygelGstRendererPlayer* self);
void rygel_gst_renderer_player_set_playback_state (RygelGstRendererPlayer* self, const char* value);
gboolean rygel_gst_renderer_player_seek (RygelGstRendererPlayer* self, const char* time);
RygelGstRendererAVTransport* rygel_gst_renderer_av_transport_new (void);
RygelGstRendererAVTransport* rygel_gst_renderer_av_transport_construct (GType object_type);
void rygel_gst_renderer_av_transport_set_n_tracks (RygelGstRendererAVTransport* self, guint value);
void rygel_gst_renderer_av_transport_set_track (RygelGstRendererAVTransport* self, guint value);
const char* rygel_gst_renderer_player_get_uri (RygelGstRendererPlayer* self);
void rygel_gst_renderer_player_set_uri (RygelGstRendererPlayer* self, const char* value);
void rygel_gst_renderer_av_transport_set_status (RygelGstRendererAVTransport* self, const char* value);
void rygel_gst_renderer_av_transport_set_speed (RygelGstRendererAVTransport* self, const char* value);
void rygel_gst_renderer_av_transport_set_mode (RygelGstRendererAVTransport* self, const char* value);
static void rygel_gst_renderer_av_transport_finalize (GObject* obj);
static void rygel_gst_renderer_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_renderer_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 163 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self) {
#line 179 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_query_last_change_cb (self, _sender, variable, value);
}


#line 207 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 186 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_set_av_transport_uri_cb (self, _sender, action);
}


#line 224 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 193 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_get_media_info_cb (self, _sender, action);
}


#line 262 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 200 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_get_transport_info_cb (self, _sender, action);
}


#line 281 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 207 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_get_position_info_cb (self, _sender, action);
}


#line 315 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 214 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_get_device_capabilities_cb (self, _sender, action);
}


#line 328 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 221 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_get_transport_settings_cb (self, _sender, action);
}


#line 340 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 228 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_stop_cb (self, _sender, action);
}


#line 350 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 235 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_play_cb (self, _sender, action);
}


#line 369 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 242 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_pause_cb (self, _sender, action);
}


#line 379 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 249 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_seek_cb (self, _sender, action);
}


#line 407 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 256 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_next_cb (self, _sender, action);
}


#line 411 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 263 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_previous_cb (self, _sender, action);
}


#line 415 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 270 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_notify_state_cb (self, _sender, pspec);
}


#line 420 "rygel-gst-renderer-av-transport.vala"
static void _rygel_gst_renderer_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 277 "rygel-gst-renderer-av-transport.c"
	rygel_gst_renderer_av_transport_notify_duration_cb (self, _sender, pspec);
}


#line 137 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_real_constructed (GObject* base) {
#line 284 "rygel-gst-renderer-av-transport.c"
	RygelGstRendererAVTransport * self;
	RygelGstRendererChangeLog* _tmp0_;
	RygelGstRendererPlayer* _tmp1_;
	self = (RygelGstRendererAVTransport*) base;
#line 138 "rygel-gst-renderer-av-transport.vala"
	self->priv->changelog = (_tmp0_ = rygel_gst_renderer_change_log_new ((GUPnPService*) self, RYGEL_GST_RENDERER_AV_TRANSPORT_LAST_CHANGE_NS), _g_object_unref0 (self->priv->changelog), _tmp0_);
#line 139 "rygel-gst-renderer-av-transport.vala"
	self->priv->player = (_tmp1_ = rygel_gst_renderer_player_get_default (), _g_object_unref0 (self->priv->player), _tmp1_);
#line 141 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_gst_renderer_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 143 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_gst_renderer_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 145 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_gst_renderer_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 146 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_gst_renderer_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 147 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_gst_renderer_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 148 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_gst_renderer_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 150 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_gst_renderer_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 152 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_gst_renderer_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 153 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_gst_renderer_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 154 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_gst_renderer_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 155 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_gst_renderer_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 156 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_gst_renderer_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 157 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_gst_renderer_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 159 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GObject*) self->priv->player, "notify::playback-state", (GCallback) _rygel_gst_renderer_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 160 "rygel-gst-renderer-av-transport.vala"
	g_signal_connect_object ((GObject*) self->priv->player, "notify::duration", (GCallback) _rygel_gst_renderer_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 323 "rygel-gst-renderer-av-transport.c"
}


#line 163 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_query_last_change_cb (RygelGstRendererAVTransport* self, GUPnPService* service, const char* variable, GValue* value) {
#line 329 "rygel-gst-renderer-av-transport.c"
	RygelGstRendererChangeLog* log;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
#line 163 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 163 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 163 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 167 "rygel-gst-renderer-av-transport.vala"
	log = rygel_gst_renderer_change_log_new (NULL, RYGEL_GST_RENDERER_AV_TRANSPORT_LAST_CHANGE_NS);
#line 169 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "TransportState", rygel_gst_renderer_player_get_playback_state (self->priv->player));
#line 170 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "TransportStatus", rygel_gst_renderer_av_transport_get_status (self));
#line 171 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
#line 172 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 173 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
#line 174 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 175 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentPlayMode", rygel_gst_renderer_av_transport_get_mode (self));
#line 176 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "TransportPlaySpeed", rygel_gst_renderer_av_transport_get_speed (self));
#line 177 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 178 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 179 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
#line 180 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", rygel_gst_renderer_av_transport_get_n_tracks (self)));
#line 371 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp0_);
#line 181 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentTrack", _tmp1_ = g_strdup_printf ("%u", rygel_gst_renderer_av_transport_get_track (self)));
#line 375 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp1_);
#line 182 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentTrackDuration", _tmp2_ = rygel_gst_renderer_player_get_duration (self->priv->player));
#line 379 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp2_);
#line 183 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentMediaDuration", _tmp3_ = rygel_gst_renderer_player_get_duration (self->priv->player));
#line 383 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp3_);
#line 184 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentTrackMetadata", _tmp4_ = rygel_gst_renderer_av_transport_get_metadata (self));
#line 387 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp4_);
#line 185 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "CurrentTrackURI", _tmp5_ = rygel_gst_renderer_av_transport_get_uri (self));
#line 391 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp5_);
#line 186 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "AVTransportURI", _tmp6_ = rygel_gst_renderer_av_transport_get_uri (self));
#line 395 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp6_);
#line 187 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
#line 189 "rygel-gst-renderer-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 190 "rygel-gst-renderer-av-transport.vala"
	g_value_set_string (value, _tmp7_ = rygel_gst_renderer_change_log_finish (log));
#line 403 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp7_);
	_g_object_unref0 (log);
}


#line 194 "rygel-gst-renderer-av-transport.vala"
static gboolean rygel_gst_renderer_av_transport_check_instance_id (RygelGstRendererAVTransport* self, GUPnPServiceAction* action) {
#line 411 "rygel-gst-renderer-av-transport.c"
	gboolean result = FALSE;
	guint instance_id = 0U;
#line 194 "rygel-gst-renderer-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 194 "rygel-gst-renderer-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 197 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 198 "rygel-gst-renderer-av-transport.vala"
	if (instance_id != 0) {
#line 199 "rygel-gst-renderer-av-transport.vala"
		gupnp_service_action_return_error (action, (guint) 718, _ ("Invalid InstanceID"));
#line 424 "rygel-gst-renderer-av-transport.c"
		result = FALSE;
#line 201 "rygel-gst-renderer-av-transport.vala"
		return result;
#line 428 "rygel-gst-renderer-av-transport.c"
	}
	result = TRUE;
#line 204 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 433 "rygel-gst-renderer-av-transport.c"
}


#line 207 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_set_av_transport_uri_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 439 "rygel-gst-renderer-av-transport.c"
	char* _uri;
	char* _metadata;
#line 207 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 207 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 207 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 209 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 210 "rygel-gst-renderer-av-transport.vala"
		return;
#line 452 "rygel-gst-renderer-av-transport.c"
	}
	_uri = NULL;
	_metadata = NULL;
#line 215 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_get (action, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
#line 218 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_av_transport_set_uri (self, _uri);
#line 219 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_av_transport_set_metadata (self, _metadata);
#line 221 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 464 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_uri);
	_g_free0 (_metadata);
}


#line 224 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_get_media_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 472 "rygel-gst-renderer-av-transport.c"
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
#line 224 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 224 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 224 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 226 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 227 "rygel-gst-renderer-av-transport.vala"
		return;
#line 486 "rygel-gst-renderer-av-transport.c"
	}
#line 231 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_set (action, "NrTracks", G_TYPE_UINT, rygel_gst_renderer_av_transport_get_n_tracks (self), "MediaDuration", G_TYPE_STRING, _tmp0_ = rygel_gst_renderer_player_get_duration (self->priv->player), "CurrentURI", G_TYPE_STRING, _tmp1_ = rygel_gst_renderer_av_transport_get_uri (self), "CurrentURIMetaData", G_TYPE_STRING, _tmp2_ = rygel_gst_renderer_av_transport_get_metadata (self), "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 490 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 259 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 496 "rygel-gst-renderer-av-transport.c"
}


#line 262 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_get_transport_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 262 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 262 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 262 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 264 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 265 "rygel-gst-renderer-av-transport.vala"
		return;
#line 512 "rygel-gst-renderer-av-transport.c"
	}
#line 268 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_set (action, "CurrentTransportState", G_TYPE_STRING, rygel_gst_renderer_player_get_playback_state (self->priv->player), "CurrentTransportStatus", G_TYPE_STRING, rygel_gst_renderer_av_transport_get_status (self), "CurrentSpeed", G_TYPE_STRING, rygel_gst_renderer_av_transport_get_speed (self), NULL);
#line 278 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 518 "rygel-gst-renderer-av-transport.c"
}


#line 281 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_get_position_info_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 524 "rygel-gst-renderer-av-transport.c"
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
#line 281 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 281 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 281 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 283 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 284 "rygel-gst-renderer-av-transport.vala"
		return;
#line 540 "rygel-gst-renderer-av-transport.c"
	}
#line 287 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_set (action, "Track", G_TYPE_UINT, rygel_gst_renderer_av_transport_get_track (self), "TrackDuration", G_TYPE_STRING, _tmp0_ = rygel_gst_renderer_player_get_duration (self->priv->player), "TrackMetaData", G_TYPE_STRING, _tmp1_ = rygel_gst_renderer_av_transport_get_metadata (self), "TrackURI", G_TYPE_STRING, _tmp2_ = rygel_gst_renderer_av_transport_get_uri (self), "RelTime", G_TYPE_STRING, _tmp3_ = rygel_gst_renderer_player_get_position (self->priv->player), "AbsTime", G_TYPE_STRING, _tmp4_ = rygel_gst_renderer_player_get_position (self->priv->player), "RelCount", G_TYPE_INT, G_MAXINT, "AbsCount", G_TYPE_INT, G_MAXINT, NULL);
#line 544 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 312 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 552 "rygel-gst-renderer-av-transport.c"
}


#line 315 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_get_device_capabilities_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 315 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 315 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 315 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 317 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 318 "rygel-gst-renderer-av-transport.vala"
		return;
#line 568 "rygel-gst-renderer-av-transport.c"
	}
#line 321 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_set (action, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 325 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 574 "rygel-gst-renderer-av-transport.c"
}


#line 328 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_get_transport_settings_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 328 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 328 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 328 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 330 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 331 "rygel-gst-renderer-av-transport.vala"
		return;
#line 590 "rygel-gst-renderer-av-transport.c"
	}
#line 334 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_set (action, "PlayMode", G_TYPE_STRING, rygel_gst_renderer_av_transport_get_mode (self), "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 337 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 596 "rygel-gst-renderer-av-transport.c"
}


#line 340 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_stop_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 340 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 340 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 340 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 341 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 342 "rygel-gst-renderer-av-transport.vala"
		return;
#line 612 "rygel-gst-renderer-av-transport.c"
	}
#line 345 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_player_set_playback_state (self->priv->player, "STOPPED");
#line 347 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 618 "rygel-gst-renderer-av-transport.c"
}


#line 350 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_play_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 624 "rygel-gst-renderer-av-transport.c"
	char* speed;
#line 350 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 350 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 350 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 351 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 352 "rygel-gst-renderer-av-transport.vala"
		return;
#line 636 "rygel-gst-renderer-av-transport.c"
	}
	speed = NULL;
#line 357 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_get (action, "Speed", G_TYPE_STRING, &speed, NULL);
#line 358 "rygel-gst-renderer-av-transport.vala"
	if (_vala_strcmp0 (speed, "1") != 0) {
#line 359 "rygel-gst-renderer-av-transport.vala"
		gupnp_service_action_return_error (action, (guint) 717, _ ("Play speed not supported"));
#line 645 "rygel-gst-renderer-av-transport.c"
		_g_free0 (speed);
#line 361 "rygel-gst-renderer-av-transport.vala"
		return;
#line 649 "rygel-gst-renderer-av-transport.c"
	}
#line 364 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_player_set_playback_state (self->priv->player, "PLAYING");
#line 366 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 655 "rygel-gst-renderer-av-transport.c"
	_g_free0 (speed);
}


#line 369 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_pause_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 369 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 369 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 369 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 370 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 371 "rygel-gst-renderer-av-transport.vala"
		return;
#line 672 "rygel-gst-renderer-av-transport.c"
	}
#line 374 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_player_set_playback_state (self->priv->player, "PAUSED_PLAYBACK");
#line 376 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return (action);
#line 678 "rygel-gst-renderer-av-transport.c"
}


#line 379 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_seek_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 684 "rygel-gst-renderer-av-transport.c"
	char* unit;
	char* target;
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
#line 379 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 379 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 379 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 380 "rygel-gst-renderer-av-transport.vala"
	if (!rygel_gst_renderer_av_transport_check_instance_id (self, action)) {
#line 381 "rygel-gst-renderer-av-transport.vala"
		return;
#line 701 "rygel-gst-renderer-av-transport.c"
	}
	unit = NULL;
	target = NULL;
#line 386 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_get (action, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 707 "rygel-gst-renderer-av-transport.c"
	_tmp0_ = unit;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("REL_TIME")))))
	switch (0) {
		default:
		{
#line 391 "rygel-gst-renderer-av-transport.vala"
			if (!rygel_gst_renderer_player_seek (self->priv->player, target)) {
#line 392 "rygel-gst-renderer-av-transport.vala"
				gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
#line 718 "rygel-gst-renderer-av-transport.c"
				_g_free0 (unit);
				_g_free0 (target);
#line 394 "rygel-gst-renderer-av-transport.vala"
				return;
#line 723 "rygel-gst-renderer-av-transport.c"
			}
#line 397 "rygel-gst-renderer-av-transport.vala"
			gupnp_service_action_return (action);
#line 727 "rygel-gst-renderer-av-transport.c"
			_g_free0 (unit);
			_g_free0 (target);
#line 399 "rygel-gst-renderer-av-transport.vala"
			return;
#line 732 "rygel-gst-renderer-av-transport.c"
		}
	} else
	switch (0) {
		default:
		{
#line 401 "rygel-gst-renderer-av-transport.vala"
			gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
#line 740 "rygel-gst-renderer-av-transport.c"
			_g_free0 (unit);
			_g_free0 (target);
#line 403 "rygel-gst-renderer-av-transport.vala"
			return;
#line 745 "rygel-gst-renderer-av-transport.c"
		}
	}
	_g_free0 (unit);
	_g_free0 (target);
}


#line 407 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_next_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 407 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 407 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 407 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 408 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
#line 763 "rygel-gst-renderer-av-transport.c"
}


#line 411 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_previous_cb (RygelGstRendererAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 411 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 411 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 411 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 412 "rygel-gst-renderer-av-transport.vala"
	gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
#line 777 "rygel-gst-renderer-av-transport.c"
}


#line 415 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_notify_state_cb (RygelGstRendererAVTransport* self, GObject* player, GParamSpec* p) {
#line 415 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 415 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 415 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 417 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "TransportState", rygel_gst_renderer_player_get_playback_state (self->priv->player));
#line 791 "rygel-gst-renderer-av-transport.c"
}


#line 420 "rygel-gst-renderer-av-transport.vala"
static void rygel_gst_renderer_av_transport_notify_duration_cb (RygelGstRendererAVTransport* self, GObject* window, GParamSpec* p) {
#line 797 "rygel-gst-renderer-av-transport.c"
	char* _tmp0_;
	char* _tmp1_;
#line 420 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 420 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (window != NULL);
#line 420 "rygel-gst-renderer-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 422 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentTrackDuration", _tmp0_ = rygel_gst_renderer_player_get_duration (self->priv->player));
#line 808 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp0_);
#line 423 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentMediaDuration", _tmp1_ = rygel_gst_renderer_player_get_duration (self->priv->player));
#line 812 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp1_);
}


#line 26 "rygel-gst-renderer-av-transport.vala"
RygelGstRendererAVTransport* rygel_gst_renderer_av_transport_construct (GType object_type) {
#line 819 "rygel-gst-renderer-av-transport.c"
	RygelGstRendererAVTransport * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 26 "rygel-gst-renderer-av-transport.vala"
RygelGstRendererAVTransport* rygel_gst_renderer_av_transport_new (void) {
#line 26 "rygel-gst-renderer-av-transport.vala"
	return rygel_gst_renderer_av_transport_construct (RYGEL_GST_RENDERER_TYPE_AV_TRANSPORT);
#line 830 "rygel-gst-renderer-av-transport.c"
}


guint rygel_gst_renderer_av_transport_get_n_tracks (RygelGstRendererAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_tracks;
#line 38 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 840 "rygel-gst-renderer-av-transport.c"
}


void rygel_gst_renderer_av_transport_set_n_tracks (RygelGstRendererAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 42 "rygel-gst-renderer-av-transport.vala"
	self->priv->_n_tracks = value;
#line 44 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", self->priv->_n_tracks));
#line 851 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "n-tracks");
}


guint rygel_gst_renderer_av_transport_get_track (RygelGstRendererAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_track;
#line 51 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 863 "rygel-gst-renderer-av-transport.c"
}


void rygel_gst_renderer_av_transport_set_track (RygelGstRendererAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 55 "rygel-gst-renderer-av-transport.vala"
	self->priv->_track = value;
#line 57 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentTrack", _tmp0_ = g_strdup_printf ("%u", self->priv->_track));
#line 874 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "track");
}


char* rygel_gst_renderer_av_transport_get_metadata (RygelGstRendererAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "rygel-gst-renderer-av-transport.vala"
	if (self->priv->_metadata != NULL) {
#line 885 "rygel-gst-renderer-av-transport.c"
		result = g_markup_escape_text (self->priv->_metadata, -1);
#line 65 "rygel-gst-renderer-av-transport.vala"
		return result;
#line 889 "rygel-gst-renderer-av-transport.c"
	} else {
		result = g_strdup ("");
#line 67 "rygel-gst-renderer-av-transport.vala"
		return result;
#line 894 "rygel-gst-renderer-av-transport.c"
	}
}


void rygel_gst_renderer_av_transport_set_metadata (RygelGstRendererAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
#line 72 "rygel-gst-renderer-av-transport.vala"
	self->priv->_metadata = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_metadata), _tmp0_);
#line 74 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentTrackMetadata", _tmp1_ = rygel_gst_renderer_av_transport_get_metadata (self));
#line 907 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "metadata");
}


char* rygel_gst_renderer_av_transport_get_uri (RygelGstRendererAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-gst-renderer-av-transport.vala"
	if (rygel_gst_renderer_player_get_uri (self->priv->player) != NULL) {
#line 918 "rygel-gst-renderer-av-transport.c"
		result = g_markup_escape_text (rygel_gst_renderer_player_get_uri (self->priv->player), -1);
#line 81 "rygel-gst-renderer-av-transport.vala"
		return result;
#line 922 "rygel-gst-renderer-av-transport.c"
	} else {
		result = g_strdup ("");
#line 83 "rygel-gst-renderer-av-transport.vala"
		return result;
#line 927 "rygel-gst-renderer-av-transport.c"
	}
}


void rygel_gst_renderer_av_transport_set_uri (RygelGstRendererAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
#line 88 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_player_set_uri (self->priv->player, value);
#line 90 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentTrackURI", _tmp0_ = rygel_gst_renderer_av_transport_get_uri (self));
#line 940 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp0_);
#line 91 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "AVTransportURI", _tmp1_ = rygel_gst_renderer_av_transport_get_uri (self));
#line 944 "rygel-gst-renderer-av-transport.c"
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "uri");
}


const char* rygel_gst_renderer_av_transport_get_status (RygelGstRendererAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
#line 98 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 956 "rygel-gst-renderer-av-transport.c"
}


void rygel_gst_renderer_av_transport_set_status (RygelGstRendererAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 102 "rygel-gst-renderer-av-transport.vala"
	self->priv->_status = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_status), _tmp0_);
#line 104 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "TransportStatus", self->priv->_status);
#line 967 "rygel-gst-renderer-av-transport.c"
	g_object_notify ((GObject *) self, "status");
}


const char* rygel_gst_renderer_av_transport_get_speed (RygelGstRendererAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_speed;
#line 111 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 978 "rygel-gst-renderer-av-transport.c"
}


void rygel_gst_renderer_av_transport_set_speed (RygelGstRendererAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 115 "rygel-gst-renderer-av-transport.vala"
	self->priv->_speed = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_speed), _tmp0_);
#line 117 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "TransportPlaySpeed", self->priv->_speed);
#line 989 "rygel-gst-renderer-av-transport.c"
	g_object_notify ((GObject *) self, "speed");
}


const char* rygel_gst_renderer_av_transport_get_mode (RygelGstRendererAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mode;
#line 124 "rygel-gst-renderer-av-transport.vala"
	return result;
#line 1000 "rygel-gst-renderer-av-transport.c"
}


void rygel_gst_renderer_av_transport_set_mode (RygelGstRendererAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 128 "rygel-gst-renderer-av-transport.vala"
	self->priv->_mode = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mode), _tmp0_);
#line 130 "rygel-gst-renderer-av-transport.vala"
	rygel_gst_renderer_change_log_log (self->priv->changelog, "CurrentPlayMode", self->priv->_mode);
#line 1011 "rygel-gst-renderer-av-transport.c"
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_gst_renderer_av_transport_class_init (RygelGstRendererAVTransportClass * klass) {
	rygel_gst_renderer_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstRendererAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_gst_renderer_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_renderer_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_renderer_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_renderer_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERER_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_gst_renderer_av_transport_instance_init (RygelGstRendererAVTransport * self) {
	self->priv = RYGEL_GST_RENDERER_AV_TRANSPORT_GET_PRIVATE (self);
	self->priv->_n_tracks = (guint) 0;
	self->priv->_track = (guint) 0;
	self->priv->_metadata = g_strdup ("");
	self->priv->_status = g_strdup ("OK");
	self->priv->_speed = g_strdup ("1");
	self->priv->_mode = g_strdup ("NORMAL");
}


static void rygel_gst_renderer_av_transport_finalize (GObject* obj) {
	RygelGstRendererAVTransport * self;
	self = RYGEL_GST_RENDERER_AV_TRANSPORT (obj);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_speed);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_gst_renderer_av_transport_parent_class)->finalize (obj);
}


GType rygel_gst_renderer_av_transport_get_type (void) {
	static volatile gsize rygel_gst_renderer_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_renderer_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstRendererAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_renderer_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstRendererAVTransport), 0, (GInstanceInitFunc) rygel_gst_renderer_av_transport_instance_init, NULL };
		GType rygel_gst_renderer_av_transport_type_id;
		rygel_gst_renderer_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelGstRendererAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_gst_renderer_av_transport_type_id__volatile, rygel_gst_renderer_av_transport_type_id);
	}
	return rygel_gst_renderer_av_transport_type_id__volatile;
}


static void rygel_gst_renderer_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstRendererAVTransport * self;
	self = RYGEL_GST_RENDERER_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_GST_RENDERER_AV_TRANSPORT_N_TRACKS:
		g_value_set_uint (value, rygel_gst_renderer_av_transport_get_n_tracks (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_TRACK:
		g_value_set_uint (value, rygel_gst_renderer_av_transport_get_track (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_METADATA:
		g_value_take_string (value, rygel_gst_renderer_av_transport_get_metadata (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_URI:
		g_value_take_string (value, rygel_gst_renderer_av_transport_get_uri (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_gst_renderer_av_transport_get_status (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_SPEED:
		g_value_set_string (value, rygel_gst_renderer_av_transport_get_speed (self));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_gst_renderer_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_renderer_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstRendererAVTransport * self;
	self = RYGEL_GST_RENDERER_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_GST_RENDERER_AV_TRANSPORT_N_TRACKS:
		rygel_gst_renderer_av_transport_set_n_tracks (self, g_value_get_uint (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_TRACK:
		rygel_gst_renderer_av_transport_set_track (self, g_value_get_uint (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_METADATA:
		rygel_gst_renderer_av_transport_set_metadata (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_URI:
		rygel_gst_renderer_av_transport_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_STATUS:
		rygel_gst_renderer_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_SPEED:
		rygel_gst_renderer_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_GST_RENDERER_AV_TRANSPORT_MODE:
		rygel_gst_renderer_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




