/* dconf-model.c generated by valac, the Vala compiler
 * generated from dconf-model.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <dconf.h>
#include <gee.h>
#include <pango/pango.h>


#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;
typedef struct _KeyPrivate KeyPrivate;

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;

#define TYPE_SCHEMA_KEY (schema_key_get_type ())
#define SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_KEY, SchemaKey))
#define SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_KEY, SchemaKeyClass))
#define IS_SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_KEY))
#define IS_SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_KEY))
#define SCHEMA_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_KEY, SchemaKeyClass))

typedef struct _SchemaKey SchemaKey;
typedef struct _SchemaKeyClass SchemaKeyClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _schema_key_unref0(var) ((var == NULL) ? NULL : (var = (schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _SettingsModelPrivate SettingsModelPrivate;

#define TYPE_SCHEMA_LIST (schema_list_get_type ())
#define SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_LIST, SchemaList))
#define SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_LIST, SchemaListClass))
#define IS_SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_LIST))
#define IS_SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_LIST))
#define SCHEMA_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_LIST, SchemaListClass))

typedef struct _SchemaList SchemaList;
typedef struct _SchemaListClass SchemaListClass;
typedef struct _SchemaListPrivate SchemaListPrivate;

#define TYPE_SCHEMA (schema_get_type ())
#define SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA, Schema))
#define SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA, SchemaClass))
#define IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA))
#define IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA))
#define SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA, SchemaClass))

typedef struct _Schema Schema;
typedef struct _SchemaClass SchemaClass;

#define TYPE_SCHEMA_ENUM (schema_enum_get_type ())
#define SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_ENUM, SchemaEnum))
#define SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_ENUM, SchemaEnumClass))
#define IS_SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_ENUM))
#define IS_SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_ENUM))
#define SCHEMA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_ENUM, SchemaEnumClass))

typedef struct _SchemaEnum SchemaEnum;
typedef struct _SchemaEnumClass SchemaEnumClass;
typedef struct _SchemaKeyPrivate SchemaKeyPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DirectoryPrivate DirectoryPrivate;

#define TYPE_KEY_MODEL (key_model_get_type ())
#define KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MODEL, KeyModel))
#define KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MODEL, KeyModelClass))
#define IS_KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MODEL))
#define IS_KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MODEL))
#define KEY_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MODEL, KeyModelClass))

typedef struct _KeyModel KeyModel;
typedef struct _KeyModelClass KeyModelClass;
typedef struct _SchemaPrivate SchemaPrivate;
typedef struct _KeyModelPrivate KeyModelPrivate;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_ENUM_MODEL (enum_model_get_type ())
#define ENUM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENUM_MODEL, EnumModel))
#define ENUM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENUM_MODEL, EnumModelClass))
#define IS_ENUM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENUM_MODEL))
#define IS_ENUM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENUM_MODEL))
#define ENUM_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENUM_MODEL, EnumModelClass))

typedef struct _EnumModel EnumModel;
typedef struct _EnumModelClass EnumModelClass;
typedef struct _EnumModelPrivate EnumModelPrivate;
#define _schema_enum_unref0(var) ((var == NULL) ? NULL : (var = (schema_enum_unref (var), NULL)))

#define TYPE_SCHEMA_ENUM_VALUE (schema_enum_value_get_type ())
#define SCHEMA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValue))
#define SCHEMA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValueClass))
#define IS_SCHEMA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_ENUM_VALUE))
#define IS_SCHEMA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_ENUM_VALUE))
#define SCHEMA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_ENUM_VALUE, SchemaEnumValueClass))

typedef struct _SchemaEnumValue SchemaEnumValue;
typedef struct _SchemaEnumValueClass SchemaEnumValueClass;
typedef struct _SchemaEnumValuePrivate SchemaEnumValuePrivate;
typedef struct _SchemaEnumPrivate SchemaEnumPrivate;
#define _schema_list_unref0(var) ((var == NULL) ? NULL : (var = (schema_list_unref (var), NULL)))
#define _schema_unref0(var) ((var == NULL) ? NULL : (var = (schema_unref (var), NULL)))

struct _Key {
	GObject parent_instance;
	KeyPrivate * priv;
	Directory* parent;
	gint index;
	char* name;
	char* full_name;
	SchemaKey* schema;
};

struct _KeyClass {
	GObjectClass parent_class;
};

struct _KeyPrivate {
	SettingsModel* model;
	GVariant* _value;
};

struct _SettingsModel {
	GObject parent_instance;
	SettingsModelPrivate * priv;
	SchemaList* schemas;
	DConfClient* client;
};

struct _SettingsModelClass {
	GObjectClass parent_class;
};

struct _SchemaList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaListPrivate * priv;
	GeeArrayList* schemas;
	GeeHashMap* keys;
	GeeHashMap* enums;
};

struct _SchemaListClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaList *self);
};

struct _SchemaKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaKeyPrivate * priv;
	Schema* schema;
	char* name;
	char* type;
	GVariant* default_value;
	char* enum_name;
	char* summary;
	char* description;
	char* gettext_domain;
};

struct _SchemaKeyClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaKey *self);
};

struct _Directory {
	GObject parent_instance;
	DirectoryPrivate * priv;
	char* name;
	char* full_name;
	Directory* parent;
	gint index;
	GeeHashMap* _child_map;
	GeeArrayList* _children;
	GeeHashMap* _key_map;
};

struct _DirectoryClass {
	GObjectClass parent_class;
};

struct _DirectoryPrivate {
	SettingsModel* model;
	KeyModel* _key_model;
	GeeArrayList* _keys;
	gboolean have_children;
};

struct _Schema {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaPrivate * priv;
	SchemaList* list;
	char* id;
	char* path;
	GeeHashMap* keys;
};

struct _SchemaClass {
	GTypeClass parent_class;
	void (*finalize) (Schema *self);
};

struct _KeyModel {
	GObject parent_instance;
	KeyModelPrivate * priv;
};

struct _KeyModelClass {
	GObjectClass parent_class;
};

struct _KeyModelPrivate {
	Directory* directory;
};

struct _EnumModel {
	GObject parent_instance;
	EnumModelPrivate * priv;
};

struct _EnumModelClass {
	GObjectClass parent_class;
};

struct _EnumModelPrivate {
	SchemaEnum* schema_enum;
};

struct _SchemaEnumValue {
	GObject parent_instance;
	SchemaEnumValuePrivate * priv;
	SchemaEnum* schema_enum;
	gint index;
	char* nick;
	gint value;
};

struct _SchemaEnumValueClass {
	GObjectClass parent_class;
};

struct _SchemaEnum {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaEnumPrivate * priv;
	SchemaList* list;
	char* id;
	GeeArrayList* values;
};

struct _SchemaEnumClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaEnum *self);
};

struct _SettingsModelPrivate {
	Directory* root;
};


static gpointer key_parent_class = NULL;
static gpointer directory_parent_class = NULL;
static gpointer key_model_parent_class = NULL;
static GtkTreeModelIface* key_model_gtk_tree_model_parent_iface = NULL;
static gpointer enum_model_parent_class = NULL;
static GtkTreeModelIface* enum_model_gtk_tree_model_parent_iface = NULL;
static gpointer settings_model_parent_class = NULL;
static GtkTreeModelIface* settings_model_gtk_tree_model_parent_iface = NULL;

GType key_get_type (void);
GType directory_get_type (void);
gpointer schema_key_ref (gpointer instance);
void schema_key_unref (gpointer instance);
GParamSpec* param_spec_schema_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_key (GValue* value, gpointer v_object);
void value_take_schema_key (GValue* value, gpointer v_object);
gpointer value_get_schema_key (const GValue* value);
GType schema_key_get_type (void);
GType settings_model_get_type (void);
#define KEY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEY, KeyPrivate))
enum  {
	KEY_DUMMY_PROPERTY,
	KEY_HAS_SCHEMA,
	KEY_TYPE_STRING,
	KEY_VALUE,
	KEY_IS_DEFAULT
};
gpointer schema_list_ref (gpointer instance);
void schema_list_unref (gpointer instance);
GParamSpec* param_spec_schema_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_list (GValue* value, gpointer v_object);
void value_take_schema_list (GValue* value, gpointer v_object);
gpointer value_get_schema_list (const GValue* value);
GType schema_list_get_type (void);
gpointer schema_ref (gpointer instance);
void schema_unref (gpointer instance);
GParamSpec* param_spec_schema (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema (GValue* value, gpointer v_object);
void value_take_schema (GValue* value, gpointer v_object);
gpointer value_get_schema (const GValue* value);
GType schema_get_type (void);
gpointer schema_enum_ref (gpointer instance);
void schema_enum_unref (gpointer instance);
GParamSpec* param_spec_schema_enum (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_enum (GValue* value, gpointer v_object);
void value_take_schema_enum (GValue* value, gpointer v_object);
gpointer value_get_schema_enum (const GValue* value);
GType schema_enum_get_type (void);
Key* key_new (SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name);
Key* key_construct (GType object_type, SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name);
static void key_update_value (Key* self);
gboolean key_get_has_schema (Key* self);
static void key_set_has_schema (Key* self, gboolean value);
const char* key_get_type_string (Key* self);
static void key_set_type_string (Key* self, const char* value);
GVariant* key_get_value (Key* self);
void key_set_value (Key* self, GVariant* value);
gboolean key_get_is_default (Key* self);
static void key_set_is_default (Key* self, gboolean value);
static void key_finalize (GObject* obj);
static void key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType key_model_get_type (void);
#define DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECTORY, DirectoryPrivate))
enum  {
	DIRECTORY_DUMMY_PROPERTY,
	DIRECTORY_KEY_MODEL,
	DIRECTORY_CHILDREN,
	DIRECTORY_KEYS
};
Directory* directory_new (SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name);
Directory* directory_construct (GType object_type, SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name);
Directory* directory_get_child (Directory* self, const char* name);
Key* directory_get_key (Directory* self, const char* name);
void directory_load_schema (Directory* self, Schema* schema, const char* path);
static void directory_update_children (Directory* self);
KeyModel* key_model_new (Directory* directory);
KeyModel* key_model_construct (GType object_type, Directory* directory);
KeyModel* directory_get_key_model (Directory* self);
static void directory_set_key_model (Directory* self, KeyModel* value);
GeeArrayList* directory_get_children (Directory* self);
static void directory_set_children (Directory* self, GeeArrayList* value);
GeeArrayList* directory_get_keys (Directory* self);
static void directory_set_keys (Directory* self, GeeArrayList* value);
static void directory_finalize (GObject* obj);
static void directory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void directory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define KEY_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEY_MODEL, KeyModelPrivate))
enum  {
	KEY_MODEL_DUMMY_PROPERTY
};
static GtkTreeModelFlags key_model_real_get_flags (GtkTreeModel* base);
static gint key_model_real_get_n_columns (GtkTreeModel* base);
static GType key_model_real_get_column_type (GtkTreeModel* base, gint index);
static void key_model_set_iter (KeyModel* self, GtkTreeIter* iter, Key* key);
Key* key_model_get_key (KeyModel* self, GtkTreeIter* iter);
static gboolean key_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* key_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void key_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean key_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean key_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean key_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint key_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean key_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean key_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void key_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void key_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static GObject * key_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void key_model_finalize (GObject* obj);
GType enum_model_get_type (void);
#define ENUM_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ENUM_MODEL, EnumModelPrivate))
enum  {
	ENUM_MODEL_DUMMY_PROPERTY
};
EnumModel* enum_model_new (SchemaEnum* schema_enum);
EnumModel* enum_model_construct (GType object_type, SchemaEnum* schema_enum);
static GtkTreeModelFlags enum_model_real_get_flags (GtkTreeModel* base);
static gint enum_model_real_get_n_columns (GtkTreeModel* base);
static GType enum_model_real_get_column_type (GtkTreeModel* base, gint index);
GType schema_enum_value_get_type (void);
static void enum_model_set_iter (EnumModel* self, GtkTreeIter* iter, SchemaEnumValue* value);
SchemaEnumValue* enum_model_get_enum_value (EnumModel* self, GtkTreeIter* iter);
static gboolean enum_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* enum_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void enum_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean enum_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean enum_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean enum_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint enum_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean enum_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean enum_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void enum_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void enum_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static GObject * enum_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void enum_model_finalize (GObject* obj);
#define SETTINGS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS_MODEL, SettingsModelPrivate))
enum  {
	SETTINGS_MODEL_DUMMY_PROPERTY
};
SchemaList* schema_list_new (void);
SchemaList* schema_list_construct (GType object_type);
void schema_list_load_directory (SchemaList* self, const char* dir, GError** error);
SettingsModel* settings_model_new (void);
SettingsModel* settings_model_construct (GType object_type);
static GtkTreeModelFlags settings_model_real_get_flags (GtkTreeModel* base);
static gint settings_model_real_get_n_columns (GtkTreeModel* base);
static GType settings_model_real_get_column_type (GtkTreeModel* base, gint index);
static void settings_model_set_iter (SettingsModel* self, GtkTreeIter* iter, Directory* directory);
Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter);
static gboolean settings_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* settings_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void settings_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean settings_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean settings_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean settings_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint settings_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean settings_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean settings_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void settings_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void settings_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static GObject * settings_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void settings_model_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Key* key_construct (GType object_type, SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name) {
	Key * self;
	SettingsModel* _tmp0_;
	Directory* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	SchemaKey* _tmp4_;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	self = (Key*) g_object_new (object_type, NULL);
	self->priv->model = (_tmp0_ = _g_object_ref0 (model), _g_object_unref0 (self->priv->model), _tmp0_);
	self->parent = (_tmp1_ = _g_object_ref0 (parent), _g_object_unref0 (self->parent), _tmp1_);
	self->index = index;
	self->name = (_tmp2_ = g_strdup (name), _g_free0 (self->name), _tmp2_);
	self->full_name = (_tmp3_ = g_strdup (full_name), _g_free0 (self->full_name), _tmp3_);
	self->schema = (_tmp4_ = (SchemaKey*) gee_abstract_map_get ((GeeAbstractMap*) model->schemas->keys, full_name), _schema_key_unref0 (self->schema), _tmp4_);
	return self;
}


Key* key_new (SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name) {
	return key_construct (TYPE_KEY, model, parent, index, name, full_name);
}


static void key_update_value (Key* self) {
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_value = (_tmp0_ = dconf_client_read (self->priv->model->client, self->full_name), _g_variant_unref0 (self->priv->_value), _tmp0_);
}


gboolean key_get_has_schema (Key* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->schema != NULL;
	return result;
}


static void key_set_has_schema (Key* self, gboolean value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "has-schema");
}


const char* key_get_type_string (Key* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_value != NULL) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (g_variant_is_of_type (self->priv->_value, G_VARIANT_TYPE_STRING)) {
			_tmp1_ = key_get_has_schema (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->schema->enum_name != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = "<enum>";
			return result;
		} else {
			result = g_variant_get_type_string (self->priv->_value);
			return result;
		}
	} else {
		result = self->schema->type;
		return result;
	}
}


static void key_set_type_string (Key* self, const char* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "type-string");
}


GVariant* key_get_value (Key* self) {
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	key_update_value (self);
	if (self->priv->_value != NULL) {
		result = self->priv->_value;
		return result;
	} else {
		result = self->schema->default_value;
		return result;
	}
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


void key_set_value (Key* self, GVariant* value) {
	GError * _inner_error_;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->_value = (_tmp0_ = _g_variant_ref0 (value), _g_variant_unref0 (self->priv->_value), _tmp0_);
	{
		dconf_client_write (self->priv->model->client, self->full_name, value, (guint64) 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "value");
}


gboolean key_get_is_default (Key* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	key_update_value (self);
	result = self->priv->_value == NULL;
	return result;
}


static void key_set_is_default (Key* self, gboolean value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "is-default");
}


static void key_class_init (KeyClass * klass) {
	key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KeyPrivate));
	G_OBJECT_CLASS (klass)->get_property = key_get_property;
	G_OBJECT_CLASS (klass)->set_property = key_set_property;
	G_OBJECT_CLASS (klass)->finalize = key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_HAS_SCHEMA, g_param_spec_boolean ("has-schema", "has-schema", "has-schema", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_TYPE_STRING, g_param_spec_string ("type-string", "type-string", "type-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_VALUE, g_param_spec_variant ("value", "value", "value", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_IS_DEFAULT, g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void key_instance_init (Key * self) {
	self->priv = KEY_GET_PRIVATE (self);
}


static void key_finalize (GObject* obj) {
	Key * self;
	self = KEY (obj);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->parent);
	_g_free0 (self->name);
	_g_free0 (self->full_name);
	_schema_key_unref0 (self->schema);
	_g_variant_unref0 (self->priv->_value);
	G_OBJECT_CLASS (key_parent_class)->finalize (obj);
}


GType key_get_type (void) {
	static volatile gsize key_type_id__volatile = 0;
	if (g_once_init_enter (&key_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Key), 0, (GInstanceInitFunc) key_instance_init, NULL };
		GType key_type_id;
		key_type_id = g_type_register_static (G_TYPE_OBJECT, "Key", &g_define_type_info, 0);
		g_once_init_leave (&key_type_id__volatile, key_type_id);
	}
	return key_type_id__volatile;
}


static void key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Key * self;
	self = KEY (object);
	switch (property_id) {
		case KEY_HAS_SCHEMA:
		g_value_set_boolean (value, key_get_has_schema (self));
		break;
		case KEY_TYPE_STRING:
		g_value_set_string (value, key_get_type_string (self));
		break;
		case KEY_VALUE:
		g_value_set_variant (value, key_get_value (self));
		break;
		case KEY_IS_DEFAULT:
		g_value_set_boolean (value, key_get_is_default (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Key * self;
	self = KEY (object);
	switch (property_id) {
		case KEY_HAS_SCHEMA:
		key_set_has_schema (self, g_value_get_boolean (value));
		break;
		case KEY_TYPE_STRING:
		key_set_type_string (self, g_value_get_string (value));
		break;
		case KEY_VALUE:
		key_set_value (self, g_value_get_variant (value));
		break;
		case KEY_IS_DEFAULT:
		key_set_is_default (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Directory* directory_construct (GType object_type, SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name) {
	Directory * self;
	SettingsModel* _tmp0_;
	Directory* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	self = (Directory*) g_object_new (object_type, NULL);
	self->priv->model = (_tmp0_ = _g_object_ref0 (model), _g_object_unref0 (self->priv->model), _tmp0_);
	self->parent = (_tmp1_ = _g_object_ref0 (parent), _g_object_unref0 (self->parent), _tmp1_);
	self->index = index;
	self->name = (_tmp2_ = g_strdup (name), _g_free0 (self->name), _tmp2_);
	self->full_name = (_tmp3_ = g_strdup (full_name), _g_free0 (self->full_name), _tmp3_);
	return self;
}


Directory* directory_new (SettingsModel* model, Directory* parent, gint index, const char* name, const char* full_name) {
	return directory_construct (TYPE_DIRECTORY, model, parent, index, name, full_name);
}


Directory* directory_get_child (Directory* self, const char* name) {
	Directory* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	Directory* _tmp2_;
	Directory* directory;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_abstract_map_has_key ((GeeAbstractMap*) self->_child_map, name)) {
		result = (Directory*) gee_abstract_map_get ((GeeAbstractMap*) self->_child_map, name);
		return result;
	}
	directory = (_tmp2_ = directory_new (self->priv->model, self, gee_collection_get_size ((GeeCollection*) self->_children), name, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat (self->full_name, name, NULL), "/", NULL)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->_children, directory);
	gee_abstract_map_set ((GeeAbstractMap*) self->_child_map, name, directory);
	result = directory;
	return result;
}


Key* directory_get_key (Directory* self, const char* name) {
	Key* result = NULL;
	char* _tmp0_;
	Key* _tmp1_;
	Key* key;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_abstract_map_has_key ((GeeAbstractMap*) self->_key_map, name)) {
		result = (Key*) gee_abstract_map_get ((GeeAbstractMap*) self->_key_map, name);
		return result;
	}
	key = (_tmp1_ = key_new (self->priv->model, self, gee_collection_get_size ((GeeCollection*) self->priv->_keys), name, _tmp0_ = g_strconcat (self->full_name, name, NULL)), _g_free0 (_tmp0_), _tmp1_);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_keys, key);
	gee_abstract_map_set ((GeeAbstractMap*) self->_key_map, name, key);
	result = key;
	return result;
}


void directory_load_schema (Directory* self, Schema* schema, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (path != NULL);
	if (_vala_strcmp0 (path, "") == 0) {
		{
			GeeCollection* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _schema_key_it;
			_schema_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) schema->keys))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				SchemaKey* schema_key;
				Key* _tmp2_;
				if (!gee_iterator_next (_schema_key_it)) {
					break;
				}
				schema_key = (SchemaKey*) gee_iterator_get (_schema_key_it);
				_tmp2_ = directory_get_key (self, schema_key->name);
				_g_object_unref0 (_tmp2_);
				_schema_key_unref0 (schema_key);
			}
			_g_object_unref0 (_schema_key_it);
		}
	} else {
		char** _tmp4_;
		gint _tokens_size_;
		gint tokens_length1;
		char** _tmp3_;
		char** tokens;
		char* name;
		Directory* directory;
		tokens = (_tmp4_ = _tmp3_ = g_strsplit (path, "/", 2), tokens_length1 = _vala_array_length (_tmp3_), _tokens_size_ = tokens_length1, _tmp4_);
		name = g_strdup (tokens[0]);
		directory = directory_get_child (self, name);
		directory_load_schema (directory, schema, tokens[1]);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (name);
		_g_object_unref0 (directory);
	}
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static void directory_update_children (Directory* self) {
	char** _tmp1_;
	gint _items_size_;
	gint items_length1;
	gsize _tmp0_;
	char** items;
	g_return_if_fail (self != NULL);
	if (self->priv->have_children) {
		return;
	}
	self->priv->have_children = TRUE;
	items = (_tmp1_ = dconf_client_list (self->priv->model->client, self->full_name, &_tmp0_), items_length1 = _tmp0_, _items_size_ = items_length1, _tmp1_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* item_name;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < items_length1)) {
					break;
				}
				item_name = g_strconcat (self->full_name, items[i], NULL);
				if (dconf_is_dir (item_name)) {
					char* dir_name;
					Directory* _tmp3_;
					dir_name = string_slice (items[i], (glong) 0, (glong) (-1));
					_tmp3_ = directory_get_child (self, dir_name);
					_g_object_unref0 (_tmp3_);
					_g_free0 (dir_name);
				} else {
					Key* _tmp4_;
					_tmp4_ = directory_get_key (self, items[i]);
					_g_object_unref0 (_tmp4_);
				}
				_g_free0 (item_name);
			}
		}
	}
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
}


KeyModel* directory_get_key_model (Directory* self) {
	KeyModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	directory_update_children (self);
	if (self->priv->_key_model == NULL) {
		KeyModel* _tmp0_;
		self->priv->_key_model = (_tmp0_ = key_model_new (self), _g_object_unref0 (self->priv->_key_model), _tmp0_);
	}
	result = self->priv->_key_model;
	return result;
}


static void directory_set_key_model (Directory* self, KeyModel* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "key-model");
}


GeeArrayList* directory_get_children (Directory* self) {
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	directory_update_children (self);
	result = self->_children;
	return result;
}


static void directory_set_children (Directory* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "children");
}


GeeArrayList* directory_get_keys (Directory* self) {
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	directory_update_children (self);
	result = self->priv->_keys;
	return result;
}


static void directory_set_keys (Directory* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "keys");
}


static void directory_class_init (DirectoryClass * klass) {
	directory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DirectoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = directory_get_property;
	G_OBJECT_CLASS (klass)->set_property = directory_set_property;
	G_OBJECT_CLASS (klass)->finalize = directory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_KEY_MODEL, g_param_spec_object ("key-model", "key-model", "key-model", TYPE_KEY_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_CHILDREN, g_param_spec_object ("children", "children", "children", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_KEYS, g_param_spec_object ("keys", "keys", "keys", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void directory_instance_init (Directory * self) {
	self->priv = DIRECTORY_GET_PRIVATE (self);
	self->_child_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_DIRECTORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->_children = gee_array_list_new (TYPE_DIRECTORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	self->_key_map = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->_keys = gee_array_list_new (TYPE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
}


static void directory_finalize (GObject* obj) {
	Directory * self;
	self = DIRECTORY (obj);
	_g_object_unref0 (self->priv->model);
	_g_free0 (self->name);
	_g_free0 (self->full_name);
	_g_object_unref0 (self->parent);
	_g_object_unref0 (self->priv->_key_model);
	_g_object_unref0 (self->_child_map);
	_g_object_unref0 (self->_children);
	_g_object_unref0 (self->_key_map);
	_g_object_unref0 (self->priv->_keys);
	G_OBJECT_CLASS (directory_parent_class)->finalize (obj);
}


GType directory_get_type (void) {
	static volatile gsize directory_type_id__volatile = 0;
	if (g_once_init_enter (&directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Directory), 0, (GInstanceInitFunc) directory_instance_init, NULL };
		GType directory_type_id;
		directory_type_id = g_type_register_static (G_TYPE_OBJECT, "Directory", &g_define_type_info, 0);
		g_once_init_leave (&directory_type_id__volatile, directory_type_id);
	}
	return directory_type_id__volatile;
}


static void directory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Directory * self;
	self = DIRECTORY (object);
	switch (property_id) {
		case DIRECTORY_KEY_MODEL:
		g_value_set_object (value, directory_get_key_model (self));
		break;
		case DIRECTORY_CHILDREN:
		g_value_set_object (value, directory_get_children (self));
		break;
		case DIRECTORY_KEYS:
		g_value_set_object (value, directory_get_keys (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void directory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Directory * self;
	self = DIRECTORY (object);
	switch (property_id) {
		case DIRECTORY_KEY_MODEL:
		directory_set_key_model (self, g_value_get_object (value));
		break;
		case DIRECTORY_CHILDREN:
		directory_set_children (self, g_value_get_object (value));
		break;
		case DIRECTORY_KEYS:
		directory_set_keys (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


KeyModel* key_model_construct (GType object_type, Directory* directory) {
	KeyModel * self;
	Directory* _tmp0_;
	g_return_val_if_fail (directory != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->directory = (_tmp0_ = _g_object_ref0 (directory), _g_object_unref0 (self->priv->directory), _tmp0_);
	return self;
}


KeyModel* key_model_new (Directory* directory) {
	return key_model_construct (TYPE_KEY_MODEL, directory);
}


static GtkTreeModelFlags key_model_real_get_flags (GtkTreeModel* base) {
	KeyModel * self;
	GtkTreeModelFlags result = 0;
	self = (KeyModel*) base;
	result = GTK_TREE_MODEL_LIST_ONLY;
	return result;
}


static gint key_model_real_get_n_columns (GtkTreeModel* base) {
	KeyModel * self;
	gint result = 0;
	self = (KeyModel*) base;
	result = 3;
	return result;
}


static GType key_model_real_get_column_type (GtkTreeModel* base, gint index) {
	KeyModel * self;
	GType result = 0UL;
	self = (KeyModel*) base;
	if (index == 0) {
		result = TYPE_KEY;
		return result;
	} else {
		result = G_TYPE_STRING;
		return result;
	}
}


static void key_model_set_iter (KeyModel* self, GtkTreeIter* iter, Key* key) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	(*iter).stamp = 0;
	(*iter).user_data = key;
	(*iter).user_data2 = key;
	(*iter).user_data3 = key;
}


Key* key_model_get_key (KeyModel* self, GtkTreeIter* iter) {
	Key* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (KEY ((*iter).user_data));
	return result;
}


static gboolean key_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	KeyModel * self;
	gboolean result = FALSE;
	self = (KeyModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (gtk_tree_path_get_depth (path) != 1) {
		result = FALSE;
		return result;
	}
	result = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, iter, NULL, gtk_tree_path_get_indices (path)[0]);
	return result;
}


static GtkTreePath* key_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path;
	Key* _tmp0_;
	self = (KeyModel*) base;
	path = gtk_tree_path_new ();
	gtk_tree_path_append_index (path, (_tmp0_ = key_model_get_key (self, iter))->index);
	_g_object_unref0 (_tmp0_);
	result = path;
	return result;
}


static void key_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	KeyModel * self;
	Key* key;
	self = (KeyModel*) base;
	key = key_model_get_key (self, iter);
	if (column == 0) {
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		*value = (_tmp1_ = (g_value_init (&_tmp0_, TYPE_KEY), g_value_set_object (&_tmp0_, key), _tmp0_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp1_);
	} else {
		if (column == 1) {
			GValue _tmp3_;
			GValue _tmp2_ = {0};
			*value = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, key->name), _tmp2_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp3_);
		} else {
			if (column == 2) {
				if (key_get_value (key) != NULL) {
					GValue _tmp5_;
					GValue _tmp4_ = {0};
					*value = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_take_string (&_tmp4_, g_variant_print (key_get_value (key), FALSE)), _tmp4_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp5_);
				} else {
					GValue _tmp7_;
					GValue _tmp6_ = {0};
					*value = (_tmp7_ = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, ""), _tmp6_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp7_);
				}
			} else {
				if (column == 4) {
					if (key_get_is_default (key)) {
						GValue _tmp9_;
						GValue _tmp8_ = {0};
						*value = (_tmp9_ = (g_value_init (&_tmp8_, PANGO_TYPE_WEIGHT), g_value_set_enum (&_tmp8_, PANGO_WEIGHT_NORMAL), _tmp8_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp9_);
					} else {
						GValue _tmp11_;
						GValue _tmp10_ = {0};
						*value = (_tmp11_ = (g_value_init (&_tmp10_, PANGO_TYPE_WEIGHT), g_value_set_enum (&_tmp10_, PANGO_WEIGHT_BOLD), _tmp10_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp11_);
					}
				}
			}
		}
	}
	_g_object_unref0 (key);
}


static gboolean key_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gboolean result = FALSE;
	Key* _tmp0_;
	gint _tmp1_;
	gint index;
	Key* _tmp2_;
	self = (KeyModel*) base;
	index = (_tmp1_ = (_tmp0_ = key_model_get_key (self, iter))->index, _g_object_unref0 (_tmp0_), _tmp1_);
	if (index >= (gee_collection_get_size ((GeeCollection*) directory_get_keys (self->priv->directory)) - 1)) {
		result = FALSE;
		return result;
	}
	key_model_set_iter (self, iter, _tmp2_ = (Key*) gee_abstract_list_get ((GeeAbstractList*) directory_get_keys (self->priv->directory), index + 1));
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean key_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	KeyModel * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Key* _tmp1_;
	self = (KeyModel*) base;
	if (parent != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gee_collection_get_size ((GeeCollection*) directory_get_keys (self->priv->directory)) == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	key_model_set_iter (self, iter, _tmp1_ = (Key*) gee_abstract_list_get ((GeeAbstractList*) directory_get_keys (self->priv->directory), 0));
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}


static gboolean key_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gboolean result = FALSE;
	self = (KeyModel*) base;
	result = FALSE;
	return result;
}


static gint key_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gint result = 0;
	self = (KeyModel*) base;
	if (iter == NULL) {
		result = gee_collection_get_size ((GeeCollection*) directory_get_keys (self->priv->directory));
		return result;
	} else {
		result = 0;
		return result;
	}
}


static gboolean key_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	KeyModel * self;
	gboolean result = FALSE;
	Key* _tmp0_;
	self = (KeyModel*) base;
	if (parent != NULL) {
		result = FALSE;
		return result;
	}
	if (n >= gee_collection_get_size ((GeeCollection*) directory_get_keys (self->priv->directory))) {
		result = FALSE;
		return result;
	}
	key_model_set_iter (self, iter, _tmp0_ = (Key*) gee_abstract_list_get ((GeeAbstractList*) directory_get_keys (self->priv->directory), n));
	_g_object_unref0 (_tmp0_);
	result = TRUE;
	return result;
}


static gboolean key_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	KeyModel * self;
	gboolean result = FALSE;
	self = (KeyModel*) base;
	result = FALSE;
	return result;
}


static void key_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	Key* _tmp0_;
	self = (KeyModel*) base;
	g_object_ref ((GObject*) (_tmp0_ = key_model_get_key (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static void key_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	Key* _tmp0_;
	self = (KeyModel*) base;
	g_object_unref ((GObject*) (_tmp0_ = key_model_get_key (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static GObject * key_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	KeyModel * self;
	parent_class = G_OBJECT_CLASS (key_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = KEY_MODEL (obj);
	{
	}
	return obj;
}


static void key_model_class_init (KeyModelClass * klass) {
	key_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KeyModelPrivate));
	G_OBJECT_CLASS (klass)->constructor = key_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = key_model_finalize;
}


static void key_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	key_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_flags = key_model_real_get_flags;
	iface->get_n_columns = key_model_real_get_n_columns;
	iface->get_column_type = key_model_real_get_column_type;
	iface->get_iter = key_model_real_get_iter;
	iface->get_path = key_model_real_get_path;
	iface->get_value = key_model_real_get_value;
	iface->iter_next = key_model_real_iter_next;
	iface->iter_children = key_model_real_iter_children;
	iface->iter_has_child = key_model_real_iter_has_child;
	iface->iter_n_children = key_model_real_iter_n_children;
	iface->iter_nth_child = key_model_real_iter_nth_child;
	iface->iter_parent = key_model_real_iter_parent;
	iface->ref_node = key_model_real_ref_node;
	iface->unref_node = key_model_real_unref_node;
}


static void key_model_instance_init (KeyModel * self) {
	self->priv = KEY_MODEL_GET_PRIVATE (self);
}


static void key_model_finalize (GObject* obj) {
	KeyModel * self;
	self = KEY_MODEL (obj);
	_g_object_unref0 (self->priv->directory);
	G_OBJECT_CLASS (key_model_parent_class)->finalize (obj);
}


GType key_model_get_type (void) {
	static volatile gsize key_model_type_id__volatile = 0;
	if (g_once_init_enter (&key_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyModel), 0, (GInstanceInitFunc) key_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) key_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType key_model_type_id;
		key_model_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyModel", &g_define_type_info, 0);
		g_type_add_interface_static (key_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&key_model_type_id__volatile, key_model_type_id);
	}
	return key_model_type_id__volatile;
}


static gpointer _schema_enum_ref0 (gpointer self) {
	return self ? schema_enum_ref (self) : NULL;
}


EnumModel* enum_model_construct (GType object_type, SchemaEnum* schema_enum) {
	EnumModel * self;
	SchemaEnum* _tmp0_;
	g_return_val_if_fail (schema_enum != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->schema_enum = (_tmp0_ = _schema_enum_ref0 (schema_enum), _schema_enum_unref0 (self->priv->schema_enum), _tmp0_);
	return self;
}


EnumModel* enum_model_new (SchemaEnum* schema_enum) {
	return enum_model_construct (TYPE_ENUM_MODEL, schema_enum);
}


static GtkTreeModelFlags enum_model_real_get_flags (GtkTreeModel* base) {
	EnumModel * self;
	GtkTreeModelFlags result = 0;
	self = (EnumModel*) base;
	result = GTK_TREE_MODEL_LIST_ONLY;
	return result;
}


static gint enum_model_real_get_n_columns (GtkTreeModel* base) {
	EnumModel * self;
	gint result = 0;
	self = (EnumModel*) base;
	result = 2;
	return result;
}


static GType enum_model_real_get_column_type (GtkTreeModel* base, gint index) {
	EnumModel * self;
	GType result = 0UL;
	self = (EnumModel*) base;
	if (index == 0) {
		result = G_TYPE_STRING;
		return result;
	} else {
		result = G_TYPE_INT;
		return result;
	}
}


static void enum_model_set_iter (EnumModel* self, GtkTreeIter* iter, SchemaEnumValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	(*iter).stamp = 0;
	(*iter).user_data = value;
	(*iter).user_data2 = value;
	(*iter).user_data3 = value;
}


SchemaEnumValue* enum_model_get_enum_value (EnumModel* self, GtkTreeIter* iter) {
	SchemaEnumValue* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (SCHEMA_ENUM_VALUE ((*iter).user_data));
	return result;
}


static gboolean enum_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	EnumModel * self;
	gboolean result = FALSE;
	self = (EnumModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (gtk_tree_path_get_depth (path) != 1) {
		result = FALSE;
		return result;
	}
	result = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, iter, NULL, gtk_tree_path_get_indices (path)[0]);
	return result;
}


static GtkTreePath* enum_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path;
	SchemaEnumValue* _tmp0_;
	self = (EnumModel*) base;
	path = gtk_tree_path_new ();
	gtk_tree_path_append_index (path, (_tmp0_ = enum_model_get_enum_value (self, iter))->index);
	_g_object_unref0 (_tmp0_);
	result = path;
	return result;
}


static void enum_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	EnumModel * self;
	self = (EnumModel*) base;
	if (column == 0) {
		GValue _tmp2_;
		GValue _tmp1_ = {0};
		SchemaEnumValue* _tmp0_;
		*value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, (_tmp0_ = enum_model_get_enum_value (self, iter))->nick), _tmp1_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp2_);
		_g_object_unref0 (_tmp0_);
	} else {
		if (column == 1) {
			GValue _tmp5_;
			GValue _tmp4_ = {0};
			SchemaEnumValue* _tmp3_;
			*value = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_INT), g_value_set_int (&_tmp4_, (_tmp3_ = enum_model_get_enum_value (self, iter))->value), _tmp4_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp5_);
			_g_object_unref0 (_tmp3_);
		}
	}
}


static gboolean enum_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gboolean result = FALSE;
	SchemaEnumValue* _tmp0_;
	gint _tmp1_;
	gint index;
	SchemaEnumValue* _tmp2_;
	self = (EnumModel*) base;
	index = (_tmp1_ = (_tmp0_ = enum_model_get_enum_value (self, iter))->index, _g_object_unref0 (_tmp0_), _tmp1_);
	if (index >= (gee_collection_get_size ((GeeCollection*) self->priv->schema_enum->values) - 1)) {
		result = FALSE;
		return result;
	}
	enum_model_set_iter (self, iter, _tmp2_ = (SchemaEnumValue*) gee_abstract_list_get ((GeeAbstractList*) self->priv->schema_enum->values, index + 1));
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean enum_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	EnumModel * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SchemaEnumValue* _tmp1_;
	self = (EnumModel*) base;
	if (parent != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->schema_enum->values) == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	enum_model_set_iter (self, iter, _tmp1_ = (SchemaEnumValue*) gee_abstract_list_get ((GeeAbstractList*) self->priv->schema_enum->values, 0));
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}


static gboolean enum_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gboolean result = FALSE;
	self = (EnumModel*) base;
	result = FALSE;
	return result;
}


static gint enum_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gint result = 0;
	self = (EnumModel*) base;
	if (iter == NULL) {
		result = gee_collection_get_size ((GeeCollection*) self->priv->schema_enum->values);
		return result;
	} else {
		result = 0;
		return result;
	}
}


static gboolean enum_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	EnumModel * self;
	gboolean result = FALSE;
	SchemaEnumValue* _tmp0_;
	self = (EnumModel*) base;
	if (parent != NULL) {
		result = FALSE;
		return result;
	}
	if (n >= gee_collection_get_size ((GeeCollection*) self->priv->schema_enum->values)) {
		result = FALSE;
		return result;
	}
	enum_model_set_iter (self, iter, _tmp0_ = (SchemaEnumValue*) gee_abstract_list_get ((GeeAbstractList*) self->priv->schema_enum->values, n));
	_g_object_unref0 (_tmp0_);
	result = TRUE;
	return result;
}


static gboolean enum_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	EnumModel * self;
	gboolean result = FALSE;
	self = (EnumModel*) base;
	result = FALSE;
	return result;
}


static void enum_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	SchemaEnumValue* _tmp0_;
	self = (EnumModel*) base;
	g_object_ref ((GObject*) (_tmp0_ = enum_model_get_enum_value (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static void enum_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	SchemaEnumValue* _tmp0_;
	self = (EnumModel*) base;
	g_object_unref ((GObject*) (_tmp0_ = enum_model_get_enum_value (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static GObject * enum_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	EnumModel * self;
	parent_class = G_OBJECT_CLASS (enum_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ENUM_MODEL (obj);
	{
	}
	return obj;
}


static void enum_model_class_init (EnumModelClass * klass) {
	enum_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EnumModelPrivate));
	G_OBJECT_CLASS (klass)->constructor = enum_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = enum_model_finalize;
}


static void enum_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	enum_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_flags = enum_model_real_get_flags;
	iface->get_n_columns = enum_model_real_get_n_columns;
	iface->get_column_type = enum_model_real_get_column_type;
	iface->get_iter = enum_model_real_get_iter;
	iface->get_path = enum_model_real_get_path;
	iface->get_value = enum_model_real_get_value;
	iface->iter_next = enum_model_real_iter_next;
	iface->iter_children = enum_model_real_iter_children;
	iface->iter_has_child = enum_model_real_iter_has_child;
	iface->iter_n_children = enum_model_real_iter_n_children;
	iface->iter_nth_child = enum_model_real_iter_nth_child;
	iface->iter_parent = enum_model_real_iter_parent;
	iface->ref_node = enum_model_real_ref_node;
	iface->unref_node = enum_model_real_unref_node;
}


static void enum_model_instance_init (EnumModel * self) {
	self->priv = ENUM_MODEL_GET_PRIVATE (self);
}


static void enum_model_finalize (GObject* obj) {
	EnumModel * self;
	self = ENUM_MODEL (obj);
	_schema_enum_unref0 (self->priv->schema_enum);
	G_OBJECT_CLASS (enum_model_parent_class)->finalize (obj);
}


GType enum_model_get_type (void) {
	static volatile gsize enum_model_type_id__volatile = 0;
	if (g_once_init_enter (&enum_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EnumModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enum_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnumModel), 0, (GInstanceInitFunc) enum_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) enum_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType enum_model_type_id;
		enum_model_type_id = g_type_register_static (G_TYPE_OBJECT, "EnumModel", &g_define_type_info, 0);
		g_type_add_interface_static (enum_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&enum_model_type_id__volatile, enum_model_type_id);
	}
	return enum_model_type_id__volatile;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


SettingsModel* settings_model_construct (GType object_type) {
	GError * _inner_error_;
	SettingsModel * self;
	DConfClient* _tmp0_;
	Directory* _tmp1_;
	SchemaList* _tmp2_;
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	self->client = (_tmp0_ = dconf_client_new ("", TRUE, NULL, NULL, NULL), _g_object_unref0 (self->client), _tmp0_);
	self->priv->root = (_tmp1_ = directory_new (self, NULL, 0, "/", "/"), _g_object_unref0 (self->priv->root), _tmp1_);
	self->schemas = (_tmp2_ = schema_list_new (), _schema_list_unref0 (self->schemas), _tmp2_);
	{
		schema_list_load_directory (self->schemas, "/usr/share/glib-2.0/schemas", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("dconf-model.vala:470: Failed to parse schemas: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GeeIterator* _schema_it;
		_schema_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->schemas->schemas);
		while (TRUE) {
			Schema* schema;
			char* _tmp3_;
			if (!gee_iterator_next (_schema_it)) {
				break;
			}
			schema = (Schema*) gee_iterator_get (_schema_it);
			directory_load_schema (self->priv->root, schema, _tmp3_ = string_slice (schema->path, (glong) 1, string_get_length (schema->path)));
			_g_free0 (_tmp3_);
			_schema_unref0 (schema);
		}
		_g_object_unref0 (_schema_it);
	}
	return self;
}


SettingsModel* settings_model_new (void) {
	return settings_model_construct (TYPE_SETTINGS_MODEL);
}


static GtkTreeModelFlags settings_model_real_get_flags (GtkTreeModel* base) {
	SettingsModel * self;
	GtkTreeModelFlags result = 0;
	self = (SettingsModel*) base;
	result = 0;
	return result;
}


static gint settings_model_real_get_n_columns (GtkTreeModel* base) {
	SettingsModel * self;
	gint result = 0;
	self = (SettingsModel*) base;
	result = 2;
	return result;
}


static GType settings_model_real_get_column_type (GtkTreeModel* base, gint index) {
	SettingsModel * self;
	GType result = 0UL;
	self = (SettingsModel*) base;
	if (index == 0) {
		result = TYPE_DIRECTORY;
		return result;
	} else {
		result = G_TYPE_STRING;
		return result;
	}
}


static void settings_model_set_iter (SettingsModel* self, GtkTreeIter* iter, Directory* directory) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	(*iter).stamp = 0;
	(*iter).user_data = directory;
	(*iter).user_data2 = directory;
	(*iter).user_data3 = directory;
}


Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter) {
	Directory* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (iter == NULL) {
		result = _g_object_ref0 (self->priv->root);
		return result;
	} else {
		result = _g_object_ref0 (DIRECTORY ((*iter).user_data));
		return result;
	}
}


static gboolean settings_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	SettingsModel * self;
	gboolean result = FALSE;
	self = (SettingsModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (!gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, iter, NULL, gtk_tree_path_get_indices (path)[0])) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter parent;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < gtk_tree_path_get_depth (path))) {
					break;
				}
				parent = *iter;
				if (!gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, iter, &parent, gtk_tree_path_get_indices (path)[i])) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static GtkTreePath* settings_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	path = gtk_tree_path_new ();
	gtk_tree_path_append_index (path, (_tmp0_ = settings_model_get_directory (self, iter))->index);
	_g_object_unref0 (_tmp0_);
	result = path;
	return result;
}


static void settings_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	SettingsModel * self;
	self = (SettingsModel*) base;
	if (column == 0) {
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		*value = (_tmp1_ = (g_value_init (&_tmp0_, TYPE_DIRECTORY), g_value_take_object (&_tmp0_, settings_model_get_directory (self, iter)), _tmp0_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp1_);
	} else {
		GValue _tmp4_;
		GValue _tmp3_ = {0};
		Directory* _tmp2_;
		*value = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_STRING), g_value_set_string (&_tmp3_, (_tmp2_ = settings_model_get_directory (self, iter))->name), _tmp3_), G_IS_VALUE (value) ? (g_value_unset (value), NULL) : NULL, _tmp4_);
		_g_object_unref0 (_tmp2_);
	}
}


static gboolean settings_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* directory;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	directory = settings_model_get_directory (self, iter);
	if (directory->index >= (gee_collection_get_size ((GeeCollection*) directory_get_children (directory->parent)) - 1)) {
		result = FALSE;
		_g_object_unref0 (directory);
		return result;
	}
	settings_model_set_iter (self, iter, _tmp0_ = (Directory*) gee_abstract_list_get ((GeeAbstractList*) directory_get_children (directory->parent), directory->index + 1));
	_g_object_unref0 (_tmp0_);
	result = TRUE;
	_g_object_unref0 (directory);
	return result;
}


static gboolean settings_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* directory;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	directory = settings_model_get_directory (self, parent);
	if (gee_collection_get_size ((GeeCollection*) directory_get_children (directory)) == 0) {
		result = FALSE;
		_g_object_unref0 (directory);
		return result;
	}
	settings_model_set_iter (self, iter, _tmp0_ = (Directory*) gee_abstract_list_get ((GeeAbstractList*) directory_get_children (directory), 0));
	_g_object_unref0 (_tmp0_);
	result = TRUE;
	_g_object_unref0 (directory);
	return result;
}


static gboolean settings_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* _tmp0_;
	gboolean _tmp1_;
	self = (SettingsModel*) base;
	result = (_tmp1_ = gee_collection_get_size ((GeeCollection*) directory_get_children (_tmp0_ = settings_model_get_directory (self, iter))) > 0, _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


static gint settings_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gint result = 0;
	Directory* _tmp0_;
	gint _tmp1_;
	self = (SettingsModel*) base;
	result = (_tmp1_ = gee_collection_get_size ((GeeCollection*) directory_get_children (_tmp0_ = settings_model_get_directory (self, iter))), _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean settings_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* directory;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	directory = settings_model_get_directory (self, parent);
	if (n >= gee_collection_get_size ((GeeCollection*) directory_get_children (directory))) {
		result = FALSE;
		_g_object_unref0 (directory);
		return result;
	}
	settings_model_set_iter (self, iter, _tmp0_ = (Directory*) gee_abstract_list_get ((GeeAbstractList*) directory_get_children (directory), n));
	_g_object_unref0 (_tmp0_);
	result = TRUE;
	_g_object_unref0 (directory);
	return result;
}


static gboolean settings_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* directory;
	self = (SettingsModel*) base;
	directory = settings_model_get_directory (self, child);
	if (directory->parent == self->priv->root) {
		result = FALSE;
		_g_object_unref0 (directory);
		return result;
	}
	settings_model_set_iter (self, iter, directory->parent);
	result = TRUE;
	_g_object_unref0 (directory);
	return result;
}


static void settings_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	g_object_ref ((GObject*) (_tmp0_ = settings_model_get_directory (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static void settings_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	Directory* _tmp0_;
	self = (SettingsModel*) base;
	g_object_unref ((GObject*) (_tmp0_ = settings_model_get_directory (self, iter)));
	_g_object_unref0 (_tmp0_);
}


static GObject * settings_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SettingsModel * self;
	parent_class = G_OBJECT_CLASS (settings_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SETTINGS_MODEL (obj);
	{
	}
	return obj;
}


static void settings_model_class_init (SettingsModelClass * klass) {
	settings_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsModelPrivate));
	G_OBJECT_CLASS (klass)->constructor = settings_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_model_finalize;
}


static void settings_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	settings_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_flags = settings_model_real_get_flags;
	iface->get_n_columns = settings_model_real_get_n_columns;
	iface->get_column_type = settings_model_real_get_column_type;
	iface->get_iter = settings_model_real_get_iter;
	iface->get_path = settings_model_real_get_path;
	iface->get_value = settings_model_real_get_value;
	iface->iter_next = settings_model_real_iter_next;
	iface->iter_children = settings_model_real_iter_children;
	iface->iter_has_child = settings_model_real_iter_has_child;
	iface->iter_n_children = settings_model_real_iter_n_children;
	iface->iter_nth_child = settings_model_real_iter_nth_child;
	iface->iter_parent = settings_model_real_iter_parent;
	iface->ref_node = settings_model_real_ref_node;
	iface->unref_node = settings_model_real_unref_node;
}


static void settings_model_instance_init (SettingsModel * self) {
	self->priv = SETTINGS_MODEL_GET_PRIVATE (self);
}


static void settings_model_finalize (GObject* obj) {
	SettingsModel * self;
	self = SETTINGS_MODEL (obj);
	_schema_list_unref0 (self->schemas);
	_g_object_unref0 (self->client);
	_g_object_unref0 (self->priv->root);
	G_OBJECT_CLASS (settings_model_parent_class)->finalize (obj);
}


GType settings_model_get_type (void) {
	static volatile gsize settings_model_type_id__volatile = 0;
	if (g_once_init_enter (&settings_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsModel), 0, (GInstanceInitFunc) settings_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) settings_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType settings_model_type_id;
		settings_model_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsModel", &g_define_type_info, 0);
		g_type_add_interface_static (settings_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&settings_model_type_id__volatile, settings_model_type_id);
	}
	return settings_model_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




