/* rygel-media-export-metadata-extractor.c generated by valac, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <rygel.h>


#define GST_TYPE_STREAM_TYPE (gst_stream_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_tag_list_free0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_free (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

typedef enum  {
	GST_STREAM_TYPE_UNKNOWN = 0,
	GST_STREAM_TYPE_AUDIO = 1,
	GST_STREAM_TYPE_VIDEO = 2,
	GST_STREAM_TYPE_TEXT = 3,
	GST_STREAM_TYPE_SUBPICTURE = 4,
	GST_STREAM_TYPE_ELEMENT = 5
} GstStreamType;

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GstElement* playbin;
	GstTagList* tag_list;
	GQueue* file_queue;
	guint timeout_id;
};

struct _Block13Data {
	int _ref_count_;
	RygelMediaExportMetadataExtractor * self;
	GError* _error_;
};


static GstElementFactory* rygel_media_export_metadata_extractor_factory;
static GstElementFactory* rygel_media_export_metadata_extractor_factory = NULL;
static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType gst_stream_type_get_type (void);
GType rygel_media_export_metadata_extractor_get_type (void);
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE "rygel-size"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME "rygel-mime"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS "rygel-channels"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE "rygel-rate"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH "rygel-width"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT "rygel-height"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH "rygel-depth"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME "rygel-mtime"
static void _gst_tag_merge_use_first_gst_tag_merge_func (GValue* dest, GValue* src);
static void rygel_media_export_metadata_extractor_register_custom_tag (const char* tag, GType type);
static inline void _dynamic_set_video_sink0 (GstElement* obj, GstElement* value);
static inline void _dynamic_set_audio_sink1 (GstElement* obj, GstElement* value);
static void rygel_media_export_metadata_extractor_tag_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_element_message_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_element_message_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_state_changed_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_error_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_error_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_renew_playbin (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_create_playbin_factory (RygelMediaExportMetadataExtractor* self);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
static void rygel_media_export_metadata_extractor_extract_next (RygelMediaExportMetadataExtractor* self);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static gboolean rygel_media_export_metadata_extractor_on_harvesting_timeout (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_mime_and_size (RygelMediaExportMetadataExtractor* self, GError** error);
static inline void _dynamic_set_uri2 (GstElement* obj, char* value);
static gboolean _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func (gpointer self);
static gboolean _lambda12_ (RygelMediaExportMetadataExtractor* self);
static gboolean __lambda12__gsource_func (gpointer self);
static gboolean _lambda13_ (Block13Data* _data13_);
static gboolean __lambda13__gsource_func (gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void rygel_media_export_metadata_extractor_extract_duration (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_stream_info (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_av_info (RygelMediaExportMetadataExtractor* self, GstPad* pad, GstStreamType type);
static inline GstElement* _dynamic_get_video_sink3 (GstElement* obj);
static inline GstElement* _dynamic_get_audio_sink4 (GstElement* obj);
static void rygel_media_export_metadata_extractor_extract_audio_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure);
static void rygel_media_export_metadata_extractor_extract_video_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure);
static void rygel_media_export_metadata_extractor_extract_int_value (RygelMediaExportMetadataExtractor* self, const GstStructure* structure, const char* key, const char* tag);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType gst_stream_type_get_type (void) {
	static volatile gsize gst_stream_type_type_id__volatile = 0;
	if (g_once_init_enter (&gst_stream_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GST_STREAM_TYPE_UNKNOWN, "GST_STREAM_TYPE_UNKNOWN", "unknown"}, {GST_STREAM_TYPE_AUDIO, "GST_STREAM_TYPE_AUDIO", "audio"}, {GST_STREAM_TYPE_VIDEO, "GST_STREAM_TYPE_VIDEO", "video"}, {GST_STREAM_TYPE_TEXT, "GST_STREAM_TYPE_TEXT", "text"}, {GST_STREAM_TYPE_SUBPICTURE, "GST_STREAM_TYPE_SUBPICTURE", "subpicture"}, {GST_STREAM_TYPE_ELEMENT, "GST_STREAM_TYPE_ELEMENT", "element"}, {0, NULL, NULL}};
		GType gst_stream_type_type_id;
		gst_stream_type_type_id = g_enum_register_static ("GstStreamType", values);
		g_once_init_leave (&gst_stream_type_type_id__volatile, gst_stream_type_type_id);
	}
	return gst_stream_type_type_id__volatile;
}


#line 2714 "gstreamer-0.10.vapi"
static void _gst_tag_merge_use_first_gst_tag_merge_func (GValue* dest, GValue* src) {
#line 166 "rygel-media-export-metadata-extractor.c"
	gst_tag_merge_use_first (dest, src);
}


#line 72 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_register_custom_tag (const char* tag, GType type) {
#line 72 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (tag != NULL);
#line 73 "rygel-media-export-metadata-extractor.vala"
	gst_tag_register (tag, GST_TAG_FLAG_META, type, tag, "", _gst_tag_merge_use_first_gst_tag_merge_func);
#line 177 "rygel-media-export-metadata-extractor.c"
}


static inline void _dynamic_set_video_sink0 (GstElement* obj, GstElement* value) {
	g_object_set (obj, "video-sink", value, NULL);
}


static inline void _dynamic_set_audio_sink1 (GstElement* obj, GstElement* value) {
	g_object_set (obj, "audio-sink", value, NULL);
}


#line 226 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 193 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_tag_cb (self, _sender, message);
}


#line 235 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_element_message_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 200 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_element_message_cb (self, _sender, message);
}


#line 254 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 207 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_state_changed_cb (self, _sender, message);
}


#line 277 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_error_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 214 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_error_cb (self, _sender, message);
}


#line 81 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_renew_playbin (RygelMediaExportMetadataExtractor* self) {
#line 81 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 82 "rygel-media-export-metadata-extractor.vala"
	if (rygel_media_export_metadata_extractor_factory != NULL) {
#line 225 "rygel-media-export-metadata-extractor.c"
		GstElement* _tmp0_;
		GstElement* sink;
		GstObject* _tmp1_;
		GstElement* _tmp2_;
		GstObject* _tmp3_;
		GstBus* bus;
#line 84 "rygel-media-export-metadata-extractor.vala"
		self->priv->playbin = (_tmp0_ = gst_element_factory_create (rygel_media_export_metadata_extractor_factory, "tag_reader"), _gst_object_unref0 (self->priv->playbin), _tmp0_);
#line 88 "rygel-media-export-metadata-extractor.vala"
		sink = gst_element_factory_make ("fakesink", NULL);
#line 89 "rygel-media-export-metadata-extractor.vala"
		_tmp1_ = gst_object_ref ((GstObject*) sink);
#line 238 "rygel-media-export-metadata-extractor.c"
		_gst_object_unref0 (_tmp1_);
#line 90 "rygel-media-export-metadata-extractor.vala"
		_dynamic_set_video_sink0 (self->priv->playbin, sink);
#line 92 "rygel-media-export-metadata-extractor.vala"
		sink = (_tmp2_ = gst_element_factory_make ("fakesink", NULL), _gst_object_unref0 (sink), _tmp2_);
#line 93 "rygel-media-export-metadata-extractor.vala"
		_tmp3_ = gst_object_ref ((GstObject*) sink);
#line 246 "rygel-media-export-metadata-extractor.c"
		_gst_object_unref0 (_tmp3_);
#line 94 "rygel-media-export-metadata-extractor.vala"
		_dynamic_set_audio_sink1 (self->priv->playbin, sink);
#line 96 "rygel-media-export-metadata-extractor.vala"
		bus = gst_element_get_bus (self->priv->playbin);
#line 97 "rygel-media-export-metadata-extractor.vala"
		gst_bus_add_signal_watch (bus);
#line 98 "rygel-media-export-metadata-extractor.vala"
		g_signal_connect_object (bus, "message::tag", (GCallback) _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message, self, 0);
#line 99 "rygel-media-export-metadata-extractor.vala"
		if (_vala_strcmp0 (g_type_name (gst_element_factory_get_element_type (rygel_media_export_metadata_extractor_factory)), "GstPlayBin2") == 0) {
#line 100 "rygel-media-export-metadata-extractor.vala"
			g_signal_connect_object (bus, "message::element", (GCallback) _rygel_media_export_metadata_extractor_element_message_cb_gst_bus_message, self, 0);
#line 260 "rygel-media-export-metadata-extractor.c"
		} else {
#line 102 "rygel-media-export-metadata-extractor.vala"
			g_signal_connect_object (bus, "message::state-changed", (GCallback) _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message, self, 0);
#line 264 "rygel-media-export-metadata-extractor.c"
		}
#line 104 "rygel-media-export-metadata-extractor.vala"
		g_signal_connect_object (bus, "message::error", (GCallback) _rygel_media_export_metadata_extractor_error_cb_gst_bus_message, self, 0);
#line 268 "rygel-media-export-metadata-extractor.c"
		_gst_object_unref0 (sink);
		_gst_object_unref0 (bus);
	}
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 108 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_create_playbin_factory (RygelMediaExportMetadataExtractor* self) {
#line 282 "rygel-media-export-metadata-extractor.c"
	GstElementFactory* factory;
	GstElementFactory* _tmp3_;
#line 108 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 109 "rygel-media-export-metadata-extractor.vala"
	g_debug ("rygel-media-export-metadata-extractor.vala:109: Checking for gstreamer" \
" element 'playbin'...");
#line 110 "rygel-media-export-metadata-extractor.vala"
	factory = gst_element_factory_find ("playbin2");
#line 111 "rygel-media-export-metadata-extractor.vala"
	if (factory != NULL) {
#line 112 "rygel-media-export-metadata-extractor.vala"
		g_debug ("rygel-media-export-metadata-extractor.vala:112: %s", _ ("Using playbin2"));
#line 295 "rygel-media-export-metadata-extractor.c"
	} else {
		GstElementFactory* _tmp0_;
#line 114 "rygel-media-export-metadata-extractor.vala"
		g_debug ("rygel-media-export-metadata-extractor.vala:114: %s", _ ("Could not create Playbin2, trying Playbin"));
#line 115 "rygel-media-export-metadata-extractor.vala"
		factory = (_tmp0_ = gst_element_factory_find ("playbin"), _gst_object_unref0 (factory), _tmp0_);
#line 117 "rygel-media-export-metadata-extractor.vala"
		if (factory != NULL) {
#line 118 "rygel-media-export-metadata-extractor.vala"
			g_debug ("rygel-media-export-metadata-extractor.vala:118: %s", _ ("Using playbin"));
#line 306 "rygel-media-export-metadata-extractor.c"
		} else {
			char* _tmp2_;
			char* _tmp1_;
#line 120 "rygel-media-export-metadata-extractor.vala"
			g_warning ("rygel-media-export-metadata-extractor.vala:120: %s", _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_ ("Could not find any playbin."), " ", NULL), _ ("Please check your gstreamer setup"), NULL));
#line 312 "rygel-media-export-metadata-extractor.c"
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
	}
#line 124 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_factory = (_tmp3_ = _gst_object_ref0 (factory), _gst_object_unref0 (rygel_media_export_metadata_extractor_factory), _tmp3_);
#line 319 "rygel-media-export-metadata-extractor.c"
	_gst_object_unref0 (factory);
}


#line 127 "rygel-media-export-metadata-extractor.vala"
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
#line 326 "rygel-media-export-metadata-extractor.c"
	GError * _inner_error_;
	RygelMediaExportMetadataExtractor * self;
	GQueue* _tmp0_;
	GstTagList* _tmp1_;
	RygelMetaConfig* config;
	gboolean extract_metadata = FALSE;
	gboolean _tmp3_ = FALSE;
	_inner_error_ = NULL;
#line 127 "rygel-media-export-metadata-extractor.vala"
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
#line 128 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE, G_TYPE_INT64);
#line 129 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, G_TYPE_STRING);
#line 130 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS, G_TYPE_INT);
#line 131 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE, G_TYPE_INT);
#line 132 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH, G_TYPE_INT);
#line 133 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT, G_TYPE_INT);
#line 134 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH, G_TYPE_INT);
#line 135 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME, G_TYPE_UINT64);
#line 137 "rygel-media-export-metadata-extractor.vala"
	self->priv->file_queue = (_tmp0_ = g_queue_new (), _g_queue_free0 (self->priv->file_queue), _tmp0_);
#line 138 "rygel-media-export-metadata-extractor.vala"
	self->priv->tag_list = (_tmp1_ = gst_tag_list_new (), _gst_tag_list_free0 (self->priv->tag_list), _tmp1_);
#line 140 "rygel-media-export-metadata-extractor.vala"
	config = rygel_meta_config_get_default ();
#line 359 "rygel-media-export-metadata-extractor.c"
	{
		gboolean _tmp2_;
#line 144 "rygel-media-export-metadata-extractor.vala"
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "extract-metadata", &_inner_error_);
#line 364 "rygel-media-export-metadata-extractor.c"
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
#line 144 "rygel-media-export-metadata-extractor.vala"
		extract_metadata = _tmp2_;
#line 370 "rygel-media-export-metadata-extractor.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 147 "rygel-media-export-metadata-extractor.vala"
			extract_metadata = FALSE;
#line 381 "rygel-media-export-metadata-extractor.c"
			_g_error_free0 (_error_);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 151 "rygel-media-export-metadata-extractor.vala"
	if (extract_metadata) {
#line 151 "rygel-media-export-metadata-extractor.vala"
		_tmp3_ = rygel_media_export_metadata_extractor_factory == NULL;
#line 396 "rygel-media-export-metadata-extractor.c"
	} else {
#line 151 "rygel-media-export-metadata-extractor.vala"
		_tmp3_ = FALSE;
#line 400 "rygel-media-export-metadata-extractor.c"
	}
#line 151 "rygel-media-export-metadata-extractor.vala"
	if (_tmp3_) {
#line 152 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_create_playbin_factory (self);
#line 406 "rygel-media-export-metadata-extractor.c"
	}
	_g_object_unref0 (config);
	return self;
}


#line 127 "rygel-media-export-metadata-extractor.vala"
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
#line 127 "rygel-media-export-metadata-extractor.vala"
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
#line 417 "rygel-media-export-metadata-extractor.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 156 "rygel-media-export-metadata-extractor.vala"
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file) {
#line 428 "rygel-media-export-metadata-extractor.c"
	gboolean trigger_run;
#line 156 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 156 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (file != NULL);
#line 157 "rygel-media-export-metadata-extractor.vala"
	trigger_run = g_queue_get_length (self->priv->file_queue) == 0;
#line 158 "rygel-media-export-metadata-extractor.vala"
	g_queue_push_tail (self->priv->file_queue, _g_object_ref0 (file));
#line 159 "rygel-media-export-metadata-extractor.vala"
	if (trigger_run) {
#line 160 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_next (self);
#line 442 "rygel-media-export-metadata-extractor.c"
	}
}


#line 164 "rygel-media-export-metadata-extractor.vala"
static gboolean rygel_media_export_metadata_extractor_on_harvesting_timeout (RygelMediaExportMetadataExtractor* self) {
#line 449 "rygel-media-export-metadata-extractor.c"
	gboolean result = FALSE;
	char* _tmp0_;
	char* message;
	GError* _tmp1_;
	GFile* _tmp2_;
#line 164 "rygel-media-export-metadata-extractor.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 165 "rygel-media-export-metadata-extractor.vala"
	g_warning (_ ("Metadata extractor timed out on %s, restarting"), _tmp0_ = g_file_get_uri ((GFile*) g_queue_peek_head (self->priv->file_queue)));
#line 459 "rygel-media-export-metadata-extractor.c"
	_g_free0 (_tmp0_);
#line 167 "rygel-media-export-metadata-extractor.vala"
	gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 169 "rygel-media-export-metadata-extractor.vala"
	message = g_strdup (_ ("Pipeline stuck while reading file info"));
#line 170 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "error", (GFile*) g_queue_peek_head (self->priv->file_queue), _tmp1_ = g_error_new_literal (G_IO_CHANNEL_ERROR, G_IO_CHANNEL_ERROR_FAILED, message));
#line 467 "rygel-media-export-metadata-extractor.c"
	_g_error_free0 (_tmp1_);
#line 172 "rygel-media-export-metadata-extractor.vala"
	_tmp2_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 471 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp2_);
#line 173 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 475 "rygel-media-export-metadata-extractor.c"
	result = FALSE;
	_g_free0 (message);
#line 175 "rygel-media-export-metadata-extractor.vala"
	return result;
#line 480 "rygel-media-export-metadata-extractor.c"
}


static inline void _dynamic_set_uri2 (GstElement* obj, char* value) {
	g_object_set (obj, "uri", value, NULL);
}


#line 164 "rygel-media-export-metadata-extractor.vala"
static gboolean _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func (gpointer self) {
#line 491 "rygel-media-export-metadata-extractor.c"
	gboolean result;
	result = rygel_media_export_metadata_extractor_on_harvesting_timeout (self);
	return result;
}


#line 199 "rygel-media-export-metadata-extractor.vala"
static gboolean _lambda12_ (RygelMediaExportMetadataExtractor* self) {
#line 500 "rygel-media-export-metadata-extractor.c"
	gboolean result = FALSE;
	GFile* _tmp0_;
#line 200 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "extraction-done", _tmp0_ = (GFile*) g_queue_pop_head (self->priv->file_queue), self->priv->tag_list);
#line 505 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp0_);
#line 202 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 509 "rygel-media-export-metadata-extractor.c"
	result = FALSE;
#line 204 "rygel-media-export-metadata-extractor.vala"
	return result;
#line 513 "rygel-media-export-metadata-extractor.c"
}


#line 199 "rygel-media-export-metadata-extractor.vala"
static gboolean __lambda12__gsource_func (gpointer self) {
#line 519 "rygel-media-export-metadata-extractor.c"
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


#line 215 "rygel-media-export-metadata-extractor.vala"
static gboolean _lambda13_ (Block13Data* _data13_) {
#line 528 "rygel-media-export-metadata-extractor.c"
	RygelMediaExportMetadataExtractor * self;
	gboolean result = FALSE;
	GFile* _tmp0_;
	self = _data13_->self;
#line 216 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "error", _tmp0_ = (GFile*) g_queue_pop_head (self->priv->file_queue), _data13_->_error_);
#line 535 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp0_);
#line 217 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 539 "rygel-media-export-metadata-extractor.c"
	result = FALSE;
#line 219 "rygel-media-export-metadata-extractor.vala"
	return result;
#line 543 "rygel-media-export-metadata-extractor.c"
}


#line 215 "rygel-media-export-metadata-extractor.vala"
static gboolean __lambda13__gsource_func (gpointer self) {
#line 549 "rygel-media-export-metadata-extractor.c"
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	++_data13_->_ref_count_;
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if ((--_data13_->_ref_count_) == 0) {
		_g_object_unref0 (_data13_->self);
		_g_error_free0 (_data13_->_error_);
		g_slice_free (Block13Data, _data13_);
	}
}


#line 178 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_next (RygelMediaExportMetadataExtractor* self) {
#line 573 "rygel-media-export-metadata-extractor.c"
	GError * _inner_error_;
#line 178 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 577 "rygel-media-export-metadata-extractor.c"
	_inner_error_ = NULL;
#line 179 "rygel-media-export-metadata-extractor.vala"
	if (self->priv->timeout_id != 0) {
#line 180 "rygel-media-export-metadata-extractor.vala"
		g_source_remove (self->priv->timeout_id);
#line 583 "rygel-media-export-metadata-extractor.c"
	}
#line 183 "rygel-media-export-metadata-extractor.vala"
	if (g_queue_get_length (self->priv->file_queue) > 0) {
#line 587 "rygel-media-export-metadata-extractor.c"
		GstTagList* _tmp0_;
		GFile* item;
#line 184 "rygel-media-export-metadata-extractor.vala"
		self->priv->tag_list = (_tmp0_ = gst_tag_list_new (), _gst_tag_list_free0 (self->priv->tag_list), _tmp0_);
#line 185 "rygel-media-export-metadata-extractor.vala"
		item = _g_object_ref0 ((GFile*) g_queue_peek_head (self->priv->file_queue));
#line 594 "rygel-media-export-metadata-extractor.c"
		{
			char* _tmp1_;
#line 187 "rygel-media-export-metadata-extractor.vala"
			g_debug (_ ("Scheduling file %s for metadata extraction"), _tmp1_ = g_file_get_uri (item));
#line 599 "rygel-media-export-metadata-extractor.c"
			_g_free0 (_tmp1_);
#line 189 "rygel-media-export-metadata-extractor.vala"
			rygel_media_export_metadata_extractor_extract_mime_and_size (self, &_inner_error_);
#line 603 "rygel-media-export-metadata-extractor.c"
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
#line 190 "rygel-media-export-metadata-extractor.vala"
			if (rygel_media_export_metadata_extractor_factory != NULL) {
#line 609 "rygel-media-export-metadata-extractor.c"
				char* _tmp2_;
#line 191 "rygel-media-export-metadata-extractor.vala"
				rygel_media_export_metadata_extractor_renew_playbin (self);
#line 192 "rygel-media-export-metadata-extractor.vala"
				_dynamic_set_uri2 (self->priv->playbin, _tmp2_ = g_file_get_uri (item));
#line 615 "rygel-media-export-metadata-extractor.c"
				_g_free0 (_tmp2_);
#line 193 "rygel-media-export-metadata-extractor.vala"
				self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 197 "rygel-media-export-metadata-extractor.vala"
				gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
#line 621 "rygel-media-export-metadata-extractor.c"
			} else {
#line 199 "rygel-media-export-metadata-extractor.vala"
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda12__gsource_func, g_object_ref (self), g_object_unref);
#line 625 "rygel-media-export-metadata-extractor.c"
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				Block13Data* _data13_;
				char* _tmp3_;
				_data13_ = g_slice_new0 (Block13Data);
				_data13_->_ref_count_ = 1;
				_data13_->self = g_object_ref (self);
#line 210 "rygel-media-export-metadata-extractor.vala"
				g_warning (_ ("Failed to extract metadata from %s: %s"), _tmp3_ = g_file_get_uri (item), _data13_->_error_->message);
#line 642 "rygel-media-export-metadata-extractor.c"
				_g_free0 (_tmp3_);
#line 215 "rygel-media-export-metadata-extractor.vala"
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda13__gsource_func, block13_data_ref (_data13_), block13_data_unref);
#line 646 "rygel-media-export-metadata-extractor.c"
				block13_data_unref (_data13_);
			}
		}
		__finally13:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (item);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (item);
	}
}


#line 226 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_tag_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 664 "rygel-media-export-metadata-extractor.c"
	GstTagList* new_tag_list;
	GstTagList* _tmp1_;
	GstTagList* _tmp0_ = NULL;
	GstTagList* _tmp2_;
#line 226 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 226 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 226 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 675 "rygel-media-export-metadata-extractor.c"
	new_tag_list = NULL;
#line 230 "rygel-media-export-metadata-extractor.vala"
	gst_message_parse_tag (message, &_tmp0_);
#line 230 "rygel-media-export-metadata-extractor.vala"
	new_tag_list = (_tmp1_ = _tmp0_, _gst_tag_list_free0 (new_tag_list), _tmp1_);
#line 231 "rygel-media-export-metadata-extractor.vala"
	self->priv->tag_list = (_tmp2_ = gst_tag_list_merge (new_tag_list, self->priv->tag_list, GST_TAG_MERGE_REPLACE), _gst_tag_list_free0 (self->priv->tag_list), _tmp2_);
#line 683 "rygel-media-export-metadata-extractor.c"
	_gst_tag_list_free0 (new_tag_list);
}


#line 235 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_element_message_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 235 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 235 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 235 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 237 "rygel-media-export-metadata-extractor.vala"
	if (message->src != GST_OBJECT (self->priv->playbin)) {
#line 238 "rygel-media-export-metadata-extractor.vala"
		return;
#line 700 "rygel-media-export-metadata-extractor.c"
	}
#line 241 "rygel-media-export-metadata-extractor.vala"
	if (_vala_strcmp0 (gst_structure_get_name (gst_message_get_structure (message)), "playbin2-stream-changed") == 0) {
#line 704 "rygel-media-export-metadata-extractor.c"
		GFile* _tmp0_;
#line 242 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_duration (self);
#line 243 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_stream_info (self);
#line 246 "rygel-media-export-metadata-extractor.vala"
		g_signal_emit_by_name (self, "extraction-done", (GFile*) g_queue_peek_head (self->priv->file_queue), self->priv->tag_list);
#line 247 "rygel-media-export-metadata-extractor.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 248 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 716 "rygel-media-export-metadata-extractor.c"
		_g_object_unref0 (_tmp0_);
#line 249 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_next (self);
#line 720 "rygel-media-export-metadata-extractor.c"
	}
}


#line 254 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_state_changed_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 727 "rygel-media-export-metadata-extractor.c"
	GstState new_state = 0;
	GstState old_state = 0;
	gboolean _tmp0_ = FALSE;
#line 254 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 254 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 254 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 256 "rygel-media-export-metadata-extractor.vala"
	if (message->src != GST_OBJECT (self->priv->playbin)) {
#line 257 "rygel-media-export-metadata-extractor.vala"
		return;
#line 741 "rygel-media-export-metadata-extractor.c"
	}
#line 263 "rygel-media-export-metadata-extractor.vala"
	gst_message_parse_state_changed (message, &old_state, &new_state, NULL);
#line 264 "rygel-media-export-metadata-extractor.vala"
	if (new_state == GST_STATE_PAUSED) {
#line 264 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = old_state == GST_STATE_READY;
#line 749 "rygel-media-export-metadata-extractor.c"
	} else {
#line 264 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = FALSE;
#line 753 "rygel-media-export-metadata-extractor.c"
	}
#line 264 "rygel-media-export-metadata-extractor.vala"
	if (_tmp0_) {
#line 757 "rygel-media-export-metadata-extractor.c"
		GFile* _tmp1_;
#line 265 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_duration (self);
#line 266 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_stream_info (self);
#line 269 "rygel-media-export-metadata-extractor.vala"
		g_signal_emit_by_name (self, "extraction-done", (GFile*) g_queue_peek_head (self->priv->file_queue), self->priv->tag_list);
#line 270 "rygel-media-export-metadata-extractor.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 271 "rygel-media-export-metadata-extractor.vala"
		_tmp1_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 769 "rygel-media-export-metadata-extractor.c"
		_g_object_unref0 (_tmp1_);
#line 272 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_next (self);
#line 773 "rygel-media-export-metadata-extractor.c"
	}
}


#line 277 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_error_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 780 "rygel-media-export-metadata-extractor.c"
	GError* _error_;
	char* debug;
	char* _tmp3_;
	char* _tmp2_ = NULL;
	GError* _tmp1_;
	GError* _tmp0_ = NULL;
	GFile* _tmp5_;
#line 277 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 277 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 277 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 280 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (g_queue_get_length (self->priv->file_queue) != 0);
#line 282 "rygel-media-export-metadata-extractor.vala"
	_error_ = NULL;
#line 798 "rygel-media-export-metadata-extractor.c"
	debug = NULL;
#line 285 "rygel-media-export-metadata-extractor.vala"
	(gst_message_parse_error (message, &_tmp0_, &_tmp2_), _error_ = (_tmp1_ = _tmp0_, _g_error_free0 (_error_), _tmp1_));
#line 285 "rygel-media-export-metadata-extractor.vala"
	debug = (_tmp3_ = _tmp2_, _g_free0 (debug), _tmp3_);
#line 286 "rygel-media-export-metadata-extractor.vala"
	if (_error_ != NULL) {
#line 806 "rygel-media-export-metadata-extractor.c"
		char* _tmp4_;
#line 287 "rygel-media-export-metadata-extractor.vala"
		debug = (_tmp4_ = g_strdup (_error_->message), _g_free0 (debug), _tmp4_);
#line 810 "rygel-media-export-metadata-extractor.c"
	}
#line 291 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "error", (GFile*) g_queue_peek_head (self->priv->file_queue), _error_);
#line 294 "rygel-media-export-metadata-extractor.vala"
	gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 295 "rygel-media-export-metadata-extractor.vala"
	_tmp5_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 818 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp5_);
#line 296 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 822 "rygel-media-export-metadata-extractor.c"
	_g_error_free0 (_error_);
	_g_free0 (debug);
}


#line 299 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_mime_and_size (RygelMediaExportMetadataExtractor* self, GError** error) {
#line 830 "rygel-media-export-metadata-extractor.c"
	GError * _inner_error_;
	GFile* file;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	const char* content_type;
	const char* mime;
	gint64 size;
	guint64 mtime;
#line 299 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 842 "rygel-media-export-metadata-extractor.c"
	_inner_error_ = NULL;
#line 300 "rygel-media-export-metadata-extractor.vala"
	file = _g_object_ref0 ((GFile*) g_queue_peek_head (self->priv->file_queue));
#line 846 "rygel-media-export-metadata-extractor.c"
	file_info = NULL;
#line 303 "rygel-media-export-metadata-extractor.vala"
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 850 "rygel-media-export-metadata-extractor.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (file_info);
		return;
	}
#line 303 "rygel-media-export-metadata-extractor.vala"
	file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_);
#line 310 "rygel-media-export-metadata-extractor.vala"
	content_type = g_file_info_get_content_type (file_info);
#line 311 "rygel-media-export-metadata-extractor.vala"
	mime = g_content_type_get_mime_type (content_type);
#line 312 "rygel-media-export-metadata-extractor.vala"
	if (mime != NULL) {
#line 314 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, mime, NULL);
#line 867 "rygel-media-export-metadata-extractor.c"
	}
#line 319 "rygel-media-export-metadata-extractor.vala"
	size = g_file_info_get_size (file_info);
#line 320 "rygel-media-export-metadata-extractor.vala"
	gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE, size, NULL);
#line 324 "rygel-media-export-metadata-extractor.vala"
	mtime = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 326 "rygel-media-export-metadata-extractor.vala"
	gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME, mtime, NULL);
#line 877 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (file);
	_g_object_unref0 (file_info);
}


#line 331 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_duration (RygelMediaExportMetadataExtractor* self) {
#line 885 "rygel-media-export-metadata-extractor.c"
	gint64 duration = 0LL;
	GstFormat format;
#line 331 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 334 "rygel-media-export-metadata-extractor.vala"
	format = GST_FORMAT_TIME;
#line 335 "rygel-media-export-metadata-extractor.vala"
	if (gst_element_query_duration (self->priv->playbin, &format, &duration)) {
#line 336 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, GST_TAG_DURATION, duration, NULL);
#line 896 "rygel-media-export-metadata-extractor.c"
	}
}


static inline GstElement* _dynamic_get_video_sink3 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "video-sink", &result, NULL);
	return result;
}


static inline GstElement* _dynamic_get_audio_sink4 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "audio-sink", &result, NULL);
	return result;
}


#line 342 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_stream_info (RygelMediaExportMetadataExtractor* self) {
#line 917 "rygel-media-export-metadata-extractor.c"
	GstPad* _tmp0_;
	GstPad* _tmp1_;
#line 342 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 343 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_av_info (self, _tmp0_ = gst_element_get_pad (_dynamic_get_video_sink3 (self->priv->playbin), "sink"), GST_STREAM_TYPE_VIDEO);
#line 924 "rygel-media-export-metadata-extractor.c"
	_gst_object_unref0 (_tmp0_);
#line 345 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_av_info (self, _tmp1_ = gst_element_get_pad (_dynamic_get_audio_sink4 (self->priv->playbin), "sink"), GST_STREAM_TYPE_AUDIO);
#line 928 "rygel-media-export-metadata-extractor.c"
	_gst_object_unref0 (_tmp1_);
}


#line 349 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_av_info (RygelMediaExportMetadataExtractor* self, GstPad* pad, GstStreamType type) {
#line 935 "rygel-media-export-metadata-extractor.c"
	GstCaps* caps;
	const GstStructure* structure;
#line 349 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 349 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (pad != NULL);
#line 350 "rygel-media-export-metadata-extractor.vala"
	if (pad == NULL) {
#line 351 "rygel-media-export-metadata-extractor.vala"
		return;
#line 946 "rygel-media-export-metadata-extractor.c"
	}
#line 354 "rygel-media-export-metadata-extractor.vala"
	caps = gst_pad_get_negotiated_caps (pad);
#line 355 "rygel-media-export-metadata-extractor.vala"
	if (caps == NULL) {
#line 952 "rygel-media-export-metadata-extractor.c"
		_gst_caps_unref0 (caps);
#line 356 "rygel-media-export-metadata-extractor.vala"
		return;
#line 956 "rygel-media-export-metadata-extractor.c"
	}
#line 359 "rygel-media-export-metadata-extractor.vala"
	structure = gst_caps_get_structure (caps, (guint) 0);
#line 360 "rygel-media-export-metadata-extractor.vala"
	if (structure == NULL) {
#line 962 "rygel-media-export-metadata-extractor.c"
		_gst_caps_unref0 (caps);
#line 361 "rygel-media-export-metadata-extractor.vala"
		return;
#line 966 "rygel-media-export-metadata-extractor.c"
	}
#line 364 "rygel-media-export-metadata-extractor.vala"
	if (type == GST_STREAM_TYPE_AUDIO) {
#line 365 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_audio_info (self, structure);
#line 972 "rygel-media-export-metadata-extractor.c"
	} else {
#line 366 "rygel-media-export-metadata-extractor.vala"
		if (type == GST_STREAM_TYPE_VIDEO) {
#line 367 "rygel-media-export-metadata-extractor.vala"
			rygel_media_export_metadata_extractor_extract_video_info (self, structure);
#line 978 "rygel-media-export-metadata-extractor.c"
		}
	}
	_gst_caps_unref0 (caps);
}


#line 371 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_audio_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure) {
#line 371 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 371 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 372 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "channels", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS);
#line 373 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "rate", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE);
#line 995 "rygel-media-export-metadata-extractor.c"
}


#line 376 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_video_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure) {
#line 376 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 376 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 377 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "width", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH);
#line 378 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "height", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT);
#line 379 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "depth", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH);
#line 1011 "rygel-media-export-metadata-extractor.c"
}


#line 382 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_int_value (RygelMediaExportMetadataExtractor* self, const GstStructure* structure, const char* key, const char* tag) {
#line 1017 "rygel-media-export-metadata-extractor.c"
	gint tag_value = 0;
#line 382 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 382 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 382 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (key != NULL);
#line 382 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (tag != NULL);
#line 387 "rygel-media-export-metadata-extractor.vala"
	if (gst_structure_get_int (structure, key, &tag_value)) {
#line 388 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, tag, tag_value, NULL);
#line 1031 "rygel-media-export-metadata-extractor.c"
	}
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR (obj);
	_gst_object_unref0 (self->priv->playbin);
	_gst_tag_list_free0 (self->priv->tag_list);
	_g_queue_free0 (self->priv->file_queue);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}



