/* rygel-external-item-factory.c generated by valac, the Vala compiler
 * generated from rygel-external-item-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_EXTERNAL_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
typedef struct _RygelExternalItemFactoryPrivate RygelExternalItemFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT (rygel_external_media_object_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObject))
#define RYGEL_IS_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObjectIface))

typedef struct _RygelExternalMediaObject RygelExternalMediaObject;
typedef struct _RygelExternalMediaObjectIface RygelExternalMediaObjectIface;

#define RYGEL_TYPE_EXTERNAL_MEDIA_ITEM (rygel_external_media_item_get_type ())
#define RYGEL_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItem))
#define RYGEL_IS_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM))
#define RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItemIface))

typedef struct _RygelExternalMediaItem RygelExternalMediaItem;
typedef struct _RygelExternalMediaItemIface RygelExternalMediaItemIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY (rygel_external_thumbnail_factory_get_type ())
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactory))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))
#define RYGEL_IS_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY))
#define RYGEL_IS_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))

typedef struct _RygelExternalThumbnailFactory RygelExternalThumbnailFactory;
typedef struct _RygelExternalThumbnailFactoryClass RygelExternalThumbnailFactoryClass;
#define _rygel_external_thumbnail_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_thumbnail_factory_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalItemFactoryCreateData RygelExternalItemFactoryCreateData;
typedef struct _RygelParamSpecExternalItemFactory RygelParamSpecExternalItemFactory;

struct _RygelExternalItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalItemFactoryPrivate * priv;
};

struct _RygelExternalItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalItemFactory *self);
};

struct _RygelExternalMediaObjectIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObject* self);
	void (*set_parent) (RygelExternalMediaObject* self, const char* value);
	char* (*get_display_name) (RygelExternalMediaObject* self);
	void (*set_display_name) (RygelExternalMediaObject* self, const char* value);
	char* (*get_object_type) (RygelExternalMediaObject* self);
	void (*set_object_type) (RygelExternalMediaObject* self, const char* value);
};

struct _RygelExternalMediaItemIface {
	GTypeInterface parent_iface;
	char** (*get_urls) (RygelExternalMediaItem* self, int* result_length1);
	void (*set_urls) (RygelExternalMediaItem* self, char** value, int value_length1);
	char* (*get_mime_type) (RygelExternalMediaItem* self);
	void (*set_mime_type) (RygelExternalMediaItem* self, const char* value);
	gint (*get_size) (RygelExternalMediaItem* self);
	void (*set_size) (RygelExternalMediaItem* self, gint value);
	char* (*get_artist) (RygelExternalMediaItem* self);
	void (*set_artist) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album) (RygelExternalMediaItem* self);
	void (*set_album) (RygelExternalMediaItem* self, const char* value);
	char* (*get_date) (RygelExternalMediaItem* self);
	void (*set_date) (RygelExternalMediaItem* self, const char* value);
	char* (*get_genre) (RygelExternalMediaItem* self);
	void (*set_genre) (RygelExternalMediaItem* self, const char* value);
	char* (*get_dlna_profile) (RygelExternalMediaItem* self);
	void (*set_dlna_profile) (RygelExternalMediaItem* self, const char* value);
	gint (*get_duration) (RygelExternalMediaItem* self);
	void (*set_duration) (RygelExternalMediaItem* self, gint value);
	gint (*get_bitrate) (RygelExternalMediaItem* self);
	void (*set_bitrate) (RygelExternalMediaItem* self, gint value);
	gint (*get_sample_rate) (RygelExternalMediaItem* self);
	void (*set_sample_rate) (RygelExternalMediaItem* self, gint value);
	gint (*get_bits_per_sample) (RygelExternalMediaItem* self);
	void (*set_bits_per_sample) (RygelExternalMediaItem* self, gint value);
	gint (*get_width) (RygelExternalMediaItem* self);
	void (*set_width) (RygelExternalMediaItem* self, gint value);
	gint (*get_height) (RygelExternalMediaItem* self);
	void (*set_height) (RygelExternalMediaItem* self, gint value);
	gint (*get_color_depth) (RygelExternalMediaItem* self);
	void (*set_color_depth) (RygelExternalMediaItem* self, gint value);
	char* (*get_thumbnail) (RygelExternalMediaItem* self);
	void (*set_thumbnail) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album_art) (RygelExternalMediaItem* self);
	void (*set_album_art) (RygelExternalMediaItem* self, const char* value);
};

struct _RygelExternalItemFactoryCreateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	char* id;
	char* type;
	char* title;
	GHashTable* props;
	char* service_name;
	char* host_ip;
	RygelMediaContainer* parent;
	RygelMediaItem* result;
	char* upnp_class;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	RygelMediaItem* item;
	GValue* value;
	char* _tmp4_;
	DBusGConnection* connection;
	RygelExternalMediaItem* item_iface;
	char** uris;
	gint _tmp5_;
	char** _tmp6_;
	gint _uris_size_;
	gint uris_length1;
	gint i;
	gboolean _tmp7_;
	char* tmp;
	GValue* _tmp8_;
	char* _tmp9_;
	GValue* _tmp10_;
	GValue* _tmp11_;
	char* _tmp12_;
	GValue* _tmp13_;
	char* _tmp14_;
	GValue* _tmp15_;
	char* _tmp16_;
	GValue* _tmp17_;
	GValue* _tmp18_;
	GValue* _tmp19_;
	GValue* _tmp20_;
	GValue* _tmp21_;
	GValue* _tmp22_;
	GValue* _tmp23_;
	GValue* _tmp24_;
	GValue* _tmp25_;
	GValue* _tmp26_;
	RygelExternalThumbnailFactory* factory;
	RygelThumbnail* thumbnail;
	GError * _inner_error_;
};

struct _RygelParamSpecExternalItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_external_item_factory_parent_class = NULL;

gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_item_factory (GValue* value, gpointer v_object);
void rygel_value_take_external_item_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void);
enum  {
	RYGEL_EXTERNAL_ITEM_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_item_factory_create_data_free (gpointer _data);
static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GValue* _g_value_dup (GValue* self);
GType rygel_external_media_object_get_type (void);
RygelExternalMediaObject* rygel_external_media_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_external_media_item_get_type (void);
RygelExternalMediaItem* rygel_external_media_item_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char** rygel_external_media_item_get_urls (RygelExternalMediaItem* self, int* result_length1);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_new (void);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_construct (GType object_type);
gpointer rygel_external_thumbnail_factory_ref (gpointer instance);
void rygel_external_thumbnail_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_thumbnail_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_thumbnail_factory (GValue* value, gpointer v_object);
void rygel_value_take_external_thumbnail_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_thumbnail_factory (const GValue* value);
GType rygel_external_thumbnail_factory_get_type (void);
void rygel_external_thumbnail_factory_create (RygelExternalThumbnailFactory* self, const char* service_name, const char* object_path, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_thumbnail_factory_create_finish (RygelExternalThumbnailFactory* self, GAsyncResult* _res_, GError** error);
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* type, const char* title, GHashTable* props, const char* service_name, const char* host_ip, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static void rygel_external_item_factory_create_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateData* data;
	data = _data;
	_g_free0 (data->id);
	_g_free0 (data->type);
	_g_free0 (data->title);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_free0 (data->host_ip);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	rygel_external_item_factory_unref (data->self);
	g_slice_free (RygelExternalItemFactoryCreateData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* type, const char* title, GHashTable* props, const char* service_name, const char* host_ip, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_data_free);
	_data_->self = rygel_external_item_factory_ref (self);
	_data_->id = g_strdup (id);
	_data_->type = g_strdup (type);
	_data_->title = g_strdup (title);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->host_ip = g_strdup (host_ip);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_co (_data_);
}


RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_create_co (data);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


#line 1148 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 325 "rygel-external-item-factory.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 334 "rygel-external-item-factory.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1150 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 343 "rygel-external-item-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1151 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 354 "rygel-external-item-factory.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1151 "glib-2.0.vapi"
		return result;
#line 369 "rygel-external-item-factory.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1153 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 380 "rygel-external-item-factory.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 12:
		goto _state_12;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 43 "rygel-external-item-factory.vala"
		if (g_str_has_prefix (data->type, "audio")) {
#line 44 "rygel-external-item-factory.vala"
			data->upnp_class = (data->_tmp0_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (data->upnp_class), data->_tmp0_);
#line 408 "rygel-external-item-factory.c"
		} else {
#line 45 "rygel-external-item-factory.vala"
			if (g_str_has_prefix (data->type, "music")) {
#line 46 "rygel-external-item-factory.vala"
				data->upnp_class = (data->_tmp1_ = g_strdup (RYGEL_MEDIA_ITEM_MUSIC_CLASS), _g_free0 (data->upnp_class), data->_tmp1_);
#line 414 "rygel-external-item-factory.c"
			} else {
#line 47 "rygel-external-item-factory.vala"
				if (g_str_has_prefix (data->type, "video")) {
#line 48 "rygel-external-item-factory.vala"
					data->upnp_class = (data->_tmp2_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (data->upnp_class), data->_tmp2_);
#line 420 "rygel-external-item-factory.c"
				} else {
#line 50 "rygel-external-item-factory.vala"
					data->upnp_class = (data->_tmp3_ = g_strdup (RYGEL_MEDIA_ITEM_IMAGE_CLASS), _g_free0 (data->upnp_class), data->_tmp3_);
#line 424 "rygel-external-item-factory.c"
				}
			}
		}
		data->item = rygel_media_item_new (data->id, data->parent, data->title, data->upnp_class);
		data->value = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "MIMEType"));
#line 56 "rygel-external-item-factory.vala"
		data->item->mime_type = (data->_tmp4_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->mime_type), data->_tmp4_);
#line 432 "rygel-external-item-factory.c"
		data->connection = dbus_g_bus_get (DBUS_BUS_SESSION, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->item);
			_g_free0 (data->value);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->item_iface = rygel_external_media_item_dbus_proxy_new (data->connection, data->service_name, data->id);
		data->uris = (data->_tmp6_ = rygel_external_media_item_get_urls (data->item_iface, &data->_tmp5_), data->uris_length1 = data->_tmp5_, data->_uris_size_ = data->uris_length1, data->_tmp6_);
		{
			data->i = 0;
			{
				data->_tmp7_ = TRUE;
#line 65 "rygel-external-item-factory.vala"
				while (TRUE) {
#line 65 "rygel-external-item-factory.vala"
					if (!data->_tmp7_) {
#line 65 "rygel-external-item-factory.vala"
						data->i++;
#line 462 "rygel-external-item-factory.c"
					}
#line 65 "rygel-external-item-factory.vala"
					data->_tmp7_ = FALSE;
#line 65 "rygel-external-item-factory.vala"
					if (!(data->uris[data->i] != NULL)) {
#line 65 "rygel-external-item-factory.vala"
						break;
#line 470 "rygel-external-item-factory.c"
					}
					data->tmp = string_replace (data->uris[data->i], "@ADDRESS@", data->host_ip);
#line 68 "rygel-external-item-factory.vala"
					rygel_media_item_add_uri (data->item, data->tmp, NULL);
#line 475 "rygel-external-item-factory.c"
					_g_free0 (data->tmp);
				}
			}
		}
#line 79 "rygel-external-item-factory.vala"
		data->value = (data->_tmp8_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "DLNAProfile")), _g_free0 (data->value), data->_tmp8_);
#line 80 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 81 "rygel-external-item-factory.vala"
			data->item->dlna_profile = (data->_tmp9_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->dlna_profile), data->_tmp9_);
#line 486 "rygel-external-item-factory.c"
		}
#line 84 "rygel-external-item-factory.vala"
		data->value = (data->_tmp10_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Size")), _g_free0 (data->value), data->_tmp10_);
#line 85 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 86 "rygel-external-item-factory.vala"
			data->item->size = (glong) g_value_get_int (data->value);
#line 494 "rygel-external-item-factory.c"
		}
#line 89 "rygel-external-item-factory.vala"
		data->value = (data->_tmp11_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Artist")), _g_free0 (data->value), data->_tmp11_);
#line 90 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 91 "rygel-external-item-factory.vala"
			data->item->author = (data->_tmp12_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->author), data->_tmp12_);
#line 502 "rygel-external-item-factory.c"
		}
#line 94 "rygel-external-item-factory.vala"
		data->value = (data->_tmp13_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Album")), _g_free0 (data->value), data->_tmp13_);
#line 95 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 96 "rygel-external-item-factory.vala"
			data->item->album = (data->_tmp14_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->album), data->_tmp14_);
#line 510 "rygel-external-item-factory.c"
		}
#line 99 "rygel-external-item-factory.vala"
		data->value = (data->_tmp15_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Date")), _g_free0 (data->value), data->_tmp15_);
#line 100 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 101 "rygel-external-item-factory.vala"
			data->item->date = (data->_tmp16_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->date), data->_tmp16_);
#line 518 "rygel-external-item-factory.c"
		}
#line 106 "rygel-external-item-factory.vala"
		data->value = (data->_tmp17_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Duration")), _g_free0 (data->value), data->_tmp17_);
#line 107 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 108 "rygel-external-item-factory.vala"
			data->item->duration = (glong) g_value_get_int (data->value);
#line 526 "rygel-external-item-factory.c"
		}
#line 111 "rygel-external-item-factory.vala"
		data->value = (data->_tmp18_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Bitrate")), _g_free0 (data->value), data->_tmp18_);
#line 112 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 113 "rygel-external-item-factory.vala"
			data->item->bitrate = g_value_get_int (data->value);
#line 534 "rygel-external-item-factory.c"
		}
#line 116 "rygel-external-item-factory.vala"
		data->value = (data->_tmp19_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "SampleRate")), _g_free0 (data->value), data->_tmp19_);
#line 117 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 118 "rygel-external-item-factory.vala"
			data->item->sample_freq = g_value_get_int (data->value);
#line 542 "rygel-external-item-factory.c"
		}
#line 121 "rygel-external-item-factory.vala"
		data->value = (data->_tmp20_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "BitsPerSample")), _g_free0 (data->value), data->_tmp20_);
#line 122 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 123 "rygel-external-item-factory.vala"
			data->item->bits_per_sample = g_value_get_int (data->value);
#line 550 "rygel-external-item-factory.c"
		}
#line 128 "rygel-external-item-factory.vala"
		data->value = (data->_tmp21_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Width")), _g_free0 (data->value), data->_tmp21_);
#line 129 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 130 "rygel-external-item-factory.vala"
			data->item->width = g_value_get_int (data->value);
#line 558 "rygel-external-item-factory.c"
		}
#line 133 "rygel-external-item-factory.vala"
		data->value = (data->_tmp22_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Height")), _g_free0 (data->value), data->_tmp22_);
#line 134 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 135 "rygel-external-item-factory.vala"
			data->item->height = g_value_get_int (data->value);
#line 566 "rygel-external-item-factory.c"
		}
#line 138 "rygel-external-item-factory.vala"
		data->value = (data->_tmp23_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "ColorDepth")), _g_free0 (data->value), data->_tmp23_);
#line 139 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 140 "rygel-external-item-factory.vala"
			data->item->color_depth = g_value_get_int (data->value);
#line 574 "rygel-external-item-factory.c"
		}
#line 143 "rygel-external-item-factory.vala"
		data->value = (data->_tmp24_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "PixelWidth")), _g_free0 (data->value), data->_tmp24_);
#line 144 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 145 "rygel-external-item-factory.vala"
			data->item->pixel_width = g_value_get_int (data->value);
#line 582 "rygel-external-item-factory.c"
		}
#line 148 "rygel-external-item-factory.vala"
		data->value = (data->_tmp25_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "PixelHeight")), _g_free0 (data->value), data->_tmp25_);
#line 149 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 150 "rygel-external-item-factory.vala"
			data->item->pixel_height = g_value_get_int (data->value);
#line 590 "rygel-external-item-factory.c"
		}
#line 153 "rygel-external-item-factory.vala"
		data->value = (data->_tmp26_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->props, "Thumbnail")), _g_free0 (data->value), data->_tmp26_);
#line 154 "rygel-external-item-factory.vala"
		if (data->value != NULL) {
#line 596 "rygel-external-item-factory.c"
			data->factory = rygel_external_thumbnail_factory_new ();
			data->_state_ = 12;
			rygel_external_thumbnail_factory_create (data->factory, g_value_get_string (data->value), data->service_name, data->host_ip, rygel_external_item_factory_create_ready, data);
			return FALSE;
			_state_12:
			data->thumbnail = rygel_external_thumbnail_factory_create_finish (data->factory, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_rygel_external_thumbnail_factory_unref0 (data->factory);
				_g_free0 (data->upnp_class);
				_g_object_unref0 (data->item);
				_g_free0 (data->value);
				_dbus_g_connection_unref0 (data->connection);
				_g_object_unref0 (data->item_iface);
				data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 159 "rygel-external-item-factory.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->item->thumbnails, data->thumbnail);
#line 625 "rygel-external-item-factory.c"
			_rygel_external_thumbnail_factory_unref0 (data->factory);
			_rygel_icon_info_unref0 (data->thumbnail);
		}
		data->result = data->item;
		_g_free0 (data->upnp_class);
		_g_free0 (data->value);
		_dbus_g_connection_unref0 (data->connection);
		_g_object_unref0 (data->item_iface);
		data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_free0 (data->upnp_class);
		_g_object_unref0 (data->item);
		_g_free0 (data->value);
		_dbus_g_connection_unref0 (data->connection);
		_g_object_unref0 (data->item_iface);
		data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 32 "rygel-external-item-factory.vala"
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type) {
#line 665 "rygel-external-item-factory.c"
	RygelExternalItemFactory* self;
	self = (RygelExternalItemFactory*) g_type_create_instance (object_type);
	return self;
}


#line 32 "rygel-external-item-factory.vala"
RygelExternalItemFactory* rygel_external_item_factory_new (void) {
#line 32 "rygel-external-item-factory.vala"
	return rygel_external_item_factory_construct (RYGEL_TYPE_EXTERNAL_ITEM_FACTORY);
#line 676 "rygel-external-item-factory.c"
}


static void rygel_value_external_item_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_external_item_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_item_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_external_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_external_item_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_external_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalItemFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_external_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_external_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecExternalItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_external_item_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_external_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


void rygel_value_take_external_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


static void rygel_external_item_factory_class_init (RygelExternalItemFactoryClass * klass) {
	rygel_external_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ITEM_FACTORY_CLASS (klass)->finalize = rygel_external_item_factory_finalize;
}


static void rygel_external_item_factory_instance_init (RygelExternalItemFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj) {
	RygelExternalItemFactory * self;
	self = RYGEL_EXTERNAL_ITEM_FACTORY (obj);
}


GType rygel_external_item_factory_get_type (void) {
	static volatile gsize rygel_external_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_external_item_factory_init, rygel_value_external_item_factory_free_value, rygel_value_external_item_factory_copy_value, rygel_value_external_item_factory_peek_pointer, "p", rygel_value_external_item_factory_collect_value, "p", rygel_value_external_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalItemFactory), 0, (GInstanceInitFunc) rygel_external_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_item_factory_type_id;
		rygel_external_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalItemFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_item_factory_type_id__volatile, rygel_external_item_factory_type_id);
	}
	return rygel_external_item_factory_type_id__volatile;
}


gpointer rygel_external_item_factory_ref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_item_factory_unref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




