/* 
 *  Copyright (C) 2002  Ricardo Fernndezs Pascual <ric@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GB_ICON_PROVIDER_H__
#define __GB_ICON_PROVIDER_H__

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "bookmarks.h"

G_BEGIN_DECLS

#define GB_TYPE_ICON_PROVIDER			(gb_icon_provider_get_type ())
#define GB_ICON_PROVIDER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), \
						 GB_TYPE_ICON_PROVIDER, \
						 GbIconProvider))
#define GB_IS_ICON_PROVIDER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
						 GB_TYPE_ICON_PROVIDER))
#define GB_ICON_PROVIDER_GET_IFACE(obj) 	(G_TYPE_INSTANCE_GET_INTERFACE ((obj), \
						 GB_TYPE_ICON_PROVIDER, \
						 GbIconProviderIface))

/**
 * This interface marks objects that can provide a small icon for
 * bookmarks.
 */

typedef struct _GbIconProviderIface	GbIconProviderIface;

struct _GbIconProviderIface
{
	GTypeInterface g_iface;
	
	/* Virtual Table */
	GdkPixbuf *	(* get_icon)		(GbIconProvider *ip, GbBookmark *b);
};

GType		gb_icon_provider_get_type		(void);
GdkPixbuf *	gb_icon_provider_get_icon		(GbIconProvider *ip, GbBookmark *b);

G_END_DECLS

#endif

