/*
 * CookiePromptService.cpp
 *
 * Copyright (C) 2003 Tommi Komulainen <tommi.komulainen@iki.fi>
 * Available under the terms of the GNU General Public License version 2.
 */ 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// nsICookiePromptService is not available in 1.3a, so simply comment
// everything out.  This is only temporary until 1.3b is released.
#if MOZILLA_SNAPSHOT > 4

#include "CookiePromptService.h"

#include "nsICookiePromptService.h"
#include "nsICookie.h"
#include "nsString.h"
#include "nsXPComFactory.h"

#include "MozillaPrivate.h"
#include "gul-glade.h"
#include "galeon-embed-shell.h"
#include "mozilla-cookie.h"
#include <gtk/gtkdialog.h>
#include <gtk/gtklabel.h>
#include <disclosure-widget.h>
#include <libgnome/gnome-triggers.h>
#include <libgnome/gnome-i18n.h>

#include "nsCOMPtr.h"
#include "nsIWindowWatcher.h"
#include "nsIServiceManagerUtils.h"

class GCookiePromptService : public nsICookiePromptService
{
public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSICOOKIEPROMPTSERVICE

	GCookiePromptService();
	virtual ~GCookiePromptService();

private:
};

// FIXME use gconf or mozilla prefs if we need to remember whether or not to
// FIXME show the cookie details across sessions
static gboolean gShowDetails = FALSE;


NS_IMPL_ISUPPORTS1(GCookiePromptService, nsICookiePromptService)

GCookiePromptService::GCookiePromptService()
{
}

GCookiePromptService::~GCookiePromptService()
{
}

static void
GCookiePromptService_button_toggled (GtkToggleButton *button, GtkWindow *dialog)
{
	gShowDetails = gtk_toggle_button_get_active (button);
	gtk_window_set_resizable (dialog, gShowDetails);
}

static char*
make_secondary_text (const char *aHost, PRBool aModify, PRInt32 aCount)
{
	char *question;
	if (aModify)
	{
		question = g_strdup_printf
			(_("The site %s wants to modify an existing cookie."),
			 aHost);
	}
	else if (aCount == 0)
	{
		question = g_strdup_printf
			(_("The site %s wants to set a cookie."), aHost);
	}
	else if (aCount == 1)
	{
		question = g_strdup_printf
			(_("The site %s wants to set a second cookie."), aHost);
	}
	else
	{
		question = g_strdup_printf
			(_("The site %s wants to set another cookie."
			   " You already have %d cookies from this site."),
			 aHost, aCount);
	}

	return question;
}

static GtkWidget *
higgy_indent_widget (GtkWidget *widget)
{
	GtkWidget *hbox;
	GtkWidget *label;

	hbox = gtk_hbox_new (FALSE, 6);

	label = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, TRUE, 6);
	gtk_widget_show (label);

	gtk_box_pack_start (GTK_BOX(hbox), widget, TRUE, TRUE, 0);

	return hbox;
}

/* boolean cookieDialog (in nsIDOMWindow parent, in nsICookie cookie, in ACString hostname, in long cookiesFromHost, in boolean changingCookie, inout boolean checkValue); */
NS_IMETHODIMP GCookiePromptService::CookieDialog(nsIDOMWindow *aParent, nsICookie *aCookie, const nsACString & aHostname, PRInt32 aCookiesFromHost, PRBool aChangingCookie, PRBool *_checkValue, PRBool *_retval)
{
	// TODO short-circuit and accept session cookies as per preference
	// TODO until mozilla starts supporting it natively?

	GtkWidget *dialog;
	GladeXML *gxml;
	gxml = gul_glade_widget_new ("prompts.glade", "prompt_cookie_dialog",
			             &dialog, NULL);

	GtkWidget *checkbutton, *label;
	label = glade_xml_get_widget (gxml, "label");
	checkbutton = glade_xml_get_widget (gxml, "checkbutton");

	g_object_unref (gxml);

	// set dynamic attributes

	// <span weight="bold" size="larger">Primary text</span>
	//
	// Secondary text
	char *primary = g_strdup_printf(_("Accept cookie from %s?"), 
			                PromiseFlatCString(aHostname).get());
	char *secondary = make_secondary_text (PromiseFlatCString(aHostname).get(), 
			                       aChangingCookie, aCookiesFromHost);
	char *msg = g_strdup_printf ("<span weight=\"bold\" size=\"larger\">%s</span>\n\n%s",
			             primary, secondary);
	gtk_label_set_markup (GTK_LABEL(label), msg);
	g_free(msg);
	g_free(secondary);
	g_free(primary);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(checkbutton), *_checkValue);

	// add the disclosure button and the cookie details table
	GtkWidget *button = cddb_disclosure_new (_("Cookie Details"),
			                         _("Cookie Details"));
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), button, FALSE, FALSE, 0);

	CookieInfo *info = mozilla_cookie_to_info (aCookie);
	GtkWidget *details = cookie_info_table_new (info);
	cookie_info_free (info);

	details = higgy_indent_widget (details);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), details, FALSE, FALSE, 0);

	cddb_disclosure_set_container (CDDB_DISCLOSURE(button), details);
	g_signal_connect_after (G_OBJECT(button), "toggled", 
			        G_CALLBACK(GCookiePromptService_button_toggled), 
				dialog);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), 
			              gShowDetails);

	// for convenience, make ESC close the dialog
	g_signal_connect (dialog, "close", 
			  G_CALLBACK (gtk_dialog_response), 
			  GINT_TO_POINTER (GTK_RESPONSE_CLOSE));

	GtkWidget *gparent = MozillaFindGtkParent (aParent);
	gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(gparent));

	// run and handle the response
	gnome_triggers_vdo ("", "question", NULL);
	gint ret = gtk_dialog_run (GTK_DIALOG(dialog));
	if (ret == GTK_RESPONSE_ACCEPT || ret == GTK_RESPONSE_REJECT)
	{
		*_retval = (ret == GTK_RESPONSE_ACCEPT);
		*_checkValue = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(checkbutton));
	}
	else
	{
		// if the dialog was closed, but no button was pressed,
		// consider it as 'Reject' but ignore the checkbutton
		*_retval = PR_FALSE;
		*_checkValue = PR_FALSE;
	}

	// done
	gtk_widget_destroy (dialog);
	return NS_OK;
}


NS_DEF_FACTORY (GCookiePromptService, GCookiePromptService);

nsresult
NS_NewCookiePromptServiceFactory(nsIFactory** aFactory)
{
	NS_ENSURE_ARG_POINTER(aFactory);

	nsGCookiePromptServiceFactory *result = new nsGCookiePromptServiceFactory;
	if (!result) return NS_ERROR_OUT_OF_MEMORY;

	NS_ADDREF(*aFactory = result);
	return NS_OK;
}

#endif /* MOZILLA_SNAPSHOT > 4 */
