/*
 * Gnome Robots II - Cursor definitions.
 *
 * Copyright 2004 by Callum McKenzie.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more details see the file COPYING.
 */

#include <config.h>
#include <gtk/gtk.h>

#include "cursors.h"
#include "game.h"
#include "gbdefs.h"

#define d_width 20
#define d_height 20
static unsigned char d_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00,
  0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x78, 0xc0, 0x03,
  0x10, 0x00, 0x01, 0x20, 0x80, 0x00, 0x40, 0x40, 0x00, 0x80, 0x20, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00
};

#define d_mask_width 20
#define d_mask_height 20
static unsigned char d_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0xf8, 0xff, 0x03,
  0xf0, 0xff, 0x01, 0xe0, 0xff, 0x00, 0xc0, 0x7f, 0x00, 0x80, 0x3f, 0x00,
  0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00
};

#define u_width 20
#define u_height 20
static unsigned char u_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x11, 0x00,
  0x80, 0x20, 0x00, 0x40, 0x40, 0x00, 0x20, 0x80, 0x00, 0x10, 0x00, 0x01,
  0x78, 0xc0, 0x03, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00,
  0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00, 0x80, 0x20, 0x00,
  0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define u_mask_width 20
#define u_mask_height 20
static unsigned char u_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00,
  0x80, 0x3f, 0x00, 0xc0, 0x7f, 0x00, 0xe0, 0xff, 0x00, 0xf0, 0xff, 0x01,
  0xf8, 0xff, 0x03, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00,
  0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define r_width 20
#define r_height 20
static unsigned char r_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x28, 0x00, 0x00, 0x48, 0x00, 0xf8, 0x87, 0x00, 0x08, 0x00, 0x01,
  0x08, 0x00, 0x02, 0x08, 0x00, 0x04, 0x08, 0x00, 0x02, 0x08, 0x00, 0x01,
  0xf8, 0x87, 0x00, 0x00, 0x48, 0x00, 0x00, 0x28, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define r_mask_width 20
#define r_mask_height 20
static unsigned char r_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x38, 0x00, 0x00, 0x78, 0x00, 0xf8, 0xff, 0x00, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0x03, 0xf8, 0xff, 0x07, 0xf8, 0xff, 0x03, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0x00, 0x00, 0x78, 0x00, 0x00, 0x38, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define l_width 20
#define l_height 20
static unsigned char l_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x80, 0x01, 0x00,
  0x40, 0x01, 0x00, 0x20, 0x01, 0x00, 0x10, 0xfe, 0x01, 0x08, 0x00, 0x01,
  0x04, 0x00, 0x01, 0x02, 0x00, 0x01, 0x04, 0x00, 0x01, 0x08, 0x00, 0x01,
  0x10, 0xfe, 0x01, 0x20, 0x01, 0x00, 0x40, 0x01, 0x00, 0x80, 0x01, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define l_mask_width 20
#define l_mask_height 20
static unsigned char l_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x80, 0x01, 0x00,
  0xc0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xf0, 0xff, 0x01, 0xf8, 0xff, 0x01,
  0xfc, 0xff, 0x01, 0xfe, 0xff, 0x01, 0xfc, 0xff, 0x01, 0xf8, 0xff, 0x01,
  0xf0, 0xff, 0x01, 0xe0, 0x01, 0x00, 0xc0, 0x01, 0x00, 0x80, 0x01, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ul_width 20
#define ul_height 20
static unsigned char ul_bits[] = {
  0x00, 0x00, 0x00, 0xfe, 0x0f, 0x00, 0x02, 0x04, 0x00, 0x02, 0x02, 0x00,
  0x02, 0x01, 0x00, 0x02, 0x02, 0x00, 0x02, 0x04, 0x00, 0x02, 0x08, 0x00,
  0x12, 0x10, 0x00, 0x2a, 0x20, 0x00, 0x46, 0x10, 0x00, 0x82, 0x08, 0x00,
  0x00, 0x05, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ul_mask_width 20
#define ul_mask_height 20
static unsigned char ul_mask_bits[] = {
  0x00, 0x00, 0x00, 0xfe, 0x0f, 0x00, 0xfe, 0x07, 0x00, 0xfe, 0x03, 0x00,
  0xfe, 0x01, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x07, 0x00, 0xfe, 0x0f, 0x00,
  0xfe, 0x1f, 0x00, 0xee, 0x3f, 0x00, 0xc6, 0x1f, 0x00, 0x82, 0x0f, 0x00,
  0x00, 0x07, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ur_width 20
#define ur_height 20
static unsigned char ur_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x02, 0x04, 0x00, 0x04, 0x04,
  0x00, 0x08, 0x04, 0x00, 0x04, 0x04, 0x00, 0x02, 0x04, 0x00, 0x01, 0x04,
  0x80, 0x80, 0x04, 0x40, 0x40, 0x05, 0x80, 0x20, 0x06, 0x00, 0x11, 0x04,
  0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ur_mask_width 20
#define ur_mask_height 20
static unsigned char ur_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0xfe, 0x07, 0x00, 0xfc, 0x07,
  0x00, 0xf8, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfe, 0x07, 0x00, 0xff, 0x07,
  0x80, 0xff, 0x07, 0xc0, 0x7f, 0x07, 0x80, 0x3f, 0x06, 0x00, 0x1f, 0x04,
  0x00, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define dl_width 20
#define dl_height 20
static unsigned char dl_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x05, 0x00,
  0x82, 0x08, 0x00, 0x46, 0x10, 0x00, 0x2a, 0x20, 0x00, 0x12, 0x10, 0x00,
  0x02, 0x08, 0x00, 0x02, 0x04, 0x00, 0x02, 0x02, 0x00, 0x02, 0x01, 0x00,
  0x02, 0x02, 0x00, 0x02, 0x04, 0x00, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x00
};

#define dl_mask_width 20
#define dl_mask_height 20
static unsigned char dl_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x07, 0x00,
  0x82, 0x0f, 0x00, 0xc6, 0x1f, 0x00, 0xee, 0x3f, 0x00, 0xfe, 0x1f, 0x00,
  0xfe, 0x0f, 0x00, 0xfe, 0x07, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x01, 0x00,
  0xfe, 0x03, 0x00, 0xfe, 0x07, 0x00, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x00
};

#define dr_width 20
#define dr_height 20
static unsigned char dr_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00,
  0x00, 0x11, 0x04, 0x80, 0x20, 0x06, 0x40, 0x40, 0x05, 0x80, 0x80, 0x04,
  0x00, 0x01, 0x04, 0x00, 0x02, 0x04, 0x00, 0x04, 0x04, 0x00, 0x08, 0x04,
  0x00, 0x04, 0x04, 0x00, 0x02, 0x04, 0x00, 0xff, 0x07, 0x00, 0x00, 0x00
};

#define dr_mask_width 20
#define dr_mask_height 20
static unsigned char dr_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00,
  0x00, 0x1f, 0x04, 0x80, 0x3f, 0x06, 0xc0, 0x7f, 0x07, 0x80, 0xff, 0x07,
  0x00, 0xff, 0x07, 0x00, 0xfe, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xf8, 0x07,
  0x00, 0xfc, 0x07, 0x00, 0xfe, 0x07, 0x00, 0xff, 0x07, 0x00, 0x00, 0x00
};

#define hold_width 20
#define hold_height 20
static unsigned char hold_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x0f, 0x00, 0x60, 0x30, 0x00, 0x20, 0x20, 0x00, 0x10, 0x40, 0x00,
  0x10, 0x40, 0x00, 0x10, 0x40, 0x00, 0x10, 0x40, 0x00, 0x10, 0x40, 0x00,
  0x20, 0x20, 0x00, 0x60, 0x30, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define hold_mask_width 20
#define hold_mask_height 20
static unsigned char hold_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x0f, 0x00, 0xe0, 0x3f, 0x00, 0xe0, 0x3f, 0x00, 0xf0, 0x7f, 0x00,
  0xf0, 0x7f, 0x00, 0xf0, 0x7f, 0x00, 0xf0, 0x7f, 0x00, 0xf0, 0x7f, 0x00,
  0xe0, 0x3f, 0x00, 0xe0, 0x3f, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

typedef struct {
  unsigned char *bits;
  unsigned char *mask;
  int width;
  int height;
  int hsx;
  int hsy;
  GdkCursor *cursor;
} cursor_props;

cursor_props cursor_list[] = { {ul_bits, ul_mask_bits, 20, 20, 3, 3, NULL},
{u_bits, u_mask_bits, 20, 20, 10, 3, NULL},
{ur_bits, ur_mask_bits, 20, 20, 17, 3, NULL},
{l_bits, l_mask_bits, 20, 20, 3, 10, NULL},
{hold_bits, hold_mask_bits, 20, 20, 10, 10, NULL},
{r_bits, r_mask_bits, 20, 20, 17, 10, NULL},
{dl_bits, dl_mask_bits, 20, 20, 3, 17, NULL},
{d_bits, d_mask_bits, 20, 20, 10, 17, NULL},
{dr_bits, dr_mask_bits, 20, 20, 17, 17, NULL}
};


GdkCursor *default_cursor;

void
make_cursors (void)
{
  GdkColor fg = { 0, 65535, 65535, 65535 };
  GdkColor bg = { 0, 0, 0, 0 };
  GdkPixmap *source;
  GdkPixmap *mask;
  int i;
  cursor_props *c;

  default_cursor = gdk_cursor_new (GDK_LEFT_PTR);

  c = cursor_list;
  for (i = 0; i < sizeof (cursor_list) / sizeof (cursor_props); i++) {
    source =
      gdk_bitmap_create_from_data (NULL, (gchar *) c->bits, c->width,
				   c->height);
    mask =
      gdk_bitmap_create_from_data (NULL, (gchar *) c->mask, c->width,
				   c->height);

    c->cursor = gdk_cursor_new_from_pixmap (source, mask, &fg, &bg,
					    c->hsx, c->hsy);

    g_object_unref (source);
    g_object_unref (mask);

    c++;
  }
}

void
set_cursor_default (GdkWindow * window)
{
  gdk_window_set_cursor (window, default_cursor);
}

void
set_cursor_by_direction (GdkWindow * window, int dx, int dy)
{
  int index;

  if (game_state != STATE_PLAYING) {
    set_cursor_default (window);
    return;
  }

  index = 3 * dy + dx + 4;

  gdk_window_set_cursor (window, cursor_list[index].cursor);
}
