/* Totem Basic Plugin
 *
 * Copyright © 2004 Bastien Nocera <hadess@hadess.net>
 * Copyright © 2002 David A. Schleef <ds@schleef.org>
 * Copyright © 2006, 2008 Christian Persch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301  USA.
 */

#include <config.h>

#include <glib.h>

#include "totemPlugin.h"
#include "totemBasicPlugin.h"

static const char *methodNames[] = {
  "Play",
  "Rewind",
  "Stop"
};

totemBasicPlayer::totemBasicPlayer (NPP aNPP)
  : totemNPObject (aNPP)
{
  TOTEM_LOG_CTOR ();
}

totemBasicPlayer::~totemBasicPlayer ()
{
  TOTEM_LOG_DTOR ();
}

bool
totemBasicPlayer::InvokeByIndex (int aIndex,
                                 const NPVariant *argv,
                                 uint32_t argc,
                                 NPVariant *_result)
{
  TOTEM_LOG_INVOKE (aIndex, totemBasicPlayer);

  VOID_TO_NPVARIANT (*_result);

  switch (Methods (aIndex)) {
    case ePlay:
      Plugin()->Command (TOTEM_COMMAND_PLAY);
      return VoidVariant (_result);

    case eRewind:
      Plugin()->Command (TOTEM_COMMAND_PAUSE);
      return VoidVariant (_result);

    case eStop:
      Plugin()->Command (TOTEM_COMMAND_STOP);
      return VoidVariant (_result);
  }

  return false;
}

/* totemBasicPlayerNPClass */

TOTEM_IMPLEMENT_NPCLASS (totemBasicPlayer,
                         NULL, 0,
                         methodNames, G_N_ELEMENTS (methodNames),
                         NULL)
