# - coding: utf-8 -

# Copyright (C) 2007 Patryk Zawadzki <patrys at pld-linux.org>
# Copyright (C) 2008 Toms Bauģis <toms.baugis at gmail.com>

# This file is part of Project Hamster.

# Project Hamster is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Project Hamster is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Project Hamster.  If not, see <http://www.gnu.org/licenses/>.


EDS_AVAILABLE = False
try:
    import evolution
    from evolution import ecal
    EDS_AVAILABLE = True
except:
    pass

def get_eds_tasks():
    if EDS_AVAILABLE == False:
        return []
    
    try:
        sources = ecal.list_task_sources()
        tasks = []
        for source in sources:
            data = ecal.open_calendar_source(source[1], ecal.CAL_SOURCE_TYPE_TODO)
            if data:
                for task in data.get_all_objects():
                    if task.get_status() in [ecal.AL_STATUS_NONE, ecal.AL_STATUS_INPROCESS]:
                        tasks.append({'name': task.get_summary()})
        return tasks
    except Exception, e: # TODO's are not priority - print warning and go home
        print e 
        return []
