# -*- coding: utf-8 -*-

import os, os.path
import gettext

DOMAIN = 'gnome-games'
gettext.bindtextdomain(DOMAIN)
gettext.textdomain(DOMAIN)
from gettext import gettext as _

import gtk.glade
gtk.glade.bindtextdomain (DOMAIN)
gtk.glade.textdomain (DOMAIN)

VERSION = "2.17.5"
APPNAME = _("glChess")

COPYRIGHT     = _('Copyright 2005-2007 Robert Ancell (and contributors)')
DESCRIPTION   = _('A 2D/3D chess interface for Gnome')
WEBSITE       = 'http://glchess.sourceforge.net'
WEBSITE_LABEL = _('glChess homepage')
AUTHORS       = ['Robert Ancell <bob27@users.sourceforge.net>']
ARTISTS       = ['John-Paul Gignac (3D Models)', 'Max Froumentin (2D Models)', 'Hylke Bons <h.bons@student.rug.nl> (icon)']
TRANSLATORS   = [u"Luca Marturana <lucamarturana@gmail.com> (It)",
                 u"Hakan Bekdas <hakanbekdas@yahoo.com> (tr)",
                 u"A S Alam <apbrar@gmail.com> (pa)",
                 u"Michał Bentkowski <mr.ecik@mail.com> (pl)",
                 u"Daniel Nylander <po@danielnylander.se> (sv)",
                 u"Zoraks <skatala4ever@gmail.com> (ca)",
                 u"Elxan İsmayılov <elxan.i@gmail.com> (az)",
                 u"Translators on Rosetta (launchpad.net)",
                 u"Gnome Translation Team"]
LICENSE = """This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

2D Models:
Copyright World Wide Web Consortium, (Massachusetts Institute of Technology, Institut National de Recherche en Informatique et en Automatique, Keio University). All Rights Reserved. http://www.w3.org/Consortium/Legal/"""

APP_DATA_DIR    = os.path.join('/usr/local', 'share') 
ICON_DIR        = os.path.join(APP_DATA_DIR, 'pixmaps')
TEXTURE_DIR     = os.path.join(ICON_DIR, 'glchess')
GLADE_DIR       = os.path.join(APP_DATA_DIR, 'glchess')
BASE_DIR        = os.path.join(APP_DATA_DIR, 'glchess')

DATA_DIR        = os.path.expanduser('~/.gnome2/glchess/')
CONFIG_FILE     = os.path.join(DATA_DIR, 'config.xml')
LOCAL_AI_CONFIG = os.path.join(DATA_DIR, 'ai.xml')

if not os.path.exists(DATA_DIR): os.makedirs(DATA_DIR)
