/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GSWITCHIT_CONFIG_H__
#define __GSWITCHIT_CONFIG_H__

#include <X11/Xlib.h>

#include <glib.h>
#include <glib/gslist.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gconf/gconf-client.h>

#include <libxklavier/xklavier.h>

extern const gchar GSWITCHIT_CONFIG_DIR[];
extern const gchar GSWITCHIT_CONFIG_KEY_DEFAULT_GROUP[];
extern const gchar GSWITCHIT_CONFIG_KEY_GROUP_PER_WINDOW[];
extern const gchar GSWITCHIT_CONFIG_KEY_HANDLE_INDICATORS[];
extern const gchar GSWITCHIT_CONFIG_KEY_LAYOUT_NAMES_AS_GROUP_NAMES[];

extern const gchar GSWITCHIT_PREVIEW_CONFIG_DIR[];
extern const gchar GSWITCHIT_PREVIEW_CONFIG_KEY_X[];
extern const gchar GSWITCHIT_PREVIEW_CONFIG_KEY_Y[];
extern const gchar GSWITCHIT_PREVIEW_CONFIG_KEY_WIDTH[];
extern const gchar GSWITCHIT_PREVIEW_CONFIG_KEY_HEIGHT[];

extern const gchar GSWITCHIT_KBD_CONFIG_DIR[];
extern const gchar GSWITCHIT_KBD_CONFIG_KEY_MODEL[];
extern const gchar GSWITCHIT_KBD_CONFIG_KEY_LAYOUTS[];
extern const gchar GSWITCHIT_KBD_CONFIG_KEY_OPTIONS[];

/*
 * General configuration
 */
typedef struct _GSwitchItConfig {
	gint defaultGroup;
	gboolean groupPerApp;
	gboolean handleIndicators;
	gboolean layoutNamesAsGroupNames;

	/* private, transient */
	GConfClient *confClient;
	int configListenerId;
	XklEngine *engine;
} GSwitchItConfig;

/*
 * Keyboard Configuration
 */
typedef struct _GSwitchItKbdConfig {
	gchar *model;
	GSList *layouts;
	GSList *options;

	/* private, transient */
	GConfClient *confClient;
	int configListenerId;
	XklEngine *engine;
} GSwitchItKbdConfig;

/*
 * Applet configuration
 */
typedef struct _GSwitchItAppletConfig {
	int secondaryGroupsMask;
	gboolean showFlags;

	GSList *enabledPlugins;

	/* private, transient */
	GConfClient *confClient;
	GSList *images;
	GtkIconTheme *iconTheme;
	int configListenerId;
	XklEngine *engine;
} GSwitchItAppletConfig;

/**
 * GSwitchItConfig functions
 */
extern void GSwitchItConfigInit (GSwitchItConfig * config,
				 GConfClient * confClient,
				 XklEngine * engine);
extern void GSwitchItConfigTerm (GSwitchItConfig * config);

extern void GSwitchItConfigLoadFromGConf (GSwitchItConfig * config);

extern void GSwitchItConfigSaveToGConf (GSwitchItConfig * config);

extern gboolean GSwitchItConfigActivate (GSwitchItConfig * config);

/* Affected by XKB and XKB/GConf configuration */
extern gchar **GSwitchItConfigLoadGroupDescriptionsUtf8 (GSwitchItConfig *
							 config,
							 XklConfigRegistry
							 * configRegistry);

extern void GSwitchItConfigLockNextGroup (GSwitchItConfig * config);

extern void GSwitchItConfigLockPrevGroup (GSwitchItConfig * config);

extern void GSwitchItConfigRestoreGroup (GSwitchItConfig * config);

extern void GSwitchItConfigStartListen (GSwitchItConfig * config,
					GConfClientNotifyFunc func,
					gpointer user_data);

extern void GSwitchItConfigStopListen (GSwitchItConfig * config);

/**
 * GSwitchItKbdConfig functions
 */
extern void GSwitchItKbdConfigInit (GSwitchItKbdConfig * kbdConfig,
				    GConfClient * confClient,
				    XklEngine * engine);
extern void GSwitchItKbdConfigTerm (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoadFromGConf (GSwitchItKbdConfig *
					     kbdConfig,
					     GSwitchItKbdConfig *
					     kbdConfigDefault);

extern void GSwitchItKbdConfigSaveToGConf (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoadFromGConfBackup (GSwitchItKbdConfig *
						   kbdConfig);

extern void GSwitchItKbdConfigSaveToGConfBackup (GSwitchItKbdConfig *
						 kbdConfig);

extern void GSwitchItKbdConfigLoadFromXInitial (GSwitchItKbdConfig *
						kbdConfig);

extern void GSwitchItKbdConfigLoadFromXCurrent (GSwitchItKbdConfig *
						kbdConfig);

extern void GSwitchItKbdConfigStartListen (GSwitchItKbdConfig * kbdConfig,
					   GConfClientNotifyFunc func,
					   gpointer user_data);

extern void GSwitchItKbdConfigStopListen (GSwitchItKbdConfig * kbdConfig);

extern gboolean GSwitchItKbdConfigEquals (GSwitchItKbdConfig * kbdConfig1,
					  GSwitchItKbdConfig * kbdConfig2);

extern gboolean GSwitchItKbdConfigActivate (GSwitchItKbdConfig *
					    kbdConfig);

extern const gchar *GSwitchItKbdConfigMergeItems (const gchar * parent,
						  const gchar * child);

extern gboolean GSwitchItKbdConfigSplitItems (const gchar * merged,
					      gchar ** parent,
					      gchar ** child);

extern Bool GSwitchItKbdConfigGetDescriptions (XklConfigRegistry *
					       configRegistry,
					       const gchar * name,
					       gchar ** layoutShortDescr,
					       gchar ** layoutDescr,
					       gchar ** variantShortDescr,
					       gchar ** variantDescr);

extern const gchar *GSwitchItKbdConfigFormatFullLayout (const gchar
							* layoutDescr,
							const gchar *
							variantDescr);

extern gchar *GSwitchItKbdConfigToString (const GSwitchItKbdConfig *
					  config);


/**
 * GSwitchItAppletConfig functions - 
 * some of them require GSwitchItKbdConfig as well - 
 * for loading approptiate images
 */
extern void GSwitchItAppletConfigInit (GSwitchItAppletConfig *
				       appletConfig,
				       GConfClient * confClient,
				       XklEngine * engine);
extern void GSwitchItAppletConfigTerm (GSwitchItAppletConfig *
				       appletConfig);

extern void GSwitchItAppletConfigLoadFromGConf (GSwitchItAppletConfig *
						appletConfig);
extern void GSwitchItAppletConfigSaveToGConf (GSwitchItAppletConfig *
					      appletConfig);

extern gchar *GSwitchItAppletConfigGetImagesFile (GSwitchItAppletConfig *
						  appletConfig,
						  GSwitchItKbdConfig *
						  kbdConfig, int group);

extern void GSwitchItAppletConfigLoadImages (GSwitchItAppletConfig *
					     appletConfig,
					     GSwitchItKbdConfig *
					     kbdConfig);
extern void GSwitchItAppletConfigFreeImages (GSwitchItAppletConfig *
					     appletConfig);

/* Should be updated on Applet/GConf and Kbd/GConf configuration change */
extern void GSwitchItAppletConfigUpdateImages (GSwitchItAppletConfig *
					       appletConfig,
					       GSwitchItKbdConfig *
					       kbdConfig);

/* Should be updated on Applet/GConf configuration change */
extern void GSwitchItAppletConfigActivate (GSwitchItAppletConfig *
					   appletConfig);

extern void GSwitchItAppletConfigStartListen (GSwitchItAppletConfig *
					      appletConfig,
					      GConfClientNotifyFunc func,
					      gpointer user_data);

extern void GSwitchItAppletConfigStopListen (GSwitchItAppletConfig *
					     appletConfig);

/**
 * GSwitchItPreview functions
 */
extern GdkRectangle *GSwitchItPreviewLoad (void);

extern void GSwitchItPreviewSave (GdkRectangle * rect);

#endif
