/* $Id: gdict-pref.h,v 1.16 2005/07/05 16:01:12 vnoel Exp $ */

/*
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 * 
 *  GDict preferences
 *
 */

#ifndef GDICT_PREF_H
#define GDICT_PREF_H

G_BEGIN_DECLS

#include <gconf/gconf-client.h>
#include "gdict-app.h"
#include "dict.h"

typedef struct _GDictPref {
    /* Server preferences */
    gchar        *server;
    gint          port;
    gchar        *database;     /* Database to search for words and defs */
    gchar        *dfl_strat;    /* Default match strategy */
    gchar        *fontname;
    int          fontsize;
    /* Applet preferences (read only during startup) */
    gboolean      applet_handle;
} GDictPref;

GConfClient *gdict_get_gconf_client (void);
GDictPref *gdict_pref_new (gpointer data);
gboolean gdict_is_gconf_key_writable (GDictWindow *gdict, gchar *key);
gboolean gdict_get_gconf_bool (GDictWindow *gdict, gchar *key);
gchar* gdict_get_gconf_string (GDictWindow *gdict, gchar *key);
void gdict_set_gconf_int (GDictWindow *gdict, gchar *key, int value);
void gdict_set_gconf_bool (GDictWindow *gdict, gchar *key, gboolean bool);
void gdict_set_gconf_string (GDictWindow *gdict, gchar *key, gchar *string);
void gdict_window_store_position (GDictWindow *gdict);
void gdict_window_restore_position (GDictWindow *gdict);
void gdict_window_store_font (GDictWindow *gdict);
void gdict_pref_load (GDictWindow *gdict, GDictPref *pref);
void gdict_pref_destroy (GDictPref *pref);
int gdict_get_gconf_int (GDictWindow *gdict, gchar *key);

G_END_DECLS

#endif /* GDICT_PREF_H */
