/* $Id: gdict-app.h,v 1.31 2005/06/15 18:54:40 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict main window
 *
 */

#ifndef GDICT_APP_H
#define GDICT_APP_H

G_BEGIN_DECLS

#include "dict.h"
#include "gdict-defbox.h"

extern gboolean  gail_loaded;

#define GDICT_TYPE_WINDOW		  (gdict_window_get_type ())
#define GDICT_WINDOW(obj)		  (GTK_CHECK_CAST ((obj), GDICT_TYPE_WINDOW, GDictWindow))
#define GDICT_WINDOW_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), GDICT_TYPE_WINDOW, GDictWindowClass))
#define GDICT_IS_WINDOW(obj)	  (GTK_CHECK_TYPE ((obj), GDICT_TYPE_WINDOW))
#define GDICT_IS_WINDOW_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((obj), GDICT_TYPE_WINDOW))
#define GDICT_WINDOW_GET_CLASS(obj)   (GTK_CHECK_GET_CLASS ((obj), GDICT_TYPE_WINDOW, GDictWindowClass))

enum {
	SEARCH_TYPE_REGULAR,
	SEARCH_TYPE_WEB
};

typedef struct _GDictWindow GDictWindow;
typedef struct _GDictWindowClass GDictWindowClass;

#include "gdict-pref.h"

struct _GDictWindow {
	GtkWindow parent_instance;

	GtkActionGroup *menu_actions;
	GtkActionGroup *edit_actions;
	GtkActionGroup *search_type_actions;
	GtkWidget *statusbar;
	guint tip_message_cid;
	GtkWidget *paned;
	GDictDefbox *defbox;
	GtkWidget *word_entry;

	GtkWidget *find_dialog;
	GtkWidget *find_dialog_entry;

	GtkWidget *pref_dialog;
	GDictPref *pref;

  gchar *find_text;
  gboolean search_from_beginning;       

  gpointer applet;
	gpointer speller;
	gboolean speller_visible;

	GtkUIManager *ui;
	dict_context_t *context;

	gpointer print_job;

	int      x, y;
	int      search_type;
	GSList *web_search_sites;
};

struct _GDictWindowClass {
	GtkWindowClass parent_class;
};

void gdict_lookup_definition (GDictWindow *gdict, gchar *text);
gint gdict_lookup_spelling (GDictWindow *gdict, gchar *text, gboolean pattern);
void gdict_lookup_web (GDictWindow *gdict, gchar *text);
GType gdict_window_get_type (void);
GtkWidget *gdict_window_new (void);
gint gdict_init_context (GDictWindow *gdict);
void gdict_socket_error_cb (GtkWidget *widget, const gchar *message, gpointer data);
void gdict_menus_set_sensitive (GDictWindow *gdict, gboolean found_definition);

#endif /* GDICT_APP_H */
