#include <gnome.h>

#include "gstplaylist.h"

struct _GstPlaylistPrivate {
	GtkListStore       *store;
	GtkTreeIter        iter;
	GtkWidget          *tree;
	GtkCellRenderer    *renderer;	
	GtkTreeViewColumn  *column;
};

enum
{
	SELECTION_CHANGE,
	LAST_SIGNAL
};

enum
{
	TITLE_COLUMN,
	N_COLUMNS
};

static gint  gst_playlist_signals   [LAST_SIGNAL] = { 0 };

static void  gst_playlist_destroy   (GtkObject *object);
static void  gst_playlist_finalize  (GObject   *object);

static void  tree_selection_changed (GtkTreeSelection *selection, GstPlaylist *playlist);

GNOME_CLASS_BOILERPLATE (GstPlaylist, gst_playlist,
			 GtkVBox, GTK_TYPE_VBOX)

static void
tree_selection_changed (GtkTreeSelection *selection, GstPlaylist *playlist)
{
	g_signal_emit (playlist, gst_playlist_signals [SELECTION_CHANGE], 0);
}

static void
gst_playlist_class_init (GstPlaylistClass *klass)
{
	GObjectClass    *gobject_class;
	GtkWidgetClass  *widget_class;
	GtkObjectClass  *object_class;

	gobject_class = (GObjectClass *) klass;
	widget_class  = (GtkWidgetClass *) klass;
	object_class = (GtkObjectClass *) klass;

	object_class->destroy = gst_playlist_destroy;
	gobject_class->finalize = gst_playlist_finalize;

	gst_playlist_signals [SELECTION_CHANGE] =
		g_signal_new ("selection_change",
			      G_TYPE_FROM_CLASS (gobject_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (GstPlaylistClass, selection_change),
			      NULL, NULL,
			      g_cclosure_marshal_VOID__VOID,
			      G_TYPE_NONE, 0);

	klass->selection_change = NULL;
}
	
static void
gst_playlist_instance_init (GstPlaylist *playlist)
{
	GtkWidget *scrolled_window;
	GstPlaylistPrivate  *priv;
	GtkTreeSelection    *select;

	playlist->_priv = g_new0 (GstPlaylistPrivate, 1);
	priv = playlist->_priv;

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (playlist), scrolled_window, TRUE, TRUE, 0);
	gtk_widget_set_usize (scrolled_window, -1, 150);

	priv->store = gtk_list_store_new (N_COLUMNS, G_TYPE_STRING);

	priv->tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (priv->store));
	gtk_container_add (GTK_CONTAINER (scrolled_window), priv->tree);

	g_object_unref (G_OBJECT (priv->store));

	priv->renderer = gtk_cell_renderer_text_new ();

	priv->column = gtk_tree_view_column_new_with_attributes ("Playlist:Filename",
								 priv->renderer,
								 "text", TITLE_COLUMN,
								 NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (priv->tree), priv->column);

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
			  G_CALLBACK (tree_selection_changed), playlist);

	gtk_widget_show_all (scrolled_window);
}

static void
gst_playlist_destroy (GtkObject *object)
{
	GstPlaylist *playlist;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GST_IS_PLAYLIST (object));

	playlist = GST_PLAYLIST (object);

	GNOME_CALL_PARENT (GTK_OBJECT_CLASS, destroy, (object));
}

static void
gst_playlist_finalize (GObject *object)
{
	GstPlaylist *playlist;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GST_IS_PLAYLIST (object));

	playlist = GST_PLAYLIST (object);

	GNOME_CALL_PARENT (G_OBJECT_CLASS, finalize, (object));
}

GtkWidget*
gst_playlist_new (void)
{
	GstPlaylist *playlist;

	playlist = g_object_new (GST_TYPE_PLAYLIST, NULL);

	return GTK_WIDGET (playlist);
}

void
gst_playlist_append (GstPlaylist *playlist, const gchar *location)
{
	GstPlaylistPrivate *priv;

	priv = playlist->_priv;

	gtk_list_store_append (priv->store, &priv->iter);
	gtk_list_store_set (priv->store, &priv->iter,
			    TITLE_COLUMN, location,
			    -1);
}

void
gst_playlist_clear (GstPlaylist *playlist)
{
	GstPlaylistPrivate *priv;
	GtkTreeSelection    *selection;
        GtkTreeIter         iter;
        GtkTreeModel        *model;

	priv = playlist->_priv;

	g_print("getting selection\n");
	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));
	g_print("select_all\n");
	gtk_tree_selection_unselect_all(selection); 
	
	g_print("getting model\n");
	model = gtk_tree_view_get_model(GTK_TREE_VIEW (priv->tree));

	g_print("getting iter\n");
	/* delete all items in list */
	while (gtk_tree_model_get_iter_from_string (model, &iter, "0")){
		gtk_list_store_remove(priv->store, &iter);
		g_print("removed item\n");
	}
}

gchar*
gst_playlist_get_selected (GstPlaylist *playlist)
{
	GstPlaylistPrivate  *priv;
	GtkTreeSelection    *selection;
        GtkTreeIter         iter;
        GtkTreeModel        *model;
        gchar               *location;

	priv = playlist->_priv;

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));

	gtk_tree_selection_get_selected (selection, &model, &iter);
	gtk_tree_model_get (model, &iter, TITLE_COLUMN, &location, -1);

	return location;
}

void
gst_playlist_set_selected (GstPlaylist *playlist, const gchar *path)
{
	GstPlaylistPrivate  *priv;
	GtkTreeSelection    *selection;
        GtkTreeIter         iter;
        GtkTreeModel        *model;
        gchar               *location;

	priv = playlist->_priv;

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));
	gtk_tree_selection_get_selected (selection, &model, &iter);

	gtk_tree_model_get_iter_from_string (model, &iter, path);
	gtk_tree_selection_select_iter (selection, &iter);
}	

gboolean
gst_playlist_get_next (GstPlaylist *playlist, gchar **location)
{
	GstPlaylistPrivate  *priv;
	GtkTreeSelection    *selection;
        GtkTreeIter         iter;
        GtkTreeModel        *model;
	gboolean            ret;
	gchar               *tmp;

	priv = playlist->_priv;

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));
	gtk_tree_selection_get_selected (selection, &model, &iter);
	
	ret = gtk_tree_model_iter_next (model, &iter);

	if (ret != FALSE){
		gtk_tree_model_get (model, &iter, TITLE_COLUMN, &tmp, -1);
	}

	*location = tmp;

	return ret;	
}

gboolean
gst_playlist_get_prev(GstPlaylist *playlist, gchar **location)
{
	GstPlaylistPrivate  *priv;
	GtkTreeSelection    *selection;
        GtkTreeIter         iter;
        GtkTreeModel        *model;
	gboolean            ret = FALSE;
	gchar               *tmp;

	priv = playlist->_priv;

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (priv->tree));
	gtk_tree_selection_get_selected (selection, &model, &iter);
	
	/* FIXME this doesn't exist 
	ret = gtk_tree_model_iter_prev (model, &iter);*/

	if (ret != FALSE){
		gtk_tree_model_get (model, &iter, TITLE_COLUMN, &tmp, -1);
	}

	*location = tmp;

	return ret;	
}

