#ifndef __GST_MEDIA_PLAY_H__
#define __GST_MEDIA_PLAY_H__

#include <gst/play/play.h>

typedef enum {
	GST_MEDIA_PLAY_NORMAL,
	GST_MEDIA_PLAY_MINI,
	GST_MEDIA_PLAY_FULLSCREEN,
}GstMediaPlayMode;

#define GST_TYPE_MEDIA_PLAY           (gst_media_play_get_type())
#define GST_MEDIA_PLAY(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_MEDIA_PLAY, GstMediaPlay))
#define GST_MEDIA_PLAY_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_MEDIA_PLAY, GstMediaPlayClass))
#define GST_IS_MEDIA_PLAY(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_MEDIA_PLAY))
#define GST_IS_MEDIA_PLAY_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GST_TYPE_MEDIA_PLAY))
#define GST_MEDIA_PLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MEDIA_PLAY, GstMediaPlayClass))

typedef struct _GstMediaPlay GstMediaPlay;
typedef struct _GstMediaPlayClass GstMediaPlayClass;

struct _GstMediaPlay
{
	GtkVBox parent;

	GstPlay	   *play;
	
	GtkWindow  *window_fs;
	GtkWidget  *video_widget;
	GtkWidget  *fs_vbox;
	GtkWidget  *control_window_fs;
	GtkWidget  *control_vbox;
	
	GtkWidget  *control;

	GtkWidget  *statusarea;
	
	const gchar *location;
	const gchar *location_short;
	gint64     length_nanos;

	GstMediaPlayMode display_mode;

	/* For moving the control window */
	guint32 move_id;
	int control_y;
};

struct _GstMediaPlayClass
{
	GtkVBoxClass parent_class;
	/* signals */
	void (*state_changed)  (GstMediaPlay *mplay, GstElementState old_state, GstElementState new_state);
	void (*display_mode_change) (GstMediaPlay *mplay, GstMediaPlayMode display_mode);
	void (*current_location) (GstMediaPlay *mplay, gchar *location, gchar *location_short);
};

GType            gst_media_play_get_type		   (void);
GstMediaPlay*    gst_media_play_new                 (void);

void             gst_media_play_set_video_scale   (GstMediaPlay *mplay, gfloat scale_factor);
gfloat           gst_media_play_get_video_scale   (GstMediaPlay *mplay);

void             gst_media_play_set_state         (GstMediaPlay *mplay, GstElementState state);
GstElementState  gst_media_play_get_state         (GstMediaPlay *mplay);

void             gst_media_play_set_display_mode  (GstMediaPlay *mplay, GstMediaPlayMode display_mode);
GstMediaPlayMode gst_media_play_get_display_mode (GstMediaPlay *mplay);

void             gst_media_play_set_volume        (GstMediaPlay *mplay, gdouble value);
gdouble          gst_media_play_get_volume        (GstMediaPlay *mplay);

void             gst_media_play_show_media_info   (GstMediaPlay *mplay);
void             gst_media_play_show_preferences  (GstMediaPlay *mplay);
void             gst_media_play_show_about        (GstMediaPlay *mplay);

void             gst_media_play_set_location      (GstMediaPlay *mplay, const gchar *location);
const gchar*     gst_media_play_get_location      (GstMediaPlay *mplay);

gboolean gst_media_gconf_get_boolean (const gchar *key, gboolean *value);

#endif /* __GST_MEDIA_PLAY_H__ */
