/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FilePicker_h
#define __FilePicker_h

#include "nsIFilePicker.h"
#include "nsError.h"
#include "nsIDOMWindow.h"
#include "nsIDOMWindowInternal.h"
#include "nsCOMPtr.h"
#include "nsString.h"
#include "nsILocalFile.h"
#include <gtk/gtktogglebutton.h>

#define G_FILEPICKER_CID			     \
{ /* 3636dc79-0b42-4bad-8a3f-ae15d3671d17 */         \
    0x3636dc79,                                      \
    0x0b42,                                          \
    0x4bad,                                          \
    {0x8a, 0x3f, 0xae, 0x15, 0xd3, 0x67, 0x1d, 0x17} \
}

#define G_FILEPICKER_CONTRACTID "@mozilla.org/filepicker;1"
#define G_FILEPICKER_CLASSNAME "Galeon's File Picker Implementation"

class nsIFactory;

extern nsresult NS_NewFilePickerFactory(nsIFactory** aFactory);

/* Header file */
class GFilePicker : public nsIFilePicker
{
	friend void filePicker_save_as_ok_cb (GtkButton *button,
					      GFilePicker *aHandler);
	friend void filePicker_save_as_cancel_cb (GtkButton *button,
						  GFilePicker *aHandler);
	friend gboolean filePicker_save_as_close_cb (GtkWidget *dialog,
						     GdkEvent *event,
						     GFilePicker *aHandler);
	friend void filePicker_save_content_cb (GtkToggleButton *button,
						GFilePicker *aHandler);
  public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIFILEPICKER

	enum { returnOKSaveContent = 256 };

	GFilePicker(PRBool showContentCheck = PR_FALSE, FileFormat *fileFormats = NULL);
	virtual ~GFilePicker();
	/* additional members */
	NS_IMETHODIMP InitWithGtkWidget (GtkWidget *parentWidget, 
					 const char *title,PRInt16 mode);
	NS_IMETHODIMP SanityCheck (PRBool *retval);

	PRInt16 mSelectedFileFormat;

  private:
	nsCOMPtr<nsIDOMWindowInternal> mParentInternal;
	nsCOMPtr<nsIDOMWindow> mParent;
	nsString mTitle;
	PRInt16 mMode;
	FileFormat *mFileFormats;

	nsString mFilter;
	nsString mDefaultString;
	nsCOMPtr<nsILocalFile> mFile;
	nsCOMPtr<nsILocalFile> mDisplayDirectory;

	PRBool mFileSelectorClosed;
	PRBool mFileSelectorOk;
	PRBool mShowContentCheck;
	PRBool mSaveContent;

	GtkWidget *mParentWidget;	
	GtkWidget *mFileSelector;
	GtkWidget *mFormatChooser;
};

#endif
